/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.order.extend.bo.saleorder.PebExtUocOrderTypeQryInfoBO;
import com.tydic.order.extend.bo.saleorder.PebExtUocOrderTypeStakeholderInfoBO;
import com.tydic.pfscext.api.ability.FscCreditDataTransferAbilityService;
import com.tydic.pfscext.api.ability.bo.FscCreditDataTransferCreateLineAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscCreditDataTransferCreateLineAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscCreditDataTransferPayConfigAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscCreditDataTransferPayConfigAbilityRspBO;
import com.tydic.pfscext.dao.CreditLineMapper;
import com.tydic.pfscext.dao.DSaleOrderInfoDataMapper;
import com.tydic.pfscext.dao.PayConfigDetailMapper;
import com.tydic.pfscext.dao.PayConfigMapper;
import com.tydic.pfscext.dao.PayTypeConfigMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.CreditLine;
import com.tydic.pfscext.dao.po.FscCreditRecordPO;
import com.tydic.pfscext.dao.po.FscPayConfigChannelPO;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.dao.po.PayConfig;
import com.tydic.pfscext.dao.po.PayConfigDetail;
import com.tydic.pfscext.dao.po.PayTypeConfig;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.FscPayConfigPayNodeRule;
import com.tydic.pfscext.enums.FscPayConfigPayType;
import com.tydic.pfscext.enums.FscPayConfigStatus;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.external.umc.api.FscUmcEnterpriseOrgQueryAbilityService;
import com.tydic.pfscext.external.uoc.api.FscPebExtUocOrderTypeQryExternalService;
import com.tydic.pfscext.external.uoc.bo.FscPebExtUocOrderTypeQryExternalReqBO;
import com.tydic.pfscext.external.uoc.bo.FscPebExtUocOrderTypeQryExternalRspBO;
import com.tydic.pfscext.service.busi.FscCreditDataTransferBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditDataTransferCreateLineBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditDataTransferPayConfigBusiReqBO;
import com.tydic.pfscext.utils.DateUtil;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgQueryAbilityReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscCreditDataTransferAbilityService"})
public class FscCreditDataTransferAbilityServiceImpl
implements FscCreditDataTransferAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscCreditDataTransferAbilityServiceImpl.class);
    @Autowired
    private FscCreditDataTransferBusiService fscCreditDataTransferBusiService;
    @Autowired
    private FscUmcEnterpriseOrgQueryAbilityService fscUmcEnterpriseOrgQueryAbilityService;
    @Autowired
    private FscPebExtUocOrderTypeQryExternalService fscPebExtUocOrderTypeQryExternalService;
    @Autowired
    private CreditLineMapper creditLineMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private DSaleOrderInfoDataMapper saleOrderInfoDataMapper;
    @Autowired
    private PayConfigMapper payConfigMapper;
    @Autowired
    private PayConfigDetailMapper payConfigDetailMapper;
    @Autowired
    private PayTypeConfigMapper payTypeConfigMapper;

    @PostMapping(value={"dealTransferCreditLineData"})
    public FscCreditDataTransferCreateLineAbilityRspBO dealTransferCreditLineData(@RequestBody FscCreditDataTransferCreateLineAbilityReqBO reqBo) {
        int pageSize = 1000;
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderCodeList())) {
            pageSize = reqBo.getOrderCodeList().size();
        }
        Page pager = new Page(1, pageSize);
        CreditLine record = new CreditLine();
        record.setOrderCodeList(reqBo.getOrderCodeList());
        List<CreditLine> creditLines = this.creditLineMapper.selectPage(record, (Page<CreditLine>)pager);
        if (!CollectionUtils.isEmpty(creditLines)) {
            ArrayList<FscCreditRecordPO> list = new ArrayList<FscCreditRecordPO>();
            for (CreditLine creditLine : creditLines) {
                FscCreditRecordPO fscCreditRecordPo = this.initFscCreditRecord(creditLine);
                list.add(fscCreditRecordPo);
            }
            log.debug("\u7b2c1\u9875");
            FscCreditDataTransferCreateLineBusiReqBO busiReqBo = new FscCreditDataTransferCreateLineBusiReqBO();
            busiReqBo.setFscCreditRecordList(list);
            this.fscCreditDataTransferBusiService.dealTransferCreditLineData(busiReqBo);
        }
        if (pager.getTotalPages() > 1) {
            for (int pageNo = 2; pageNo <= pager.getTotalPages(); ++pageNo) {
                log.debug("\u7b2c{}\u9875", (Object)pageNo);
                Page pagerTwo = new Page(pageNo, pageSize);
                List<CreditLine> creditLinesTwo = this.creditLineMapper.selectPage(record, (Page<CreditLine>)pagerTwo);
                if (CollectionUtils.isEmpty(creditLinesTwo)) continue;
                ArrayList<FscCreditRecordPO> list = new ArrayList<FscCreditRecordPO>();
                for (CreditLine creditLine : creditLinesTwo) {
                    FscCreditRecordPO fscCreditRecordPo = this.initFscCreditRecord(creditLine);
                    list.add(fscCreditRecordPo);
                }
                FscCreditDataTransferCreateLineBusiReqBO busiReqBo = new FscCreditDataTransferCreateLineBusiReqBO();
                busiReqBo.setFscCreditRecordList(list);
                this.fscCreditDataTransferBusiService.dealTransferCreditLineData(busiReqBo);
            }
        }
        return FscRu.success(FscCreditDataTransferCreateLineAbilityRspBO.class);
    }

    @PostMapping(value={"dealTransferPayConfigData"})
    public FscCreditDataTransferPayConfigAbilityRspBO dealTransferPayConfigData(@RequestBody FscCreditDataTransferPayConfigAbilityReqBO reqBo) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPayConfigIdList())) {
            return this.dealTransferPayConfigMain(reqBo.getPayConfigIdList(), reqBo.getSysDetail());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPayConfigDetailIdList())) {
            return this.dealTransferPayConfigDetail(reqBo.getPayConfigDetailIdList());
        }
        this.dealTransferPayConfigAll();
        return FscRu.success(FscCreditDataTransferPayConfigAbilityRspBO.class);
    }

    private void dealTransferPayConfigAll() {
        log.debug("\u5f00\u59cb\u540c\u6b65\u4e3b\u6570\u636e{}", (Object)DateUtil.dateToStrLong(new Date()));
        int pageSize = 1000;
        Page pager = new Page(1, pageSize);
        PayConfig record = new PayConfig();
        record.setIsDelete(0);
        List<PayConfig> payConfigs = this.payConfigMapper.selectPage(record, (Page<PayConfig>)pager);
        if (!CollectionUtils.isEmpty(payConfigs)) {
            for (PayConfig payConfig : payConfigs) {
                FscPayConfigPO fscPayConfigMain = this.initPayConfigMain(payConfig);
                List<FscPayConfigChannelPO> payConfigChannelsMain = this.initPayChannels(payConfig.getPayConfigId(), null);
                ArrayList<FscPayConfigPO> payConfigDetail = new ArrayList<FscPayConfigPO>();
                ArrayList<FscPayConfigChannelPO> payConfigChannelsDetail = new ArrayList<FscPayConfigChannelPO>();
                this.initPayConfigDetail(payConfig, payConfigDetail, payConfigChannelsDetail);
                FscCreditDataTransferPayConfigBusiReqBO busiReqBo = new FscCreditDataTransferPayConfigBusiReqBO();
                busiReqBo.setPayConfigMain(fscPayConfigMain);
                busiReqBo.setPayConfigChannelsMain(payConfigChannelsMain);
                busiReqBo.setPayConfigsDetail(payConfigDetail);
                busiReqBo.setPayConfigChannelsDetail(payConfigChannelsDetail);
                this.fscCreditDataTransferBusiService.dealTransferPayConfigData(busiReqBo);
            }
        }
        if (pager.getTotalPages() > 1) {
            for (int pageNo = 2; pageNo <= pager.getTotalPages(); ++pageNo) {
                Page pagerTwo = new Page(pageNo, pageSize);
                PayConfig recordTwo = new PayConfig();
                recordTwo.setIsDelete(0);
                List<PayConfig> payConfigsTwo = this.payConfigMapper.selectPage(recordTwo, (Page<PayConfig>)pagerTwo);
                if (CollectionUtils.isEmpty(payConfigsTwo)) continue;
                for (PayConfig payConfig : payConfigsTwo) {
                    log.debug("\u5f00\u59cb\u540c\u6b65\u4e3b\u6570\u636e[{}].{}", (Object)payConfig.getPayConfigId(), (Object)DateUtil.dateToStrLong(new Date()));
                    FscPayConfigPO fscPayConfigMain = this.initPayConfigMain(payConfig);
                    List<FscPayConfigChannelPO> payConfigChannelsMain = this.initPayChannels(payConfig.getPayConfigId(), null);
                    ArrayList<FscPayConfigPO> payConfigDetail = new ArrayList<FscPayConfigPO>();
                    ArrayList<FscPayConfigChannelPO> payConfigChannelsDetail = new ArrayList<FscPayConfigChannelPO>();
                    this.initPayConfigDetail(payConfig, payConfigDetail, payConfigChannelsDetail);
                    FscCreditDataTransferPayConfigBusiReqBO busiReqBo = new FscCreditDataTransferPayConfigBusiReqBO();
                    busiReqBo.setPayConfigMain(fscPayConfigMain);
                    busiReqBo.setPayConfigChannelsMain(payConfigChannelsMain);
                    busiReqBo.setPayConfigsDetail(payConfigDetail);
                    busiReqBo.setPayConfigChannelsDetail(payConfigChannelsDetail);
                    this.fscCreditDataTransferBusiService.dealTransferPayConfigData(busiReqBo);
                    log.debug("\u4e3b\u6570\u636e\u540c\u6b65\u7ed3\u675f[{}].{}", (Object)payConfig.getPayConfigId(), (Object)DateUtil.dateToStrLong(new Date()));
                }
            }
        }
        log.debug("\u4e3b\u6570\u636e\u540c\u6b65\u7ed3\u675f{}", (Object)DateUtil.dateToStrLong(new Date()));
    }

    private void initPayConfigDetail(PayConfig payConfig, List<FscPayConfigPO> payConfigDetail, List<FscPayConfigChannelPO> payConfigChannelsDetail) {
        PayConfigDetail pd = new PayConfigDetail();
        pd.setPayConfigId(payConfig.getPayConfigId());
        pd.setIsDelete(0);
        List<PayConfigDetail> payConfigDetailOld = this.payConfigDetailMapper.selectPageNoPage(pd);
        if (!CollectionUtils.isEmpty(payConfigDetailOld)) {
            for (PayConfigDetail configDetail : payConfigDetailOld) {
                FscPayConfigPO fscPayConfig = new FscPayConfigPO();
                fscPayConfig.setPayConfigId(configDetail.getPayConfigDetailId());
                fscPayConfig.setParentConfigId(configDetail.getPayConfigId());
                fscPayConfig.setVersionNo(1L);
                fscPayConfig.setPayBusiType(configDetail.getPayBusiType());
                fscPayConfig.setPaySubClass(configDetail.getPaySubClass());
                fscPayConfig.setPaySubType(configDetail.getPaySubType());
                fscPayConfig.setPayConfigMode(payConfig.getPayConfigMode());
                if (configDetail.getIsExcept().equals(0)) {
                    fscPayConfig.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
                } else {
                    fscPayConfig.setPayConfigType(FscPayConfigType.DEF.getCode());
                }
                if (FscPayConfigPayType.ZQ.getCode().equals(configDetail.getPayType()) || FscPayConfigPayType.XY.getCode().equals(configDetail.getPayType())) {
                    fscPayConfig.setPayUsedPeriodFlag(YesOrNo.YES.getCode());
                } else {
                    fscPayConfig.setPayUsedPeriodFlag(YesOrNo.NO.getCode());
                }
                fscPayConfig.setPayOrgId(configDetail.getExceptId());
                fscPayConfig.setPayOrgName(configDetail.getExceptName());
                fscPayConfig.setPayOrgPath(this.getPayOrgPath(configDetail.getExceptId()));
                fscPayConfig.setPayUserId(null);
                fscPayConfig.setPayUserName(null);
                fscPayConfig.setPayAllowExceptionFlag(YesOrNo.NO.getCode());
                fscPayConfig.setExceptionOrgNum(0);
                fscPayConfig.setExceptionAgrNum(0);
                fscPayConfig.setExceptionConnNum(0);
                fscPayConfig.setPayType(configDetail.getPayType());
                fscPayConfig.setDownPaymentRatio(configDetail.getDwnPaymentRatio());
                fscPayConfig.setCheckPaymentRatio(configDetail.getCheckPaymentRatio());
                if (FscPayConfigPayType.ZQ.getCode().equals(configDetail.getPayType()) || FscPayConfigBusiType.AGR_PT.getCode().equals(configDetail.getPayBusiType()) && FscPayConfigPayType.XY.getCode().equals(configDetail.getPayType())) {
                    fscPayConfig.setPayNodeRule(FscPayConfigPayNodeRule.YS.getCode());
                }
                fscPayConfig.setPaymentDays(configDetail.getDays());
                fscPayConfig.setDelayDays(0);
                fscPayConfig.setCreditAmount(configDetail.getOverdraftQuota());
                fscPayConfig.setUsedAmount(configDetail.getUsedQuota());
                fscPayConfig.setBalanceAmount(configDetail.getBalance());
                if (configDetail.getOverdraftQuota() != null) {
                    fscPayConfig.setPaymentDays(60);
                    fscPayConfig.setUsedWarningAmount(configDetail.getOverdraftQuota().multiply(new BigDecimal("0.8")));
                    fscPayConfig.setOverdueStartAmount(new BigDecimal("10000"));
                    fscPayConfig.setOverdueWarningRatio(new BigDecimal("0.3"));
                    fscPayConfig.setOverdueControlRatio(new BigDecimal("0.6"));
                    fscPayConfig.setOverdueRecoveryRatio(new BigDecimal("0.3"));
                    fscPayConfig.setOverdueIndexRatio(new BigDecimal("0.0005"));
                    fscPayConfig.setOverdueWarningIndex(new BigDecimal("500000"));
                    fscPayConfig.setOverdueControlIndex(new BigDecimal("1000000"));
                    fscPayConfig.setOverdueRecoveryIndex(new BigDecimal("500000"));
                } else {
                    fscPayConfig.setUsedWarningAmount(BigDecimal.ZERO);
                    fscPayConfig.setOverdueStartAmount(BigDecimal.ZERO);
                    fscPayConfig.setOverdueWarningRatio(BigDecimal.ZERO);
                    fscPayConfig.setOverdueControlRatio(BigDecimal.ZERO);
                    fscPayConfig.setOverdueRecoveryRatio(BigDecimal.ZERO);
                    fscPayConfig.setOverdueIndexRatio(BigDecimal.ZERO);
                    fscPayConfig.setOverdueWarningIndex(BigDecimal.ZERO);
                    fscPayConfig.setOverdueControlIndex(BigDecimal.ZERO);
                    fscPayConfig.setOverdueRecoveryIndex(BigDecimal.ZERO);
                }
                fscPayConfig.setCurrentOrgControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
                fscPayConfig.setCurrentOrgControlTag("[]");
                fscPayConfig.setCurrentOrgWarningTag("[]");
                fscPayConfig.setCurrentOverdueRatio(BigDecimal.ZERO);
                fscPayConfig.setCurrentOverdueAmount(BigDecimal.ZERO);
                fscPayConfig.setCurrentPenaltyAmount(BigDecimal.ZERO);
                fscPayConfig.setCurrentOverdueIndex(BigDecimal.ZERO);
                fscPayConfig.setCreateTime(configDetail.getUpdateTime());
                fscPayConfig.setCreateUserId(configDetail.getUpdateUserId());
                fscPayConfig.setCreateUserName(configDetail.getUpdateUserName());
                fscPayConfig.setUpdateTime(configDetail.getUpdateTime());
                fscPayConfig.setUpdateUserId(configDetail.getUpdateUserId());
                fscPayConfig.setUpdateUserName(configDetail.getUpdateUserName());
                fscPayConfig.setRemark(configDetail.getRemark());
                fscPayConfig.setStatus(FscPayConfigStatus.DRAFT.getCode());
                fscPayConfig.setDeleteFlag(YesOrNo.NO.getCode());
                payConfigDetail.add(fscPayConfig);
                if (!configDetail.getIsExcept().equals(0)) continue;
                payConfigChannelsDetail.addAll(this.initPayChannels(null, configDetail.getPayConfigDetailId()));
            }
        }
    }

    private String getPayOrgPath(Long exceptId) {
        UmcEnterpriseOrgQueryAbilityReqBO umcReqBo = new UmcEnterpriseOrgQueryAbilityReqBO();
        umcReqBo.setOrgIdWeb(exceptId);
        UmcEnterpriseOrgDetailAbilityRspBO umcRspBo = this.fscUmcEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcReqBo);
        if (umcRspBo.getUmcEnterpriseOrgAbilityBO() != null) {
            return umcRspBo.getUmcEnterpriseOrgAbilityBO().getOrgTreePath();
        }
        return null;
    }

    private List<FscPayConfigChannelPO> initPayChannels(Long payConfigId, Long payConfigDetailId) {
        ArrayList<FscPayConfigChannelPO> payConfigChannels = new ArrayList<FscPayConfigChannelPO>();
        PayTypeConfig payTypeConfig = new PayTypeConfig();
        payTypeConfig.setPayConfigId(payConfigId);
        payTypeConfig.setPayConfigDetailId(payConfigDetailId);
        List<PayTypeConfig> payTypeConfigs = this.payTypeConfigMapper.selectPage(payTypeConfig);
        if (!CollectionUtils.isEmpty(payTypeConfigs)) {
            for (PayTypeConfig typeConfig : payTypeConfigs) {
                FscPayConfigChannelPO channelPo = new FscPayConfigChannelPO();
                channelPo.setPayConfigChannelId(typeConfig.getPayTypeConfigId());
                if (payConfigId != null) {
                    channelPo.setPayConfigId(typeConfig.getPayConfigId());
                    channelPo.setPayConfigType(FscPayConfigType.MAIN.getCode());
                }
                if (payConfigDetailId != null) {
                    channelPo.setPayConfigId(typeConfig.getPayConfigDetailId());
                    channelPo.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
                }
                channelPo.setPayChannels(typeConfig.getPayChannels());
                channelPo.setPayMethod(typeConfig.getPayMent());
                channelPo.setCreateTime(typeConfig.getCreateTime());
                channelPo.setRemark(typeConfig.getRemark());
                payConfigChannels.add(channelPo);
            }
        }
        return payConfigChannels;
    }

    private FscPayConfigPO initPayConfigMain(PayConfig payConfig) {
        FscPayConfigPO fscPayConfig = new FscPayConfigPO();
        fscPayConfig.setPayConfigId(payConfig.getPayConfigId());
        fscPayConfig.setParentConfigId(0L);
        fscPayConfig.setVersionNo(1L);
        fscPayConfig.setPayBusiType(payConfig.getPayBusiType());
        fscPayConfig.setPaySubClass(payConfig.getPaySubClass());
        fscPayConfig.setPaySubType(payConfig.getPaySubType());
        fscPayConfig.setPayConfigMode(payConfig.getPayConfigMode());
        fscPayConfig.setPayConfigType(FscPayConfigType.MAIN.getCode());
        if (FscPayConfigPayType.ZQ.getCode().equals(payConfig.getPayType()) || FscPayConfigPayType.XY.getCode().equals(payConfig.getPayType())) {
            fscPayConfig.setPayUsedPeriodFlag(YesOrNo.YES.getCode());
        } else {
            fscPayConfig.setPayUsedPeriodFlag(YesOrNo.NO.getCode());
        }
        fscPayConfig.setPayAllowExceptionFlag(payConfig.getIsHaveExcept());
        fscPayConfig.setExceptionOrgNum(0);
        fscPayConfig.setExceptionAgrNum(0);
        fscPayConfig.setExceptionConnNum(0);
        fscPayConfig.setPayType(payConfig.getPayType());
        fscPayConfig.setDownPaymentRatio(payConfig.getDwnPaymentRatio());
        fscPayConfig.setCheckPaymentRatio(payConfig.getCheckPaymentRatio());
        fscPayConfig.setPayNodeRule(FscPayConfigPayNodeRule.YS.getCode());
        fscPayConfig.setPaymentDays(payConfig.getDays());
        fscPayConfig.setDelayDays(0);
        fscPayConfig.setCreditAmount(payConfig.getOverdraftQuota());
        fscPayConfig.setUsedAmount(BigDecimal.ZERO);
        fscPayConfig.setBalanceAmount(BigDecimal.ZERO);
        fscPayConfig.setUsedWarningAmount(BigDecimal.ZERO);
        fscPayConfig.setOverdueStartAmount(BigDecimal.ZERO);
        fscPayConfig.setOverdueWarningRatio(BigDecimal.ZERO);
        fscPayConfig.setOverdueControlRatio(BigDecimal.ZERO);
        fscPayConfig.setOverdueRecoveryRatio(BigDecimal.ZERO);
        fscPayConfig.setOverdueIndexRatio(BigDecimal.ZERO);
        fscPayConfig.setOverdueWarningIndex(BigDecimal.ZERO);
        fscPayConfig.setOverdueControlIndex(BigDecimal.ZERO);
        fscPayConfig.setOverdueRecoveryIndex(BigDecimal.ZERO);
        fscPayConfig.setCurrentOrgControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
        fscPayConfig.setCurrentOrgControlTag("[]");
        fscPayConfig.setCurrentOrgWarningTag("[]");
        fscPayConfig.setCurrentOverdueRatio(BigDecimal.ZERO);
        fscPayConfig.setCurrentOverdueAmount(BigDecimal.ZERO);
        fscPayConfig.setCurrentPenaltyAmount(BigDecimal.ZERO);
        fscPayConfig.setCurrentOverdueIndex(BigDecimal.ZERO);
        fscPayConfig.setCreateTime(payConfig.getCreateTime());
        fscPayConfig.setCreateUserId(payConfig.getCreateUserId());
        fscPayConfig.setCreateUserName(payConfig.getCreateUserName());
        fscPayConfig.setUpdateTime(payConfig.getUpdateTime());
        fscPayConfig.setUpdateUserId(payConfig.getUpdateUserId());
        fscPayConfig.setUpdateUserName(payConfig.getUpdateUserName());
        fscPayConfig.setRemark(payConfig.getRemark());
        fscPayConfig.setStatus(FscPayConfigStatus.DRAFT.getCode());
        fscPayConfig.setDeleteFlag(YesOrNo.NO.getCode());
        return fscPayConfig;
    }

    private FscCreditDataTransferPayConfigAbilityRspBO dealTransferPayConfigDetail(List<Long> payConfigDetailIdList) {
        ArrayList<FscPayConfigPO> payConfigDetail = new ArrayList<FscPayConfigPO>();
        ArrayList<FscPayConfigChannelPO> payConfigChannelsDetail = new ArrayList<FscPayConfigChannelPO>();
        if (!CollectionUtils.isEmpty(payConfigDetailIdList)) {
            PayConfigDetail pd = new PayConfigDetail();
            pd.setPayConfigDetailIds(payConfigDetailIdList);
            pd.setIsDelete(0);
            List<PayConfigDetail> payConfigDetailOld = this.payConfigDetailMapper.selectPageNoPage(pd);
            if (!CollectionUtils.isEmpty(payConfigDetailOld)) {
                PayConfig payConfig;
                HashMap<Long, PayConfig> mapPayConfig = new HashMap<Long, PayConfig>();
                List payConfigIds = payConfigDetailOld.stream().map(PayConfigDetail::getPayConfigId).filter(i -> i != null && i != 0L).distinct().collect(Collectors.toList());
                if (CollectionUtils.isEmpty(payConfigIds)) {
                    for (Long payConfigId : payConfigIds) {
                        payConfig = this.payConfigMapper.selectByPrimaryKey(payConfigId);
                        if (payConfig == null || payConfig.getIsDelete() != 0) continue;
                        mapPayConfig.put(payConfigId, payConfig);
                    }
                }
                for (PayConfigDetail configDetail : payConfigDetailOld) {
                    payConfig = (PayConfig)mapPayConfig.get(configDetail.getPayConfigId());
                    if (payConfig != null) {
                        FscPayConfigPO fscPayConfig = new FscPayConfigPO();
                        fscPayConfig.setPayConfigId(configDetail.getPayConfigDetailId());
                        fscPayConfig.setParentConfigId(configDetail.getPayConfigId());
                        fscPayConfig.setVersionNo(1L);
                        fscPayConfig.setPayBusiType(configDetail.getPayBusiType());
                        fscPayConfig.setPaySubClass(configDetail.getPaySubClass());
                        fscPayConfig.setPaySubType(configDetail.getPaySubType());
                        fscPayConfig.setPayConfigMode(payConfig.getPayConfigMode());
                        if (configDetail.getIsExcept().equals(0)) {
                            fscPayConfig.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
                        } else {
                            fscPayConfig.setPayConfigType(FscPayConfigType.DEF.getCode());
                        }
                        if (FscPayConfigPayType.ZQ.getCode().equals(configDetail.getPayType()) || FscPayConfigPayType.XY.getCode().equals(configDetail.getPayType())) {
                            fscPayConfig.setPayUsedPeriodFlag(YesOrNo.YES.getCode());
                        } else {
                            fscPayConfig.setPayUsedPeriodFlag(YesOrNo.NO.getCode());
                        }
                        fscPayConfig.setPayOrgId(configDetail.getExceptId());
                        fscPayConfig.setPayOrgName(configDetail.getExceptName());
                        fscPayConfig.setPayOrgPath(this.getPayOrgPath(configDetail.getExceptId()));
                        fscPayConfig.setPayUserId(null);
                        fscPayConfig.setPayUserName(null);
                        fscPayConfig.setPayAllowExceptionFlag(YesOrNo.NO.getCode());
                        fscPayConfig.setExceptionOrgNum(0);
                        fscPayConfig.setExceptionAgrNum(0);
                        fscPayConfig.setExceptionConnNum(0);
                        fscPayConfig.setPayType(configDetail.getPayType());
                        fscPayConfig.setDownPaymentRatio(configDetail.getDwnPaymentRatio());
                        fscPayConfig.setCheckPaymentRatio(configDetail.getCheckPaymentRatio());
                        if (FscPayConfigPayType.ZQ.getCode().equals(configDetail.getPayType()) || FscPayConfigBusiType.AGR_PT.getCode().equals(configDetail.getPayBusiType()) && FscPayConfigPayType.XY.getCode().equals(configDetail.getPayType())) {
                            fscPayConfig.setPayNodeRule(FscPayConfigPayNodeRule.YS.getCode());
                        }
                        fscPayConfig.setPaymentDays(configDetail.getDays());
                        fscPayConfig.setDelayDays(0);
                        fscPayConfig.setCreditAmount(configDetail.getOverdraftQuota());
                        fscPayConfig.setUsedAmount(configDetail.getUsedQuota());
                        fscPayConfig.setBalanceAmount(configDetail.getBalance());
                        fscPayConfig.setUsedWarningAmount(BigDecimal.ZERO);
                        fscPayConfig.setOverdueStartAmount(BigDecimal.ZERO);
                        fscPayConfig.setOverdueWarningRatio(BigDecimal.ZERO);
                        fscPayConfig.setOverdueControlRatio(BigDecimal.ZERO);
                        fscPayConfig.setOverdueRecoveryRatio(BigDecimal.ZERO);
                        fscPayConfig.setOverdueIndexRatio(BigDecimal.ZERO);
                        fscPayConfig.setOverdueWarningIndex(BigDecimal.ZERO);
                        fscPayConfig.setOverdueControlIndex(BigDecimal.ZERO);
                        fscPayConfig.setOverdueRecoveryIndex(BigDecimal.ZERO);
                        fscPayConfig.setCurrentOrgControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
                        fscPayConfig.setCurrentOrgControlTag("[]");
                        fscPayConfig.setCurrentOrgWarningTag("[]");
                        fscPayConfig.setCurrentOverdueRatio(BigDecimal.ZERO);
                        fscPayConfig.setCurrentOverdueAmount(BigDecimal.ZERO);
                        fscPayConfig.setCurrentPenaltyAmount(BigDecimal.ZERO);
                        fscPayConfig.setCurrentOverdueIndex(BigDecimal.ZERO);
                        fscPayConfig.setCreateTime(configDetail.getUpdateTime());
                        fscPayConfig.setCreateUserId(configDetail.getUpdateUserId());
                        fscPayConfig.setCreateUserName(configDetail.getUpdateUserName());
                        fscPayConfig.setUpdateTime(configDetail.getUpdateTime());
                        fscPayConfig.setUpdateUserId(configDetail.getUpdateUserId());
                        fscPayConfig.setUpdateUserName(configDetail.getUpdateUserName());
                        fscPayConfig.setRemark(configDetail.getRemark());
                        fscPayConfig.setStatus(FscPayConfigStatus.DRAFT.getCode());
                        fscPayConfig.setDeleteFlag(YesOrNo.NO.getCode());
                        payConfigDetail.add(fscPayConfig);
                        if (!configDetail.getIsExcept().equals(0)) continue;
                        payConfigChannelsDetail.addAll(this.initPayChannels(null, configDetail.getPayConfigDetailId()));
                        continue;
                    }
                    log.error("\u540c\u6b65\u4f8b\u5916\u652f\u4ed8\u914d\u7f6e\u5931\u8d25\u652f\u4ed8\u914d\u7f6e[{}]\u5bf9\u5e94\u7684\u4e3b\u914d\u7f6e[{}]\u67e5\u8be2\u4e3a\u7a7a", (Object)configDetail.getPayConfigDetailId(), (Object)configDetail.getPayConfigId());
                }
            }
        }
        FscCreditDataTransferPayConfigBusiReqBO busiReqBo = new FscCreditDataTransferPayConfigBusiReqBO();
        busiReqBo.setPayConfigsDetail(payConfigDetail);
        busiReqBo.setPayConfigChannelsDetail(payConfigChannelsDetail);
        this.fscCreditDataTransferBusiService.dealTransferPayConfigData(busiReqBo);
        return FscRu.success(FscCreditDataTransferPayConfigAbilityRspBO.class);
    }

    private FscCreditDataTransferPayConfigAbilityRspBO dealTransferPayConfigMain(List<Long> payConfigIdList, String sysDetail) {
        if (!CollectionUtils.isEmpty(payConfigIdList)) {
            for (Long payConfigId : payConfigIdList) {
                PayConfig payConfig = this.payConfigMapper.selectByPrimaryKey(payConfigId);
                if (payConfig == null) continue;
                FscPayConfigPO fscPayConfigMain = this.initPayConfigMain(payConfig);
                List<FscPayConfigChannelPO> payConfigChannelsMain = this.initPayChannels(payConfig.getPayConfigId(), null);
                ArrayList<FscPayConfigPO> payConfigDetail = new ArrayList<FscPayConfigPO>();
                ArrayList<FscPayConfigChannelPO> payConfigChannelsDetail = new ArrayList<FscPayConfigChannelPO>();
                if (YesNo.YES.getCode().equals(sysDetail)) {
                    this.initPayConfigDetail(payConfig, payConfigDetail, payConfigChannelsDetail);
                }
                FscCreditDataTransferPayConfigBusiReqBO busiReqBo = new FscCreditDataTransferPayConfigBusiReqBO();
                busiReqBo.setPayConfigMain(fscPayConfigMain);
                busiReqBo.setPayConfigChannelsMain(payConfigChannelsMain);
                busiReqBo.setPayConfigsDetail(payConfigDetail);
                busiReqBo.setPayConfigChannelsDetail(payConfigChannelsDetail);
                this.fscCreditDataTransferBusiService.dealTransferPayConfigData(busiReqBo);
            }
        }
        return FscRu.success(FscCreditDataTransferPayConfigAbilityRspBO.class);
    }

    private FscCreditRecordPO initFscCreditRecord(CreditLine creditLine) {
        FscCreditRecordPO fscCreditRecord = new FscCreditRecordPO();
        fscCreditRecord.setRecordId(creditLine.getCreditLineId());
        fscCreditRecord.setPayConfigId(creditLine.getPayConfigDetailId());
        fscCreditRecord.setPurOrgId(null);
        fscCreditRecord.setSupplierNo(creditLine.getSupplierNo());
        fscCreditRecord.setSupplierName("");
        fscCreditRecord.setAccountId(creditLine.getAccountId());
        fscCreditRecord.setBusiAmount(creditLine.getChangeInfo());
        fscCreditRecord.setBusiBeforeAmount(BigDecimal.ZERO);
        fscCreditRecord.setBusiAfterAmount(BigDecimal.ZERO);
        fscCreditRecord.setObjId(null);
        fscCreditRecord.setObjCode(creditLine.getOrderCode());
        fscCreditRecord.setBusiCategory(creditLine.getChangeType());
        fscCreditRecord.setBusiType("0");
        fscCreditRecord.setBusiModel(creditLine.getBusiModel());
        fscCreditRecord.setPayApplyCode(creditLine.getPayApplyCode());
        fscCreditRecord.setRemark(creditLine.getRemark());
        fscCreditRecord.setCreateTime(creditLine.getUpdateTime());
        fscCreditRecord.setCreateUserName("\u8001\u6570\u636e\u8fc1\u79fb-" + DateUtil.dateToStrLong(new Date()));
        this.setOderIdAndPurOrgId(fscCreditRecord);
        return fscCreditRecord;
    }

    private void setOderIdAndPurOrgId(FscCreditRecordPO fscCreditRecord) {
        String orderCode = fscCreditRecord.getObjCode();
        if (StringUtils.hasText((String)orderCode)) {
            FscPebExtUocOrderTypeQryExternalReqBO reqBo = new FscPebExtUocOrderTypeQryExternalReqBO();
            reqBo.setOrderCodeList(Collections.singletonList(orderCode));
            reqBo.setStakeholderFlag(YesNo.YES.getCode());
            FscPebExtUocOrderTypeQryExternalRspBO rspBo = this.fscPebExtUocOrderTypeQryExternalService.qryOrderTypeByOrderCode(reqBo);
            if (!CollectionUtils.isEmpty((Collection)rspBo.getInfoList())) {
                for (PebExtUocOrderTypeQryInfoBO infoBo : rspBo.getInfoList()) {
                    if (!orderCode.equals(infoBo.getSaleOrderCode()) || infoBo.getStakeholderInfoBo() == null) continue;
                    PebExtUocOrderTypeStakeholderInfoBO stakeholderInfoBo = infoBo.getStakeholderInfoBo();
                    fscCreditRecord.setObjId(infoBo.getOrderId());
                    if (StringUtils.hasText((String)stakeholderInfoBo.getPurOrgId())) {
                        try {
                            fscCreditRecord.setPurOrgId(Long.valueOf(stakeholderInfoBo.getPurOrgId()));
                        }
                        catch (NumberFormatException e) {
                            log.error("\u8ba2\u5355[{}]\u4e0b\u5355\u5355\u4f4d\u8f6c\u6362\u5931\u8d25", (Object)orderCode);
                        }
                    }
                    fscCreditRecord.setPurCompanyId(stakeholderInfoBo.getCompanyId());
                    if (fscCreditRecord.getSupplierNo() == null && stakeholderInfoBo.getSupNo() != null) {
                        try {
                            fscCreditRecord.setSupplierNo(Long.valueOf(stakeholderInfoBo.getSupNo()));
                        }
                        catch (NumberFormatException e) {
                            log.error("\u8ba2\u5355[{}]\u4f9b\u5e94\u5546id\u8f6c\u6362\u5931\u8d25", (Object)orderCode);
                        }
                    }
                    if (!StringUtils.hasText((String)fscCreditRecord.getSupplierName())) {
                        fscCreditRecord.setSupplierName(stakeholderInfoBo.getSupName());
                    }
                    if (fscCreditRecord.getBusiModel() == null && StringUtils.hasText((String)stakeholderInfoBo.getBusiModel())) {
                        try {
                            fscCreditRecord.setBusiModel(Integer.valueOf(stakeholderInfoBo.getBusiModel()));
                        }
                        catch (NumberFormatException e) {
                            log.error("\u8ba2\u5355[{}]\u7ed3\u7b97\u6a21\u5f0f\u8f6c\u6362\u5931\u8d25", (Object)orderCode);
                        }
                    }
                    if (!StringUtils.hasText((String)stakeholderInfoBo.getOrderCategory())) continue;
                    fscCreditRecord.setBusiType(stakeholderInfoBo.getOrderCategory());
                }
            }
        }
    }
}

