/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.ability.FscCreditSupplierAmountQryAbilityService;
import com.tydic.pfscext.api.ability.bo.FscCreditSupplierAmountInfoBO;
import com.tydic.pfscext.api.ability.bo.FscCreditSupplierAmountQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscCreditSupplierAmountQryAbilityRspBO;
import com.tydic.pfscext.dao.FscCreditRecordMapper;
import com.tydic.pfscext.dao.po.FscCreditRecordPO;
import com.tydic.pfscext.enums.FscCreditBusiCategory;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.external.umc.api.FscUmcQrySupplierInfoListAbilityService;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.umc.perf.common.UmcSupplierInfoBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoListAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoListAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscCreditSupplierAmountQryAbilityService"})
public class FscCreditSupplierAmountQryAbilityServiceImpl
implements FscCreditSupplierAmountQryAbilityService {
    @Autowired
    private FscCreditRecordMapper fscCreditRecordMapper;
    @Autowired
    private FscUmcQrySupplierInfoListAbilityService fscUmcQrySupplierInfoListAbilityService;

    @PostMapping(value={"listPageCreditSupplierAmount"})
    public FscCreditSupplierAmountQryAbilityRspBO listPageCreditSupplierAmount(@RequestBody FscCreditSupplierAmountQryAbilityReqBO reqBo) {
        FscCreditSupplierAmountQryAbilityRspBO rspBo = FscRu.success(FscCreditSupplierAmountQryAbilityRspBO.class);
        if (reqBo.getPayConfigId() == null) {
            rspBo.setPageNo(Integer.valueOf(1));
            rspBo.setTotal(Integer.valueOf(0));
            rspBo.setRecordsTotal(Integer.valueOf(0));
            rspBo.setRows(new ArrayList());
            rspBo.setRespDesc("\u5165\u53c2\u652f\u4ed8\u914d\u7f6eID\u4e3a\u7a7a");
        }
        Page pager = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        FscCreditRecordPO fscCreditRecordQry = new FscCreditRecordPO();
        fscCreditRecordQry.setPayConfigId(reqBo.getPayConfigId());
        fscCreditRecordQry.setSupplierNo(reqBo.getSupplierNo());
        fscCreditRecordQry.setSupplierNoNotNull(YesNo.YES.getCode());
        fscCreditRecordQry.setBusiCategoryList(Arrays.asList(FscCreditBusiCategory.ORD_ADD.getCode(), FscCreditBusiCategory.ORD_RETURN.getCode(), FscCreditBusiCategory.ORD_CANCEL.getCode(), FscCreditBusiCategory.ORD_PART_CANCEL.getCode(), FscCreditBusiCategory.ORD_ADJUST.getCode(), FscCreditBusiCategory.ORD_DIFF.getCode(), FscCreditBusiCategory.ORD_ABNORMAL.getCode(), FscCreditBusiCategory.ORD_ADJUST_REFUND.getCode(), FscCreditBusiCategory.WRITE_OFF_FAIL.getCode(), FscCreditBusiCategory.ORD_PAY_REFUND.getCode(), FscCreditBusiCategory.ORD_PAY.getCode()));
        List<FscCreditRecordPO> recordList = this.fscCreditRecordMapper.getListSupplierSum(fscCreditRecordQry, (Page<FscCreditRecordPO>)pager);
        FscCreditRecordPO recordSum = this.fscCreditRecordMapper.getSupplierSum(fscCreditRecordQry);
        rspBo.setPageNo(Integer.valueOf(pager.getPageNo()));
        rspBo.setTotal(Integer.valueOf(pager.getTotalPages()));
        rspBo.setRecordsTotal(Integer.valueOf(pager.getTotalCount()));
        rspBo.setRows(new ArrayList());
        if (!CollectionUtils.isEmpty(recordList)) {
            this.mapUmcSupplierName(recordList);
            rspBo.getRows().addAll(recordList.stream().map(i -> {
                FscCreditSupplierAmountInfoBO infoBo = FscRu.js(i, FscCreditSupplierAmountInfoBO.class);
                infoBo.setMatchUseAmount(i.getMatchingAmount().negate());
                infoBo.setTradeUseAmount(i.getTradeAmount().negate());
                infoBo.setTotalUseAmount(i.getTotalAmount().negate());
                return infoBo;
            }).collect(Collectors.toList()));
        }
        if (recordSum != null) {
            rspBo.setMatchUseAmount(recordSum.getMatchingAmount().negate());
            rspBo.setTradeUseAmount(recordSum.getTradeAmount().negate());
            rspBo.setTotalUseAmount(recordSum.getTotalAmount().negate());
        } else {
            rspBo.setMatchUseAmount(BigDecimal.ZERO);
            rspBo.setTradeUseAmount(BigDecimal.ZERO);
            rspBo.setTotalUseAmount(BigDecimal.ZERO);
        }
        return rspBo;
    }

    private void mapUmcSupplierName(List<FscCreditRecordPO> recordList) {
        List supplierNoList = recordList.stream().filter(i -> !StringUtils.hasText((String)i.getSupplierName())).map(FscCreditRecordPO::getSupplierNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        HashMap<Long, String> supplierMap = new HashMap<Long, String>(recordList.size());
        if (!CollectionUtils.isEmpty(supplierNoList)) {
            UmcQrySupplierInfoListAbilityReqBO umcReqBo = new UmcQrySupplierInfoListAbilityReqBO();
            umcReqBo.setSupplierIds(supplierNoList);
            umcReqBo.setPageNo(Integer.valueOf(1));
            umcReqBo.setPageSize(Integer.valueOf(supplierNoList.size()));
            UmcQrySupplierInfoListAbilityRspBO umcRspBo = this.fscUmcQrySupplierInfoListAbilityService.qrySupplierInfoList(umcReqBo);
            if (null != umcRspBo && !CollectionUtils.isEmpty((Collection)umcRspBo.getRows())) {
                for (UmcSupplierInfoBO row : umcRspBo.getRows()) {
                    supplierMap.put(row.getSupplierId(), row.getSupplierName());
                }
            }
        }
        for (FscCreditRecordPO po : recordList) {
            if (StringUtils.hasText((String)po.getSupplierName()) || po.getSupplierNo() == null) continue;
            po.setSupplierName((String)supplierMap.get(po.getSupplierNo()));
        }
    }
}

