/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.ability.FscCreditUseReportQryAbilityService;
import com.tydic.pfscext.api.ability.bo.FscCreditUsePurSupInfoBO;
import com.tydic.pfscext.api.ability.bo.FscCreditUsePurSupQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscCreditUsePurSupQryAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscCreditUseReportInfoBO;
import com.tydic.pfscext.api.ability.bo.FscCreditUseReportOverdueInfoBO;
import com.tydic.pfscext.api.ability.bo.FscCreditUseReportOverdueQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscCreditUseReportOverdueQryAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscCreditUseReportQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscCreditUseReportQryAbilityRspBO;
import com.tydic.pfscext.dao.FscCreditRecordMapper;
import com.tydic.pfscext.dao.FscOrderOverdueInspectionRecordMapper;
import com.tydic.pfscext.dao.po.FscCreditRecordPO;
import com.tydic.pfscext.dao.po.FscOrderOverdueInspectionRecordPO;
import com.tydic.pfscext.enums.FscCreditBusiCategory;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.utils.FscRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscCreditUseReportQryAbilityService"})
public class FscCreditUseReportQryAbilityServiceImpl
implements FscCreditUseReportQryAbilityService {
    @Autowired
    private FscCreditRecordMapper fscCreditRecordMapper;
    @Autowired
    private FscOrderOverdueInspectionRecordMapper fscOrderOverdueInspectionRecordMapper;

    @PostMapping(value={"listPageCreditUseReport"})
    public FscCreditUseReportQryAbilityRspBO listPageCreditUseReport(@RequestBody FscCreditUseReportQryAbilityReqBO reqBo) {
        FscCreditUseReportQryAbilityRspBO rspBo = FscRu.success(FscCreditUseReportQryAbilityRspBO.class);
        rspBo.setPageNo(Integer.valueOf(1));
        rspBo.setTotal(Integer.valueOf(0));
        rspBo.setRecordsTotal(Integer.valueOf(0));
        rspBo.setRows(new ArrayList());
        Page pager = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        FscCreditRecordPO fscCreditRecordQry = new FscCreditRecordPO();
        fscCreditRecordQry.setSupplierNoNotNull(YesNo.YES.getCode());
        fscCreditRecordQry.setBusiCategoryList(Arrays.asList(FscCreditBusiCategory.ORD_ADD.getCode(), FscCreditBusiCategory.ORD_CANCEL.getCode(), FscCreditBusiCategory.ORD_PART_CANCEL.getCode(), FscCreditBusiCategory.ORD_RETURN.getCode(), FscCreditBusiCategory.ORD_PAY.getCode(), FscCreditBusiCategory.ORD_PAY_REFUND.getCode(), FscCreditBusiCategory.WRITE_OFF_FAIL.getCode(), FscCreditBusiCategory.ORD_ADJUST.getCode(), FscCreditBusiCategory.ORD_DIFF.getCode(), FscCreditBusiCategory.ORD_ABNORMAL.getCode(), FscCreditBusiCategory.ORD_ADJUST_REFUND.getCode()));
        fscCreditRecordQry.setPurOrgId(reqBo.getPurOrgId());
        fscCreditRecordQry.setSupplierNo(reqBo.getSupplierNo());
        fscCreditRecordQry.setGroupBy(" SUPPLIER_NO,PUR_ORG_ID ");
        fscCreditRecordQry.setOrderBy(" totalAmount ASC ");
        List<FscCreditRecordPO> recordList = this.fscCreditRecordMapper.getListCreditUseReport(fscCreditRecordQry, (Page<FscCreditRecordPO>)pager);
        rspBo.setPageNo(Integer.valueOf(pager.getPageNo()));
        rspBo.setTotal(Integer.valueOf(pager.getTotalPages()));
        rspBo.setRecordsTotal(Integer.valueOf(pager.getTotalCount()));
        if (!CollectionUtils.isEmpty(recordList)) {
            rspBo.setRows(recordList.stream().map(i -> {
                FscCreditUseReportInfoBO infoBo = new FscCreditUseReportInfoBO();
                infoBo.setPurOrgId(i.getPurOrgId());
                infoBo.setSupplierNo(i.getSupplierNo());
                infoBo.setMatchUseAmount(i.getMatchingAmount().negate());
                infoBo.setTradeUseAmount(i.getTradeAmount().negate());
                infoBo.setTotalUseAmount(i.getTotalAmount().negate());
                infoBo.setOverdueAmount(null);
                return infoBo;
            }).collect(Collectors.toList()));
        }
        return rspBo;
    }

    @PostMapping(value={"listPageCreditUsePurAndSup"})
    public FscCreditUsePurSupQryAbilityRspBO listPageCreditUsePurAndSup(@RequestBody FscCreditUsePurSupQryAbilityReqBO reqBo) {
        FscCreditUsePurSupQryAbilityRspBO rspBo = FscRu.success(FscCreditUsePurSupQryAbilityRspBO.class);
        rspBo.setPageNo(Integer.valueOf(1));
        rspBo.setTotal(Integer.valueOf(0));
        rspBo.setRecordsTotal(Integer.valueOf(0));
        rspBo.setRows(new ArrayList());
        Page pager = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        FscCreditRecordPO fscCreditRecordQry = new FscCreditRecordPO();
        fscCreditRecordQry.setSupplierNoNotNull(YesNo.YES.getCode());
        fscCreditRecordQry.setBusiCategoryList(Arrays.asList(FscCreditBusiCategory.ORD_ADD.getCode(), FscCreditBusiCategory.ORD_RETURN.getCode(), FscCreditBusiCategory.ORD_CANCEL.getCode(), FscCreditBusiCategory.ORD_PART_CANCEL.getCode(), FscCreditBusiCategory.ORD_ADJUST.getCode(), FscCreditBusiCategory.ORD_DIFF.getCode(), FscCreditBusiCategory.ORD_ABNORMAL.getCode(), FscCreditBusiCategory.ORD_ADJUST_REFUND.getCode(), FscCreditBusiCategory.WRITE_OFF_FAIL.getCode(), FscCreditBusiCategory.ORD_PAY_REFUND.getCode(), FscCreditBusiCategory.ORD_PAY.getCode()));
        fscCreditRecordQry.setCreateTimeStart(reqBo.getCreateTimeStart());
        fscCreditRecordQry.setCreateTimeEnd(reqBo.getCreateTimeEnd());
        fscCreditRecordQry.setGroupBy(" SUPPLIER_NO,PUR_ORG_ID ");
        fscCreditRecordQry.setOrderBy(" PUR_ORG_ID ASC,SUPPLIER_NO ASC ");
        List<FscCreditRecordPO> recordList = this.fscCreditRecordMapper.getListCreditPurSup(fscCreditRecordQry, (Page<FscCreditRecordPO>)pager);
        rspBo.setPageNo(Integer.valueOf(pager.getPageNo()));
        rspBo.setTotal(Integer.valueOf(pager.getTotalPages()));
        rspBo.setRecordsTotal(Integer.valueOf(pager.getTotalCount()));
        if (!CollectionUtils.isEmpty(recordList)) {
            rspBo.setRows(recordList.stream().map(i -> FscRu.js(i, FscCreditUsePurSupInfoBO.class)).collect(Collectors.toList()));
        }
        return rspBo;
    }

    @PostMapping(value={"listPageCreditUseReportOverdue"})
    public FscCreditUseReportOverdueQryAbilityRspBO listPageCreditUseReportOverdue(@RequestBody FscCreditUseReportOverdueQryAbilityReqBO reqBo) {
        FscOrderOverdueInspectionRecordPO recordQry = new FscOrderOverdueInspectionRecordPO();
        recordQry.setCreateTimeStart(reqBo.getCreateTimeStart());
        recordQry.setCreateTimeEnd(reqBo.getCreateTimeEnd());
        recordQry.setOrderBy(" PUR_ORG_ID ASC ");
        Page pager = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List<Long> purOrgIds = this.fscOrderOverdueInspectionRecordMapper.getListPagePurOrgIds(recordQry, (Page<FscOrderOverdueInspectionRecordPO>)pager);
        ArrayList<FscCreditUseReportOverdueInfoBO> rows = new ArrayList<FscCreditUseReportOverdueInfoBO>();
        if (!CollectionUtils.isEmpty(purOrgIds)) {
            for (Long purOrgId : purOrgIds.stream().filter(i -> i != null && i != 0L).distinct().collect(Collectors.toList())) {
                FscCreditUseReportOverdueInfoBO infoBo = new FscCreditUseReportOverdueInfoBO();
                infoBo.setPurOrgId(purOrgId);
                rows.add(infoBo);
            }
        }
        FscCreditUseReportOverdueQryAbilityRspBO rspBo = FscRu.success(FscCreditUseReportOverdueQryAbilityRspBO.class);
        rspBo.setPageNo(Integer.valueOf(pager.getPageNo()));
        rspBo.setRecordsTotal(Integer.valueOf(pager.getTotalCount()));
        rspBo.setTotal(Integer.valueOf(pager.getTotalPages()));
        rspBo.setRows(rows);
        return rspBo;
    }
}

