/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.ability.FscDownBoxQryAbilityService;
import com.tydic.pfscext.api.ability.bo.FscDownBoxInfoBO;
import com.tydic.pfscext.api.ability.bo.FscDownBoxQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscDownBoxQryAbilityRspBO;
import com.tydic.pfscext.base.AuthorityInfo;
import com.tydic.pfscext.dao.FscPayConfigLogMapper;
import com.tydic.pfscext.dao.FscUserOverdueControlConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigLogPO;
import com.tydic.pfscext.dao.po.FscUserOverdueControlConfigPO;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.utils.FscRu;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscDownBoxQryAbilityService"})
public class FscDownBoxQryAbilityServiceImpl
implements FscDownBoxQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscDownBoxQryAbilityServiceImpl.class);
    @Autowired
    private FscPayConfigLogMapper fscPayConfigLogMapper;
    @Autowired
    private FscUserOverdueControlConfigMapper fscUserOverdueControlConfigMapper;
    @Value(value="${FSC_AUTH_SYSTEM_MANAGE:auth:system:manage}")
    private String FSC_AUTH_SYSTEM_MANAGE;
    @Value(value="${FSC_AUTH_PRO_CREDIT_MANAGE:overall:yunyingshouxinguanlizhuanyuan}")
    private String FSC_AUTH_PRO_CREDIT_MANAGE;
    @Value(value="${FSC_AUTH_SECONDARY_COMPANY_MANAGE:overall:erjidanweiguanliyuan}")
    private String FSC_AUTH_SECONDARY_COMPANY_MANAGE;
    @Value(value="${FSC_AUTH_PUR_COMPANY_MANAGE:001}")
    private String FSC_AUTH_PUR_COMPANY_MANAGE;
    @Value(value="${FSC_AUTH_PUR_COMPANY_BUYER:002}")
    private String FSC_AUTH_PUR_COMPANY_BUYER;

    @PostMapping(value={"listPageDownBox"})
    public FscDownBoxQryAbilityRspBO listPageDownBox(@RequestBody FscDownBoxQryAbilityReqBO reqBo) {
        FscDownBoxQryAbilityRspBO rspBo = FscRu.success(FscDownBoxQryAbilityRspBO.class);
        rspBo.setPageNo(Integer.valueOf(1));
        rspBo.setRecordsTotal(Integer.valueOf(0));
        rspBo.setTotal(Integer.valueOf(0));
        if (reqBo.getDownBoxConfigKey() == null) {
            return rspBo;
        }
        if ("FSC_DOWN_BOX_PAY_CONFIG_UPPER".equals(reqBo.getDownBoxConfigKey())) {
            this.queryPayConfigLogUserName(reqBo, rspBo);
        } else if ("FSC_DOWN_BOX_USER_OVERDUE_CONFIG_USER".equals(reqBo.getDownBoxConfigKey())) {
            this.queryUserOverdueControlConfigUserName(reqBo, rspBo);
        } else if ("FSC_DOWN_BOX_USER_OVERDUE_STATISTICS_USER".equals(reqBo.getDownBoxConfigKey()) || "FSC_DOWN_BOX_USER_OVERDUE_STATISTICS_USER_ACCOUNT".equals(reqBo.getDownBoxConfigKey())) {
            this.queryUserOverdueStatisticsUserName(reqBo, rspBo);
        }
        return rspBo;
    }

    private void queryUserOverdueStatisticsUserName(FscDownBoxQryAbilityReqBO reqBo, FscDownBoxQryAbilityRspBO rspBo) {
        List<FscUserOverdueControlConfigPO> listPage;
        log.debug("\u7528\u6237\u903e\u671f\u7edf\u8ba1\u67e5\u8be2\u7528\u6237\u59d3\u540d\u4e0b\u62c9\u6846\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        if (CollectionUtils.isEmpty((Collection)reqBo.getPermission())) {
            rspBo.setRespDesc("\u89d2\u8272\u96c6\u5408\u4e3a\u7a7a");
            return;
        }
        List roleList = reqBo.getPermission().stream().map(AuthorityInfo::getKey).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(roleList)) {
            rspBo.setRespDesc("\u89d2\u8272\u96c6\u5408key\u4e3a\u7a7a");
            return;
        }
        FscUserOverdueControlConfigPO fscUserOverdueControlConfigQry = new FscUserOverdueControlConfigPO();
        if (!roleList.contains(this.FSC_AUTH_SYSTEM_MANAGE) && !roleList.contains(this.FSC_AUTH_PRO_CREDIT_MANAGE)) {
            if (roleList.contains(this.FSC_AUTH_SECONDARY_COMPANY_MANAGE)) {
                fscUserOverdueControlConfigQry.setConfigOrgPathLike(reqBo.getOrgPath());
            } else if (roleList.contains(this.FSC_AUTH_PUR_COMPANY_MANAGE)) {
                String orgPath = reqBo.getOrgPath();
                Long companyId = reqBo.getCompanyId();
                orgPath = StrUtil.subBefore((CharSequence)orgPath, (CharSequence)(companyId + ""), (boolean)true) + companyId;
                fscUserOverdueControlConfigQry.setConfigOrgPathLike(orgPath);
            } else if (roleList.contains(this.FSC_AUTH_PUR_COMPANY_BUYER)) {
                fscUserOverdueControlConfigQry.setConfigUserAccount(reqBo.getUsername());
                fscUserOverdueControlConfigQry.setConfigUserId(reqBo.getUserId());
            } else {
                rspBo.setRespDesc("\u6ca1\u6709\u5177\u5907\u67e5\u770b\u6743\u9650\u7684\u89d2\u8272");
                return;
            }
        }
        fscUserOverdueControlConfigQry.setQueryCriteria("1");
        Page pager = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        if ("FSC_DOWN_BOX_USER_OVERDUE_STATISTICS_USER".equals(reqBo.getDownBoxConfigKey())) {
            fscUserOverdueControlConfigQry.setConfigUserNameLike(reqBo.getQueryCriteria());
            fscUserOverdueControlConfigQry.setConfigUserNameNotNull(YesNo.YES.getCode());
            fscUserOverdueControlConfigQry.setOrderBy(" a.CONFIG_USER_NAME ASC ");
            listPage = this.fscUserOverdueControlConfigMapper.getListPageStatisticsConfigUserName(fscUserOverdueControlConfigQry, (Page<FscUserOverdueControlConfigPO>)pager);
            if (!CollectionUtils.isEmpty(listPage)) {
                List rows = listPage.stream().map(i -> {
                    FscDownBoxInfoBO infoBo = new FscDownBoxInfoBO();
                    infoBo.setDownBoxValue(i.getConfigUserName());
                    return infoBo;
                }).collect(Collectors.toList());
                rspBo.setPageNo(Integer.valueOf(pager.getPageNo()));
                rspBo.setTotal(Integer.valueOf(pager.getTotalPages()));
                rspBo.setRecordsTotal(Integer.valueOf(pager.getTotalCount()));
                rspBo.setRows(rows);
            }
        } else {
            fscUserOverdueControlConfigQry.setConfigUserAccountLike(reqBo.getQueryCriteria());
            fscUserOverdueControlConfigQry.setOrderBy(" a.CONFIG_USER_ACCOUNT ASC ");
            listPage = this.fscUserOverdueControlConfigMapper.getListPageStatisticsConfigUserAccount(fscUserOverdueControlConfigQry, (Page<FscUserOverdueControlConfigPO>)pager);
            if (!CollectionUtils.isEmpty(listPage)) {
                List rows = listPage.stream().map(i -> {
                    FscDownBoxInfoBO infoBo = new FscDownBoxInfoBO();
                    infoBo.setDownBoxValue(i.getConfigUserAccount());
                    return infoBo;
                }).collect(Collectors.toList());
                rspBo.setPageNo(Integer.valueOf(pager.getPageNo()));
                rspBo.setTotal(Integer.valueOf(pager.getTotalPages()));
                rspBo.setRecordsTotal(Integer.valueOf(pager.getTotalCount()));
                rspBo.setRows(rows);
            }
        }
    }

    private void queryUserOverdueControlConfigUserName(FscDownBoxQryAbilityReqBO reqBo, FscDownBoxQryAbilityRspBO rspBo) {
        log.debug("\u7528\u6237\u903e\u671f\u8bb0\u5f55\u59d3\u540d\u4e0b\u62c9\u6846\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        FscUserOverdueControlConfigPO fscUserOverdueControlConfigQry = new FscUserOverdueControlConfigPO();
        fscUserOverdueControlConfigQry.setConfigUserNameLike(reqBo.getQueryCriteria());
        fscUserOverdueControlConfigQry.setConfigUserNameNotNull(YesNo.YES.getCode());
        Page pager = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List<FscUserOverdueControlConfigPO> listPage = this.fscUserOverdueControlConfigMapper.getListPageConfigUserName(fscUserOverdueControlConfigQry, (Page<FscUserOverdueControlConfigPO>)pager);
        if (!CollectionUtils.isEmpty(listPage)) {
            List rows = listPage.stream().map(i -> {
                FscDownBoxInfoBO infoBo = new FscDownBoxInfoBO();
                infoBo.setDownBoxValue(i.getConfigUserName());
                return infoBo;
            }).collect(Collectors.toList());
            rspBo.setPageNo(Integer.valueOf(pager.getPageNo()));
            rspBo.setTotal(Integer.valueOf(pager.getTotalPages()));
            rspBo.setRecordsTotal(Integer.valueOf(pager.getTotalCount()));
            rspBo.setRows(rows);
        }
    }

    private void queryPayConfigLogUserName(FscDownBoxQryAbilityReqBO reqBo, FscDownBoxQryAbilityRspBO rspBo) {
        log.debug("\u652f\u4ed8\u914d\u7f6e\u4fee\u6539\u8bb0\u5f55\u4fee\u6539\u4eba\u4e0b\u62c9\u6846\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        FscPayConfigLogPO fscPayConfigLogPo = new FscPayConfigLogPO();
        fscPayConfigLogPo.setCreateUserNameLike(reqBo.getQueryCriteria());
        fscPayConfigLogPo.setCreateUserNameNotNull(YesNo.YES.getCode());
        fscPayConfigLogPo.setOrderBy(" CREATE_USER_NAME ASC ");
        Page pager = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List<FscPayConfigLogPO> listPage = this.fscPayConfigLogMapper.getListPageCreateUserName(fscPayConfigLogPo, (Page<FscPayConfigLogPO>)pager);
        if (!CollectionUtils.isEmpty(listPage)) {
            List rows = listPage.stream().map(i -> {
                FscDownBoxInfoBO infoBo = new FscDownBoxInfoBO();
                infoBo.setDownBoxValue(i.getCreateUserName());
                return infoBo;
            }).collect(Collectors.toList());
            rspBo.setPageNo(Integer.valueOf(pager.getPageNo()));
            rspBo.setTotal(Integer.valueOf(pager.getTotalPages()));
            rspBo.setRecordsTotal(Integer.valueOf(pager.getTotalCount()));
            rspBo.setRows(rows);
        }
    }
}

