/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import com.tydic.pfscext.api.ability.FscGetElectronicInvoiceAbilityService;
import com.tydic.pfscext.api.ability.bo.FscGetElectronicInvoiceAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscGetElectronicInvoiceAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscGetElectronicInvoiceInfoBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.esb.api.FscEsbGetElectronicInvoiceExternalService;
import com.tydic.pfscext.external.esb.bo.FscEsbGetElectronicInvoiceExternalReqBO;
import com.tydic.pfscext.external.esb.bo.FscEsbGetElectronicInvoiceExternalRspBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscGetElectronicInvoiceAbilityService"})
public class FscGetElectronicInvoiceAbilityServiceImpl
implements FscGetElectronicInvoiceAbilityService {
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private FscEsbGetElectronicInvoiceExternalService fscEsbGetElectronicInvoiceExternalService;

    @PostMapping(value={"getElectronicInvoice"})
    public FscGetElectronicInvoiceAbilityRspBO getElectronicInvoice(@RequestBody FscGetElectronicInvoiceAbilityReqBO reqBo) {
        ValUtil.isBlank(reqBo.getNotificationNo()).exception("\u5165\u53c2\u5f00\u7968\u901a\u77e5\u5355\u53f7\u4e3a\u7a7a");
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(reqBo.getNotificationNo());
        ValUtil.isEmpty(billNotificationInfo).exception("\u6839\u636e\u5f00\u7968\u901a\u77e5\u5355\u53f7[" + reqBo.getNotificationNo() + "]\u67e5\u8be2\u901a\u77e5\u5355\u4e3a\u7a7a");
        ValUtil.isEmpty(billNotificationInfo.getSupplierNo()).exception("\u6839\u636e\u901a\u77e5\u5355\u53f7\u67e5\u8be2\u7684\u5f00\u7968\u901a\u77e5\u4f9b\u5e94\u5546ID\u4e3a\u7a7a");
        FscEsbGetElectronicInvoiceExternalReqBO externalReqBo = new FscEsbGetElectronicInvoiceExternalReqBO();
        externalReqBo.setSupplierId(billNotificationInfo.getSupplierNo().toString());
        externalReqBo.setNotificationNo(reqBo.getNotificationNo());
        FscEsbGetElectronicInvoiceExternalRspBO externalRspBo = this.fscEsbGetElectronicInvoiceExternalService.getElectronicInvoice(externalReqBo);
        if (FscRu.isFailed(externalRspBo.getRespCode()).booleanValue()) {
            throw new PfscExtBusinessException(externalRspBo.getRespCode(), externalRspBo.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)externalRspBo.getInvoiceInfos())) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u53d1\u7968\u4e3a\u7a7a");
        }
        List<FscGetElectronicInvoiceInfoBO> invoiceInfoList = FscRu.jsl(externalRspBo.getInvoiceInfos(), FscGetElectronicInvoiceInfoBO.class);
        FscGetElectronicInvoiceAbilityRspBO rspBo = FscRu.success(FscGetElectronicInvoiceAbilityRspBO.class);
        rspBo.setInvoiceInfoList(invoiceInfoList);
        return rspBo;
    }
}

