/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.ability.FscInspectionBillInfoQryAbilityService;
import com.tydic.pfscext.api.ability.bo.FscInspectionBillInfoItemBO;
import com.tydic.pfscext.api.ability.bo.FscInspectionBillInfoQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscInspectionBillInfoQryAbilityRspBO;
import com.tydic.pfscext.api.busi.QueryApplyPayInfoService;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.ApplyPayInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscInspectionBillInfoQryAbilityService"})
public class FscInspectionBillInfoQryAbilityServiceImpl
implements FscInspectionBillInfoQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscInspectionBillInfoQryAbilityServiceImpl.class);
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper purchaseOrderInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private QueryApplyPayInfoService queryApplyPayInfoService;

    @PostMapping(value={"listInspectionBillInfo"})
    public FscInspectionBillInfoQryAbilityRspBO listInspectionBillInfo(@RequestBody FscInspectionBillInfoQryAbilityReqBO reqBo) {
        FscInspectionBillInfoQryAbilityRspBO rspBo = FscRu.success(FscInspectionBillInfoQryAbilityRspBO.class);
        ArrayList<FscInspectionBillInfoItemBO> inspectionBillInfos = new ArrayList<FscInspectionBillInfoItemBO>();
        rspBo.setInspectionBillInfos(inspectionBillInfos);
        if (CollectionUtils.isEmpty((Collection)reqBo.getOrderIds())) {
            rspBo.setRespDesc("\u5165\u53c2\u8ba2\u5355ID\u96c6\u5408\u4e3a\u7a7a");
            return rspBo;
        }
        List orderIds = reqBo.getOrderIds().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orderIds)) {
            rspBo.setRespDesc("\u5165\u53c2\u8ba2\u5355ID\u96c6\u5408\u4e0d\u8981\u5168\u662f\u7a7a\u503c");
            return rspBo;
        }
        List batchList = ListUtil.batchList(orderIds);
        for (List subOrderIds : batchList) {
            List<SaleOrderInfo> orderInfos;
            if (CollectionUtils.isEmpty((Collection)subOrderIds) || CollectionUtils.isEmpty(orderInfos = this.saleOrderInfoMapper.getListSaleOrderInfoByOrderIds(subOrderIds))) continue;
            for (SaleOrderInfo saleOrderInfo : orderInfos) {
                PayPurchaseOrderInfo purchaseOrderInfo;
                FscInspectionBillInfoItemBO item = new FscInspectionBillInfoItemBO();
                inspectionBillInfos.add(item);
                item.setInspectionId(saleOrderInfo.getInspectionId());
                item.setOrderId(saleOrderInfo.getOrderId());
                item.setSource(saleOrderInfo.getSource());
                item.setSaleOrderCode(saleOrderInfo.getSaleOrderCode());
                item.setBusiModel(saleOrderInfo.getBusiModel());
                if (saleOrderInfo.getBusiModel() == null) continue;
                if (BusiModel.TRADE_MODEL.getCode().equals(saleOrderInfo.getBusiModel())) {
                    BillApplyInfo billApplyInfo;
                    item.setOrderStatus(saleOrderInfo.getOrderStatus());
                    item.setOrderStatusStr(OrderStatus.desc(saleOrderInfo.getOrderStatus()));
                    item.setApplyNo(saleOrderInfo.getApplyNo());
                    if (!StringUtils.hasText((String)saleOrderInfo.getApplyNo()) || (billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(saleOrderInfo.getApplyNo())) == null) continue;
                    item.setApplyDate(billApplyInfo.getApplyDate());
                    item.setSignDate(billApplyInfo.getSignDate());
                    continue;
                }
                if (!BusiModel.MATCH_UP_MODEL.getCode().equals(saleOrderInfo.getBusiModel()) || (purchaseOrderInfo = this.purchaseOrderInfoMapper.getModelByPrimaryKey(saleOrderInfo.getOrderId(), saleOrderInfo.getInspectionId())) == null) continue;
                item.setNotificationNo(purchaseOrderInfo.getNotificationNo());
                item.setOrderStatus(purchaseOrderInfo.getOrderStatus());
                item.setOrderStatusStr(OrderStatus.desc(purchaseOrderInfo.getOrderStatus()));
                if (!StringUtils.hasText((String)purchaseOrderInfo.getNotificationNo())) continue;
                BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(purchaseOrderInfo.getNotificationNo());
                item.setApplyDate(billNotificationInfo.getApplyDate());
                item.setSignDate(billNotificationInfo.getSignDate());
            }
        }
        return rspBo;
    }

    private Date getPayApplyDate(String saleOrderCode) {
        if (StringUtils.hasText((String)saleOrderCode)) {
            ApplyPayInfoVO applyPayInfoVo = new ApplyPayInfoVO();
            applyPayInfoVo.setPurchaseOrderCode(saleOrderCode);
            List<ApplyPayInfoVO> applyPayInfoVOS = this.applyPayInfoMapper.selectListPayableList(applyPayInfoVo, (Page<Map<String, Object>>)new Page(1, -1), null, new ArrayList<Integer>(), new ArrayList<Integer>());
            log.debug("\u4ed8\u6b3e\u7533\u8bf7\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(applyPayInfoVOS));
            if (!CollectionUtils.isEmpty(applyPayInfoVOS)) {
                Date date = applyPayInfoVOS.stream().map(ApplyPayInfoPO::getApplyDate).filter(Objects::nonNull).max(Date::compareTo).get();
                return date;
            }
        }
        return null;
    }
}

