/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.tydic.pfscext.api.ability.FscOrderBeachHangAbilityService;
import com.tydic.pfscext.api.ability.bo.FscOrderBeachHangAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscOrderBeachHangAbilityRspBO;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfoExtendPO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoExtendPO;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscOrderBeachHangBusiService;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import com.tydic.pfscext.utils.ValUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscOrderBeachHangAbilityService"})
public class FscOrderBeachHangAbilityServiceImpl
implements FscOrderBeachHangAbilityService {
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private FscOrderBeachHangBusiService fscOrderBeachHangBusiService;

    @PostMapping(value={"dealPurchaseOrderBeachHang"})
    public FscOrderBeachHangAbilityRspBO dealPurchaseOrderBeachHang(@RequestBody FscOrderBeachHangAbilityReqBO reqBo) {
        this.parameterValidation(reqBo);
        List<Long> inspectionIdList = reqBo.getInspectionIdList().stream().distinct().collect(Collectors.toList());
        this.checkPurchaseOrderStatus(reqBo.getOpeFlag(), inspectionIdList);
        if ("1".equals(reqBo.getOpeFlag())) {
            for (List subInspIds : ListUtil.batchList(inspectionIdList, (int)100)) {
                FscOrderBeachHangAbilityReqBO busiReqBo = FscRu.js(reqBo, FscOrderBeachHangAbilityReqBO.class);
                busiReqBo.setInspectionIdList(subInspIds);
                FscOrderBeachHangAbilityRspBO busiRspBo = this.fscOrderBeachHangBusiService.dealPurchaseOrderHang(busiReqBo);
                if (!FscRu.isFailed(busiRspBo.getRespCode()).booleanValue()) continue;
                return busiRspBo;
            }
            return FscRu.success("\u6279\u91cf\u6302\u8d77\u64cd\u4f5c\u6210\u529f", FscOrderBeachHangAbilityRspBO.class);
        }
        if ("2".equals(reqBo.getOpeFlag())) {
            for (List subInspIds : ListUtil.batchList(inspectionIdList, (int)100)) {
                FscOrderBeachHangAbilityReqBO busiReqBo = FscRu.js(reqBo, FscOrderBeachHangAbilityReqBO.class);
                busiReqBo.setInspectionIdList(subInspIds);
                FscOrderBeachHangAbilityRspBO busiRspBo = this.fscOrderBeachHangBusiService.dealPurchaseOrderCancelHang(busiReqBo);
                if (!FscRu.isFailed(busiRspBo.getRespCode()).booleanValue()) continue;
                return busiRspBo;
            }
            return FscRu.success("\u6279\u91cf\u53d6\u6d88\u6302\u8d77\u64cd\u4f5c\u6210\u529f", FscOrderBeachHangAbilityRspBO.class);
        }
        return FscRu.failed("0001", "\u672a\u77e5\u64cd\u4f5c\u7c7b\u578b", FscOrderBeachHangAbilityRspBO.class);
    }

    @PostMapping(value={"dealSaleOrderBeachHang"})
    public FscOrderBeachHangAbilityRspBO dealSaleOrderBeachHang(@RequestBody FscOrderBeachHangAbilityReqBO reqBo) {
        this.parameterValidation(reqBo);
        List<Long> inspectionIdList = reqBo.getInspectionIdList().stream().distinct().collect(Collectors.toList());
        this.checkSaleOrderStatus(reqBo.getOpeFlag(), inspectionIdList);
        if ("1".equals(reqBo.getOpeFlag())) {
            for (List subInspIds : ListUtil.batchList(inspectionIdList, (int)100)) {
                FscOrderBeachHangAbilityReqBO busiReqBo = FscRu.js(reqBo, FscOrderBeachHangAbilityReqBO.class);
                busiReqBo.setInspectionIdList(subInspIds);
                FscOrderBeachHangAbilityRspBO busiRspBo = this.fscOrderBeachHangBusiService.dealSaleOrderHang(busiReqBo);
                if (!FscRu.isFailed(busiRspBo.getRespCode()).booleanValue()) continue;
                return busiRspBo;
            }
            return FscRu.success("\u6279\u91cf\u6302\u8d77\u64cd\u4f5c\u6210\u529f", FscOrderBeachHangAbilityRspBO.class);
        }
        if ("2".equals(reqBo.getOpeFlag())) {
            for (List subInspIds : ListUtil.batchList(inspectionIdList, (int)100)) {
                FscOrderBeachHangAbilityReqBO busiReqBo = FscRu.js(reqBo, FscOrderBeachHangAbilityReqBO.class);
                busiReqBo.setInspectionIdList(subInspIds);
                FscOrderBeachHangAbilityRspBO busiRspBo = this.fscOrderBeachHangBusiService.dealSaleOrderCancelHang(busiReqBo);
                if (!FscRu.isFailed(busiRspBo.getRespCode()).booleanValue()) continue;
                return busiRspBo;
            }
            return FscRu.success("\u6279\u91cf\u53d6\u6d88\u6302\u8d77\u64cd\u4f5c\u6210\u529f", FscOrderBeachHangAbilityRspBO.class);
        }
        return FscRu.failed("0001", "\u672a\u77e5\u64cd\u4f5c\u7c7b\u578b", FscOrderBeachHangAbilityRspBO.class);
    }

    private void checkSaleOrderStatus(String opeFlag, List<Long> inspectionIdList) {
        List batchList = ListUtil.batchList(inspectionIdList, (int)500);
        ArrayList notSearchIds = new ArrayList();
        HashMap<Long, String> errorHangIds = new HashMap<Long, String>();
        HashMap<Long, String> errorCancelIds = new HashMap<Long, String>();
        for (List subInspectionIdList : batchList) {
            Map<Long, String> mapOrderStatus;
            List<SaleOrderInfoExtendPO> saleOrderInfoList = this.getSaleOrderInfo(subInspectionIdList);
            if (CollectionUtils.isEmpty(saleOrderInfoList)) {
                notSearchIds.addAll(subInspectionIdList);
                continue;
            }
            if ("1".equals(opeFlag)) {
                mapOrderStatus = saleOrderInfoList.stream().filter(i -> !OrderStatus.NO_APPLY.getCode().equals(i.getOrderStatus())).collect(Collectors.toMap(SaleOrderInfo::getInspectionId, SaleOrderInfo::getOrderStatus));
                if (!CollectionUtils.isEmpty(mapOrderStatus)) {
                    errorHangIds.putAll(mapOrderStatus);
                }
            } else if ("2".equals(opeFlag) && !CollectionUtils.isEmpty(mapOrderStatus = saleOrderInfoList.stream().filter(item -> !OrderStatus.HANGING.getCode().equals(item.getOrderStatus()) && !OrderStatus.AUTO_HANG_UP.getCode().equals(item.getOrderStatus())).collect(Collectors.toMap(SaleOrderInfo::getInspectionId, SaleOrderInfo::getOrderStatus)))) {
                errorCancelIds.putAll(mapOrderStatus);
            }
            List insIdList = saleOrderInfoList.stream().map(SaleOrderInfo::getInspectionId).collect(Collectors.toList());
            notSearchIds.addAll(subInspectionIdList.stream().filter(i -> !insIdList.contains(i)).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(notSearchIds)) {
            throw new PfscExtBusinessException("0001", StrUtil.format((CharSequence)"\u9a8c\u6536\u5355[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{notSearchIds.stream().map(String::valueOf).collect(Collectors.joining(","))}));
        }
        if (!errorHangIds.isEmpty()) {
            throw new PfscExtBusinessException("0001", StrUtil.format((CharSequence)"\u9a8c\u6536\u5355[{}]\u72b6\u6001\u5f02\u5e38\uff0c\u672a\u63d0\u4ea4\u7684\u8ba2\u5355\u624d\u80fd\u6302\u8d77", (Object[])new Object[]{errorHangIds.keySet().stream().map(String::valueOf).collect(Collectors.joining(","))}));
        }
        if (!errorCancelIds.isEmpty()) {
            throw new PfscExtBusinessException("0001", StrUtil.format((CharSequence)"\u9a8c\u6536\u5355[{}]\u72b6\u6001\u4e0d\u662f\u6302\u8d77\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u6302\u8d77", (Object[])new Object[]{errorCancelIds.keySet().stream().map(String::valueOf).collect(Collectors.joining(","))}));
        }
    }

    private List<SaleOrderInfoExtendPO> getSaleOrderInfo(List<Long> inspectionIdList) {
        if (!CollectionUtils.isEmpty(inspectionIdList)) {
            SaleOrderInfoExtendPO saleOrderInfoExtendQry = new SaleOrderInfoExtendPO();
            saleOrderInfoExtendQry.setQueryResultIdentification("2");
            saleOrderInfoExtendQry.setInspectionIdList(inspectionIdList);
            return this.saleOrderInfoMapper.getListNew(saleOrderInfoExtendQry);
        }
        return new ArrayList<SaleOrderInfoExtendPO>();
    }

    private void checkPurchaseOrderStatus(String opeFlag, List<Long> inspectionIdList) {
        List batchList = ListUtil.batchList(inspectionIdList, (int)500);
        ArrayList notSearchIds = new ArrayList();
        HashMap<Long, String> errorHangIds = new HashMap<Long, String>();
        HashMap<Long, String> errorCancelIds = new HashMap<Long, String>();
        for (List subInspectionIdList : batchList) {
            Map<Long, String> mapOrderStatus;
            List<PayPurchaseOrderInfoExtendPO> purchaseOrderInfoList = this.getPayPurchaseOrderInfo(subInspectionIdList);
            if (CollectionUtils.isEmpty(purchaseOrderInfoList)) {
                notSearchIds.addAll(subInspectionIdList);
                continue;
            }
            if ("1".equals(opeFlag)) {
                mapOrderStatus = purchaseOrderInfoList.stream().filter(i -> !OrderStatus.NO_APPLY.getCode().equals(i.getOrderStatus())).collect(Collectors.toMap(PayPurchaseOrderInfo::getInspectionId, PayPurchaseOrderInfo::getOrderStatus));
                if (!CollectionUtils.isEmpty(mapOrderStatus)) {
                    errorHangIds.putAll(mapOrderStatus);
                }
            } else if ("2".equals(opeFlag) && !CollectionUtils.isEmpty(mapOrderStatus = purchaseOrderInfoList.stream().filter(item -> !OrderStatus.HANGING.getCode().equals(item.getOrderStatus()) && !OrderStatus.AUTO_HANG_UP.getCode().equals(item.getOrderStatus())).collect(Collectors.toMap(PayPurchaseOrderInfo::getInspectionId, PayPurchaseOrderInfo::getOrderStatus)))) {
                errorCancelIds.putAll(mapOrderStatus);
            }
            List insIdList = purchaseOrderInfoList.stream().map(PayPurchaseOrderInfo::getInspectionId).collect(Collectors.toList());
            notSearchIds.addAll(subInspectionIdList.stream().filter(i -> !insIdList.contains(i)).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(notSearchIds)) {
            throw new PfscExtBusinessException("0001", StrUtil.format((CharSequence)"\u9a8c\u6536\u5355[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{notSearchIds.stream().map(String::valueOf).collect(Collectors.joining(","))}));
        }
        if (!errorHangIds.isEmpty()) {
            throw new PfscExtBusinessException("0001", StrUtil.format((CharSequence)"\u9a8c\u6536\u5355[{}]\u72b6\u6001\u5f02\u5e38\uff0c\u672a\u63d0\u4ea4\u7684\u8ba2\u5355\u624d\u80fd\u6302\u8d77", (Object[])new Object[]{errorHangIds.keySet().stream().map(String::valueOf).collect(Collectors.joining(","))}));
        }
        if (!errorCancelIds.isEmpty()) {
            throw new PfscExtBusinessException("0001", StrUtil.format((CharSequence)"\u9a8c\u6536\u5355[{}]\u72b6\u6001\u4e0d\u662f\u6302\u8d77\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u6302\u8d77", (Object[])new Object[]{errorCancelIds.keySet().stream().map(String::valueOf).collect(Collectors.joining(","))}));
        }
    }

    private List<PayPurchaseOrderInfoExtendPO> getPayPurchaseOrderInfo(List<Long> inspectionIdList) {
        if (!CollectionUtils.isEmpty(inspectionIdList)) {
            PayPurchaseOrderInfoExtendPO payPurchaseOrderInfoExtendQry = new PayPurchaseOrderInfoExtendPO();
            payPurchaseOrderInfoExtendQry.setQueryResultIdentification("2");
            payPurchaseOrderInfoExtendQry.setInspectionIdList(inspectionIdList);
            return this.payPurchaseOrderInfoMapper.getListNew(payPurchaseOrderInfoExtendQry);
        }
        return new ArrayList<PayPurchaseOrderInfoExtendPO>();
    }

    private void parameterValidation(FscOrderBeachHangAbilityReqBO reqBo) {
        ValUtil.isBlank(reqBo.getOpeFlag()).exception("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (!Arrays.asList("1", "2").contains(reqBo.getOpeFlag())) {
            throw new PfscExtBusinessException("0001", "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getInspectionIdList())) {
            throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355\u6570\u636e\u4e3a\u7a7a");
        }
        if (reqBo.getInspectionIdList().size() > 1000) {
            throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355\u6570\u636e\u91cf\u592a\u5927,\u8d85\u8fc7\u4e00\u5343\u6761\uff0c\u8bf7\u5206\u6279\u64cd\u4f5c");
        }
        long count = reqBo.getInspectionIdList().stream().filter(i -> i != null && 0L != i).distinct().count();
        if ((long)reqBo.getInspectionIdList().size() != count) {
            throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355\u6570\u636e\u5b58\u5728\u9a8c\u6536\u5355ID\u91cd\u590d\u6216\u8005\u4e3a\u7a7a");
        }
    }
}

