/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.tydic.pfscext.annotation.constant.LogConstant;
import com.tydic.pfscext.annotation.log.FscExtSysLog;
import com.tydic.pfscext.api.ability.FscOrderCreditRecordAbilityService;
import com.tydic.pfscext.api.ability.bo.FscOrderCreditRecordAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscOrderCreditRecordAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscOrderCreditUsedAmountQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscOrderCreditUsedAmountQryAbilityRspBO;
import com.tydic.pfscext.dao.FscCreditRecordMapper;
import com.tydic.pfscext.dao.po.FscCreditRecordPO;
import com.tydic.pfscext.enums.FscCreditBusiCategory;
import com.tydic.pfscext.enums.FscCreditBusiType;
import com.tydic.pfscext.service.busi.FscCreditRecordBusiService;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscOrderCreditRecordAbilityService"})
public class FscOrderCreditRecordAbilityServiceImpl
implements FscOrderCreditRecordAbilityService {
    @Autowired
    private FscCreditRecordMapper fscCreditRecordMapper;
    @Autowired
    private FscCreditRecordBusiService fscCreditRecordBusiService;

    @FscExtSysLog(params={"orderId"}, source=LogConstant.SysCode.UOC, target=LogConstant.SysCode.FSC, rspBase=LogConstant.RspBase.CENTER)
    @PostMapping(value={"dealAddCreditRecord"})
    public FscOrderCreditRecordAbilityRspBO dealAddCreditRecord(@RequestBody FscOrderCreditRecordAbilityReqBO reqBo) {
        List<String> errorList = this.parameterValidation(reqBo);
        if (errorList.size() > 0) {
            return FscRu.failed("18000", "\u5165\u53c2\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a" + errorList, FscOrderCreditRecordAbilityRspBO.class);
        }
        FscOrderCreditRecordBusiReqBO busiReqBo = FscRu.js(reqBo, FscOrderCreditRecordBusiReqBO.class);
        FscOrderCreditRecordBusiRspBO busiRspBo = this.fscCreditRecordBusiService.dealOrderCreditRecord(busiReqBo);
        return FscRu.js((Object)busiRspBo, FscOrderCreditRecordAbilityRspBO.class);
    }

    private List<String> parameterValidation(FscOrderCreditRecordAbilityReqBO reqBo) {
        ArrayList<String> errorList = new ArrayList<String>();
        if (reqBo == null) {
            errorList.add("\u5165\u53c2\u4e3a\u7a7a");
            return errorList;
        }
        FscCreditBusiCategory busiCategory = FscCreditBusiCategory.instance((String)reqBo.getBusiCategory());
        FscCreditBusiType busiType = FscCreditBusiType.instance((String)reqBo.getBusiType());
        if (busiCategory == null) {
            errorList.add("\u6388\u4fe1\u989d\u5ea6\u4f7f\u7528\u7c7b\u578b\u672a\u77e5");
        } else {
            EnumSet<FscCreditBusiCategory[]> busiCategoryEnumSet = EnumSet.of(FscCreditBusiCategory.ORD_ADD, new FscCreditBusiCategory[]{FscCreditBusiCategory.ORD_CANCEL, FscCreditBusiCategory.ORD_RETURN, FscCreditBusiCategory.ORD_PART_CANCEL, FscCreditBusiCategory.ORD_PAY, FscCreditBusiCategory.ORD_PAY_REFUND, FscCreditBusiCategory.ORD_ADJUST, FscCreditBusiCategory.ORD_DIFF, FscCreditBusiCategory.ORD_ABNORMAL, FscCreditBusiCategory.ORD_ADJUST_REFUND, FscCreditBusiCategory.ORD_DISPATCH, FscCreditBusiCategory.ORD_DISPATCH_RESEND});
            if (!busiCategoryEnumSet.contains(busiCategory)) {
                errorList.add("\u6388\u4fe1\u989d\u5ea6\u4f7f\u7528\u7c7b\u578b\u9519\u8bef");
            }
        }
        if (busiType == null) {
            errorList.add("\u5355\u636e\u7c7b\u578b\u672a\u77e5");
        }
        if (reqBo.getOrderId() == null || reqBo.getOrderId() == 0L) {
            errorList.add("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)reqBo.getOrderCode())) {
            errorList.add("\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getBusiAmount() == null) {
            errorList.add("\u6388\u4fe1\u989d\u5ea6\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (FscCreditBusiCategory.ORD_ADD.equals((Object)busiCategory)) {
            if (reqBo.getPayConfigId() == null || reqBo.getPayConfigId() == 0L) {
                errorList.add("\u652f\u4ed8\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBo.getAccountId() == null || reqBo.getAccountId() == 0L) {
                errorList.add("\u91c7\u8d2d\u5355\u4f4d\u5e10\u5957\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBo.getBusiModel() == null) {
                errorList.add("\u7ed3\u7b97\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!FscCreditBusiType.ORD_PD.equals((Object)busiType) && FscRu.isEmptyNum(reqBo.getSupplierNo())) {
                errorList.add("\u4f9b\u5e94\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            FscCreditRecordPO fscCreditRecordOld = new FscCreditRecordPO();
            fscCreditRecordOld.setObjId(reqBo.getOrderId());
            fscCreditRecordOld.setBusiCategory(FscCreditBusiCategory.ORD_ADD.getCode());
            int checkBy = this.fscCreditRecordMapper.getCheckBy(fscCreditRecordOld);
            if (checkBy < 1) {
                errorList.add("\u5458\u5de5\u6d3b\u52a8\u4e0b\u5355\u6263\u51cf\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
        }
        if (FscCreditBusiCategory.ORD_DISPATCH.equals((Object)busiCategory)) {
            if (!FscCreditBusiType.ORD_PD.equals((Object)busiType)) {
                errorList.add("\u6d3e\u5355\u8ba2\u5355\u624d\u6709\u6d3e\u5355\u4e1a\u52a1");
            }
            if (FscRu.isEmptyNum(reqBo.getSupplierNo())) {
                errorList.add("\u4f9b\u5e94\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (FscCreditBusiCategory.ORD_DISPATCH_RESEND.equals((Object)busiCategory)) {
            if (!FscCreditBusiType.ORD_PD.equals((Object)busiType)) {
                errorList.add("\u6d3e\u5355\u8ba2\u5355\u624d\u6709\u91cd\u65b0\u6d3e\u5355\u4e1a\u52a1");
            }
            if (FscRu.isEmptyNum(reqBo.getDispatchOrderId())) {
                errorList.add("\u6d3e\u5355\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)reqBo.getDispatchOrderCode())) {
                errorList.add("\u6d3e\u5355\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        return errorList;
    }

    @PostMapping(value={"getOrdCreditUsedAmt"})
    public FscOrderCreditUsedAmountQryAbilityRspBO getOrdCreditUsedAmt(@RequestBody FscOrderCreditUsedAmountQryAbilityReqBO reqBo) {
        ValUtil.isEmpty(reqBo.getOrderId()).exception("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal usedAmount = BigDecimal.ZERO;
        FscCreditRecordPO po = this.fscCreditRecordMapper.getOrderCreditUsedAmt(reqBo.getOrderId());
        if (po != null && po.getBusiAmount() != null) {
            usedAmount = po.getBusiAmount();
        }
        FscOrderCreditUsedAmountQryAbilityRspBO rspBo = FscRu.success(FscOrderCreditUsedAmountQryAbilityRspBO.class);
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setUsedAmount(usedAmount);
        return rspBo;
    }
}

