/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.pfscext.api.ability.FscOrderOverdueChangeRecordAbilityService;
import com.tydic.pfscext.api.ability.bo.FscOrderOverdueChangeRecordAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscOrderOverdueChangeRecordAbilityRspBO;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.service.busi.FscCreditControlBusiService;
import com.tydic.pfscext.service.busi.FscOrderOverdueInspectionRecordBusiService;
import com.tydic.pfscext.service.busi.FscPayConfigSaveBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlUserInspectionBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscOrderOverdueInspectionRecordAddBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscOrderOverdueInspectionRecordAddBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigUpdateOverdueBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigUpdateOverdueBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscOrderOverdueChangeRecordAbilityService"})
public class FscOrderOverdueChangeRecordAbilityServiceImpl
implements FscOrderOverdueChangeRecordAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderOverdueChangeRecordAbilityServiceImpl.class);
    @Resource
    private FscPayConfigMapper fscPayConfigMapper;
    @Resource
    private FscPayConfigSaveBusiService fscPayConfigSaveBusiService;
    @Resource
    private FscCreditControlBusiService fscCreditControlBusiService;
    @Resource
    private FscOrderOverdueInspectionRecordBusiService fscOrderOverdueInspectionRecordBusiService;
    @Resource(name="fscCreditControlUserProvider")
    private ProxyMessageProducer fscCreditControlUserProvider;
    @Value(value="${FSC_CREDIT_CONTROL_USER_TOPIC:FSC_CREDIT_CONTROL_USER_TOPIC}")
    private String FSC_CREDIT_CONTROL_USER_TOPIC;
    @Value(value="${FSC_CREDIT_CONTROL_USER_TAG:*}")
    private String FSC_CREDIT_CONTROL_USER_TAG;

    @PostMapping(value={"dealOrderOverdueChangeRecord"})
    public FscOrderOverdueChangeRecordAbilityRspBO dealOrderOverdueChangeRecord(@RequestBody FscOrderOverdueChangeRecordAbilityReqBO reqBo) {
        FscOrderOverdueChangeRecordAbilityRspBO rspBo = FscRu.success(FscOrderOverdueChangeRecordAbilityRspBO.class);
        FscOrderOverdueInspectionRecordAddBusiReqBO busiReqBo = FscRu.js(reqBo, FscOrderOverdueInspectionRecordAddBusiReqBO.class);
        busiReqBo.setCreateUserId(reqBo.getUserId());
        busiReqBo.setCreateUserName(reqBo.getUsername());
        FscOrderOverdueInspectionRecordAddBusiRspBO busiRspBo = this.fscOrderOverdueInspectionRecordBusiService.dealOrderOverdueInspectionRecordSave(busiReqBo);
        if (FscRu.isFailed(busiRspBo.getRespCode()).booleanValue()) {
            log.error("\u8ba2\u5355\u4e2d\u5fc3\u9a8c\u6536\u5355\u8fdd\u7ea6\u91d1\u53d8\u66f4\u8bb0\u5f55\u65b0\u589e\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)((Object)busiRspBo)));
            rspBo.setRespDesc("\u8ba2\u5355\u4e2d\u5fc3\u9a8c\u6536\u5355\u8fdd\u7ea6\u91d1\u53d8\u66f4\u8bb0\u5f55\u65b0\u589e\u5931\u8d25");
            return rspBo;
        }
        FscOrderOverdueInspectionRecordAddBusiReqBO updateRemarkReqBo = new FscOrderOverdueInspectionRecordAddBusiReqBO();
        updateRemarkReqBo.setRecordId(busiRspBo.getRecordId());
        updateRemarkReqBo.setDealCode("0000");
        updateRemarkReqBo.setRemark("\u6210\u529f");
        String error = this.parameterVerification(reqBo);
        if (error == null) {
            if ("4".equals(reqBo.getChangeReason())) {
                this.updateUserOverdueOrderNum(reqBo.getInspectionId(), reqBo.getOrderCode());
                updateRemarkReqBo.setDealCode("0000");
                updateRemarkReqBo.setRemark("\u5f02\u6b65\u66f4\u65b0\u9a8c\u6536\u5355\u8fdd\u7ea6\u91d1");
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("0000");
            } else {
                FscPayConfigUpdateOverdueBusiReqBO overdueBusiReqBo = new FscPayConfigUpdateOverdueBusiReqBO();
                overdueBusiReqBo.setUserId(reqBo.getUserId());
                overdueBusiReqBo.setUsername(reqBo.getUsername());
                overdueBusiReqBo.setPayConfigId(reqBo.getPayConfigId());
                overdueBusiReqBo.setOrderId(reqBo.getOrderId());
                overdueBusiReqBo.setInspectionId(reqBo.getInspectionId());
                overdueBusiReqBo.setOverdueRatio(reqBo.getOverdueRatio());
                overdueBusiReqBo.setOverdueAmount(reqBo.getOverdueAmount());
                overdueBusiReqBo.setOverdueIndex(reqBo.getOverdueIndex());
                overdueBusiReqBo.setPenaltyAmount(reqBo.getPenaltyAmount());
                overdueBusiReqBo.setChangeReason(reqBo.getChangeReason());
                FscPayConfigUpdateOverdueBusiRspBO overdueBusiRspBo = this.fscPayConfigSaveBusiService.dealPayConfigUpdateOverdue(overdueBusiReqBo);
                updateRemarkReqBo.setDealCode(overdueBusiRspBo.getRespCode());
                updateRemarkReqBo.setRemark(overdueBusiRspBo.getRespDesc());
                updateRemarkReqBo.setOldOverdueAmount(overdueBusiRspBo.getOldOverdueAmount());
                if (FscRu.isSuccess(overdueBusiRspBo.getRespCode()).booleanValue()) {
                    FscCreditControlBusiReqBO fscCreditControlBusiReqBo = new FscCreditControlBusiReqBO();
                    fscCreditControlBusiReqBo.setPayConfigId(reqBo.getPayConfigId());
                    FscCreditControlBusiRspBO fscCreditControlBusiRspBo = this.fscCreditControlBusiService.dealCreditControl(fscCreditControlBusiReqBo);
                    updateRemarkReqBo.setDealCode(fscCreditControlBusiRspBo.getRespCode());
                    updateRemarkReqBo.setRemark(Optional.ofNullable(fscCreditControlBusiRspBo.getRespDesc()).orElse("fscCreditControlBusiRspBo.respDesc is null"));
                    if (FscRu.isFailed(fscCreditControlBusiRspBo.getRespCode()).booleanValue()) {
                        log.error("\u8ba2\u5355\u4e2d\u5fc3\u9a8c\u6536\u5355\u8fdd\u7ea6\u91d1\u53d8\u66f4\u8bb0\u5f55\u65b0\u589e\u5931\u8d25\uff0c\u66f4\u65b0\u6388\u4fe1\u7ba1\u63a7\u72b6\u6001\u5f02\u5e38\uff1a" + rspBo.getRespDesc());
                        rspBo.setRespCode(fscCreditControlBusiRspBo.getRespCode());
                        rspBo.setRespDesc(fscCreditControlBusiRspBo.getRespDesc());
                    }
                } else {
                    updateRemarkReqBo.setDealCode(overdueBusiRspBo.getRespCode());
                    updateRemarkReqBo.setRemark(Optional.ofNullable(StrUtil.subPre((CharSequence)overdueBusiRspBo.getRespDesc(), (int)1000)).orElse("overdueBusiRspBo.respDesc is null"));
                    rspBo.setRespCode(overdueBusiRspBo.getRespCode());
                    rspBo.setRespDesc(overdueBusiRspBo.getRespDesc());
                }
                if (Arrays.asList("1", "2").contains(reqBo.getChangeReason())) {
                    this.updateUserOverdueOrderNum(reqBo.getInspectionId(), reqBo.getOrderCode());
                }
            }
        } else {
            log.error("\u8ba2\u5355\u4e2d\u5fc3\u9a8c\u6536\u5355\u8fdd\u7ea6\u91d1\u53d8\u66f4\u8bb0\u5f55\u53c2\u6570\u9519\u8bef\uff1a{}.", (Object)error);
            updateRemarkReqBo.setDealCode("0001");
            updateRemarkReqBo.setRemark(error);
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a" + error);
            rspBo.setRecordId(busiRspBo.getRecordId());
        }
        updateRemarkReqBo.setRemark(StrUtil.subPre((CharSequence)updateRemarkReqBo.getRemark(), (int)2000));
        FscOrderOverdueInspectionRecordAddBusiRspBO updateRemarkRspBo = this.fscOrderOverdueInspectionRecordBusiService.dealOrderOverdueInspectionRecordSave(updateRemarkReqBo);
        if (FscRu.isFailed(updateRemarkRspBo.getRespCode()).booleanValue()) {
            rspBo.setRespCode(updateRemarkRspBo.getRespCode());
            rspBo.setRespDesc(updateRemarkRspBo.getRespDesc());
        }
        return rspBo;
    }

    private void updateUserOverdueOrderNum(Long inspectionId, String orderCode) {
        if (inspectionId == null) {
            log.error("\u9a8c\u6536\u5355ID\u4e3a\u7a7a");
            return;
        }
        FscCreditControlUserInspectionBusiReqBO busiReqBo = new FscCreditControlUserInspectionBusiReqBO();
        busiReqBo.setInspectionId(inspectionId);
        busiReqBo.setOrderCode(orderCode);
        JSONObject data = new JSONObject();
        data.put("type", (Object)"TYPE_CONTROL_USER_INSPECTION");
        data.put("busiReqBo", (Object)busiReqBo);
        ProxySendResult sendResult = this.fscCreditControlUserProvider.send(new ProxyMessage(this.FSC_CREDIT_CONTROL_USER_TOPIC, this.FSC_CREDIT_CONTROL_USER_TAG, data.toJSONString()));
        if (!"SEND_OK".equals(sendResult.getStatus())) {
            log.error("\u5f02\u6b65\u66f4\u65b0\u8ba2\u5355\u903e\u671f\u6570\u91cf\u5931\u8d25\uff0cMQ\u53d1\u9001\u5931\u8d25.inspectionId:{}.orderCode:{}", (Object)inspectionId, (Object)orderCode);
        }
    }

    private String parameterVerification(FscOrderOverdueChangeRecordAbilityReqBO reqBo) {
        if (reqBo.getPayConfigId() == null) {
            return "\u5165\u53c2[payConfigId]\u4e3a\u7a7a";
        }
        if (reqBo.getChangeReason() == null) {
            return "\u5165\u53c2[changeReason]\u4e3a\u7a7a";
        }
        if ("3".equals(reqBo.getChangeReason())) {
            if (reqBo.getOverdueAmount() == null) {
                return "\u652f\u4ed8\u914d\u7f6e\u66f4\u65b0\u5165\u53c2[overdueAmount]\u4e3a\u7a7a";
            }
            if (reqBo.getOverdueIndex() == null) {
                return "\u652f\u4ed8\u914d\u7f6e\u66f4\u65b0\u5165\u53c2[overdueIndex]\u4e3a\u7a7a";
            }
            if (reqBo.getPenaltyAmount() == null) {
                return "\u652f\u4ed8\u914d\u7f6e\u66f4\u65b0\u5165\u53c2[penaltyAmount]\u4e3a\u7a7a";
            }
        } else if ("4".equals(reqBo.getChangeReason())) {
            if (reqBo.getInspectionId() == null) {
                return "\u5165\u53c2[inspectionId]\u4e3a\u7a7a";
            }
        } else {
            if (reqBo.getPurOrgId() == null) {
                return "\u5165\u53c2[purOrgId]\u4e3a\u7a7a";
            }
            if (reqBo.getInspectionId() == null) {
                return "\u5165\u53c2[inspectionId]\u4e3a\u7a7a";
            }
            if (reqBo.getOverdueAmount() == null) {
                return "\u5165\u53c2[overdueAmount]\u4e3a\u7a7a";
            }
            if (reqBo.getOverdueAmount() == null && reqBo.getOverdueRatio() == null && reqBo.getOverdueIndex() == null && reqBo.getPenaltyAmount() == null) {
                return "\u5165\u53c2\u4e2d\u88ab\u66f4\u65b0\u5b57\u6bb5\u5168\u4e3anull";
            }
        }
        FscPayConfigPO fscPayConfigPo = new FscPayConfigPO();
        fscPayConfigPo.setPayConfigId(reqBo.getPayConfigId());
        fscPayConfigPo = this.fscPayConfigMapper.getModelBy(fscPayConfigPo);
        if (fscPayConfigPo == null) {
            return "\u652f\u4ed8\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a";
        }
        if (!Arrays.asList(FscPayConfigType.EXT_ORG.getCode(), FscPayConfigType.DEF.getCode()).contains(fscPayConfigPo.getPayConfigType())) {
            return "\u652f\u4ed8\u914d\u7f6e\u67e5\u8be2\u7ed3\u679c\u9519\u8bef\uff0c\u4e0d\u662f\u5355\u4f4d\u652f\u4ed8\u914d\u7f6e";
        }
        if (!YesOrNo.YES.getCode().equals(fscPayConfigPo.getPayUsedPeriodFlag())) {
            return "\u652f\u4ed8\u914d\u7f6e\u67e5\u8be2\u7ed3\u679c\u9519\u8bef\uff0c\u8be5\u5355\u4f4d\u672a\u914d\u7f6e\u8fc7\u8d26\u671f";
        }
        return null;
    }
}

