/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.ability.FscOrderPayConfigListQryAbilityService;
import com.tydic.pfscext.api.ability.bo.FscOrderPayConfigInfoBO;
import com.tydic.pfscext.api.ability.bo.FscOrderPayConfigListQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscOrderPayConfigListQryAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscOrderPayConfigQryExcAgrInfoBO;
import com.tydic.pfscext.api.ability.bo.FscOrderPayConfigQryExcConnInfoBO;
import com.tydic.pfscext.api.ability.bo.FscPayConfigChannelBO;
import com.tydic.pfscext.dao.FscPayConfigChannelMapper;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigChannelPO;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.FscPayConfigPayNodeRule;
import com.tydic.pfscext.enums.FscPayConfigPayType;
import com.tydic.pfscext.enums.FscPayConfigSubClass;
import com.tydic.pfscext.enums.FscPayConfigSubType;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.FscPayCreditControlTag;
import com.tydic.pfscext.enums.FscPayCreditWarningTag;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import com.tydic.pfscext.utils.ValUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscOrderPayConfigListQryAbilityService"})
public class FscOrderPayConfigListQryAbilityServiceImpl
implements FscOrderPayConfigListQryAbilityService {
    @Resource
    private FscPayConfigMapper fscPayConfigMapper;
    @Resource
    private FscPayConfigChannelMapper fscPayConfigChannelMapper;
    @Value(value="${FSC_CREDIT_INDIVIDUALS_ORG_IDS:518412111045562368}")
    private String FSC_CREDIT_INDIVIDUALS_ORG_IDS;

    @PostMapping(value={"listOrderPayConfig"})
    public FscOrderPayConfigListQryAbilityRspBO listOrderPayConfig(@RequestBody FscOrderPayConfigListQryAbilityReqBO reqBo) {
        ValUtil.isEmpty(reqBo).exception("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollUtil.isEmpty((Collection)reqBo.getPayConfigIdList())) {
            if (FscPayConfigBusiType.FL.getCode().equals(reqBo.getPayBusiType()) && FscPayConfigSubType.GR.getCode().equals(reqBo.getPaySubType())) {
                reqBo.setPaySubType(FscPayConfigSubType.QY.getCode());
            }
            ValUtil.isEmpty(reqBo.getPayOrgId()).exception("\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
            if (StrUtil.isNotBlank((CharSequence)this.FSC_CREDIT_INDIVIDUALS_ORG_IDS) && Stream.of(this.FSC_CREDIT_INDIVIDUALS_ORG_IDS.split("[,\uff0c]")).collect(Collectors.toList()).contains(reqBo.getPayOrgId().toString())) {
                ValUtil.isEmpty(reqBo.getPayUserId()).exception("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (FscPayConfigSubType.GR.getCode().equals(reqBo.getPaySubType())) {
                ValUtil.isEmpty(reqBo.getPayUserId()).exception("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            List payConfigIds = reqBo.getPayConfigIdList().stream().filter(i -> i != null && i != 0L).distinct().collect(Collectors.toList());
            ValUtil.isCollEmpty(payConfigIds).exception("\u652f\u4ed8\u914d\u7f6eID\u96c6\u5408\u503c\u5168\u4e3a\u7a7a");
            reqBo.setPayConfigIdList(payConfigIds);
        }
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        if (CollUtil.isNotEmpty((Collection)reqBo.getPayConfigIdList())) {
            fscPayConfigQry.setPayConfigIdList(reqBo.getPayConfigIdList());
        } else {
            fscPayConfigQry.setPayOrgId(reqBo.getPayOrgId());
            fscPayConfigQry.setPayBusiType(reqBo.getPayBusiType());
            fscPayConfigQry.setPaySubType(reqBo.getPaySubType());
            fscPayConfigQry.setPaySubClass(reqBo.getPaySubClass());
            fscPayConfigQry.setPayUserId(reqBo.getPayUserId());
        }
        fscPayConfigQry.setPayConfigTypeList(Arrays.asList(FscPayConfigType.DEF.getCode(), FscPayConfigType.EXT_ORG.getCode()));
        List<FscPayConfigPO> payConfigList = this.fscPayConfigMapper.getList(fscPayConfigQry);
        FscOrderPayConfigListQryAbilityRspBO rspBo = FscRu.success(FscOrderPayConfigListQryAbilityRspBO.class);
        ArrayList<FscOrderPayConfigInfoBO> payConfigRspBoList = new ArrayList<FscOrderPayConfigInfoBO>();
        rspBo.setPayConfigList(payConfigRspBoList);
        if (CollUtil.isEmpty(payConfigList)) {
            return rspBo;
        }
        Map<Long, List<FscPayConfigChannelBO>> mapPayChannels = this.mapPayChannels(reqBo.getShowPayChannelFlag(), payConfigList);
        List<Long> payConfigIds = payConfigList.stream().map(i -> {
            if (FscPayConfigType.EXT_ORG.getCode().equals(i.getPayConfigType())) {
                return i.getPayConfigId();
            }
            if (FscPayConfigType.DEF.getCode().equals(i.getPayConfigType())) {
                return i.getParentConfigId();
            }
            return null;
        }).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Long, List<FscOrderPayConfigQryExcAgrInfoBO>> mapAgrInfo = this.mapAgrInfo(reqBo.getPayAgrIdList(), payConfigIds);
        Map<Long, List<FscOrderPayConfigQryExcConnInfoBO>> mapConnInfo = this.mapConnInfo(reqBo.getPayContractIdList(), payConfigIds);
        for (FscPayConfigPO fscPayConfig : payConfigList) {
            FscOrderPayConfigInfoBO item = FscRu.js(fscPayConfig, FscOrderPayConfigInfoBO.class);
            item.setPayBusiTypeStr(FscPayConfigBusiType.desc((String)item.getPayBusiType()));
            item.setPaySubClassStr(FscPayConfigSubClass.desc((String)fscPayConfig.getPaySubClass()));
            item.setPaySubTypeStr(FscPayConfigSubType.desc((String)fscPayConfig.getPaySubType()));
            item.setPayClassType(this.getPayClassType(fscPayConfig.getPaySubClass(), fscPayConfig.getPaySubType()));
            item.setPayTypeStr(FscPayConfigPayType.desc((String)fscPayConfig.getPayType()));
            item.setPayNodeRuleStr(FscPayConfigPayNodeRule.desc((Integer)fscPayConfig.getPayNodeRule()));
            Long payConfigId = item.getPayConfigId();
            if (mapPayChannels.containsKey(payConfigId)) {
                item.setPayConfigChannels(mapPayChannels.get(payConfigId));
            }
            if (mapAgrInfo.containsKey(payConfigId)) {
                item.setAgrInfoList(mapAgrInfo.get(payConfigId));
            }
            if (mapConnInfo.containsKey(payConfigId)) {
                item.setConnInfoList(mapConnInfo.get(payConfigId));
            }
            if (FscPayConfigBusiType.AGR_PT.getCode().equals(fscPayConfig.getPayBusiType())) {
                FscPayConfigPO fscPayConfigNoControlAgrQry = new FscPayConfigPO();
                fscPayConfigNoControlAgrQry.setParentConfigId(fscPayConfig.getParentConfigId());
                fscPayConfigNoControlAgrQry.setPayConfigType(FscPayConfigType.NO_CREDIT_AGR.getCode());
                fscPayConfigNoControlAgrQry.setPayAgrIdList(reqBo.getPayAgrIdList());
                List<Long> listNoControlAgrIds = this.fscPayConfigMapper.getListNoControlAgrIdById(fscPayConfigNoControlAgrQry);
                if (CollUtil.isNotEmpty(listNoControlAgrIds)) {
                    item.setNoControlAgrIdList(listNoControlAgrIds);
                }
            }
            item.setTipsInfos(this.initTips(fscPayConfig));
            payConfigRspBoList.add(item);
        }
        return rspBo;
    }

    private List<String> initTips(FscPayConfigPO po) {
        ArrayList<String> tips;
        block10: {
            block9: {
                tips = new ArrayList<String>();
                if (!FscPayConfigControlStatus.RESTRICTED.getCode().equals(po.getCurrentOrgControlStatus())) break block9;
                List controlTagList = JSON.parseArray((String)po.getCurrentOrgControlTag(), String.class);
                if (CollectionUtils.isEmpty((Collection)controlTagList)) break block10;
                for (String controlTag : controlTagList) {
                    if (FscPayCreditControlTag.CONTROL_QUOTA.getCode().equals(controlTag)) {
                        BigDecimal usedAmount = Optional.ofNullable(po.getUsedAmount()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal balanceAmount = Optional.ofNullable(po.getBalanceAmount()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal currentOverdueAmount = Optional.ofNullable(po.getCurrentOverdueAmount()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                        tips.add(StrUtil.format((CharSequence)"\u5f53\u524d\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u4e3a {},\u5269\u4f59\u6388\u4fe1\u989d\u5ea6 {}\uff0c\u903e\u671f\u91d1\u989d {}", (Object[])new Object[]{usedAmount.toPlainString(), balanceAmount.toPlainString(), currentOverdueAmount.toPlainString()}));
                        continue;
                    }
                    if (FscPayCreditControlTag.CONTROL_OVERDUE_RATIO.getCode().equals(controlTag)) {
                        BigDecimal overdueControlRatio = Optional.ofNullable(po.getOverdueControlRatio()).orElse(BigDecimal.ZERO).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal currentOverdueRatio = Optional.ofNullable(po.getCurrentOverdueRatio()).orElse(BigDecimal.ZERO).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                        tips.add(StrUtil.format((CharSequence)"\u903e\u671f\u5360\u6bd4\u8d85\u8fc7\u9608\u503c {}%\uff0c\u5f53\u524d\u903e\u671f\u5360\u6bd4\u4e3a {}%", (Object[])new Object[]{overdueControlRatio.toPlainString(), currentOverdueRatio.toPlainString()}));
                        continue;
                    }
                    if (!FscPayCreditControlTag.CONTROL_OVERDUE_INDEX.getCode().equals(controlTag)) continue;
                    BigDecimal overdueControlIndex = Optional.ofNullable(po.getOverdueControlIndex()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal currentOverdueIndex = Optional.ofNullable(po.getCurrentOverdueIndex()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                    tips.add(StrUtil.format((CharSequence)"\u903e\u671f\u6307\u6570\u8d85\u8fc7\u9608\u503c {}\uff0c\u5f53\u524d\u903e\u671f\u6307\u6570\u4e3a {}", (Object[])new Object[]{overdueControlIndex.toPlainString(), currentOverdueIndex.toPlainString()}));
                }
                break block10;
            }
            if (FscPayConfigControlStatus.WARNING.getCode().equals(po.getCurrentOrgControlStatus())) {
                List warningTagList;
                String closeMsg = "\u5173\u505c\u4e0b\u5355";
                if (FscPayConfigBusiType.FL.getCode().equals(po.getPayBusiType())) {
                    closeMsg = "\u5173\u95ed\u521b\u5efa\u6d3b\u52a8";
                }
                if (!CollectionUtils.isEmpty((Collection)(warningTagList = JSON.parseArray((String)po.getCurrentOrgWarningTag(), String.class)))) {
                    for (String warningTag : warningTagList) {
                        if (FscPayCreditWarningTag.WARNING_QUOTA.getCode().equals(warningTag)) {
                            BigDecimal usedAmount = Optional.ofNullable(po.getUsedAmount()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                            BigDecimal balanceAmount = Optional.ofNullable(po.getBalanceAmount()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                            BigDecimal currentOverdueAmount = Optional.ofNullable(po.getCurrentOverdueAmount()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                            tips.add(StrUtil.format((CharSequence)"\u5f53\u524d\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u4e3a {}\uff0c\u5269\u4f59\u6388\u4fe1\u989d\u5ea6 {}\uff0c\u903e\u671f\u91d1\u989d {}", (Object[])new Object[]{usedAmount.toPlainString(), balanceAmount.toPlainString(), currentOverdueAmount.toPlainString()}));
                            continue;
                        }
                        if (FscPayCreditWarningTag.WARNING_OVERDUE_RATIO.getCode().equals(warningTag)) {
                            BigDecimal currentOverdueRatio = Optional.ofNullable(po.getCurrentOverdueRatio()).orElse(BigDecimal.ZERO).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                            BigDecimal overdueWarningRatio = Optional.ofNullable(po.getOverdueWarningRatio()).orElse(BigDecimal.ZERO).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                            BigDecimal overdueControlRatio = Optional.ofNullable(po.getOverdueControlRatio()).orElse(BigDecimal.ZERO).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                            tips.add(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u5360\u6bd4\u4e3a {}%\uff0c\u5982\u679c\u8d85\u8fc7 {}%\uff0c\u5c06{}\u6743\u9650", (Object[])new Object[]{currentOverdueRatio.toPlainString(), overdueControlRatio.toPlainString(), closeMsg}));
                            continue;
                        }
                        if (!FscPayCreditWarningTag.WARNING_OVERDUE_INDEX.getCode().equals(warningTag)) continue;
                        BigDecimal currentOverdueIndex = Optional.ofNullable(po.getCurrentOverdueIndex()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal overdueControlIndex = Optional.ofNullable(po.getOverdueControlIndex()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal overdueWarningIndex = Optional.ofNullable(po.getOverdueWarningIndex()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                        tips.add(StrUtil.format((CharSequence)"\u5f53\u524d\u7684\u903e\u671f\u6307\u6570\u4e3a {}\uff0c\u5982\u679c\u8d85\u8fc7 {}\uff0c\u5c06{}\u6743\u9650", (Object[])new Object[]{currentOverdueIndex.toPlainString(), overdueControlIndex.toPlainString(), closeMsg}));
                    }
                }
            }
        }
        return tips;
    }

    private String getPayClassType(String paySubClass, String paySubType) {
        if (StrUtil.isBlank((CharSequence)paySubClass) || StrUtil.isBlank((CharSequence)paySubType)) {
            return "";
        }
        if (FscPayConfigSubClass.OUT.getCode().equals(paySubClass) && FscPayConfigSubType.GR.getCode().equals(paySubType)) {
            return "1";
        }
        if (FscPayConfigSubClass.OUT.getCode().equals(paySubClass) && FscPayConfigSubType.QY.getCode().equals(paySubType)) {
            return "2";
        }
        if (FscPayConfigSubClass.IN.getCode().equals(paySubClass) && FscPayConfigSubType.GR.getCode().equals(paySubType)) {
            return "3";
        }
        if (FscPayConfigSubClass.IN.getCode().equals(paySubClass) && FscPayConfigSubType.QY.getCode().equals(paySubType)) {
            return "4";
        }
        return "";
    }

    private Map<Long, List<FscOrderPayConfigQryExcConnInfoBO>> mapConnInfo(List<Long> payContractIdList, List<Long> payConfigIdList) {
        HashMap<Long, List<FscOrderPayConfigQryExcConnInfoBO>> mapConnInfo = new HashMap<Long, List<FscOrderPayConfigQryExcConnInfoBO>>();
        if (CollUtil.isEmpty(payContractIdList) || CollUtil.isEmpty(payConfigIdList)) {
            return mapConnInfo;
        }
        FscPayConfigPO fscPayConfigAgrQry = new FscPayConfigPO();
        fscPayConfigAgrQry.setParentConfigIdList(payConfigIdList);
        fscPayConfigAgrQry.setPayConfigType(FscPayConfigType.EXT_CONN.getCode());
        fscPayConfigAgrQry.setPayContractIdList(payContractIdList);
        List<FscPayConfigPO> list = this.fscPayConfigMapper.getList(fscPayConfigAgrQry);
        if (CollUtil.isNotEmpty(list)) {
            Map<Long, List<FscPayConfigPO>> map = list.stream().collect(Collectors.groupingBy(FscPayConfigPO::getParentConfigId));
            for (Long payConfigId : payConfigIdList) {
                if (!map.containsKey(payConfigId)) continue;
                mapConnInfo.put(payConfigId, FscRu.jsl(map.get(payConfigId), FscOrderPayConfigQryExcConnInfoBO.class));
            }
        }
        return mapConnInfo;
    }

    private Map<Long, List<FscOrderPayConfigQryExcAgrInfoBO>> mapAgrInfo(List<Long> payAgrIdList, List<Long> payConfigIdList) {
        HashMap<Long, List<FscOrderPayConfigQryExcAgrInfoBO>> mapAgrInfo = new HashMap<Long, List<FscOrderPayConfigQryExcAgrInfoBO>>();
        if (CollUtil.isEmpty(payAgrIdList) || CollUtil.isEmpty(payConfigIdList)) {
            return mapAgrInfo;
        }
        FscPayConfigPO fscPayConfigAgrQry = new FscPayConfigPO();
        fscPayConfigAgrQry.setParentConfigIdList(payConfigIdList);
        fscPayConfigAgrQry.setPayConfigType(FscPayConfigType.EXT_AGR.getCode());
        fscPayConfigAgrQry.setPayAgrIdList(payAgrIdList);
        List<FscPayConfigPO> list = this.fscPayConfigMapper.getList(fscPayConfigAgrQry);
        if (CollUtil.isNotEmpty(list)) {
            Map<Long, List<FscPayConfigPO>> map = list.stream().collect(Collectors.groupingBy(FscPayConfigPO::getParentConfigId));
            for (Long payConfigId : payConfigIdList) {
                if (!map.containsKey(payConfigId)) continue;
                mapAgrInfo.put(payConfigId, FscRu.jsl(map.get(payConfigId), FscOrderPayConfigQryExcAgrInfoBO.class));
            }
        }
        return mapAgrInfo;
    }

    private Map<Long, List<FscPayConfigChannelBO>> mapPayChannels(String showPayChannelFlag, List<FscPayConfigPO> payConfigList) {
        HashMap<Long, List<FscPayConfigChannelBO>> mapPayChannels = new HashMap<Long, List<FscPayConfigChannelBO>>();
        if (!YesNo.YES.getCode().equals(showPayChannelFlag)) {
            return mapPayChannels;
        }
        for (List payConfigIds : ListUtil.batchList(payConfigList.stream().filter(i -> FscPayConfigType.EXT_ORG.getCode().equals(i.getPayConfigType())).map(FscPayConfigPO::getPayConfigId).distinct().collect(Collectors.toList()))) {
            if (!CollUtil.isNotEmpty((Collection)payConfigIds)) continue;
            FscPayConfigChannelPO fscPayConfigChannelQry = new FscPayConfigChannelPO();
            fscPayConfigChannelQry.setPayConfigIdList(payConfigIds);
            fscPayConfigChannelQry.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
            List<FscPayConfigChannelPO> payChannels = this.fscPayConfigChannelMapper.getList(fscPayConfigChannelQry);
            if (!CollUtil.isNotEmpty(payChannels)) continue;
            mapPayChannels.putAll(payChannels.stream().collect(Collectors.groupingBy(FscPayConfigChannelPO::getPayConfigId, Collectors.collectingAndThen(Collectors.toList(), list -> FscRu.jsl(list, FscPayConfigChannelBO.class)))));
        }
        List defPayConfig = payConfigList.stream().filter(i -> FscPayConfigType.DEF.getCode().equals(i.getPayConfigType())).collect(Collectors.toList());
        for (List parentConfigIds : ListUtil.batchList(defPayConfig.stream().map(FscPayConfigPO::getParentConfigId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            if (!CollUtil.isNotEmpty((Collection)parentConfigIds)) continue;
            FscPayConfigChannelPO fscPayConfigChannelQry = new FscPayConfigChannelPO();
            fscPayConfigChannelQry.setPayConfigIdList(parentConfigIds);
            fscPayConfigChannelQry.setPayConfigType(FscPayConfigType.MAIN.getCode());
            List<FscPayConfigChannelPO> payChannels = this.fscPayConfigChannelMapper.getList(fscPayConfigChannelQry);
            if (!CollUtil.isNotEmpty(payChannels)) continue;
            Map<Long, List<FscPayConfigChannelPO>> mapMain = payChannels.stream().collect(Collectors.groupingBy(FscPayConfigChannelPO::getPayConfigId));
            for (FscPayConfigPO fscPayConfig : defPayConfig) {
                if (!mapMain.containsKey(fscPayConfig.getParentConfigId())) continue;
                mapPayChannels.put(fscPayConfig.getPayConfigId(), FscRu.jsl(mapMain.get(fscPayConfig.getParentConfigId()), FscPayConfigChannelBO.class));
            }
        }
        return mapPayChannels;
    }
}

