/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import com.tydic.pfscext.api.ability.FscOrderPayConfigQryAbilityService;
import com.tydic.pfscext.api.ability.bo.FscOrderPayConfigQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscOrderPayConfigQryAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscOrderPayConfigQryExcAgrInfoBO;
import com.tydic.pfscext.api.ability.bo.FscOrderPayConfigQryExcConnInfoBO;
import com.tydic.pfscext.api.ability.bo.FscPayConfigChannelBO;
import com.tydic.pfscext.dao.FscPayConfigChannelMapper;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigChannelPO;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigSubType;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscOrderPayConfigQryAbilityService"})
public class FscOrderPayConfigQryAbilityServiceImpl
implements FscOrderPayConfigQryAbilityService {
    @Resource
    private FscPayConfigMapper fscPayConfigMapper;
    @Resource
    private FscPayConfigChannelMapper fscPayConfigChannelMapper;

    @PostMapping(value={"qryOrderPayConfig"})
    public FscOrderPayConfigQryAbilityRspBO qryOrderPayConfig(@RequestBody FscOrderPayConfigQryAbilityReqBO reqBo) {
        List<FscPayConfigPO> list;
        FscPayConfigPO fscPayConfigOrg;
        ValUtil.isEmpty(reqBo).exception("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getExceptId()).exception("\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getPayBusiType()).exception("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (reqBo.getPayConfigId() == null || reqBo.getPayConfigId() == 0L) {
            ValUtil.isEmpty(reqBo.getPaySubType()).exception("\u4ed8\u6b3e\u4e3b\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            ValUtil.isEmpty(reqBo.getPaySubClass()).exception("\u4ed8\u6b3e\u4e3b\u4f53\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        if (reqBo.getPayConfigId() != null && reqBo.getPayConfigId() != 0L) {
            fscPayConfigQry.setPayConfigId(reqBo.getPayConfigId());
        }
        fscPayConfigQry.setPayBusiType(reqBo.getPayBusiType());
        fscPayConfigQry.setPayConfigTypeList(Arrays.asList(FscPayConfigType.DEF.getCode(), FscPayConfigType.EXT_ORG.getCode()));
        fscPayConfigQry.setPaySubType(reqBo.getPaySubType());
        fscPayConfigQry.setPaySubClass(reqBo.getPaySubClass());
        fscPayConfigQry.setPayOrgId(reqBo.getExceptId());
        if (FscPayConfigBusiType.FL.getCode().equals(reqBo.getPayBusiType()) && FscPayConfigSubType.GR.getCode().equals(fscPayConfigQry.getPaySubType())) {
            fscPayConfigQry.setPaySubType(FscPayConfigSubType.QY.getCode());
        }
        if (FscPayConfigSubType.GR.getCode().equals(reqBo.getPaySubType())) {
            fscPayConfigQry.setPayUserId(reqBo.getUserId());
        }
        if ((fscPayConfigOrg = this.fscPayConfigMapper.getModelBy(fscPayConfigQry)) == null) {
            throw new PfscExtBusinessException("18000", "\u8be5\u5355\u4f4d\u3001\u7528\u6237\u7684\u652f\u4ed8\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a\uff0c\u8bf7\u5148\u914d\u7f6e");
        }
        FscOrderPayConfigQryAbilityRspBO rspBo = FscRu.success(FscOrderPayConfigQryAbilityRspBO.class);
        BeanUtils.copyProperties((Object)fscPayConfigOrg, (Object)rspBo);
        rspBo.setPayConfigChannels(this.listPayChannels(fscPayConfigOrg));
        if (reqBo.getPayAgrId() != null) {
            FscPayConfigPO fscPayConfigAgrQry = new FscPayConfigPO();
            if (FscPayConfigType.EXT_ORG.getCode().equals(fscPayConfigOrg.getPayConfigType())) {
                fscPayConfigAgrQry.setParentConfigId(fscPayConfigOrg.getPayConfigId());
            } else {
                fscPayConfigAgrQry.setParentConfigId(fscPayConfigOrg.getParentConfigId());
            }
            fscPayConfigAgrQry.setPayConfigType(FscPayConfigType.EXT_AGR.getCode());
            fscPayConfigAgrQry.setPayAgrId(reqBo.getPayAgrId());
            list = this.fscPayConfigMapper.getList(fscPayConfigAgrQry);
            if (!CollectionUtils.isEmpty(list)) {
                rspBo.setAgrInfoList(list.stream().map(i -> FscRu.js(i, FscOrderPayConfigQryExcAgrInfoBO.class)).collect(Collectors.toList()));
            }
            if (FscPayConfigBusiType.AGR_PT.getCode().equals(fscPayConfigOrg.getPayBusiType())) {
                FscPayConfigPO fscPayConfigNoControlAgrQry = new FscPayConfigPO();
                fscPayConfigNoControlAgrQry.setParentConfigId(fscPayConfigOrg.getParentConfigId());
                fscPayConfigNoControlAgrQry.setPayConfigType(FscPayConfigType.NO_CREDIT_AGR.getCode());
                fscPayConfigNoControlAgrQry.setPayAgrId(reqBo.getPayAgrId());
                List<Long> listNoControlAgrIds = this.fscPayConfigMapper.getListNoControlAgrIdById(fscPayConfigNoControlAgrQry);
                if (!CollectionUtils.isEmpty(listNoControlAgrIds)) {
                    rspBo.setNoControlAgrIdList(listNoControlAgrIds);
                }
            }
        }
        if (reqBo.getPayContractId() != null) {
            FscPayConfigPO fscPayConfigConnQry = new FscPayConfigPO();
            if (FscPayConfigType.EXT_ORG.getCode().equals(fscPayConfigOrg.getPayConfigType())) {
                fscPayConfigConnQry.setParentConfigId(fscPayConfigOrg.getPayConfigId());
            } else {
                fscPayConfigConnQry.setParentConfigId(fscPayConfigOrg.getParentConfigId());
            }
            fscPayConfigConnQry.setPayConfigType(FscPayConfigType.EXT_CONN.getCode());
            fscPayConfigConnQry.setPayContractId(reqBo.getPayContractId());
            list = this.fscPayConfigMapper.getList(fscPayConfigConnQry);
            if (!CollectionUtils.isEmpty(list)) {
                rspBo.setConnInfoList(list.stream().map(i -> FscRu.js(i, FscOrderPayConfigQryExcConnInfoBO.class)).collect(Collectors.toList()));
            }
        }
        return rspBo;
    }

    private List<FscPayConfigChannelBO> listPayChannels(FscPayConfigPO fscPayConfigOrg) {
        ArrayList<FscPayConfigChannelBO> payConfigChannels = new ArrayList<FscPayConfigChannelBO>();
        FscPayConfigChannelPO fscPayConfigChannelQry = new FscPayConfigChannelPO();
        if (FscPayConfigType.DEF.getCode().equals(fscPayConfigOrg.getPayConfigType()) && fscPayConfigOrg.getParentConfigId() != null) {
            fscPayConfigChannelQry.setPayConfigId(fscPayConfigOrg.getParentConfigId());
            fscPayConfigChannelQry.setPayConfigType(FscPayConfigType.MAIN.getCode());
            List<FscPayConfigChannelPO> payChannels = this.fscPayConfigChannelMapper.getList(fscPayConfigChannelQry);
            if (!CollectionUtils.isEmpty(payChannels)) {
                payConfigChannels.addAll(FscRu.jsl(payChannels, FscPayConfigChannelBO.class));
            }
        } else if (FscPayConfigType.EXT_ORG.getCode().equals(fscPayConfigOrg.getPayConfigType())) {
            fscPayConfigChannelQry.setPayConfigId(fscPayConfigOrg.getPayConfigId());
            fscPayConfigChannelQry.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
            List<FscPayConfigChannelPO> payChannels = this.fscPayConfigChannelMapper.getList(fscPayConfigChannelQry);
            if (!CollectionUtils.isEmpty(payChannels)) {
                payConfigChannels.addAll(FscRu.jsl(payChannels, FscPayConfigChannelBO.class));
            }
        }
        return payConfigChannels;
    }
}

