/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.ability.FscPayConfigExtOrgBatchImportAbilityService;
import com.tydic.pfscext.api.ability.bo.FscPayConfigBatchImportFileInfoCallbackItemBO;
import com.tydic.pfscext.api.ability.bo.FscPayConfigBatchImportInfoBO;
import com.tydic.pfscext.api.ability.bo.FscPayConfigExtOrgBatchImportAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscPayConfigExtOrgBatchImportAbilityRspBO;
import com.tydic.pfscext.api.busi.FscPayConfigImportTempSaveBusiService;
import com.tydic.pfscext.api.busi.bo.FscPayConfigImportTempSaveBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscPayConfigImportTempSaveBusiRspBO;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigSubClass;
import com.tydic.pfscext.enums.FscPayConfigSubType;
import com.tydic.pfscext.external.umc.api.FscUmcQryAccountListExternalService;
import com.tydic.pfscext.external.umc.bo.FscUmcQryAccountListExternalReqBO;
import com.tydic.pfscext.external.umc.bo.FscUmcQryAccountListExternalRspBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgAbilityBO;
import com.tydic.umcext.ability.fileUpload.CnncUmcFileAbilityService;
import com.tydic.umcext.ability.fileUpload.bo.CnncUmcFileObjRspBO;
import com.tydic.umcext.ability.fileUpload.bo.CnncUmcFileReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscPayConfigExtOrgBatchImportAbilityService"})
public class FscPayConfigExtOrgBatchImportAbilityServiceImpl
implements FscPayConfigExtOrgBatchImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayConfigExtOrgBatchImportAbilityServiceImpl.class);
    @Resource
    private FscPayConfigMapper fscPayConfigMapper;
    @Autowired
    private CnncUmcFileAbilityService cnncUmcFileAbilityService;
    @Resource
    private FscPayConfigImportTempSaveBusiService fscPayConfigImportTempSaveBusiService;
    @Resource
    private FscUmcQryAccountListExternalService fscUmcQryAccountListExternalService;

    @PostMapping(value={"dealPayConfigExtOrgBatchImport"})
    public FscPayConfigExtOrgBatchImportAbilityRspBO dealPayConfigExtOrgBatchImport(@RequestBody FscPayConfigExtOrgBatchImportAbilityReqBO reqBo) {
        FscPayConfigExtOrgBatchImportAbilityRspBO rspBo = FscRu.success(FscPayConfigExtOrgBatchImportAbilityRspBO.class);
        List<String> errorParam = this.parameterValidation(reqBo);
        FscPayConfigPO fscPayConfigPo = null;
        if (CollUtil.isEmpty(errorParam)) {
            fscPayConfigPo = new FscPayConfigPO();
            fscPayConfigPo.setPayConfigId(reqBo.getParentConfigId());
            fscPayConfigPo = this.fscPayConfigMapper.getModelBy(fscPayConfigPo);
            if (fscPayConfigPo == null) {
                errorParam.add("\u652f\u4ed8\u914d\u7f6e\u7236\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a");
            } else {
                if (!FscPayConfigSubType.QY.getCode().equals(fscPayConfigPo.getPaySubType())) {
                    errorParam.add("\u4ec5\u4ed8\u6b3e\u4e3b\u4f53\u7c7b\u578b\u4e3a\u4f01\u4e1a\u53ef\u4f7f\u7528\u6279\u91cf\u8c03\u6574\u4f8b\u5916\u5355\u4f4d");
                }
                if (FscPayConfigSubType.instance((String)fscPayConfigPo.getPaySubType()) == null) {
                    errorParam.add("\u652f\u4ed8\u914d\u7f6e\u7236\u914d\u7f6e\u4ed8\u6b3e\u4e3b\u4f53\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406");
                }
                if (FscPayConfigSubClass.instance((String)fscPayConfigPo.getPaySubClass()) == null) {
                    errorParam.add("\u652f\u4ed8\u914d\u7f6e\u7236\u914d\u7f6e\u4ed8\u6b3e\u4e3b\u4f53\u5206\u7c7b\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406");
                }
                if (FscPayConfigBusiType.instance((String)fscPayConfigPo.getPayBusiType()) == null) {
                    errorParam.add("\u652f\u4ed8\u914d\u7f6e\u7236\u914d\u7f6e\u4e1a\u52a1\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406");
                }
            }
        }
        ArrayList<FscPayConfigBatchImportFileInfoCallbackItemBO> failList = new ArrayList<FscPayConfigBatchImportFileInfoCallbackItemBO>();
        if (CollUtil.isNotEmpty(errorParam)) {
            String failReason = "\u5165\u53c2\u6821\u9a8c\u4e0d\u901a\u8fc7:" + String.join((CharSequence)";", errorParam);
            if (CollectionUtils.isEmpty((Collection)reqBo.getPayConfigList())) {
                FscPayConfigBatchImportFileInfoCallbackItemBO itemBo = new FscPayConfigBatchImportFileInfoCallbackItemBO();
                itemBo.setLineNum(Integer.valueOf(1));
                itemBo.setFailReason(failReason);
                failList.add(itemBo);
            } else {
                for (FscPayConfigBatchImportInfoBO item : reqBo.getPayConfigList()) {
                    FscPayConfigBatchImportFileInfoCallbackItemBO itemBo = new FscPayConfigBatchImportFileInfoCallbackItemBO();
                    itemBo.setLineNum(Optional.ofNullable(item.getGluttonLineNum()).orElse(1));
                    itemBo.setFailReason(failReason);
                    failList.add(itemBo);
                }
            }
            rspBo.setFailReasonList(failList);
            return rspBo;
        }
        Long shardId = Sequence.getInstance().nextId();
        for (FscPayConfigBatchImportInfoBO item : reqBo.getPayConfigList()) {
            FscPayConfigBatchImportFileInfoCallbackItemBO itemBo;
            this.initImportInfoAndCheck(item, fscPayConfigPo);
            if (StrUtil.isNotBlank((CharSequence)item.getFailReason())) {
                itemBo = new FscPayConfigBatchImportFileInfoCallbackItemBO();
                itemBo.setLineNum(item.getGluttonLineNum());
                itemBo.setFailReason(item.getFailReason());
                failList.add(itemBo);
                continue;
            }
            this.saveData(reqBo, item, shardId);
            if (!StrUtil.isNotBlank((CharSequence)item.getFailReason())) continue;
            itemBo = new FscPayConfigBatchImportFileInfoCallbackItemBO();
            itemBo.setLineNum(item.getGluttonLineNum());
            itemBo.setFailReason(item.getFailReason());
            failList.add(itemBo);
        }
        rspBo.setFailReasonList(failList);
        return rspBo;
    }

    private void saveData(FscPayConfigExtOrgBatchImportAbilityReqBO reqBo, FscPayConfigBatchImportInfoBO item, Long shardId) {
        FscPayConfigImportTempSaveBusiReqBO busiReqBo = new FscPayConfigImportTempSaveBusiReqBO();
        busiReqBo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        busiReqBo.setImpId(reqBo.getImpId());
        busiReqBo.setImpType(reqBo.getImpType());
        busiReqBo.setShardId(shardId);
        busiReqBo.setShardSize(reqBo.getServiceShardSize());
        busiReqBo.setTotalCount(reqBo.getMainDataCount());
        busiReqBo.setLineNum(item.getGluttonLineNum());
        busiReqBo.setParentConfigId(reqBo.getParentConfigId());
        busiReqBo.setCompanyId(Long.valueOf(item.getCompanyId()));
        busiReqBo.setCompanyName(item.getCompanyName());
        busiReqBo.setCompanyTreePath(item.getCompanyTreePath());
        busiReqBo.setPayType(Integer.valueOf(item.getPayType()));
        busiReqBo.setPayNodeRule(NumberUtil.isInteger((String)item.getPayNodeRule()) ? Integer.valueOf(item.getPayNodeRule()) : null);
        busiReqBo.setPaymentDays(NumberUtil.isInteger((String)item.getPaymentDays()) ? Integer.valueOf(item.getPaymentDays()) : null);
        busiReqBo.setDelayDays(NumberUtil.isInteger((String)item.getDelayDays()) ? Integer.valueOf(item.getDelayDays()) : null);
        busiReqBo.setCreditAmount(FscRu.isBigDecimal(item.getCreditAmount()) ? new BigDecimal(item.getCreditAmount()) : null);
        busiReqBo.setUsedWarningAmount(FscRu.isBigDecimal(item.getCreditAmount()) ? new BigDecimal(item.getUsedWarningAmount()) : null);
        busiReqBo.setOverdueStartAmount(FscRu.isBigDecimal(item.getCreditAmount()) ? new BigDecimal(item.getOverdueStartAmount()) : null);
        busiReqBo.setOverdueWarningRatio(FscRu.isBigDecimal(item.getCreditAmount()) ? new BigDecimal(item.getOverdueWarningRatio()) : null);
        busiReqBo.setOverdueControlRatio(FscRu.isBigDecimal(item.getCreditAmount()) ? new BigDecimal(item.getOverdueControlRatio()) : null);
        busiReqBo.setOverdueRecoveryRatio(FscRu.isBigDecimal(item.getCreditAmount()) ? new BigDecimal(item.getOverdueRecoveryRatio()) : null);
        busiReqBo.setOverdueIndexRatio(FscRu.isBigDecimal(item.getCreditAmount()) ? new BigDecimal(item.getOverdueIndexRatio()) : null);
        busiReqBo.setOverdueWarningIndex(FscRu.isBigDecimal(item.getCreditAmount()) ? new BigDecimal(item.getOverdueWarningIndex()) : null);
        busiReqBo.setOverdueControlIndex(FscRu.isBigDecimal(item.getCreditAmount()) ? new BigDecimal(item.getOverdueControlIndex()) : null);
        busiReqBo.setOverdueRecoveryIndex(FscRu.isBigDecimal(item.getCreditAmount()) ? new BigDecimal(item.getOverdueRecoveryIndex()) : null);
        busiReqBo.setPayMethod(item.getPayMethod());
        busiReqBo.setOperatorId(reqBo.getUserId());
        busiReqBo.setOperateType("fsc_pay_config_import");
        FscPayConfigImportTempSaveBusiRspBO busiRspBo = this.fscPayConfigImportTempSaveBusiService.savePayConfigImportTemp(busiReqBo);
        if (FscRu.isFailed(busiRspBo.getRespCode()).booleanValue()) {
            item.setFailReason(StrUtil.isNotBlank((CharSequence)busiRspBo.getRespDesc()) ? StrUtil.subPre((CharSequence)busiRspBo.getRespDesc(), (int)500) : "\u4e34\u65f6\u5b58\u50a8\u5931\u8d25");
        }
    }

    private void initImportInfoAndCheck(FscPayConfigBatchImportInfoBO item, FscPayConfigPO fscPayConfigPo) {
        ArrayList<String> errorList = new ArrayList<String>();
        if (!NumberUtil.isLong((String)item.getCompanyId())) {
            errorList.add("\u5355\u4f4dID\u5fc5\u586b\u4e14\u503c\u5e94\u4e3a\u957f\u6574\u6570");
        }
        if (StrUtil.isBlank((CharSequence)item.getPayType())) {
            errorList.add("\u4ed8\u6b3e\u65b9\u5f0f\u5fc5\u586b\u5355\u9009");
        } else if (!Arrays.asList("1", "2", "3").contains(item.getPayType())) {
            errorList.add("\u4ed8\u6b3e\u65b9\u5f0f\u503c\u9519\u8bef");
        } else {
            String configComb = fscPayConfigPo.getPayBusiType() + fscPayConfigPo.getPaySubClass() + fscPayConfigPo.getPaySubType();
            String configCombStr = FscPayConfigBusiType.desc((String)fscPayConfigPo.getPayBusiType()) + FscPayConfigSubClass.desc((String)fscPayConfigPo.getPaySubClass()) + FscPayConfigSubType.desc((String)fscPayConfigPo.getPaySubType());
            if ("1".equals(item.getPayType()) && !Arrays.asList("001", "011", "301", "311", "801", "811").contains(configComb)) {
                errorList.add(configCombStr + "\u4e0d\u53ef\u914d\u7f6e\u6309\u8d26\u671f\u652f\u4ed8");
            }
            if ("2".equals(item.getPayType()) && !Arrays.asList("011", "601", "611", "811").contains(configComb)) {
                errorList.add(configCombStr + "\u4e0d\u53ef\u914d\u7f6e\u9884\u4ed8\u6b3e\u6309\u6bd4\u4f8b\u652f\u4ed8");
            }
            if ("3".equals(item.getPayType()) && !Arrays.asList("101", "111", "201", "211").contains(configComb)) {
                errorList.add(configCombStr + "\u4e0d\u53ef\u914d\u7f6e\u6309\u534f\u8bae\u7ea6\u675f\u652f\u4ed8");
            }
        }
        if (StrUtil.isBlank((CharSequence)item.getPayNodeRule())) {
            if (FscPayConfigBusiType.EC.getCode().equals(fscPayConfigPo.getPayBusiType()) && "1".equals(item.getPayType())) {
                errorList.add(FscPayConfigBusiType.desc((String)fscPayConfigPo.getPayBusiType()) + "\u652f\u4ed8\u65b9\u5f0f\u914d\u7f6e\u4e3a\u6309\u8d26\u671f\u652f\u4ed8\u65f6\u8d26\u671f\u8d77\u7b97\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (FscPayConfigBusiType.AGR_PT.getCode().equals(fscPayConfigPo.getPayBusiType()) && "3".equals(item.getPayType())) {
                errorList.add(FscPayConfigBusiType.desc((String)fscPayConfigPo.getPayBusiType()) + "\u652f\u4ed8\u65b9\u5f0f\u914d\u7f6e\u4e3a\u6309\u534f\u8bae\u7ea6\u675f\u652f\u4ed8\u65f6\u8d26\u671f\u8d77\u7b97\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (!NumberUtil.isInteger((String)item.getPayNodeRule()) || !Arrays.asList("1", "2").contains(item.getPayNodeRule())) {
            errorList.add("\u8d26\u671f\u8d77\u7b97\u8282\u70b9\u503c\u9519\u8bef");
        } else if (FscPayConfigBusiType.FL.getCode().equals(fscPayConfigPo.getPayBusiType()) && "1".equals(item.getPayType()) && !"2".equals(item.getPayNodeRule())) {
            errorList.add(FscPayConfigBusiType.desc((String)fscPayConfigPo.getPayBusiType()) + "\u8d26\u671f\u8d77\u7b97\u8282\u70b9\u53ea\u80fd\u914d\u7f6e[\u7b7e\u6536\u53d1\u7968\u5f00\u59cb\u8ba1\u7b97]");
        }
        if (StrUtil.isBlank((CharSequence)item.getPaymentDays())) {
            if (FscPayConfigBusiType.EC.getCode().equals(fscPayConfigPo.getPayBusiType()) && "1".equals(item.getPayType())) {
                errorList.add(FscPayConfigBusiType.desc((String)fscPayConfigPo.getPayBusiType()) + "\u652f\u4ed8\u65b9\u5f0f\u914d\u7f6e\u4e3a\u6309\u8d26\u671f\u652f\u4ed8\u65f6\u8d26\u671f\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (FscPayConfigBusiType.AGR_PT.getCode().equals(fscPayConfigPo.getPayBusiType()) && "3".equals(item.getPayType())) {
                errorList.add(FscPayConfigBusiType.desc((String)fscPayConfigPo.getPayBusiType()) + "\u652f\u4ed8\u65b9\u5f0f\u914d\u7f6e\u4e3a\u6309\u534f\u8bae\u7ea6\u675f\u652f\u4ed8\u65f6\u8d26\u671f\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (!NumberUtil.isInteger((String)item.getPaymentDays()) || Integer.parseInt(item.getPaymentDays()) < 0) {
            errorList.add("\u8d26\u671f\u5929\u6570\u4ec5\u53ef\u8f93\u5165\u6b63\u6574\u6570");
        }
        if (StrUtil.isBlank((CharSequence)item.getPaymentDays())) {
            if (FscPayConfigBusiType.EC.getCode().equals(fscPayConfigPo.getPayBusiType()) && "1".equals(item.getPayType())) {
                errorList.add(FscPayConfigBusiType.desc((String)fscPayConfigPo.getPayBusiType()) + "\u652f\u4ed8\u65b9\u5f0f\u914d\u7f6e\u4e3a\u6309\u8d26\u671f\u652f\u4ed8\u65f6\u5bbd\u9650\u671f\u9650\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (FscPayConfigBusiType.AGR_PT.getCode().equals(fscPayConfigPo.getPayBusiType()) && "3".equals(item.getPayType())) {
                errorList.add(FscPayConfigBusiType.desc((String)fscPayConfigPo.getPayBusiType()) + "\u652f\u4ed8\u65b9\u5f0f\u914d\u7f6e\u4e3a\u6309\u534f\u8bae\u7ea6\u675f\u652f\u4ed8\u65f6\u5bbd\u9650\u671f\u9650\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (!NumberUtil.isInteger((String)item.getDelayDays()) || Integer.parseInt(item.getDelayDays()) < 0) {
            errorList.add("\u5bbd\u9650\u671f\u9650\u4ec5\u53ef\u8f93\u5165\u6b63\u6574\u6570");
        }
        if (!FscRu.isBigDecimal(item.getCreditAmount())) {
            errorList.add("\u53ef\u900f\u652f\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
        } else if (!FscRu.checkDecimal(new BigDecimal(item.getCreditAmount()), 14, 3)) {
            errorList.add("\u53ef\u900f\u652f\u91d1\u989d\u6700\u591a\u652f\u630114\u4f4d\u6574\u6570\u30013\u4f4d\u5c0f\u6570");
        } else if (BigDecimal.ZERO.compareTo(new BigDecimal(item.getOverdueWarningRatio())) > 0) {
            errorList.add("\u53ef\u900f\u652f\u91d1\u989d\u4ec5\u53ef\u8f93\u5165\u6b63\u6574\u6570");
        }
        if (!FscRu.isBigDecimal(item.getUsedWarningAmount())) {
            errorList.add("\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u9884\u8b66\u503c\u683c\u5f0f\u9519\u8bef");
        } else if (!FscRu.checkDecimal(new BigDecimal(item.getUsedWarningAmount()), 14, 2)) {
            errorList.add("\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u9884\u8b66\u503c\u6700\u591a\u652f\u630114\u4f4d\u6574\u6570\u30012\u4f4d\u5c0f\u6570");
        } else if (BigDecimal.ZERO.compareTo(new BigDecimal(item.getOverdueWarningRatio())) > 0) {
            errorList.add("\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u9884\u8b66\u503c\u4ec5\u53ef\u8f93\u5165\u6b63\u6570");
        }
        if (!FscRu.isBigDecimal(item.getOverdueStartAmount())) {
            errorList.add("\u903e\u671f\u7ba1\u63a7\u8d77\u7b97\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
        } else if (!FscRu.checkDecimal(new BigDecimal(item.getOverdueStartAmount()), 14, 3)) {
            errorList.add("\u903e\u671f\u7ba1\u63a7\u8d77\u7b97\u91d1\u989d\u6700\u591a\u652f\u630114\u4f4d\u6574\u6570\u30013\u4f4d\u5c0f\u6570");
        } else if (BigDecimal.ZERO.compareTo(new BigDecimal(item.getOverdueWarningRatio())) > 0) {
            errorList.add("\u903e\u671f\u7ba1\u63a7\u8d77\u7b97\u91d1\u989d\u4ec5\u53ef\u8f93\u5165\u6b63\u6570");
        }
        if (!FscRu.isBigDecimal(item.getOverdueWarningRatio())) {
            errorList.add("\u903e\u671f\u9884\u8b66\u5360\u6bd4\u683c\u5f0f\u9519\u8bef");
        } else if (!FscRu.checkDecimal(new BigDecimal(item.getOverdueWarningRatio()), null, 3)) {
            errorList.add("\u903e\u671f\u9884\u8b66\u5360\u6bd4\u6700\u591a\u652f\u63013\u4f4d\u5c0f\u6570");
        } else if (BigDecimal.ONE.compareTo(new BigDecimal(item.getOverdueWarningRatio())) < 0 || BigDecimal.ZERO.compareTo(new BigDecimal(item.getOverdueWarningRatio())) >= 0) {
            errorList.add("\u903e\u671f\u9884\u8b66\u5360\u6bd4\u4ec5\u53ef\u8f93\u5165\uff080,1]\u4e4b\u95f4");
        }
        if (!FscRu.isBigDecimal(item.getOverdueControlRatio())) {
            errorList.add("\u903e\u671f\u7ba1\u63a7\u5360\u6bd4\u683c\u5f0f\u9519\u8bef");
        } else if (!FscRu.checkDecimal(new BigDecimal(item.getOverdueControlRatio()), null, 3)) {
            errorList.add("\u903e\u671f\u7ba1\u63a7\u5360\u6bd4\u6700\u591a\u652f\u63013\u4f4d\u5c0f\u6570");
        } else if (BigDecimal.ONE.compareTo(new BigDecimal(item.getOverdueControlRatio())) < 0 || BigDecimal.ZERO.compareTo(new BigDecimal(item.getOverdueControlRatio())) >= 0) {
            errorList.add("\u903e\u671f\u7ba1\u63a7\u5360\u6bd4\u4ec5\u53ef\u8f93\u5165\uff080,1]\u4e4b\u95f4");
        }
        if (!FscRu.isBigDecimal(item.getOverdueRecoveryRatio())) {
            errorList.add("\u903e\u671f\u6062\u590d\u5360\u6bd4\u683c\u5f0f\u9519\u8bef");
        } else if (!FscRu.checkDecimal(new BigDecimal(item.getOverdueRecoveryRatio()), null, 3)) {
            errorList.add("\u903e\u671f\u6062\u590d\u5360\u6bd4\u6700\u591a\u652f\u63013\u4f4d\u5c0f\u6570");
        } else if (BigDecimal.ONE.compareTo(new BigDecimal(item.getOverdueRecoveryRatio())) < 0 || BigDecimal.ZERO.compareTo(new BigDecimal(item.getOverdueRecoveryRatio())) >= 0) {
            errorList.add("\u903e\u671f\u6062\u590d\u5360\u6bd4\u4ec5\u53ef\u8f93\u5165\uff080,1]\u4e4b\u95f4");
        }
        if (!FscRu.isBigDecimal(item.getOverdueIndexRatio())) {
            errorList.add("\u7ba1\u63a7\u6307\u6570\u4ea7\u751f\u6bd4\u4f8b\u683c\u5f0f\u9519\u8bef");
        } else if (!FscRu.checkDecimal(new BigDecimal(item.getOverdueIndexRatio()), null, 6)) {
            errorList.add("\u7ba1\u63a7\u6307\u6570\u4ea7\u751f\u6bd4\u4f8b\u6700\u591a\u652f\u63016\u4f4d\u5c0f\u6570");
        } else if (BigDecimal.ONE.compareTo(new BigDecimal(item.getOverdueIndexRatio())) < 0 || BigDecimal.ZERO.compareTo(new BigDecimal(item.getOverdueIndexRatio())) >= 0) {
            errorList.add("\u7ba1\u63a7\u6307\u6570\u4ea7\u751f\u6bd4\u4f8b\u4ec5\u53ef\u8f93\u5165\uff080,1]\u4e4b\u95f4");
        }
        if (!FscRu.isBigDecimal(item.getOverdueWarningIndex())) {
            errorList.add("\u903e\u671f\u9884\u8b66\u6307\u6570\u683c\u5f0f\u9519\u8bef");
        } else if (!FscRu.checkDecimal(new BigDecimal(item.getOverdueWarningIndex()), 14, 3)) {
            errorList.add("\u903e\u671f\u9884\u8b66\u6307\u6570\u6700\u591a\u652f\u63013\u4f4d\u5c0f\u6570");
        } else if (BigDecimal.ZERO.compareTo(new BigDecimal(item.getOverdueWarningIndex())) > 0) {
            errorList.add("\u903e\u671f\u9884\u8b66\u6307\u6570\u4ec5\u53ef\u8f93\u5165\u6b63\u6570");
        }
        if (StrUtil.isBlank((CharSequence)item.getPayMethod())) {
            errorList.add("\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            List<String> payMethodList = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12");
            List payMethodArr = Arrays.stream(item.getPayMethod().replace(" ", "").split("[,\uff0c]")).filter(StrUtil::isNotBlank).collect(Collectors.toList());
            if (payMethodArr.isEmpty()) {
                errorList.add("\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u5b57\u7b26\u4e32");
            } else if (payMethodArr.stream().anyMatch(i -> !payMethodList.contains(i))) {
                errorList.add("\u652f\u4ed8\u65b9\u5f0f\u5b58\u5728\u4e3a\u77e5\u7c7b\u578b");
            }
        }
        if (errorList.isEmpty()) {
            if (new BigDecimal(item.getOverdueStartAmount()).compareTo(new BigDecimal(item.getCreditAmount())) >= 0) {
                errorList.add("\u903e\u671f\u7ba1\u63a7\u8d77\u7b97\u91d1\u989d\u5e94\u5f53\u5c0f\u4e8e\u53ef\u900f\u652f\u91d1\u989d");
            }
            if (new BigDecimal(item.getOverdueRecoveryRatio()).compareTo(new BigDecimal(item.getOverdueControlRatio())) >= 0) {
                errorList.add("\u903e\u671f\u6062\u590d\u5360\u6bd4\u5e94\u5f53\u5c0f\u4e8e\u903e\u671f\u7ba1\u63a7\u5360\u6bd4");
            }
            if (new BigDecimal(item.getOverdueRecoveryIndex()).compareTo(new BigDecimal(item.getOverdueControlIndex())) >= 0) {
                errorList.add("\u903e\u671f\u6062\u590d\u6307\u6570\u5e94\u5f53\u5c0f\u4e8e\u903e\u671f\u7ba1\u63a7\u6307\u6570");
            }
        }
        if (!errorList.isEmpty()) {
            item.setFailReason(String.join((CharSequence)";", errorList));
            return;
        }
        this.initOrgInfo(item, fscPayConfigPo);
    }

    private void initOrgInfo(FscPayConfigBatchImportInfoBO item, FscPayConfigPO fscPayConfigPo) {
        Long companyId = Long.valueOf(item.getCompanyId());
        String paySubClass = fscPayConfigPo.getPaySubClass();
        FscUmcQryAccountListExternalReqBO umcReqBo = new FscUmcQryAccountListExternalReqBO();
        umcReqBo.setOrgIdWeb(companyId);
        umcReqBo.setPageNo(Integer.valueOf(1));
        umcReqBo.setPageSize(Integer.valueOf(5));
        umcReqBo.setQueryType("01");
        umcReqBo.setOrgTypes(Arrays.asList("00", "01", "02", "03", "04"));
        umcReqBo.setIsProfessionalOrgs(Arrays.asList("0", "1"));
        String intExtProperty = FscPayConfigSubClass.IN.getCode().equals(paySubClass) ? "101" : "102";
        umcReqBo.setIntExtPropertys(Collections.singletonList(intExtProperty));
        FscUmcQryAccountListExternalRspBO umcOrgRspBo = this.fscUmcQryAccountListExternalService.qryPurchaseUnitListByOperatio(umcReqBo);
        if (FscRu.isFailed(umcOrgRspBo.getRespCode()).booleanValue()) {
            log.error("\u6839\u636e\u5355\u4f4dID\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u5f02\u5e38\uff1acompanyId:{}.rsp:{}", (Object)item.getCompanyId(), (Object)JSON.toJSONString((Object)umcOrgRspBo));
            item.setFailReason("\u6839\u636e\u5355\u4f4dID\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u5f02\u5e38");
        } else if (CollUtil.isEmpty((Collection)umcOrgRspBo.getRows())) {
            item.setFailReason("\u6839\u636e\u5355\u4f4dID\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
        } else {
            UmcEnterpriseOrgAbilityBO umcEnterpriseOrgBo = umcOrgRspBo.getRows().stream().filter(i -> Objects.equals(companyId, i.getOrgId())).findFirst().orElse(null);
            if (umcEnterpriseOrgBo == null) {
                item.setFailReason("\u6839\u636e\u5355\u4f4dID\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u7ed3\u679c\u4e0d\u5b58\u5728\u5f53\u524d\u5355\u4f4d");
            } else if ("03".equals(umcEnterpriseOrgBo.getOrgType())) {
                item.setFailReason("\u6839\u636e\u5355\u4f4dID\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u4e3a\u90e8\u95e8\uff0c\u8bf7\u914d\u7f6e\u5355\u4f4d");
            } else if (StrUtil.isNotBlank((CharSequence)item.getCompanyName()) && !item.getCompanyName().equals(umcEnterpriseOrgBo.getOrgName())) {
                item.setFailReason("\u5355\u4f4d\u540d\u79f0\u4e0e\u7cfb\u7edf\u5185\u90e8\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u83b7\u53d6\u6700\u65b0\u5355\u4f4d\u540d\u79f0");
            } else {
                item.setCompanyTreePath(umcEnterpriseOrgBo.getOrgTreePath());
            }
        }
    }

    private List<String> parameterValidation(FscPayConfigExtOrgBatchImportAbilityReqBO reqBo) {
        ArrayList<String> errorList = new ArrayList<String>();
        if (reqBo == null) {
            errorList.add("\u5165\u53c2\u4e3a\u7a7a");
            return errorList;
        }
        if (reqBo.getUserId() == null || reqBo.getUserId() == 0L) {
            errorList.add("\u5165\u53c2[userId]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getImpType())) {
            errorList.add("\u5165\u53c2[impType]\u4e3a\u7a7a");
        }
        if (reqBo.getImpId() == null || reqBo.getImpId() == 0L) {
            errorList.add("\u5165\u53c2[impId]\u4e3a\u7a7a");
        }
        if (reqBo.getParentConfigId() == null || reqBo.getParentConfigId() == 0L) {
            errorList.add("\u5165\u53c2[parentConfigId]\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getPayConfigList())) {
            errorList.add("\u6570\u636e\u8bfb\u53d6\u96c6\u5408\u4e3a\u7a7a");
        } else if (reqBo.getPayConfigList().stream().anyMatch(i -> i.getGluttonLineNum() == null)) {
            errorList.add("\u6570\u636e\u8bfb\u53d6\u96c6\u5408\u884c\u53f7\u9519\u8bef");
        }
        if (reqBo.getMainDataCount() == null) {
            errorList.add("\u6570\u636e\u8bfb\u53d6\u603b\u6570\u636e\u91cf\u4e3a\u7a7a");
        }
        if (errorList.isEmpty()) {
            CnncUmcFileReqBO umcFileReqBo = new CnncUmcFileReqBO();
            umcFileReqBo.setImpType(reqBo.getImpType());
            umcFileReqBo.setImpId(reqBo.getImpId());
            CnncUmcFileObjRspBO umcFileObjRspBo = this.cnncUmcFileAbilityService.fileGet(umcFileReqBo);
            if (FscRu.isFailed(umcFileObjRspBo.getRespCode()).booleanValue()) {
                errorList.add("\u6839\u636e[impId]\u548c[impType]\u67e5\u8be2\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff1a" + umcFileObjRspBo.getRespDesc());
            } else if (umcFileObjRspBo.getRecord() == null) {
                errorList.add("\u6839\u636e[impId]\u548c[impType]\u67e5\u8be2\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
            }
        }
        return errorList;
    }
}

