/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.date.BetweenFormater;
import cn.hutool.core.date.DateUtil;
import com.tydic.pfscext.api.ability.FscPayConfigExtOrgSaveImportAbilityService;
import com.tydic.pfscext.api.ability.bo.FscPayConfigExtOrgSaveImportAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscPayConfigExtOrgSaveImportAbilityRspBO;
import com.tydic.pfscext.api.busi.FscPayConfigExtOrgSaveImportBusiService;
import com.tydic.pfscext.api.busi.bo.FscPayConfigExtOrgSaveImportBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscPayConfigExtOrgSaveImportBusiRspBO;
import com.tydic.pfscext.dao.FscPayConfigImportTempMapper;
import com.tydic.pfscext.dao.po.FscPayConfigImportTempPO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.RedisLock;
import com.tydic.pfscext.utils.ValUtil;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscPayConfigExtOrgSaveImportAbilityService"})
public class FscPayConfigExtOrgSaveImportAbilityServiceImpl
implements FscPayConfigExtOrgSaveImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayConfigExtOrgSaveImportAbilityServiceImpl.class);
    @Resource
    private RedisLock redisLock;
    @Resource
    private FscPayConfigImportTempMapper fscPayConfigImportTempMapper;
    @Resource
    private FscPayConfigExtOrgSaveImportBusiService fscPayConfigExtOrgSaveImportBusiService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"dealPayConfigExtOrgSaveImport"})
    public FscPayConfigExtOrgSaveImportAbilityRspBO dealPayConfigExtOrgSaveImport(@RequestBody FscPayConfigExtOrgSaveImportAbilityReqBO reqBo) {
        ValUtil.isEmptyNum(reqBo.getParentConfigId()).exception("\u7236\u652f\u4ed8\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmptyNum(reqBo.getImpId()).exception("\u5bfc\u5165ID\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isBlank(reqBo.getImpType()).exception("\u5bfc\u5165\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        FscPayConfigImportTempPO fscPayConfigImportTempPo = new FscPayConfigImportTempPO();
        fscPayConfigImportTempPo.setParentConfigId(reqBo.getParentConfigId());
        fscPayConfigImportTempPo.setImpType(reqBo.getImpType());
        fscPayConfigImportTempPo.setImpId(reqBo.getImpId());
        fscPayConfigImportTempPo = this.fscPayConfigImportTempMapper.getCountAndTotalCount(fscPayConfigImportTempPo);
        ValUtil.isEmpty(fscPayConfigImportTempPo).exception("\u6839\u636e\u5bfc\u5165ID\u3001\u5bfc\u5165\u7c7b\u578b\u3001\u7236\u652f\u4ed8\u914d\u7f6eID\u67e5\u8be2\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        if (fscPayConfigImportTempPo.getImportCount() == 0) {
            throw new PfscExtBusinessException("18000", "\u5bfc\u5165\u6570\u636e\u4e3a0\u6761");
        }
        if (fscPayConfigImportTempPo.getUnprocessedCount() == 0) {
            throw new PfscExtBusinessException("18000", "\u672a\u6267\u884c\u6570\u636e\u4e3a0\u6761,\u8bf7\u52a1\u91cd\u590d\u63d0\u4ea4");
        }
        if (!Objects.equals(fscPayConfigImportTempPo.getImportCount(), fscPayConfigImportTempPo.getInboundCount())) {
            throw new PfscExtBusinessException("18000", "\u671f\u671b\u5bfc\u5165\u6570\u636e" + fscPayConfigImportTempPo.getImportCount() + "\u6761\uff0c\u5b9e\u9645\u5bfc\u5165" + fscPayConfigImportTempPo.getInboundCount() + "\u6761\uff0c\u9700\u5168\u90e8\u6210\u529f\u624d\u53ef\u5bfc\u5165");
        }
        String redisLockKey = "FSC_PAY_CONFIG_EXT_ORG_IMPORT_LOCK_PREFIX_" + reqBo.getParentConfigId();
        if (this.redisLock.getLock(redisLockKey, 72000)) {
            log.error("\u4f8b\u5916\u5355\u4f4d\u6279\u91cf\u8c03\u6574\u5f02\u5e38,\u5f53\u524d\u7236\u652f\u4ed8\u914d\u7f6e\u6b63\u5728\u8c03\u6574\u4e2d" + DateUtil.formatBetween((long)this.redisLock.getExpireTime(redisLockKey), (BetweenFormater.Level)BetweenFormater.Level.SECOND));
            FscPayConfigExtOrgSaveImportAbilityRspBO rspBo = new FscPayConfigExtOrgSaveImportAbilityRspBO();
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u4f8b\u5916\u5355\u4f4d\u6279\u91cf\u8c03\u6574\u5f02\u5e38,\u5f53\u524d\u7236\u652f\u4ed8\u914d\u7f6e\u6b63\u5728\u8c03\u6574\u4e2d");
            return rspBo;
        }
        try {
            FscPayConfigExtOrgSaveImportBusiReqBO busiReqBo = FscRu.js(reqBo, FscPayConfigExtOrgSaveImportBusiReqBO.class);
            FscPayConfigExtOrgSaveImportBusiRspBO busiRspBo = this.fscPayConfigExtOrgSaveImportBusiService.dealPayConfigExtOrgSaveImport(busiReqBo);
            FscPayConfigExtOrgSaveImportAbilityRspBO fscPayConfigExtOrgSaveImportAbilityRspBO = FscRu.js(busiRspBo, FscPayConfigExtOrgSaveImportAbilityRspBO.class);
            return fscPayConfigExtOrgSaveImportAbilityRspBO;
        }
        catch (Exception e) {
            log.error("\u4f8b\u5916\u5355\u4f4d\u6279\u91cf\u8c03\u6574\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
            FscPayConfigExtOrgSaveImportAbilityRspBO rspBo = new FscPayConfigExtOrgSaveImportAbilityRspBO();
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u4f8b\u5916\u5355\u4f4d\u6279\u91cf\u8c03\u6574\u5f02\u5e38:" + e.getMessage());
            FscPayConfigExtOrgSaveImportAbilityRspBO fscPayConfigExtOrgSaveImportAbilityRspBO = rspBo;
            return fscPayConfigExtOrgSaveImportAbilityRspBO;
        }
        finally {
            this.redisLock.unLock(redisLockKey);
        }
    }
}

