/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.pfscext.api.ability.FscPayConfigSaveAbilityService;
import com.tydic.pfscext.api.ability.bo.FscPayConfigSaveAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscPayConfigSaveAbilityRspBO;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigPayNodeRule;
import com.tydic.pfscext.enums.FscPayConfigPayType;
import com.tydic.pfscext.enums.FscPayConfigStatus;
import com.tydic.pfscext.enums.FscPayConfigSubClass;
import com.tydic.pfscext.enums.FscPayConfigSubType;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscPayConfigEditBusiService;
import com.tydic.pfscext.service.busi.FscPayConfigSaveBusiService;
import com.tydic.pfscext.service.busi.bo.FscPayConfigEditBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigEditBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigSaveBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigSaveBusiRspBO;
import com.tydic.pfscext.service.comb.bo.FscPayConfigSaveBasicCombReqBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscPayConfigSaveAbilityService"})
public class FscPayConfigSaveAbilityServiceImpl
implements FscPayConfigSaveAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayConfigSaveAbilityServiceImpl.class);
    @Autowired
    private FscPayConfigSaveBusiService fscPayConfigSaveBusiService;
    @Autowired
    private FscPayConfigEditBusiService fscPayConfigEditBusiService;
    @Autowired
    private FscPayConfigMapper fscPayConfigMapper;
    @Resource(name="fscPayConfigSaveProvider")
    private ProxyMessageProducer fscPayConfigSaveProvider;
    @Value(value="${FSC_PAY_CONFIG_SAVE_TOPIC:FSC_PAY_CONFIG_SAVE_TOPIC}")
    private String FSC_PAY_CONFIG_SAVE_TOPIC;
    @Value(value="${FSC_PAY_CONFIG_SAVE_TAG:*}")
    private String FSC_PAY_CONFIG_SAVE_TAG;

    @PostMapping(value={"dealPayConfigSave"})
    public FscPayConfigSaveAbilityRspBO dealPayConfigSave(@RequestBody FscPayConfigSaveAbilityReqBO reqBo) {
        this.parameterVerification(reqBo);
        if ("1".equals(reqBo.getOperationType())) {
            return this.savePayConfig(reqBo);
        }
        if ("2".equals(reqBo.getOperationType())) {
            if (reqBo.getPayConfigId() == null || reqBo.getPayConfigId() == 0L) {
                throw new PfscExtBusinessException("18000", "\u4fee\u6539\u652f\u4ed8\u914d\u7f6e\u65f6,\u652f\u4ed8\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return this.editPayConfig(reqBo);
        }
        throw new PfscExtBusinessException("18000", "\u5165\u53c2[operationType]\u503c\u9519\u8bef");
    }

    private FscPayConfigSaveAbilityRspBO editPayConfig(FscPayConfigSaveAbilityReqBO reqBo) {
        FscPayConfigEditBusiReqBO busiReqBo = FscRu.js(reqBo, FscPayConfigEditBusiReqBO.class);
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        fscPayConfigQry.setPayConfigId(reqBo.getPayConfigId());
        fscPayConfigQry.setPayBusiType(reqBo.getPayBusiType());
        fscPayConfigQry.setPaySubType(reqBo.getPaySubType());
        fscPayConfigQry.setPaySubClass(reqBo.getPaySubClass());
        fscPayConfigQry.setPayConfigType(FscPayConfigType.MAIN.getCode());
        fscPayConfigQry.setDeleteFlag(YesOrNo.NO.getCode());
        FscPayConfigPO modelBy = this.fscPayConfigMapper.getModelBy(fscPayConfigQry);
        if (modelBy == null) {
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        if (FscPayConfigStatus.UPDATING.getCode().equals(modelBy.getStatus())) {
            throw new PfscExtBusinessException("18000", "\u5f53\u524d\u652f\u4ed8\u914d\u7f6e\u6b63\u5728\u4fee\u6539\u4e2d\uff0c\u8bf7\u7a0d\u540e\u4fee\u6539");
        }
        FscPayConfigEditBusiRspBO busiRspBo = this.fscPayConfigEditBusiService.dealPayConfigEdit(busiReqBo);
        try {
            FscPayConfigSaveBasicCombReqBO editBasicCombReqBo = FscRu.js(reqBo, FscPayConfigSaveBasicCombReqBO.class);
            JSONObject data = new JSONObject();
            data.put("type", (Object)"EDIT");
            data.put("busiReqBo", (Object)editBasicCombReqBo);
            ProxySendResult sendResult = this.fscPayConfigSaveProvider.send(new ProxyMessage(this.FSC_PAY_CONFIG_SAVE_TOPIC, this.FSC_PAY_CONFIG_SAVE_TAG, data.toJSONString()));
            if (!"SEND_OK".equals(sendResult.getStatus())) {
                throw new PfscExtBusinessException("18000", "\u5f02\u6b65\u5904\u7406\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff0cMQ\u53d1\u9001\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001MQ\u5f02\u5e38\uff1a" + e);
            throw new PfscExtBusinessException("18000", "\u5f02\u6b65\u5904\u7406\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff0cMQ\u53d1\u9001\u5931\u8d25");
        }
        return FscRu.js((Object)busiRspBo, FscPayConfigSaveAbilityRspBO.class);
    }

    private FscPayConfigSaveAbilityRspBO savePayConfig(FscPayConfigSaveAbilityReqBO reqBo) {
        FscPayConfigSaveBusiReqBO busiReqBo = FscRu.js(reqBo, FscPayConfigSaveBusiReqBO.class);
        if (this.payConfigExist(reqBo)) {
            StringJoiner joiner = new StringJoiner("-");
            joiner.add(FscPayConfigBusiType.desc((String)reqBo.getPayBusiType()));
            joiner.add(FscPayConfigSubClass.desc((String)reqBo.getPaySubClass()));
            joiner.add(FscPayConfigSubType.desc((String)reqBo.getPaySubType()));
            joiner.add("\u914d\u7f6e\u5df2\u5b58\u5728");
            throw new PfscExtBusinessException("18000", joiner.toString());
        }
        FscPayConfigSaveBusiRspBO busiRspBo = this.fscPayConfigSaveBusiService.dealPayConfigSave(busiReqBo);
        if (FscRu.isFailed(busiRspBo.getRespCode()).booleanValue()) {
            throw new PfscExtBusinessException(busiRspBo.getRespCode(), "\u65b0\u589e\u652f\u4ed8\u914d\u7f6e\u5f02\u5e38-" + busiRspBo.getRespDesc());
        }
        try {
            FscPayConfigSaveBasicCombReqBO saveBasicCombReqBo = FscRu.js(reqBo, FscPayConfigSaveBasicCombReqBO.class);
            saveBasicCombReqBo.setPayConfigId(busiRspBo.getPayConfigId());
            JSONObject data = new JSONObject();
            data.put("type", (Object)"ADD");
            data.put("busiReqBo", (Object)saveBasicCombReqBo);
            ProxySendResult sendResult = this.fscPayConfigSaveProvider.send(new ProxyMessage(this.FSC_PAY_CONFIG_SAVE_TOPIC, this.FSC_PAY_CONFIG_SAVE_TAG, data.toJSONString()));
            if (!"SEND_OK".equals(sendResult.getStatus())) {
                throw new PfscExtBusinessException("18000", "\u5f02\u6b65\u5904\u7406\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff0cMQ\u53d1\u9001\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001MQ\u5f02\u5e38\uff1a{}", (Object)e.toString());
            throw new PfscExtBusinessException("18000", "\u5f02\u6b65\u5904\u7406\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff0cMQ\u53d1\u9001\u5931\u8d25");
        }
        return FscRu.js((Object)busiRspBo, FscPayConfigSaveAbilityRspBO.class);
    }

    private boolean payConfigExist(FscPayConfigSaveAbilityReqBO reqBo) {
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        fscPayConfigQry.setPayBusiType(reqBo.getPayBusiType());
        fscPayConfigQry.setPaySubClass(reqBo.getPaySubClass());
        fscPayConfigQry.setPaySubType(reqBo.getPaySubType());
        fscPayConfigQry.setPayConfigType(FscPayConfigType.MAIN.getCode());
        fscPayConfigQry.setDeleteFlag(YesOrNo.NO.getCode());
        int checkBy = this.fscPayConfigMapper.getCheckBy(fscPayConfigQry);
        return checkBy > 0;
    }

    private void parameterVerification(FscPayConfigSaveAbilityReqBO reqBo) {
        ValUtil.isEmpty(reqBo).exception("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isBlank(reqBo.getOperationType()).exception("\u5165\u53c2[operationType]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isBlank(reqBo.getPayBusiType()).exception("\u5165\u53c2[payBusiType]\u4e0d\u80fd\u4e3a\u7a7a");
        FscPayConfigBusiType busiType = FscPayConfigBusiType.instance((String)reqBo.getPayBusiType());
        ValUtil.isEmpty(busiType).exception("\u5165\u53c2[payBusiType]\u9519\u8bef\u503c");
        ValUtil.isBlank(reqBo.getPaySubClass()).exception("\u5165\u53c2[paySubClass]\u4e0d\u80fd\u4e3a\u7a7a");
        FscPayConfigSubClass subClass = FscPayConfigSubClass.instance((String)reqBo.getPaySubClass());
        ValUtil.isEmpty(subClass).exception("\u5165\u53c2[paySubClass]\u503c\u9519\u8bef");
        ValUtil.isBlank(reqBo.getPaySubType()).exception("\u5165\u53c2[paySubType]\u4e0d\u80fd\u4e3a\u7a7a");
        FscPayConfigSubType subType = FscPayConfigSubType.instance((String)reqBo.getPaySubType());
        ValUtil.isEmpty(subType).exception("\u5165\u53c2[paySubType]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isBlank(reqBo.getPayType()).exception("\u5165\u53c2[payType]\u4e0d\u80fd\u4e3a\u7a7a");
        FscPayConfigPayType payType = FscPayConfigPayType.instance((String)reqBo.getPayType());
        ValUtil.isEmpty(payType).exception("\u5165\u53c2[payType]\u9519\u8bef\u503c");
        List<String> combination = Arrays.asList("0012", "0110", "0112", "0103", "1011", "1103", "1111", "2011", "2111", "3012", "3112", "6013", "6103", "6113", "8010", "8012", "8103", "8110", "8112");
        String reqComb = reqBo.getPayBusiType() + reqBo.getPaySubClass() + reqBo.getPaySubType() + reqBo.getPayType();
        if (!combination.contains(reqComb)) {
            log.error("\u7ec4\u5408\u503c\uff1a{}", (Object)reqComb);
            throw new PfscExtBusinessException("18000", "\u9519\u8bef\u7f16\u7801\uff1a" + reqComb + ",\u8bf7\u52ff\u7be1\u6539\u5165\u53c2\u503c");
        }
        BigDecimal hundred = new BigDecimal("100");
        if (FscPayConfigPayType.YF_RATIO.getCode().equals(reqBo.getPayType())) {
            ValUtil.isEmpty(reqBo.getDownPaymentRatio()).exception("\u5165\u53c2[downPaymentRatio]\u4e0d\u80fd\u4e3a\u7a7a");
            if (reqBo.getDownPaymentRatio().compareTo(BigDecimal.ZERO) < 0) {
                throw new PfscExtBusinessException("0001", "\u9996\u4ed8\u6b3e\u652f\u4ed8\u6bd4\u4f8b\u5e94\u5927\u4e8e\u7b49\u4e8e0");
            }
            ValUtil.isEmpty(reqBo.getCheckPaymentRatio()).exception("\u5165\u53c2[checkPaymentRatio]\u4e0d\u80fd\u4e3a\u7a7a");
            if (reqBo.getCheckPaymentRatio().compareTo(BigDecimal.ZERO) < 0) {
                throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u6b3e\u652f\u4ed8\u6bd4\u4f8b\u5e94\u5927\u4e8e\u7b49\u4e8e0");
            }
            if (reqBo.getDownPaymentRatio().add(reqBo.getCheckPaymentRatio()).compareTo(hundred) != 0) {
                throw new PfscExtBusinessException("18000", "\u9884\u4ed8\u6b3e\u6bd4\u4f8b\u4e0e\u9a8c\u6536\u6b3e\u6bd4\u4f8b\u548c\u4e0d\u4e3a100%");
            }
        } else if (FscPayConfigPayType.XY.getCode().equals(reqBo.getPayType())) {
            if (FscPayConfigBusiType.AGR_PT.getCode().equals(reqBo.getPayBusiType())) {
                ValUtil.isEmpty(reqBo.getPayNodeRule()).exception("\u5165\u53c2[payNodeRule]\u4e0d\u80fd\u4e3a\u7a7a");
                ValUtil.isEmpty(FscPayConfigPayNodeRule.instance((Integer)reqBo.getPayNodeRule())).exception("\u5165\u53c2[payNodeRule]\u503c\u9519\u8bef");
                ValUtil.isEmpty(reqBo.getPaymentDays()).exception("\u5165\u53c2[paymentDays]\u4e0d\u80fd\u4e3a\u7a7a");
                if (reqBo.getPaymentDays() <= 0) {
                    throw new PfscExtBusinessException("0001", "\u8d26\u671f\u5929\u6570\u5e94\u5927\u4e8e0");
                }
                ValUtil.isEmpty(reqBo.getDelayDays()).exception("\u5165\u53c2[delayDays]\u4e0d\u80fd\u4e3a\u7a7a");
                if (reqBo.getDelayDays() < 0) {
                    throw new PfscExtBusinessException("0001", "\u5bbd\u9650\u671f\u9650\u5e94\u5927\u4e8e\u7b49\u4e8e0");
                }
            }
            this.creditParameterVerification(reqBo);
        } else if (FscPayConfigPayType.ZQ.getCode().equals(reqBo.getPayType())) {
            ValUtil.isEmpty(reqBo.getPayNodeRule()).exception("\u5165\u53c2[payNodeRule]\u4e0d\u80fd\u4e3a\u7a7a");
            ValUtil.isEmpty(FscPayConfigPayNodeRule.instance((Integer)reqBo.getPayNodeRule())).exception("\u5165\u53c2[payNodeRule]\u503c\u9519\u8bef");
            ValUtil.isEmpty(reqBo.getPaymentDays()).exception("\u5165\u53c2[paymentDays]\u4e0d\u80fd\u4e3a\u7a7a");
            if (reqBo.getPaymentDays() <= 0) {
                throw new PfscExtBusinessException("0001", "\u8d26\u671f\u5929\u6570\u5e94\u5927\u4e8e0");
            }
            ValUtil.isEmpty(reqBo.getDelayDays()).exception("\u5165\u53c2[delayDays]\u4e0d\u80fd\u4e3a\u7a7a");
            if (reqBo.getDelayDays() < 0) {
                throw new PfscExtBusinessException("0001", "\u5bbd\u9650\u671f\u9650\u5e94\u5927\u4e8e\u7b49\u4e8e0");
            }
            this.creditParameterVerification(reqBo);
        } else if (FscPayConfigPayType.YF_ALL.getCode().equals(reqBo.getPayType())) {
            reqBo.setDownPaymentRatio(hundred);
            reqBo.setCheckPaymentRatio(BigDecimal.ZERO);
        }
        String parentPayBusiType = reqBo.getPayBusiType();
        if (FscPayConfigBusiType.FL.getCode().equals(parentPayBusiType) && !FscPayConfigPayNodeRule.QS.getCode().equals(reqBo.getPayNodeRule())) {
            throw new PfscExtBusinessException("18000", "\u5458\u5de5\u798f\u5229\u8d26\u671f\u8d77\u7b97\u8282\u70b9\u53ea\u80fd\u914d\u7f6e[\u7b7e\u6536\u53d1\u7968\u5f00\u59cb\u8ba1\u7b97]");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPayConfigChannels())) {
            reqBo.getPayConfigChannels().forEach(i -> {
                ValUtil.isEmpty(i.getPayChannels()).exception("\u5165\u53c2[payConfigChannels.payChannels]\u4e0d\u80fd\u4e3a\u7a7a");
                ValUtil.isEmpty(i.getPayMethod()).exception("\u5165\u53c2[payConfigChannels.payMethod]\u4e0d\u80fd\u4e3a\u7a7a");
                ValUtil.isEmpty(i.getRemark()).exception("\u5165\u53c2[payConfigChannels.remark]\u4e0d\u80fd\u4e3a\u7a7a");
            });
        }
    }

    private void creditParameterVerification(FscPayConfigSaveAbilityReqBO reqBo) {
        ValUtil.isEmpty(reqBo.getCreditAmount()).exception("\u5165\u53c2[creditAmount]\u4e0d\u80fd\u4e3a\u7a7a");
        if (reqBo.getCreditAmount().compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u6388\u4fe1\u989d\u5ea6\u5e94\u5927\u4e8e0");
        }
        ValUtil.isEmpty(reqBo.getUsedWarningAmount()).exception("\u5165\u53c2[usedWarningAmount]\u4e0d\u80fd\u4e3a\u7a7a");
        if (reqBo.getUsedWarningAmount().compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u9884\u8b66\u503c\u5e94\u5927\u4e8e0");
        }
        ValUtil.isEmpty(reqBo.getOverdueStartAmount()).exception("\u5165\u53c2[overdueStartAmount]\u4e0d\u80fd\u4e3a\u7a7a");
        if (reqBo.getOverdueStartAmount().compareTo(BigDecimal.ZERO) < 0) {
            throw new PfscExtBusinessException("0001", "\u903e\u671f\u7ba1\u63a7\u8d77\u7b97\u91d1\u989d\u5e94\u5927\u4e8e\u7b49\u4e8e0");
        }
        ValUtil.isEmpty(reqBo.getOverdueWarningRatio()).exception("\u5165\u53c2[overdueWarningRatio]\u4e0d\u80fd\u4e3a\u7a7a");
        if (reqBo.getOverdueWarningRatio().compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u903e\u671f\u8b66\u544a\u5360\u6bd4\u5e94\u5927\u4e8e0");
        }
        ValUtil.isEmpty(reqBo.getOverdueControlRatio()).exception("\u5165\u53c2[overdueControlRatio]\u4e0d\u80fd\u4e3a\u7a7a");
        if (reqBo.getOverdueControlRatio().compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u903e\u671f\u7ba1\u63a7\u5360\u6bd4\u5e94\u5927\u4e8e0");
        }
        ValUtil.isEmpty(reqBo.getOverdueRecoveryRatio()).exception("\u5165\u53c2[overdueRecoveryRatio]\u4e0d\u80fd\u4e3a\u7a7a");
        if (reqBo.getOverdueRecoveryRatio().compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u903e\u671f\u6062\u590d\u5360\u6bd4\u5e94\u5927\u4e8e0");
        }
        ValUtil.isEmpty(reqBo.getOverdueIndexRatio()).exception("\u5165\u53c2[overdueIndexRatio]\u4e0d\u80fd\u4e3a\u7a7a");
        if (reqBo.getOverdueIndexRatio().compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u7ba1\u63a7\u6307\u6570\u4ea7\u751f\u6bd4\u4f8b\u5e94\u5927\u4e8e0");
        }
        ValUtil.isEmpty(reqBo.getOverdueWarningIndex()).exception("\u5165\u53c2[overdueWarningIndex]\u4e0d\u80fd\u4e3a\u7a7a");
        if (reqBo.getOverdueWarningIndex().compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u903e\u671f\u8b66\u544a\u6307\u6570\u5e94\u5927\u4e8e0");
        }
        ValUtil.isEmpty(reqBo.getOverdueControlIndex()).exception("\u5165\u53c2[overdueControlIndex]\u4e0d\u80fd\u4e3a\u7a7a");
        if (reqBo.getOverdueControlIndex().compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u903e\u671f\u7ba1\u63a7\u6307\u6570\u5e94\u5927\u4e8e0");
        }
        ValUtil.isEmpty(reqBo.getOverdueRecoveryIndex()).exception("\u5165\u53c2[overdueRecoveryIndex]\u4e0d\u80fd\u4e3a\u7a7a");
        if (reqBo.getOverdueRecoveryIndex().compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u903e\u671f\u6062\u590d\u6307\u6570\u5e94\u5927\u4e8e0");
        }
        if (reqBo.getOverdueStartAmount().compareTo(reqBo.getCreditAmount()) >= 0) {
            throw new PfscExtBusinessException("0001", "\u903e\u671f\u7ba1\u63a7\u8d77\u7b97\u91d1\u989d\u5e94\u5f53\u5c0f\u4e8e\u53ef\u900f\u652f\u91d1\u989d");
        }
        if (reqBo.getOverdueRecoveryRatio().compareTo(reqBo.getOverdueControlRatio()) >= 0) {
            throw new PfscExtBusinessException("0001", "\u903e\u671f\u6062\u590d\u5360\u6bd4\u5e94\u5f53\u5c0f\u4e8e\u903e\u671f\u7ba1\u63a7\u5360\u6bd4");
        }
        if (reqBo.getOverdueRecoveryIndex().compareTo(reqBo.getOverdueControlIndex()) >= 0) {
            throw new PfscExtBusinessException("0001", "\u903e\u671f\u6062\u590d\u6307\u6570\u5e94\u5f53\u5c0f\u4e8e\u903e\u671f\u7ba1\u63a7\u6307\u6570");
        }
    }
}

