/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.pfscext.api.ability.FscPayResultModifyAbilityService;
import com.tydic.pfscext.api.busi.BusiPayResultModifyService;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyRspBO;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscPayResultModifyAbilityService"})
public class FscPayResultModifyAbilityServiceImpl
implements FscPayResultModifyAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayResultModifyAbilityServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private BusiPayResultModifyService busiPayResultModifyService;
    @Autowired
    private CacheClient cacheClient;
    @Resource(name="fscApplyPayResultUocCallbackProvider")
    private ProxyMessageProducer fscApplyPayResultUocCallbackProvider;
    @Value(value="${FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TOPIC:FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TOPIC}")
    private String FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TOPIC;
    @Value(value="${FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TAG:*}")
    private String FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TAG;

    @PostMapping(value={"modifyResult"})
    public BusiPayResultModifyRspBO modifyResult(@RequestBody BusiPayResultModifyReqBO reqBo) {
        List payNos = reqBo.getPayNos();
        if (CollectionUtils.isEmpty((Collection)payNos)) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355\u53f7(payNo)\u5fc5\u987b\u8f93\u5165");
        }
        List<String> payNoList = payNos.stream().filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(payNoList)) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355\u53f7(payNo)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ApplyPayInfoPO> applyPayInfoList = this.applyPayInfoMapper.getListByPayNoList(payNoList);
        if (CollectionUtils.isEmpty(applyPayInfoList)) {
            throw new PfscExtBusinessException("0001", "\u6839\u636e\u4ed8\u6b3e\u5355\u53f7(payNo)\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        List payNoListSearch = applyPayInfoList.stream().map(ApplyPayInfoPO::getPayno).collect(Collectors.toList());
        String noFoundPayNo = payNoList.stream().filter(i -> !payNoListSearch.contains(i)).collect(Collectors.joining(","));
        if (StrUtil.isNotBlank((CharSequence)noFoundPayNo)) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355[" + noFoundPayNo + "]\u4e0d\u5b58\u5728");
        }
        String errorPayStatus = applyPayInfoList.stream().filter(i -> !PayResultStatus.PAY_CONFIRMED.getCode().equals(i.getPayStatus())).map(i -> Optional.ofNullable(PayResultStatus.getInstance(i.getPayStatus())).map(item -> StrUtil.format((CharSequence)"\u4ed8\u6b3e\u7533\u8bf7\u5355[{}]\u4ed8\u6b3e\u72b6\u6001[{}]\u9519\u8bef,\u4e0d\u4e3a[{}]", (Object[])new Object[]{i.getPayno(), item.getDescr(), PayResultStatus.PAY_CONFIRMED.getDescr()})).orElse(StrUtil.format((CharSequence)"\u4ed8\u6b3e\u7533\u8bf7\u5355[{}]\u4ed8\u6b3e\u7ed3\u679c\u72b6\u6001\u4e0d\u5408\u6cd5", (Object[])new Object[]{i.getPayno()}))).collect(Collectors.joining(";"));
        if (StrUtil.isNotBlank((CharSequence)errorPayStatus)) {
            throw new PfscExtBusinessException("0001", errorPayStatus);
        }
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<String> cacheList = new ArrayList<String>();
        for (String payNo : payNoList) {
            String key = "FSC_APPLY_PAY_INFO_MODIFY_RESULT_PREFIX_" + payNo;
            String cachePayNo = null;
            try {
                cachePayNo = (String)this.cacheClient.get(key, String.class);
                log.error("\u7f13\u5b58\u7684redis.key:{}.value\uff1a{}", (Object)key, (Object)cachePayNo);
            }
            catch (Exception e) {
                log.error("\u6dfb\u52a0\u7f13\u5b58\u5f02\u5e38\uff1a{}", (Object)e.toString());
                if (!CollectionUtils.isEmpty(cacheList)) {
                    cacheList.forEach(arg_0 -> ((CacheClient)this.cacheClient).delete(arg_0));
                }
                throw new PfscExtBusinessException("0001", "REDIS\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u5904\u7406");
            }
            if (cachePayNo != null) {
                errorList.add(payNo);
                continue;
            }
            cacheList.add(key);
            this.cacheClient.set(key, (Object)key, 86400);
        }
        if (!CollectionUtils.isEmpty(errorList)) {
            if (!CollectionUtils.isEmpty(cacheList)) {
                cacheList.forEach(arg_0 -> ((CacheClient)this.cacheClient).delete(arg_0));
            }
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u7533\u8bf7\u5355" + errorList + "\u5df2\u7ecf\u5728\u786e\u8ba4\u4ed8\u6b3e\u4e2d,\u8bf7\u7a0d\u540e\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5");
        }
        reqBo.setUocEsSyncVersionId(Long.valueOf(Sequence.getInstance().nextId()));
        BusiPayResultModifyRspBO busiRspBo = this.busiPayResultModifyService.modifyResult(reqBo);
        this.sendMqSyncUocOrder(reqBo.getUocEsSyncVersionId());
        if (!CollectionUtils.isEmpty(cacheList)) {
            cacheList.forEach(arg_0 -> ((CacheClient)this.cacheClient).delete(arg_0));
        }
        return busiRspBo;
    }

    private void sendMqSyncUocOrder(Long uocEsSyncVersionId) {
        JSONObject data = new JSONObject();
        data.put("type", (Object)"ORDER_SYNC_ES");
        data.put("uocEsSyncVersionId", (Object)uocEsSyncVersionId);
        ProxyMessage message = new ProxyMessage(this.FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TOPIC, this.FSC_APPLY_PAY_RESULT_UOC_CALLBACK_TAG, data.toJSONString());
        ProxySendResult sendResult = this.fscApplyPayResultUocCallbackProvider.send(message);
    }
}

