/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.bo.PayProAbleQueryOrderStatusAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProAbleQueryOrderStatusAbilityRspBo;
import com.tydic.pfscext.api.ability.FscPaymentFlowSyncAbilityService;
import com.tydic.pfscext.api.ability.bo.FscBillSystemPaymentFlowInfoAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscBillSystemPaymentFlowInfoAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscCnerpPaymentFlowInfoAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscCnerpPaymentFlowInfoAbilityRspBO;
import com.tydic.pfscext.api.busi.FscPaymentFlowInfoAddBusiService;
import com.tydic.pfscext.api.busi.bo.FscPaymentFlowInfoAddBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscPaymentFlowInfoAddBusiRspBO;
import com.tydic.pfscext.enums.FlowFlag;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.pay.api.FscPayProAbleQueryOrderStatusAbilityService;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.RedisLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscPaymentFlowSyncAbilityService"})
public class FscPaymentFlowSyncAbilityServiceImpl
implements FscPaymentFlowSyncAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPaymentFlowSyncAbilityServiceImpl.class);
    @Resource
    private RedisLock redisLock;
    @Resource
    private FscPaymentFlowInfoAddBusiService fscPaymentFlowInfoAddBusiService;
    @Resource
    private FscPayProAbleQueryOrderStatusAbilityService fscPayProAbleQueryOrderStatusAbilityService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"addBillSystemPaymentFlowInfo"})
    public FscBillSystemPaymentFlowInfoAbilityRspBO addBillSystemPaymentFlowInfo(@RequestBody FscBillSystemPaymentFlowInfoAbilityReqBO reqBo) {
        FscBillSystemPaymentFlowInfoAbilityRspBO rspBo = FscRu.success(FscBillSystemPaymentFlowInfoAbilityRspBO.class);
        List<String> errorList = this.parameterValidationBill(reqBo);
        if (errorList.size() > 0) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a" + String.join((CharSequence)";", errorList));
            return rspBo;
        }
        String outOrderId = this.getBillOutOrderId(reqBo);
        String redisLockKey = "FSC_BILL_SYSTEM_PAYMENT_FLOW_LOCK_PREFIX_" + outOrderId;
        if (this.redisLock.getLock(redisLockKey, 1200)) {
            log.error("\u7968\u636e\u7cfb\u7edf\u65b0\u589e\u4ea4\u6613\u8bb0\u5f55\u5f02\u5e38,\u5f53\u524d\u4ea4\u6613\u8bb0\u5f55\u6b63\u5728\u5904\u7406\u4e2d" + DateUtil.formatBetween((long)this.redisLock.getExpireTime(redisLockKey)));
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u7968\u636e\u7cfb\u7edf\u65b0\u589e\u4ea4\u6613\u8bb0\u5f55\u5f02\u5e38,\u5f53\u524d\u6821\u9a8c\u8bb0\u5f55\u6b63\u5728\u5904\u7406\u4e2d");
            return rspBo;
        }
        try {
            FscPaymentFlowInfoAddBusiReqBO busiReqBo = FscRu.js(reqBo, FscPaymentFlowInfoAddBusiReqBO.class);
            busiReqBo.setOutOrderId(outOrderId);
            this.initPayInfo(busiReqBo);
            FscPaymentFlowInfoAddBusiRspBO busiRspBo = this.fscPaymentFlowInfoAddBusiService.addPaymentFlowInfo(busiReqBo);
            FscBillSystemPaymentFlowInfoAbilityRspBO fscBillSystemPaymentFlowInfoAbilityRspBO = FscRu.js(busiRspBo, FscBillSystemPaymentFlowInfoAbilityRspBO.class);
            return fscBillSystemPaymentFlowInfoAbilityRspBO;
        }
        catch (Exception e) {
            log.error("\u7968\u636e\u7cfb\u7edf\u65b0\u589e\u4ea4\u6613\u8bb0\u5f55\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u7968\u636e\u7cfb\u7edf\u65b0\u589e\u4ea4\u6613\u8bb0\u5f55\u5f02\u5e38:" + e.getMessage());
            FscBillSystemPaymentFlowInfoAbilityRspBO fscBillSystemPaymentFlowInfoAbilityRspBO = rspBo;
            return fscBillSystemPaymentFlowInfoAbilityRspBO;
        }
        finally {
            this.redisLock.unLock(redisLockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"addCnerpPaymentFlowInfo"})
    public FscCnerpPaymentFlowInfoAbilityRspBO addCnerpPaymentFlowInfo(@RequestBody FscCnerpPaymentFlowInfoAbilityReqBO reqBo) {
        FscCnerpPaymentFlowInfoAbilityRspBO rspBo = FscRu.success(FscCnerpPaymentFlowInfoAbilityRspBO.class);
        List<String> errorList = this.parameterValidationCnerp(reqBo);
        if (errorList.size() > 0) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a" + String.join((CharSequence)";", errorList));
            return rspBo;
        }
        String outOrderId = this.getCnerpOutOrderId(reqBo);
        String redisLockKey = "FSC_CNERP_PAYMENT_FLOW_LOCK_PREFIX_" + outOrderId;
        if (this.redisLock.getLock(redisLockKey, 1200)) {
            log.error("\u96c6\u56e2ERP\u65b0\u589e\u4ea4\u6613\u8bb0\u5f55\u5f02\u5e38,\u5f53\u524d\u4ea4\u6613\u8bb0\u5f55\u6b63\u5728\u5904\u7406\u4e2d" + DateUtil.formatBetween((long)this.redisLock.getExpireTime(redisLockKey)));
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u96c6\u56e2ERP\u65b0\u589e\u4ea4\u6613\u8bb0\u5f55\u5f02\u5e38,\u5f53\u524d\u6821\u9a8c\u8bb0\u5f55\u6b63\u5728\u5904\u7406\u4e2d");
            return rspBo;
        }
        try {
            FscPaymentFlowInfoAddBusiReqBO busiReqBo = FscRu.js(reqBo, FscPaymentFlowInfoAddBusiReqBO.class);
            busiReqBo.setOutOrderId(outOrderId);
            busiReqBo.setPayType(PayMethod.CNERP.getCode());
            busiReqBo.setPayChannel(PayChannel.CNERP.getCode());
            FscPaymentFlowInfoAddBusiRspBO busiRspBo = this.fscPaymentFlowInfoAddBusiService.addPaymentFlowInfo(busiReqBo);
            FscCnerpPaymentFlowInfoAbilityRspBO fscCnerpPaymentFlowInfoAbilityRspBO = FscRu.js(busiRspBo, FscCnerpPaymentFlowInfoAbilityRspBO.class);
            return fscCnerpPaymentFlowInfoAbilityRspBO;
        }
        catch (Exception e) {
            log.error("\u96c6\u56e2ERP\u65b0\u589e\u4ea4\u6613\u8bb0\u5f55\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u96c6\u56e2ERP\u65b0\u589e\u4ea4\u6613\u8bb0\u5f55\u5f02\u5e38:" + e.getMessage());
            FscCnerpPaymentFlowInfoAbilityRspBO fscCnerpPaymentFlowInfoAbilityRspBO = rspBo;
            return fscCnerpPaymentFlowInfoAbilityRspBO;
        }
        finally {
            this.redisLock.unLock(redisLockKey);
        }
    }

    private String getBillOutOrderId(FscBillSystemPaymentFlowInfoAbilityReqBO reqBo) {
        String outOrderId;
        if (FlowFlag.BILL_SYS_PAY.getCode().equals(reqBo.getFlowFlag())) {
            outOrderId = "BILL_PAYMENT-";
        } else if (FlowFlag.BILL_SYS_REFUND.getCode().equals(reqBo.getFlowFlag())) {
            outOrderId = "BILL_REFUND-";
        } else {
            throw new PfscExtBusinessException("18000", "\u6d41\u6c34\u6807\u8bc6\u503c\u9519\u8bef");
        }
        outOrderId = outOrderId + reqBo.getPayApplyNo() + "-" + reqBo.getInspectionId();
        return outOrderId;
    }

    private String getCnerpOutOrderId(FscCnerpPaymentFlowInfoAbilityReqBO reqBo) {
        String outOrderId;
        if (FlowFlag.CNERP_PAY.getCode().equals(reqBo.getFlowFlag())) {
            outOrderId = "CNERP_PAYMENT-";
        } else if (FlowFlag.CNERP_REFUND.getCode().equals(reqBo.getFlowFlag())) {
            outOrderId = "CNERP_REFUND-";
        } else {
            throw new PfscExtBusinessException("18000", "\u6d41\u6c34\u6807\u8bc6\u503c\u9519\u8bef");
        }
        outOrderId = outOrderId + reqBo.getPayApplyNo() + "-" + reqBo.getOrderId();
        return outOrderId;
    }

    private void initPayInfo(FscPaymentFlowInfoAddBusiReqBO busiReqBo) {
        if (StrUtil.isBlank((CharSequence)busiReqBo.getPayApplyNo())) {
            return;
        }
        PayProAbleQueryOrderStatusAbilityReqBo orderStatusAbilityReqBo = new PayProAbleQueryOrderStatusAbilityReqBo();
        orderStatusAbilityReqBo.setRealQueryFlag("1");
        orderStatusAbilityReqBo.setBusiCode("D500");
        orderStatusAbilityReqBo.setOriOrderId(busiReqBo.getPayApplyNo());
        log.info("\u7968\u636e\u4ea4\u6613\u8bb0\u5f55\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u5165\u53c2:" + JSON.toJSONString((Object)orderStatusAbilityReqBo));
        PayProAbleQueryOrderStatusAbilityRspBo orderStatusAbilityRspBo = this.fscPayProAbleQueryOrderStatusAbilityService.queryStatus(orderStatusAbilityReqBo);
        log.info("\u7968\u636e\u4ea4\u6613\u8bb0\u5f55\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u51fa\u53c2:" + JSON.toJSONString((Object)orderStatusAbilityRspBo));
        if (FscRu.isSuccess(orderStatusAbilityRspBo.getRespCode()).booleanValue()) {
            busiReqBo.setPaymentStatus(orderStatusAbilityRspBo.getPayStatus());
            busiReqBo.setPaymentFlowId(orderStatusAbilityRspBo.getPayNotifyTransId());
            busiReqBo.setPayOrderId(orderStatusAbilityRspBo.getPayOrderId());
            busiReqBo.setResultJson(JSON.toJSONString((Object)orderStatusAbilityRspBo));
            busiReqBo.setPayType(orderStatusAbilityRspBo.getPayMethod());
            busiReqBo.setPayChannel(orderStatusAbilityRspBo.getPaymentInsId());
            busiReqBo.setPayOrderId(orderStatusAbilityRspBo.getPayOrderId());
            busiReqBo.setBusiCode("D500");
        }
    }

    private List<String> parameterValidationBill(FscBillSystemPaymentFlowInfoAbilityReqBO reqBo) {
        ArrayList<String> errorList = new ArrayList<String>();
        if (reqBo == null) {
            errorList.add("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return errorList;
        }
        if (StrUtil.isBlank((CharSequence)reqBo.getPayApplyNo())) {
            errorList.add("\u4ed8\u6b3e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getPayTime() == null) {
            errorList.add("\u652f\u4ed8\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getPayOrgNo() == null) {
            errorList.add("\u4ed8\u6b3e\u65b9\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)reqBo.getPayName())) {
            errorList.add("\u4ed8\u6b3e\u65b9\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderAmt() == null) {
            errorList.add("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRecOrgNo() == null) {
            errorList.add("\u6536\u6b3e\u65b9\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)reqBo.getRecName())) {
            errorList.add("\u6536\u6b3e\u65b9\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderId() == null) {
            errorList.add("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)reqBo.getOrderCode())) {
            errorList.add("\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getInspectionId() == null) {
            errorList.add("\u9a8c\u6536\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getFlowType() == null) {
            errorList.add("\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)reqBo.getFlowFlag())) {
            errorList.add("\u6d41\u6c34\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            List<String> flowFlagList = Arrays.asList(FlowFlag.BILL_SYS_PAY.getCode(), FlowFlag.BILL_SYS_REFUND.getCode());
            if (!flowFlagList.contains(reqBo.getFlowFlag())) {
                errorList.add("\u6d41\u6c34\u6807\u8bc6[flowFlag=" + reqBo.getFlowFlag() + "]\u503c\u9519\u8bef");
            }
        }
        if (reqBo.getOrdOrgId() == null) {
            errorList.add("\u8ba2\u5355\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrdCompanyId() == null) {
            errorList.add("\u8ba2\u5355\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrdPurchaserId() == null) {
            errorList.add("\u8ba2\u5355\u4e0b\u5355\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getBillSysUrl() == null) {
            errorList.add("\u7968\u636e\u8df3\u8f6c\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return errorList;
    }

    private List<String> parameterValidationCnerp(FscCnerpPaymentFlowInfoAbilityReqBO reqBo) {
        ArrayList<String> errorList = new ArrayList<String>();
        if (reqBo == null) {
            errorList.add("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return errorList;
        }
        if (StrUtil.isBlank((CharSequence)reqBo.getPayApplyNo())) {
            errorList.add("\u4ed8\u6b3e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getPayTime() == null) {
            errorList.add("\u652f\u4ed8\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getPayOrgNo() == null) {
            errorList.add("\u4ed8\u6b3e\u65b9\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)reqBo.getPayName())) {
            errorList.add("\u4ed8\u6b3e\u65b9\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderAmt() == null) {
            errorList.add("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRecOrgNo() == null) {
            errorList.add("\u6536\u6b3e\u65b9\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)reqBo.getRecName())) {
            errorList.add("\u6536\u6b3e\u65b9\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderId() == null) {
            errorList.add("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)reqBo.getOrderCode())) {
            errorList.add("\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getFlowType() == null) {
            errorList.add("\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)reqBo.getFlowFlag())) {
            errorList.add("\u6d41\u6c34\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            List<String> flowFlagList = Arrays.asList(FlowFlag.CNERP_PAY.getCode(), FlowFlag.CNERP_REFUND.getCode());
            if (!flowFlagList.contains(reqBo.getFlowFlag())) {
                errorList.add("\u6d41\u6c34\u6807\u8bc6[flowFlag=" + reqBo.getFlowFlag() + "]\u503c\u9519\u8bef");
            }
        }
        if (reqBo.getOrdOrgId() == null) {
            errorList.add("\u8ba2\u5355\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrdCompanyId() == null) {
            errorList.add("\u8ba2\u5355\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrdPurchaserId() == null) {
            errorList.add("\u8ba2\u5355\u4e0b\u5355\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return errorList;
    }
}

