/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.PageReadListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.pfscext.api.ability.FscSaleInvoiceInfoAbilityService;
import com.tydic.pfscext.api.ability.bo.FscSaleInvoiceInfoAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscSaleInvoiceInfoAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscSaleInvoiceInfoNewAbilityReqBO;
import com.tydic.pfscext.api.busi.bo.BusiSaleInvoiceInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiSaleInvoiceInfoRspBO;
import com.tydic.pfscext.api.deal.bo.SaleInvoiceInfoExportBO;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoInvoicingTempMapper;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfoInvoicingTempPO;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscBillApplyInfoBusiService;
import com.tydic.pfscext.service.busi.FscSaleOrderInfoInvoicingTempBusiService;
import com.tydic.pfscext.service.busi.bo.FscBillApplyManualInvoiceUpdateBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscBillApplyManualInvoiceUpdateBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscSaleOrderInfoInvoicingTempBatchSaveBO;
import com.tydic.pfscext.service.busi.bo.FscSaleOrderInfoInvoicingTempBatchSaveBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscSaleOrderInfoInvoicingTempBatchSaveBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscSaleOrderInfoInvoicingTempDeleteBusiReqBO;
import com.tydic.pfscext.service.comb.api.FscSaleInvoiceInfoCombService;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import com.tydic.pfscext.utils.ValUtil;
import com.tydic.pfscext.utils.excel.bo.FscBillApplyInvoicingExcelReadBillInfoBO;
import com.tydic.pfscext.utils.excel.bo.FscBillApplyInvoicingExcelReadBillItemBO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscSaleInvoiceInfoAbilityService"})
public class FscSaleInvoiceInfoAbilityServiceImpl
implements FscSaleInvoiceInfoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscSaleInvoiceInfoAbilityServiceImpl.class);
    @Autowired
    private FscSaleOrderInfoInvoicingTempBusiService fscSaleOrderInfoInvoicingTempBusiService;
    @Autowired
    private FscBillApplyInfoBusiService fscBillApplyInfoBusiService;
    @Autowired
    private FscSaleInvoiceInfoCombService fscSaleInvoiceInfoCombService;
    @Autowired
    private SaleOrderInfoInvoicingTempMapper saleOrderInfoInvoicingTempMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Resource(name="fscBillApplyInvoicingProvider")
    private ProxyMessageProducer fscBillApplyInvoicingProvider;
    @Value(value="${FSC_BILL_APPLY_INVOICING_TOPIC:FSC_BILL_APPLY_INVOICING_TOPIC}")
    private String FSC_BILL_APPLY_INVOICING_TOPIC;
    @Value(value="${FSC_BILL_APPLY_INVOICING_TAG:*}")
    private String FSC_BILL_APPLY_INVOICING_TAG;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;

    @Deprecated
    @PostMapping(value={"dealManualInvoice"})
    public FscSaleInvoiceInfoAbilityRspBO dealManualInvoice(@RequestBody FscSaleInvoiceInfoAbilityReqBO reqBo) {
        ValUtil.isBlank(reqBo.getApplyNo()).exception("\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty((Collection)reqBo.getSaleInvoiceList())) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u4fe1\u606f\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String cacheApplyNoKey = "APPLY_MANUAL_INVOICE_" + reqBo.getApplyNo();
        String cacheApplyNoCache = (String)this.cacheClient.get(cacheApplyNoKey, String.class);
        if (StringUtils.hasText((String)cacheApplyNoCache)) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7[" + reqBo.getApplyNo() + "]\u6b63\u5728\u63d0\u4ea4\u786e\u8ba4\uff0c\u8bf75\u5206\u949f\u540e\u518d\u5c1d\u8bd5\u63d0\u4ea4");
        }
        this.cacheClient.set(cacheApplyNoKey, (Object)cacheApplyNoKey, 300);
        BusiSaleInvoiceInfoReqBO busiReqBo = FscRu.js(reqBo, BusiSaleInvoiceInfoReqBO.class);
        BusiSaleInvoiceInfoRspBO busiRspBo = this.fscSaleInvoiceInfoCombService.dealManualInvoice(busiReqBo);
        this.cacheClient.delete(cacheApplyNoKey);
        if (FscRu.isFailed(busiRspBo.getRespCode()).booleanValue()) {
            throw new PfscExtBusinessException(busiRspBo.getRespCode(), busiRspBo.getRespDesc());
        }
        return FscRu.success(FscSaleInvoiceInfoAbilityRspBO.class);
    }

    @PostMapping(value={"dealManualInvoiceNew"})
    public FscSaleInvoiceInfoAbilityRspBO dealManualInvoiceNew(@RequestBody FscSaleInvoiceInfoNewAbilityReqBO reqBo) {
        ValUtil.isBlank(reqBo.getApplyNo()).exception("\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isBlank(reqBo.getInvoiceXlsUrl()).exception("\u53d1\u7968\u4fe1\u606fExcel\u6587\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        String cacheApplyNoKey = "APPLY_MANUAL_INVOICE_" + reqBo.getApplyNo();
        String cacheApplyNoCache = (String)this.cacheClient.get(cacheApplyNoKey, String.class);
        if (StringUtils.hasText((String)cacheApplyNoCache)) {
            String errorMessage = "\u5f00\u7968\u7533\u8bf7[" + reqBo.getApplyNo() + "]\u6b63\u5728\u63d0\u4ea4\u786e\u8ba4\uff0c\u8bf75\u5206\u949f\u540e\u518d\u5c1d\u8bd5\u63d0\u4ea4";
            Long expireTimeByKey = this.cacheClient.getExpireTimeByKey(cacheApplyNoKey);
            if (expireTimeByKey != null) {
                errorMessage = StrUtil.format((CharSequence)"\u5f00\u7968\u7533\u8bf7[{}]\u6b63\u5728\u63d0\u4ea4\u786e\u8ba4\u5f00\u7968\uff0c\u8bf7{}\u540e\u518d\u5c1d\u8bd5\u63d0\u4ea4", (Object[])new Object[]{reqBo.getApplyNo(), DateUtil.formatBetween((long)(expireTimeByKey * 1000L))});
            }
            throw new PfscExtBusinessException("18000", errorMessage);
        }
        Long versionId = Sequence.getInstance().nextId();
        this.cacheClient.set(cacheApplyNoKey, (Object)String.valueOf(versionId), 600);
        BusiSaleInvoiceInfoReqBO busiReqBo = FscRu.js(reqBo, BusiSaleInvoiceInfoReqBO.class);
        busiReqBo.setApplyNo(reqBo.getApplyNo());
        busiReqBo.setElectronicInvoiceName(reqBo.getElectronicInvoiceName());
        busiReqBo.setElectronicInvoiceUrl(reqBo.getElectronicInvoiceUrl());
        busiReqBo.setInvoiceXlsName(reqBo.getInvoiceXlsName());
        busiReqBo.setInvoiceXlsUrl(reqBo.getInvoiceXlsUrl());
        busiReqBo.setVersionId(versionId);
        busiReqBo.setTempFlag(YesNo.YES.getCode());
        URL rootPath = FscSaleInvoiceInfoAbilityServiceImpl.class.getResource("/");
        String rootPathStr = rootPath.getPath() + "temp" + System.currentTimeMillis();
        File directoryFile = new File(rootPathStr);
        if (!directoryFile.exists()) {
            directoryFile.mkdir();
        }
        try {
            this.dealReadShardingExcel(busiReqBo, rootPathStr, versionId);
            FileUtil.del((File)directoryFile);
        }
        catch (Exception e) {
            this.cacheClient.delete(cacheApplyNoKey);
            FscSaleOrderInfoInvoicingTempDeleteBusiReqBO deleteBusiReqBo = new FscSaleOrderInfoInvoicingTempDeleteBusiReqBO();
            deleteBusiReqBo.setVersionId(versionId);
            this.fscSaleOrderInfoInvoicingTempBusiService.dealSaleOrderInfoInvoicingDelete(deleteBusiReqBo);
            FileUtil.del((File)directoryFile);
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        this.updateBillApplyManualInvoice(reqBo, versionId);
        if (YesNo.YES.getCode().equals(busiReqBo.getTempFlag())) {
            JSONObject mqData = new JSONObject();
            mqData.put("REDIS_KEY", (Object)cacheApplyNoKey);
            mqData.put("BUSI_REQ_BO", (Object)busiReqBo);
            mqData.put("ACTION_CATEGORY", (Object)"import");
            ProxySendResult sendResult = this.fscBillApplyInvoicingProvider.send(new ProxyMessage(this.FSC_BILL_APPLY_INVOICING_TOPIC, this.FSC_BILL_APPLY_INVOICING_TAG, mqData.toJSONString()));
            if (!"SEND_OK".equals(sendResult.getStatus())) {
                log.error("\u624b\u52a8\u5f00\u7968\u786e\u8ba4\u5f00\u7968\u5bfc\u5165\u53d1\u7968\u4fe1\u606f\u5931\u8d25\uff0cMQ\u53d1\u9001\u5931\u8d25.");
                FscSaleOrderInfoInvoicingTempDeleteBusiReqBO deleteBusiReqBo = new FscSaleOrderInfoInvoicingTempDeleteBusiReqBO();
                deleteBusiReqBo.setVersionId(versionId);
                this.fscSaleOrderInfoInvoicingTempBusiService.dealSaleOrderInfoInvoicingDelete(deleteBusiReqBo);
                this.cacheClient.delete(cacheApplyNoKey);
                this.updateBillApplyManualInvoiceStatus(reqBo.getApplyNo(), "18000", "\u624b\u52a8\u5f00\u7968\u786e\u8ba4\u5f00\u7968\u5bfc\u5165\u53d1\u7968\u4fe1\u606f\u5931\u8d25\uff0cMQ\u53d1\u9001\u5931\u8d25.");
                throw new PfscExtBusinessException("18000", reqBo.getApplyNo() + "\u786e\u8ba4\u5f00\u7968\u5f02\u6b65\u6d88\u8d39\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458");
            }
        } else {
            BusiSaleInvoiceInfoRspBO busiRspBo = this.fscSaleInvoiceInfoCombService.dealManualInvoice(busiReqBo);
            this.cacheClient.delete(cacheApplyNoKey);
            this.updateBillApplyManualInvoiceStatus(reqBo.getApplyNo(), busiRspBo.getRespCode(), busiRspBo.getRespDesc());
            if (FscRu.isFailed(busiRspBo.getRespCode()).booleanValue()) {
                throw new PfscExtBusinessException(busiRspBo.getRespCode(), busiRspBo.getRespDesc());
            }
        }
        FscSaleInvoiceInfoAbilityRspBO success = FscRu.success(FscSaleInvoiceInfoAbilityRspBO.class);
        success.setTempFlag(busiReqBo.getTempFlag());
        return success;
    }

    private void updateBillApplyManualInvoice(FscSaleInvoiceInfoNewAbilityReqBO reqBo, Long versionId) {
        FscBillApplyManualInvoiceUpdateBusiReqBO busiReqBo = new FscBillApplyManualInvoiceUpdateBusiReqBO();
        busiReqBo.setApplyNo(reqBo.getApplyNo());
        busiReqBo.setManualInvoiceFileName(versionId + "_" + reqBo.getInvoiceXlsName());
        busiReqBo.setManualInvoiceFileUrl(reqBo.getInvoiceXlsUrl());
        busiReqBo.setManualInvoiceStatus("1");
        busiReqBo.setManualInvoiceFailMessage("");
        FscBillApplyManualInvoiceUpdateBusiRspBO busiRspBo = this.fscBillApplyInfoBusiService.updateBillApplyManualInvoice(busiReqBo);
        if (FscRu.isFailed(busiRspBo.getRespCode()).booleanValue()) {
            throw new PfscExtBusinessException(busiRspBo.getRespCode(), busiRspBo.getRespDesc());
        }
    }

    private void updateBillApplyManualInvoiceStatus(String applyNo, String manualInvoiceStatus, String manualInvoiceFailMessage) {
        if (!StringUtils.hasText((String)applyNo)) {
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u5f00\u7968\u7533\u8bf7\u786e\u8ba4\u5f00\u7968\u72b6\u6001\u5931\u8d25\uff0c\u7533\u8bf7\u5355\u53f7\u4e3a\u7a7a");
        }
        FscBillApplyManualInvoiceUpdateBusiReqBO busiReqBo = new FscBillApplyManualInvoiceUpdateBusiReqBO();
        busiReqBo.setApplyNo(applyNo);
        busiReqBo.setManualInvoiceStatus(manualInvoiceStatus);
        busiReqBo.setManualInvoiceFailMessage(manualInvoiceFailMessage);
        FscBillApplyManualInvoiceUpdateBusiRspBO busiRspBo = this.fscBillApplyInfoBusiService.updateBillApplyManualInvoice(busiReqBo);
        if (FscRu.isFailed(busiRspBo.getRespCode()).booleanValue()) {
            throw new PfscExtBusinessException(busiRspBo.getRespCode(), busiRspBo.getRespDesc());
        }
    }

    private void dealReadShardingExcel(BusiSaleInvoiceInfoReqBO busiReqBo, String rootPathStr, Long versionId) {
        String applyNo = busiReqBo.getApplyNo();
        String invoiceXlsUrl = busiReqBo.getInvoiceXlsUrl();
        String cacheFileName = applyNo + "\u624b\u52a8\u5f00\u7968\u786e\u8ba4\u5f00\u7968";
        if (invoiceXlsUrl.endsWith(".xls")) {
            cacheFileName = cacheFileName + ".xls";
        } else if (invoiceXlsUrl.endsWith(".xlsx")) {
            cacheFileName = cacheFileName + ".xlsx";
        } else {
            throw new PfscExtBusinessException("18000", "\u624b\u52a8\u5f00\u7968\u786e\u8ba4\u5f00\u7968\u63d0\u4ea4\u53d1\u7968\u6587\u4ef6\u4e0d\u662fExcel");
        }
        Date timeDownloadStart = new Date();
        File file = this.downloadToFile(invoiceXlsUrl, rootPathStr, cacheFileName);
        Date timeDownloadEnd = new Date();
        log.error("\u786e\u8ba4\u5f00\u7968{}\u6587\u4ef6\u4e0b\u8f7d\u5b8c\u6210:{}.\u7528\u65f6\uff1a{} ms", new Object[]{applyNo, file, timeDownloadEnd.getTime() - timeDownloadStart.getTime()});
        String[] sheetNames = new String[]{"\u586b\u5199\u8bf4\u660e", "\u5f00\u7968\u901a\u77e5\u5355\u4fe1\u606f", "\u5f00\u7968\u660e\u7ec6", "\u90ae\u5bc4\u4fe1\u606f"};
        AtomicInteger indexRow = new AtomicInteger(2);
        try (ExcelReader excelReader = EasyExcel.read((File)file).build();){
            ArrayList<String> errorMsgList = new ArrayList<String>();
            List readSheets = excelReader.excelExecutor().sheetList();
            Map<Integer, String> mapSheetName = readSheets.stream().collect(Collectors.toMap(ReadSheet::getSheetNo, ReadSheet::getSheetName));
            for (int i = 0; i < sheetNames.length; ++i) {
                String sheetNameNew = mapSheetName.get(i);
                if (StringUtils.hasText((String)sheetNameNew) && sheetNames[i].equals(sheetNameNew)) continue;
                errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c[{}]\u4e2a\u6570\u636e\u9875\u7684\u540d\u79f0[{}]\u4e0e\u9884\u671f\u4e0d\u7b26\u5408,\u8bf7\u4e0d\u8981\u4fee\u6539\u6a21\u677f\u6587\u4ef6\u7684\u9875\u540d\u79f0", (Object[])new Object[]{i + 1, sheetNameNew}));
            }
            if (errorMsgList.size() > 0) {
                throw new PfscExtBusinessException("18000", String.join((CharSequence)";", errorMsgList));
            }
            ArrayList sheetApplyInfoBos = new ArrayList();
            ReadSheet readSheetApplyInfo = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)1).head(FscBillApplyInvoicingExcelReadBillInfoBO.class)).registerReadListener((ReadListener)new PageReadListener(sheetApplyInfoBos::addAll))).build();
            excelReader.read(new ReadSheet[]{readSheetApplyInfo});
            if (CollectionUtils.isEmpty(sheetApplyInfoBos) || sheetApplyInfoBos.size() > 1) {
                errorMsgList.add("\u5f00\u7968\u7533\u8bf7\u5355\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u52ff\u4fee\u6539\u6a21\u7248\u5f00\u7968\u7533\u8bf7\u5355\u4fe1\u606f");
            } else {
                FscBillApplyInvoicingExcelReadBillInfoBO sheetApplyInfoBo = (FscBillApplyInvoicingExcelReadBillInfoBO)sheetApplyInfoBos.get(0);
                if (!applyNo.equals(sheetApplyInfoBo.getApplyNo())) {
                    errorMsgList.add(StrUtil.format((CharSequence)"\u5bfc\u5165\u7684\u7533\u8bf7\u5355\u53f7\u4e0d\u7b26\u5408,\u8bf7\u5bfc\u5165[{}]\u7684\u53d1\u7968\u6570\u636e", (Object[])new Object[]{applyNo}));
                }
                busiReqBo.setApplyNo(sheetApplyInfoBo.getApplyNo());
                busiReqBo.setInvoiceTypeStr(sheetApplyInfoBo.getInvoiceTypeStr());
                busiReqBo.setInvoiceName(sheetApplyInfoBo.getInvoiceName());
                busiReqBo.setTaxNo(sheetApplyInfoBo.getTaxNo());
                busiReqBo.setAddr(sheetApplyInfoBo.getAddr());
                busiReqBo.setPhone(sheetApplyInfoBo.getPhone());
                busiReqBo.setBankName(sheetApplyInfoBo.getBankName());
                busiReqBo.setBankAcctNo(sheetApplyInfoBo.getBankAcctNo());
                busiReqBo.setAmt(sheetApplyInfoBo.getAmt());
            }
            if (errorMsgList.size() > 0) {
                throw new PfscExtBusinessException("18000", String.join((CharSequence)";", errorMsgList));
            }
            log.error("\u786e\u8ba4\u5f00\u7968{}\u7533\u8bf7\u5355\u4fe1\u606f\u8bfb\u53d6\u5b8c\u6210,\u5f00\u59cb\u8bfb\u53d6\u53d1\u7968\u660e\u7ec6.\u7528\u65f6\uff1a{} ms", (Object)applyNo, (Object)(new Date().getTime() - timeDownloadEnd.getTime()));
            ReadSheet readSheetBillItem = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)2).head(FscBillApplyInvoicingExcelReadBillItemBO.class)).registerReadListener((ReadListener)new PageReadListener(dataList -> {
                if (!CollectionUtils.isEmpty((Collection)dataList)) {
                    ArrayList<FscSaleOrderInfoInvoicingTempBatchSaveBO> batchSaveList = new ArrayList<FscSaleOrderInfoInvoicingTempBatchSaveBO>();
                    ArrayList<String> invoiceNoList = new ArrayList<String>();
                    for (FscBillApplyInvoicingExcelReadBillItemBO item : dataList) {
                        int index = indexRow.getAndIncrement();
                        if (!StringUtils.hasText((String)item.getApplyNo())) {
                            errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index}));
                        }
                        if (!StringUtils.hasText((String)item.getInvoiceCode())) {
                            errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index}));
                        }
                        if (!StringUtils.hasText((String)item.getInvoiceNo())) {
                            errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index}));
                        } else if (!invoiceNoList.contains(item.getInvoiceNo().trim())) {
                            invoiceNoList.add(item.getInvoiceNo().trim());
                        }
                        if (!StringUtils.hasText((String)item.getInvoiceDate())) {
                            errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index}));
                        } else {
                            try {
                                if (com.tydic.pfscext.utils.DateUtil.strToDate(item.getInvoiceDate(), "yyyy-MM-dd") == null) {
                                    errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u5f00\u7968\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1a1900-01-01", (Object[])new Object[]{index}));
                                }
                            }
                            catch (Exception e) {
                                errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u5f00\u7968\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1a1900-01-01", (Object[])new Object[]{index}));
                            }
                        }
                        if (!StringUtils.hasText((String)item.getTaxCatCode())) {
                            errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index}));
                        }
                        if (!StringUtils.hasText((String)item.getIdentify())) {
                            errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u5546\u54c1\u884c\u53f7-\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index}));
                        }
                        FscSaleOrderInfoInvoicingTempBatchSaveBO exportBo = new FscSaleOrderInfoInvoicingTempBatchSaveBO();
                        exportBo.setInvoicingId(Sequence.getInstance().nextId());
                        exportBo.setVersionId(versionId);
                        exportBo.setInvoiceNo(item.getInvoiceNo().trim());
                        exportBo.setInvoiceCode(item.getInvoiceCode());
                        exportBo.setInvoiceDate(com.tydic.pfscext.utils.DateUtil.strToDate(item.getInvoiceDate(), "yyyy-MM-dd"));
                        exportBo.setApplyNo(item.getApplyNo());
                        exportBo.setUnTaxAmt(item.getUnTaxAmt());
                        exportBo.setTaxAmt(item.getTaxAmt());
                        exportBo.setAmount(item.getAmount());
                        exportBo.setIdentify(item.getIdentify());
                        exportBo.setTaxRate(item.getTaxRate());
                        exportBo.setTaxCatCode(item.getTaxCatCode());
                        exportBo.setSkuName(item.getSkuName());
                        exportBo.setSkuId(item.getSkuId());
                        exportBo.setPurchaseOrderId(item.getPurchaseOrderId());
                        exportBo.setSerialNumber(String.valueOf(index));
                        exportBo.setSpecModelFigureNo(item.getSpecModelFigureNo());
                        exportBo.setQuantity(item.getQuantity());
                        exportBo.setUnitName(item.getUnitName());
                        exportBo.setCheckState("0");
                        exportBo.setDeleteFlag("0");
                        exportBo.setCreateTime(new Date());
                        exportBo.setCreateUserId(busiReqBo.getUserId());
                        exportBo.setCreateUserName(busiReqBo.getName());
                        batchSaveList.add(exportBo);
                    }
                    if (errorMsgList.size() > 0) {
                        throw new PfscExtBusinessException("18000", String.join((CharSequence)";", errorMsgList));
                    }
                    if (!invoiceNoList.isEmpty()) {
                        for (String invoiceNo : invoiceNoList) {
                            SaleInvoiceInfo saleInvoiceInfo = this.saleInvoiceInfoMapper.selectByPrimaryKey(invoiceNo);
                            if (null == saleInvoiceInfo || applyNo.equals(saleInvoiceInfo.getApplyNo())) continue;
                            errorMsgList.add(StrUtil.format((CharSequence)"\u53d1\u7968\u53f7[{}]\u5df2\u5b58\u5728\uff0c\u8be5\u53d1\u7968\u5bf9\u5e94\u5f00\u7968\u7533\u8bf7\u5355\u53f7[{}]\u53d1\u7968\u53f7\u7801[{}]\u53d1\u7968\u4ee3\u7801[{}]\u5f00\u7968\u65e5\u671f[{}]", (Object[])new Object[]{invoiceNo, saleInvoiceInfo.getApplyNo(), saleInvoiceInfo.getInvoiceNo(), saleInvoiceInfo.getInvoiceCode(), DateUtils.dateToStr((Date)saleInvoiceInfo.getInvoiceDate())}));
                        }
                    }
                    if (errorMsgList.size() > 0) {
                        throw new PfscExtBusinessException("18000", String.join((CharSequence)";", errorMsgList));
                    }
                    if (!CollectionUtils.isEmpty(batchSaveList)) {
                        for (List subList : ListUtil.batchList(batchSaveList, (int)5000)) {
                            FscSaleOrderInfoInvoicingTempBatchSaveBusiReqBO batchSaveBusiReqBo = FscRu.js(busiReqBo, FscSaleOrderInfoInvoicingTempBatchSaveBusiReqBO.class);
                            batchSaveBusiReqBo.setBatchSaveList(subList);
                            FscSaleOrderInfoInvoicingTempBatchSaveBusiRspBO batchSaveBusiRspBo = this.fscSaleOrderInfoInvoicingTempBusiService.dealSaleOrderInfoInvoicingTempBatchSave(batchSaveBusiReqBo);
                            if (!FscRu.isFailed(batchSaveBusiRspBo.getRespCode()).booleanValue()) continue;
                            throw new PfscExtBusinessException(batchSaveBusiRspBo.getRespCode(), "\u5bfc\u5165\u53d1\u7968\u6570\u636e\u6570\u636e\u5199\u5165\u4e34\u65f6\u8868\u5f02\u5e38:" + batchSaveBusiRspBo.getRespDesc());
                        }
                    }
                }
            }))).build();
            excelReader.read(new ReadSheet[]{readSheetBillItem});
            Date timeReadEnd = new Date();
            log.error("\u786e\u8ba4\u5f00\u7968{}Excel\u8bfb\u53d6\u5b8c\u6210:{}.\u8bfb\u53d6\u7528\u65f6\uff1a{} ms.\u4e0b\u8f7d\u548c\u8bfb\u53d6\u5171\u7528\u65f6:{} ms", new Object[]{applyNo, file, timeReadEnd.getTime() - timeDownloadEnd.getTime(), timeReadEnd.getTime() - timeDownloadStart.getTime()});
            if (errorMsgList.size() > 0) {
                throw new PfscExtBusinessException("18000", String.join((CharSequence)";", errorMsgList));
            }
            SaleOrderInfoInvoicingTempPO saleOrderInfoInvoicingTempQry = new SaleOrderInfoInvoicingTempPO();
            saleOrderInfoInvoicingTempQry.setVersionId(versionId);
            saleOrderInfoInvoicingTempQry.setApplyNo(applyNo);
            int dataSize = this.saleOrderInfoInvoicingTempMapper.getCheckBy(saleOrderInfoInvoicingTempQry);
            busiReqBo.setDataSize(Integer.valueOf(dataSize));
            if (dataSize < 1) {
                throw new PfscExtBusinessException("18000", "\u5bfc\u5165\u6570\u636e\u8bfb\u53d6\u4e3a\u7a7a");
            }
            if (dataSize < 1000) {
                busiReqBo.setTempFlag(YesNo.NO.getCode());
                List<SaleOrderInfoInvoicingTempPO> batchSaveList = this.saleOrderInfoInvoicingTempMapper.getList(saleOrderInfoInvoicingTempQry);
                busiReqBo.setSaleInvoiceList(batchSaveList.stream().map(item -> {
                    SaleInvoiceInfoExportBO exportBo = new SaleInvoiceInfoExportBO();
                    exportBo.setInvoiceNo(item.getInvoiceNo());
                    exportBo.setInvoiceCode(item.getInvoiceCode());
                    exportBo.setInvoiceDate(item.getInvoiceDate());
                    exportBo.setApplyNo(item.getApplyNo());
                    exportBo.setUnTaxAmt(item.getUnTaxAmt());
                    exportBo.setTaxAmt(item.getTaxAmt());
                    exportBo.setAmount(item.getAmount());
                    exportBo.setIdentify(item.getIdentify());
                    exportBo.setTaxRate(item.getTaxRate());
                    exportBo.setTaxCatCode(item.getTaxCatCode());
                    exportBo.setSkuName(item.getSkuName());
                    exportBo.setSkuId(item.getSkuId());
                    exportBo.setPurchaseOrderId(item.getPurchaseOrderId());
                    exportBo.setSerialNumber(item.getSerialNumber());
                    return exportBo;
                }).collect(Collectors.toList()));
            } else {
                busiReqBo.setTempFlag(YesNo.YES.getCode());
            }
            log.error("\u786e\u8ba4\u5f00\u7968{}Excel\u8bfb\u53d6\u5b8c\u6210:{}.\u8bfb\u53d6\u7528\u65f6\uff1a{} ms.\u4e0b\u8f7d\u548c\u8bfb\u53d6\u5171\u7528\u65f6:{} ms.\u6570\u636e\u7f13\u5b58\u4e34\u65f6\u8868\u7528\u65f6:{} ms", new Object[]{applyNo, file, timeReadEnd.getTime() - timeDownloadEnd.getTime(), timeReadEnd.getTime() - timeDownloadStart.getTime(), new Date().getTime() - timeReadEnd.getTime()});
        }
        catch (PfscExtBusinessException e) {
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", "Excel\u6570\u636e\u8bfb\u53d6\u5f02\u5e38:" + e.getMessage());
        }
    }

    @Deprecated
    private void dealReadAllExcel(BusiSaleInvoiceInfoReqBO busiReqBo, String rootPathStr) {
        String applyNo = busiReqBo.getApplyNo();
        String invoiceXlsUrl = busiReqBo.getInvoiceXlsUrl();
        String cacheFileName = applyNo + "\u624b\u52a8\u5f00\u7968\u786e\u8ba4\u5f00\u7968";
        if (invoiceXlsUrl.endsWith(".xls")) {
            cacheFileName = cacheFileName + ".xls";
        } else if (invoiceXlsUrl.endsWith(".xlsx")) {
            cacheFileName = cacheFileName + ".xlsx";
        } else {
            throw new PfscExtBusinessException("18000", "\u624b\u52a8\u5f00\u7968\u786e\u8ba4\u5f00\u7968\u63d0\u4ea4\u53d1\u7968\u6587\u4ef6\u4e0d\u662fExcel");
        }
        Date timeDownloadStart = new Date();
        File file = this.downloadToFile(invoiceXlsUrl, rootPathStr, cacheFileName);
        Date timeDownloadEnd = new Date();
        log.error("\u786e\u8ba4\u5f00\u7968{}\u6587\u4ef6\u4e0b\u8f7d\u5b8c\u6210:{}.\u7528\u65f6\uff1a{} ms", new Object[]{applyNo, file, timeDownloadEnd.getTime() - timeDownloadStart.getTime()});
        String[] sheetNames = new String[]{"\u586b\u5199\u8bf4\u660e", "\u5f00\u7968\u901a\u77e5\u5355\u4fe1\u606f", "\u5f00\u7968\u660e\u7ec6", "\u90ae\u5bc4\u4fe1\u606f"};
        ArrayList saleInvoiceList = new ArrayList();
        AtomicInteger indexRow = new AtomicInteger(2);
        try (ExcelReader excelReader = EasyExcel.read((File)file).build();){
            ArrayList<String> errorMsgList = new ArrayList<String>();
            List readSheets = excelReader.excelExecutor().sheetList();
            Map<Integer, String> mapSheetName = readSheets.stream().collect(Collectors.toMap(ReadSheet::getSheetNo, ReadSheet::getSheetName));
            for (int i = 0; i < sheetNames.length; ++i) {
                String sheetNameNew = mapSheetName.get(i);
                if (StringUtils.hasText((String)sheetNameNew) && sheetNames[i].equals(sheetNameNew)) continue;
                errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c[{}]\u4e2a\u6570\u636e\u9875\u7684\u540d\u79f0[{}]\u4e0e\u9884\u671f\u4e0d\u7b26\u5408,\u8bf7\u4e0d\u8981\u4fee\u6539\u6a21\u677f\u6587\u4ef6\u7684\u9875\u540d\u79f0", (Object[])new Object[]{i + 1, sheetNameNew}));
            }
            if (errorMsgList.size() > 0) {
                throw new PfscExtBusinessException("18000", String.join((CharSequence)";", errorMsgList));
            }
            ArrayList sheetApplyInfoBos = new ArrayList();
            ReadSheet readSheetApplyInfo = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)1).head(FscBillApplyInvoicingExcelReadBillInfoBO.class)).registerReadListener((ReadListener)new PageReadListener(sheetApplyInfoBos::addAll))).build();
            excelReader.read(new ReadSheet[]{readSheetApplyInfo});
            if (CollectionUtils.isEmpty(sheetApplyInfoBos) || sheetApplyInfoBos.size() > 1) {
                errorMsgList.add("\u5f00\u7968\u7533\u8bf7\u5355\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u52ff\u4fee\u6539\u6a21\u7248\u5f00\u7968\u7533\u8bf7\u5355\u4fe1\u606f");
            } else {
                FscBillApplyInvoicingExcelReadBillInfoBO sheetApplyInfoBo = (FscBillApplyInvoicingExcelReadBillInfoBO)sheetApplyInfoBos.get(0);
                if (!applyNo.equals(sheetApplyInfoBo.getApplyNo())) {
                    errorMsgList.add(StrUtil.format((CharSequence)"\u5bfc\u5165\u7684\u7533\u8bf7\u5355\u53f7\u4e0d\u7b26\u5408,\u8bf7\u5bfc\u5165[{}]\u7684\u53d1\u7968\u6570\u636e", (Object[])new Object[]{applyNo}));
                }
                busiReqBo.setApplyNo(sheetApplyInfoBo.getApplyNo());
                busiReqBo.setInvoiceTypeStr(sheetApplyInfoBo.getInvoiceTypeStr());
                busiReqBo.setInvoiceName(sheetApplyInfoBo.getInvoiceName());
                busiReqBo.setTaxNo(sheetApplyInfoBo.getTaxNo());
                busiReqBo.setAddr(sheetApplyInfoBo.getAddr());
                busiReqBo.setPhone(sheetApplyInfoBo.getPhone());
                busiReqBo.setBankName(sheetApplyInfoBo.getBankName());
                busiReqBo.setBankAcctNo(sheetApplyInfoBo.getBankAcctNo());
                busiReqBo.setAmt(sheetApplyInfoBo.getAmt());
            }
            ReadSheet readSheetBillItem = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)2).head(FscBillApplyInvoicingExcelReadBillItemBO.class)).registerReadListener((ReadListener)new PageReadListener(dataList -> {
                if (!CollectionUtils.isEmpty((Collection)dataList)) {
                    for (FscBillApplyInvoicingExcelReadBillItemBO item : dataList) {
                        int index = indexRow.getAndIncrement();
                        if (!StringUtils.hasText((String)item.getApplyNo())) {
                            errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index}));
                        }
                        if (!StringUtils.hasText((String)item.getInvoiceCode())) {
                            errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index}));
                        }
                        if (!StringUtils.hasText((String)item.getInvoiceNo())) {
                            errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index}));
                        }
                        if (!StringUtils.hasText((String)item.getInvoiceDate())) {
                            errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index}));
                        } else {
                            try {
                                if (com.tydic.pfscext.utils.DateUtil.strToDate(item.getInvoiceDate(), "yyyy-MM-dd") == null) {
                                    errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u5f00\u7968\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1a1900-01-01", (Object[])new Object[]{index}));
                                }
                            }
                            catch (Exception e) {
                                errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u5f00\u7968\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1a1900-01-01", (Object[])new Object[]{index}));
                            }
                        }
                        if (!StringUtils.hasText((String)item.getTaxCatCode())) {
                            errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index}));
                        }
                        if (!StringUtils.hasText((String)item.getIdentify())) {
                            errorMsgList.add(StrUtil.format((CharSequence)"\u7b2c{}\u884c\u5546\u54c1\u884c\u53f7-\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index}));
                        }
                        SaleInvoiceInfoExportBO exportBo = new SaleInvoiceInfoExportBO();
                        exportBo.setInvoiceNo(item.getInvoiceNo());
                        exportBo.setInvoiceCode(item.getInvoiceCode());
                        exportBo.setInvoiceDate(com.tydic.pfscext.utils.DateUtil.strToDate(item.getInvoiceDate(), "yyyy-MM-dd"));
                        exportBo.setApplyNo(item.getApplyNo());
                        exportBo.setUnTaxAmt(item.getUnTaxAmt());
                        exportBo.setTaxAmt(item.getTaxAmt());
                        exportBo.setAmount(item.getAmount());
                        exportBo.setIdentify(item.getIdentify());
                        exportBo.setTaxRate(item.getTaxRate());
                        exportBo.setTaxCatCode(item.getTaxCatCode());
                        exportBo.setSkuName(item.getSkuName());
                        exportBo.setSkuId(item.getSkuId());
                        exportBo.setPurchaseOrderId(item.getPurchaseOrderId());
                        exportBo.setSerialNumber(String.valueOf(index));
                        saleInvoiceList.add(exportBo);
                    }
                    if (errorMsgList.size() > 0) {
                        throw new PfscExtBusinessException("18000", String.join((CharSequence)";", errorMsgList));
                    }
                }
            }))).build();
            excelReader.read(new ReadSheet[]{readSheetBillItem});
            busiReqBo.setSaleInvoiceList(saleInvoiceList);
            Date timeReadEnd = new Date();
            log.error("\u786e\u8ba4\u5f00\u7968{}Excel\u8bfb\u53d6\u5b8c\u6210:{}.\u8bfb\u53d6\u7528\u65f6\uff1a{} ms.\u4e0b\u8f7d\u548c\u8bfb\u53d6\u5171\u7528\u65f6:{} ms", new Object[]{applyNo, file, timeReadEnd.getTime() - timeDownloadEnd.getTime(), timeReadEnd.getTime() - timeDownloadStart.getTime()});
            if (errorMsgList.size() > 0) {
                throw new PfscExtBusinessException("18000", String.join((CharSequence)";", errorMsgList));
            }
        }
    }

    private File downloadToFile(String templateUrl, String rootPathStr, String templateFileName) {
        File downloadFile = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        if (FileType.FASTDFS.name().equals(this.fileType)) {
            for (int i = 0; i < 3; ++i) {
                templateUrl = templateUrl.substring(templateUrl.indexOf("/") + 1);
            }
            templateUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + templateUrl;
        }
        log.info("\u4e0b\u8f7d\u5730\u5740\uff1a" + templateUrl);
        HttpGet httpGet = new HttpGet(templateUrl);
        CloseableHttpResponse response = null;
        InputStream content = null;
        FileOutputStream fileOutputStream = null;
        try {
            Object responseEntity;
            response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                int len;
                responseEntity = response.getEntity();
                downloadFile = new File(rootPathStr + "/" + templateFileName);
                content = responseEntity.getContent();
                fileOutputStream = new FileOutputStream(downloadFile);
                byte[] buff = new byte[1024];
                while ((len = content.read(buff)) != -1) {
                    fileOutputStream.write(buff, 0, len);
                }
            } else {
                throw new PfscExtBusinessException("18000", "\u624b\u52a8\u5f00\u7968\u786e\u8ba4\u5f00\u7968\u4e0b\u8f7d\u53d1\u7968\u6587\u4ef6\u5931\u8d25\uff1a\u8c03\u7528\u94fe\u63a5\u8fd4\u56de\u5931\u8d25\uff01");
            }
            fileOutputStream.flush();
            responseEntity = downloadFile;
            return responseEntity;
        }
        catch (IOException e) {
            throw new PfscExtBusinessException("18000", "\u624b\u52a8\u5f00\u7968\u786e\u8ba4\u5f00\u7968\u4e0b\u8f7d\u53d1\u7968\u6587\u4ef6\u5931\u8d25\uff1a\u8c03\u7528\u94fe\u63a5\u5931\u8d25\uff01");
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (content != null) {
                try {
                    content.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

