/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.pfscext.api.ability.FscSaleInvoiceInfoExportAbilityService;
import com.tydic.pfscext.api.ability.bo.FscSaleInvoiceInfoExportAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscSaleInvoiceInfoExportAbilityRspBO;
import com.tydic.pfscext.api.aisino.bo.BusiUpdateBillApplyFileUrlReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiUpdateBillApplyFileUrlRspBO;
import com.tydic.pfscext.api.busi.QueryBillApplyInfoExportService;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.PushStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.comb.api.FscSaleInvoiceInfoExportCombService;
import com.tydic.pfscext.service.comb.bo.FscBillApplyInvoicingExportDataBO;
import com.tydic.pfscext.service.comb.bo.FscSaleInvoiceInfoExportCombReqBO;
import com.tydic.pfscext.service.comb.bo.FscSaleInvoiceInfoExportCombRspBO;
import com.tydic.pfscext.service.comb.bo.FscSaleInvoiceInfoExportExcelCombReqBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscSaleInvoiceInfoExportAbilityService"})
public class FscSaleInvoiceInfoExportAbilityServiceImpl
implements FscSaleInvoiceInfoExportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscSaleInvoiceInfoExportAbilityServiceImpl.class);
    @Resource(name="fscBillApplyInvoicingProvider")
    private ProxyMessageProducer fscBillApplyInvoicingProvider;
    @Value(value="${FSC_BILL_APPLY_INVOICING_TOPIC:FSC_BILL_APPLY_INVOICING_TOPIC}")
    private String FSC_BILL_APPLY_INVOICING_TOPIC;
    @Value(value="${FSC_BILL_APPLY_INVOICING_TAG:*}")
    private String FSC_BILL_APPLY_INVOICING_TAG;
    @Autowired
    private QueryBillApplyInfoExportService queryBillApplyInfoExportService;
    @Autowired
    private FscSaleInvoiceInfoExportCombService fscSaleInvoiceInfoExportCombService;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"dealManualInvoiceExport"})
    public FscSaleInvoiceInfoExportAbilityRspBO dealManualInvoiceExport(@RequestBody FscSaleInvoiceInfoExportAbilityReqBO reqBo) {
        ValUtil.isEmpty(reqBo).exception("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isBlank(reqBo.getApplyNo()).exception("\u5165\u53c2[\u7533\u8bf7\u5355\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isBlank(reqBo.getPurchaseNo()).exception("\u5165\u53c2[\u91c7\u8d2d\u5355\u4f4d]\u4e0d\u80fd\u4e3a\u7a7a");
        String redisKey = "APPLY_MANUAL_INVOICE_EXPORT_" + reqBo.getApplyNo() + "_" + reqBo.getPurchaseNo();
        if (this.cacheClient.get(redisKey) != null) {
            String errorMsg = "\u7533\u8bf7\u5355[" + reqBo.getApplyNo() + "]\u6b63\u5728\u5bfc\u51fa\u53d1\u7968\uff0c\u8bf7\u7a0d\u540e\u5bfc\u51fa\u5931\u8d25\u540e\u518d\u91cd\u8bd5";
            Long expireTimeByKey = this.cacheClient.getExpireTimeByKey(redisKey);
            if (expireTimeByKey != null) {
                String between = DateUtil.formatBetween((long)(expireTimeByKey * 1000L));
                errorMsg = "\u7533\u8bf7\u5355[" + reqBo.getApplyNo() + "]\u6b63\u5728\u5bfc\u51fa\u53d1\u7968\uff0c\u8bf7" + between + "\u540e\u518d\u91cd\u8bd5";
            }
            throw new PfscExtBusinessException("18000", errorMsg);
        }
        this.updateBillFileUrl(reqBo.getApplyNo(), "1");
        try {
            FscBillApplyInvoicingExportDataBO dataBo = this.queryBillApplyInfo(reqBo);
            FscSaleInvoiceInfoExportExcelCombReqBO combReqBo = FscRu.js(reqBo, FscSaleInvoiceInfoExportExcelCombReqBO.class);
            combReqBo.setApplyNo(reqBo.getApplyNo());
            combReqBo.setPurchaseNo(reqBo.getPurchaseNo());
            combReqBo.setDataBo(dataBo);
            this.cacheClient.set(redisKey, (Object)combReqBo, 600);
            JSONObject mqData = new JSONObject();
            mqData.put("REDIS_KEY", (Object)redisKey);
            mqData.put("ACTION_CATEGORY", (Object)"export");
            ProxySendResult sendResult = this.fscBillApplyInvoicingProvider.send(new ProxyMessage(this.FSC_BILL_APPLY_INVOICING_TOPIC, this.FSC_BILL_APPLY_INVOICING_TAG, mqData.toJSONString()));
            if (!"SEND_OK".equals(sendResult.getStatus())) {
                log.error("\u624b\u52a8\u5f00\u7968\u5f02\u6b65\u5bfc\u51fa\u53d1\u7968\u4fe1\u606f\u5931\u8d25\uff0cMQ\u53d1\u9001\u5931\u8d25.");
            }
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u53d1\u7968\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)e));
            this.updateBillFileUrl(reqBo.getApplyNo(), "3");
            this.cacheClient.delete(redisKey);
            throw new PfscExtBusinessException("18000", "\u5bfc\u51fa\u53d1\u7968\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return FscRu.success(FscSaleInvoiceInfoExportAbilityRspBO.class);
    }

    private FscBillApplyInvoicingExportDataBO queryBillApplyInfo(FscSaleInvoiceInfoExportAbilityReqBO reqBo) {
        FscSaleInvoiceInfoExportCombReqBO combReqBo = FscRu.js(reqBo, FscSaleInvoiceInfoExportCombReqBO.class);
        FscSaleInvoiceInfoExportCombRspBO combRspBO = this.fscSaleInvoiceInfoExportCombService.queryManualInvoiceExportData(combReqBo);
        if (FscRu.isFailed(combRspBO.getRespCode()).booleanValue()) {
            throw new PfscExtBusinessException(combRspBO.getRespCode(), combRspBO.getRespDesc());
        }
        FscBillApplyInvoicingExportDataBO dataBo = combRspBO.getDataBo();
        if (dataBo == null) {
            log.error("\u624b\u52a8\u5f00\u7968\u67e5\u8be2\u5f00\u7968\u6570\u636e\u67e5\u8be2\u4e3a\u7a7a\uff1a{},{}", (Object)reqBo.getApplyNo(), (Object)reqBo.getPurchaseNo());
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u6570\u636e\u67e5\u8be2\u4e3a\u7a7a");
        }
        String billStatus = dataBo.getBillStatus();
        String pushStatus = dataBo.getPushStatus();
        if (BillStatus.NO_APPLY.getCode().equals(billStatus)) {
            if (!PushStatus.NOT_PUSH.getCode().equals(pushStatus) && !PushStatus.PUSH_FAIL.getCode().equals(pushStatus)) {
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u7684\u63a8\u9001\u72b6\u6001\u4e0d\u5141\u8bb8\u5904\u7406,billStatus:" + billStatus + " push_status:" + pushStatus);
            }
        } else if (BillStatus.SEND_BILL.getCode().equals(billStatus)) {
            if (pushStatus != null) {
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u7684\u63a8\u9001\u72b6\u6001\u4e0d\u5141\u8bb8\u5904\u7406,billStatus:" + billStatus + " push_status:" + pushStatus);
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u72b6\u6001\u4e0d\u5141\u8bb8\u624b\u52a8\u5f00\u7968\uff0cbillStatus\uff1a" + billStatus);
        }
        return dataBo;
    }

    private void updateBillFileUrl(String applyNo, String templateStatus) {
        BusiUpdateBillApplyFileUrlReqBO updateFileReqBo = new BusiUpdateBillApplyFileUrlReqBO();
        updateFileReqBo.setApplyNo(applyNo);
        updateFileReqBo.setFileName("\u624b\u52a8\u5f00\u7968\u6a21\u677f\u5bfc\u51fa" + applyNo + ".xls");
        updateFileReqBo.setTemplateStatus(templateStatus);
        BusiUpdateBillApplyFileUrlRspBO rspBo = this.queryBillApplyInfoExportService.updateBillApplyInfoFileUrl(updateFileReqBo);
        if (FscRu.isFailed(rspBo.getRespCode()).booleanValue()) {
            throw new PfscExtBusinessException(rspBo.getRespCode(), rspBo.getRespDesc());
        }
    }
}

