/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.pfscext.api.ability.FscUmcPayConfigAddAbilityService;
import com.tydic.pfscext.api.ability.bo.FscUmcEnterpriseOrgBO;
import com.tydic.pfscext.api.ability.bo.FscUmcPayConfigAddAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscUmcPayConfigAddAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscUmcPayConfigOutPersonAddAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscUmcPayConfigOutPersonAddAbilityRspBO;
import com.tydic.pfscext.base.PfscExtReqBaseBO;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigSubClass;
import com.tydic.pfscext.enums.FscPayConfigSubType;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.service.busi.FscPayConfigSaveBusiService;
import com.tydic.pfscext.service.busi.FscUmcPayConfigAddBusiService;
import com.tydic.pfscext.service.busi.FscUmcQryAccountListBusiService;
import com.tydic.pfscext.service.busi.bo.FscPayConfigSaveBasicBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigSaveBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscUmcOrgListBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscUmcOrgListBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscUmcPayConfigAddAbilityService"})
public class FscUmcPayConfigAddAbilityServiceImpl
implements FscUmcPayConfigAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscUmcPayConfigAddAbilityServiceImpl.class);
    @Autowired
    private FscUmcPayConfigAddBusiService fscUmcPayConfigAddBusiService;
    @Autowired
    private FscUmcQryAccountListBusiService fscUmcQryAccountListBusiService;
    @Autowired
    private FscPayConfigSaveBusiService fscPayConfigSaveBusiService;
    @Autowired
    private FscPayConfigMapper fscPayConfigMapper;

    @PostMapping(value={"dealAddPayConfig"})
    public FscUmcPayConfigAddAbilityRspBO dealAddPayConfig(@RequestBody FscUmcPayConfigAddAbilityReqBO reqBo) {
        return this.fscUmcPayConfigAddBusiService.dealAddPayConfig(reqBo);
    }

    @PostMapping(value={"dealAddPayConfigOutPerson"})
    public FscUmcPayConfigOutPersonAddAbilityRspBO dealAddPayConfigOutPerson(@RequestBody FscUmcPayConfigOutPersonAddAbilityReqBO reqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getUserIdList())) {
            throw new BusinessException("18000", "\u5165\u53c2\u7528\u6237ID\u96c6\u5408\u4e3a\u7a7a");
        }
        FscPayConfigPO fscPayConfigMainQry = new FscPayConfigPO();
        fscPayConfigMainQry.setPaySubClass(FscPayConfigSubClass.OUT.getCode());
        fscPayConfigMainQry.setPaySubType(FscPayConfigSubType.GR.getCode());
        fscPayConfigMainQry.setPayBusiTypeList(Arrays.asList(FscPayConfigBusiType.EC.getCode(), FscPayConfigBusiType.AGR_PT.getCode(), FscPayConfigBusiType.RY.getCode(), FscPayConfigBusiType.AGR_NONE.getCode()));
        fscPayConfigMainQry.setPayConfigType(FscPayConfigType.MAIN.getCode());
        List<FscPayConfigPO> payConfigMainList = this.fscPayConfigMapper.getList(fscPayConfigMainQry);
        if (CollectionUtils.isEmpty(payConfigMainList)) {
            return FscRu.success("\u5916\u90e8\u4e2a\u4eba\u4e3b\u914d\u7f6e\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u65b0\u589e\u9ed8\u8ba4\u914d\u7f6e", FscUmcPayConfigOutPersonAddAbilityRspBO.class);
        }
        List<FscUmcEnterpriseOrgBO> fscUmcEnterpriseOrgBos = this.getUmcOrgList(reqBo.getUserIdList());
        PfscExtReqBaseBO baseBo = FscRu.js(reqBo, PfscExtReqBaseBO.class);
        if (!CollectionUtils.isEmpty(fscUmcEnterpriseOrgBos)) {
            for (FscPayConfigPO mainPayConfig : payConfigMainList) {
                for (FscUmcEnterpriseOrgBO fscUmcEnterpriseOrgBo : fscUmcEnterpriseOrgBos) {
                    FscPayConfigSaveBasicBusiReqBO busiReqBo = new FscPayConfigSaveBasicBusiReqBO();
                    BeanUtils.copyProperties((Object)baseBo, (Object)((Object)busiReqBo));
                    busiReqBo.setMainPayConfigId(mainPayConfig.getPayConfigId());
                    busiReqBo.setFscUmcOrgBo(fscUmcEnterpriseOrgBo);
                    busiReqBo.setOpeType("2");
                    FscPayConfigSaveBusiRspBO fscPayConfigSaveBusiRspBO = this.fscPayConfigSaveBusiService.dealPayConfigBasicSave(busiReqBo);
                }
            }
        }
        return FscRu.success("\u5916\u90e8\u4e2a\u4eba\u914d\u7f6e\u65b0\u589e\u5b8c\u6210" + reqBo.getUserIdList(), FscUmcPayConfigOutPersonAddAbilityRspBO.class);
    }

    private List<FscUmcEnterpriseOrgBO> getUmcOrgList(List<Long> userIdList) {
        FscUmcOrgListBusiReqBO fscUmcOrgListBusiReqBo = new FscUmcOrgListBusiReqBO();
        fscUmcOrgListBusiReqBo.setPaySubClass(FscPayConfigSubClass.OUT.getCode());
        fscUmcOrgListBusiReqBo.setPaySubType(FscPayConfigSubType.GR.getCode());
        fscUmcOrgListBusiReqBo.setUmcUserIdList(userIdList);
        FscUmcOrgListBusiRspBO umcAllOrgList = this.fscUmcQryAccountListBusiService.getUmcAllOrgList(fscUmcOrgListBusiReqBo);
        if (FscRu.isFailed(umcAllOrgList.getRespCode()).booleanValue()) {
            log.error("\u67e5\u8be2\u4f1a\u5458\u4e2d\u5fc3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)((Object)umcAllOrgList)));
        }
        ArrayList<FscUmcEnterpriseOrgBO> fscUmcOrgList = new ArrayList<FscUmcEnterpriseOrgBO>();
        if (CollectionUtils.isEmpty(umcAllOrgList.getUmcOrgList())) {
            log.error("\u67e5\u8be2\u4f1a\u5458\u4e2d\u5fc3\u7528\u6237\u4e3a\u7a7a.\u5165\u53c2\uff1a{}.\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)fscUmcOrgListBusiReqBo)), (Object)JSON.toJSONString((Object)((Object)umcAllOrgList)));
        } else {
            fscUmcOrgList.addAll(umcAllOrgList.getUmcOrgList());
        }
        return fscUmcOrgList;
    }
}

