/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.pfscext.api.ability.FscUserOverdueControlConfigExcelAbilityService;
import com.tydic.pfscext.api.ability.bo.FscCreditControlTipsUserTaskAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigExportAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigExportAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigImportAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigImportAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigImportInfoBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigModifyAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigModifyAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigTemplateAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigTemplateAbilityRspBO;
import com.tydic.pfscext.common.ExcelFile;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.umc.api.FscUmcQryAccountListExternalService;
import com.tydic.pfscext.external.umc.bo.FscUmcQryMemListExternalReqBO;
import com.tydic.pfscext.external.umc.bo.FscUmcQryMemListExternalRspBO;
import com.tydic.pfscext.service.busi.FscUserOverdueControlConfigExceptionSaveBusiService;
import com.tydic.pfscext.utils.DateUtil;
import com.tydic.pfscext.utils.ExcelUtils;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import com.tydic.pfscext.utils.ValUtil;
import com.tydic.umc.ability.bo.UmcMemDetailInfoAbilityBO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscUserOverdueControlConfigExcelAbilityService"})
public class FscUserOverdueControlConfigExcelAbilityServiceImpl
implements FscUserOverdueControlConfigExcelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscUserOverdueControlConfigExcelAbilityServiceImpl.class);
    @Autowired
    private FscUmcQryAccountListExternalService fscUmcQryAccountListExternalService;
    @Autowired
    private FscUserOverdueControlConfigExceptionSaveBusiService fscUserOverdueControlConfigExceptionSaveBusiService;
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${export.file.public.url}")
    private String exportFilePublicUrl;
    private final String SHEET_NAME = "\u7528\u6237\u903e\u671f\u7ba1\u63a7\u914d\u7f6e\u6279\u91cf\u5bfc\u5165\u7528\u6237";
    private final String EXCEL_END_SUFFIX = ".xlsx";
    @Value(value="${FSC_PAY_CONFIG_IMPORT_MAX_NUM:1000}")
    private Integer FSC_PAY_CONFIG_IMPORT_MAX_NUM;
    @Resource(name="fscCreditControlUserProvider")
    private ProxyMessageProducer fscCreditControlUserProvider;
    @Value(value="${FSC_CREDIT_CONTROL_USER_TOPIC:FSC_CREDIT_CONTROL_USER_TOPIC}")
    private String FSC_CREDIT_CONTROL_USER_TOPIC;
    @Value(value="${FSC_CREDIT_CONTROL_USER_TAG:*}")
    private String FSC_CREDIT_CONTROL_USER_TAG;

    @PostMapping(value={"dealUserOverdueConfigTemplate"})
    public FscUserOverdueControlConfigTemplateAbilityRspBO dealUserOverdueConfigTemplate(@RequestBody FscUserOverdueControlConfigTemplateAbilityReqBO reqBo) {
        FscUserOverdueControlConfigTemplateAbilityRspBO rspBo = FscRu.success(FscUserOverdueControlConfigTemplateAbilityRspBO.class);
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
        item.put("\u7528\u6237\u540d", null);
        item.put("\u59d3\u540d", null);
        item.put("\u6240\u5c5e\u7ec4\u7ec7\u673a\u6784", null);
        item.put("\u7528\u6237ID", null);
        item.put("\u903e\u671f\u8ba2\u5355\u9884\u8b66\u6570", null);
        item.put("\u903e\u671f\u8ba2\u5355\u7ba1\u63a7\u6570", null);
        item.put("\u903e\u671f\u8ba2\u5355\u6062\u590d\u6570", null);
        exportData.add(item);
        this.uploadFile(exportData, rspBo);
        String fullFilePath = "";
        if ("OSS".equals(this.fileType)) {
            fullFilePath = rspBo.getFilePath();
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)rspBo.getFilePath());
            fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        }
        rspBo.setFileUrl(fullFilePath);
        return rspBo;
    }

    @PostMapping(value={"dealUserOverdueConfigImport"})
    public FscUserOverdueControlConfigImportAbilityRspBO dealUserOverdueConfigImport(@RequestBody FscUserOverdueControlConfigImportAbilityReqBO reqBo) {
        ExcelFile excel;
        FscUserOverdueControlConfigImportAbilityRspBO rspBo = FscRu.success(FscUserOverdueControlConfigImportAbilityRspBO.class);
        rspBo.setConfigIdList(new ArrayList());
        ValUtil.isBlank(reqBo.getFileUrl()).exception("\u6587\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        if (!reqBo.getFileUrl().endsWith(".xlsx")) {
            throw new PfscExtBusinessException("0001", "\u6587\u4ef6\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20Excel");
        }
        try {
            URL url = new URL(reqBo.getFileUrl());
            URLConnection connection = url.openConnection();
            excel = new ExcelFile(connection.getInputStream(), true);
            if (!excel.isReady()) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6");
                return rspBo;
            }
            if (excel.getSheetCount() != 1) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u4e0a\u4f20\u7684Excel\u5e94\u53ea\u67091\u9875");
                return rspBo;
            }
            if (!"\u7528\u6237\u903e\u671f\u7ba1\u63a7\u914d\u7f6e\u6279\u91cf\u5bfc\u5165\u7528\u6237".equals(excel.getSheetName(0))) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u7b2c1\u4e2a\u6570\u636e\u9875\u7684\u540d\u79f0[" + excel.getSheetName(0) + "]\u4e0e\u9884\u671f\u4e0d\u7b26\u5408,\u8bf7\u4e0d\u8981\u4fee\u6539\u6a21\u677f\u6587\u4ef6\u7684\u9875\u540d\u79f0");
                return rspBo;
            }
        }
        catch (IOException e) {
            log.error("\u7528\u6237\u903e\u671f\u7ba1\u63a7\u914d\u7f6e\u6279\u91cf\u5bfc\u5165\u8bfb\u53d6Excel\u5f02\u5e38\uff1a{}", (Object)e.toString());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u7528\u6237\u903e\u671f\u7ba1\u63a7\u914d\u7f6e\u6279\u91cf\u5bfc\u5165\u7528\u6237\u5931\u8d25\uff0c\u8bfb\u53d6Excel\u5f02\u5e38");
            return rspBo;
        }
        log.debug("\u5f00\u59cb\u8bfb\u53d6\u6570\u636e=============" + DateUtil.dateToStrLong(new Date()));
        ArrayList<FscUserOverdueControlConfigImportInfoBO> importInfoList = new ArrayList<FscUserOverdueControlConfigImportInfoBO>();
        List dataRows = excel.readRows(0, 2, -1);
        ArrayList<Long> userIdList = new ArrayList<Long>();
        if (CollectionUtils.isEmpty((Collection)dataRows)) {
            log.error("\u8bfb\u53d6\u6570\u636e\u7ed3\u675f\uff0c\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a====" + DateUtil.dateToStrLong(new Date()));
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u7528\u6237\u903e\u671f\u7ba1\u63a7\u914d\u7f6e\u6279\u91cf\u5bfc\u5165\u7528\u6237\u5931\u8d25\uff0c\u5bfc\u5165Excel\u6570\u636e\u4e3a\u7a7a");
            return rspBo;
        }
        if (this.FSC_PAY_CONFIG_IMPORT_MAX_NUM < dataRows.size()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u7528\u6237\u903e\u671f\u7ba1\u63a7\u914d\u7f6e\u6279\u91cf\u5bfc\u5165\u7528\u6237\u5931\u8d25\uff0c\u5bfc\u5165\u6570\u636e\u8bf7\u52ff\u8d85\u8fc7 " + this.FSC_PAY_CONFIG_IMPORT_MAX_NUM + " \u6761");
            return rspBo;
        }
        for (int i = 0; i < dataRows.size(); ++i) {
            Long configUserId;
            String[] fields = (String[])dataRows.get(i);
            FscUserOverdueControlConfigImportInfoBO importInfoBo = new FscUserOverdueControlConfigImportInfoBO();
            List<String> row = Arrays.asList(fields);
            int index = i + 3;
            try {
                configUserId = Long.valueOf(row.get(3));
            }
            catch (NumberFormatException e) {
                rspBo.setRespCode("18000");
                rspBo.setRespDesc("\u7b2c" + index + "\u884c\u6570\u636e[\u7528\u6237ID]\u4e0d\u662f\u6574\u6570\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5");
                return rspBo;
            }
            if (userIdList.contains(configUserId)) {
                rspBo.setRespCode("18000");
                rspBo.setRespDesc("\u7b2c" + index + "\u884c\u6570\u636e[\u7528\u6237ID:" + configUserId + "]\u91cd\u590d\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5");
                return rspBo;
            }
            userIdList.add(configUserId);
            importInfoBo.setConfigUserId(configUserId);
            try {
                importInfoBo.setWarningNum(Integer.valueOf(Integer.parseInt(row.get(4))));
            }
            catch (NumberFormatException e) {
                rspBo.setRespCode("18000");
                rspBo.setRespDesc("\u7b2c" + index + "\u884c\u6570\u636e[\u903e\u671f\u8ba2\u5355\u9884\u8b66\u6570]\u4e0d\u662f\u6574\u6570\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5");
                return rspBo;
            }
            try {
                importInfoBo.setControlNum(Integer.valueOf(Integer.parseInt(row.get(5))));
            }
            catch (NumberFormatException e) {
                rspBo.setRespCode("18000");
                rspBo.setRespDesc("\u7b2c" + index + "\u884c\u6570\u636e[\u903e\u671f\u8ba2\u5355\u7ba1\u63a7\u6570]\u4e0d\u662f\u6574\u6570\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5");
                return rspBo;
            }
            try {
                importInfoBo.setRecoveryNum(Integer.valueOf(Integer.parseInt(row.get(6))));
            }
            catch (NumberFormatException e) {
                rspBo.setRespCode("18000");
                rspBo.setRespDesc("\u7b2c" + index + "\u884c\u6570\u636e[\u903e\u671f\u8ba2\u5355\u6062\u590d\u6570]\u4e0d\u662f\u6574\u6570\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5");
                return rspBo;
            }
            if (importInfoBo.getControlNum() < importInfoBo.getRecoveryNum()) {
                rspBo.setRespCode("18000");
                rspBo.setRespDesc("\u7b2c" + index + "\u884c\u6570\u636e[\u903e\u671f\u8ba2\u5355\u6062\u590d\u6570:" + importInfoBo.getRecoveryNum() + "]\u5e94\u5c0f\u4e8e[\u903e\u671f\u8ba2\u5355\u7ba1\u63a7\u6570:" + importInfoBo.getControlNum() + "]\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5");
                return rspBo;
            }
            importInfoList.add(importInfoBo);
        }
        log.debug("Excel\u6570\u636e\u8bfb\u53d6\u5b8c\u6210======size:{}.\u65f6\u95f4\uff1a{}", (Object)importInfoList.size(), (Object)DateUtil.dateToStrLong(new Date()));
        if (CollectionUtils.isEmpty(importInfoList)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u7528\u6237\u903e\u671f\u7ba1\u63a7\u914d\u7f6e\u6279\u91cf\u5bfc\u5165\u7528\u6237\u5931\u8d25\uff0c\u5bfc\u5165\u6570\u636e\u8bfb\u53d6\u7ed3\u679c\u4e3a\u7a7a");
            return rspBo;
        }
        this.initUmcOrgData(importInfoList);
        ArrayList<Long> successUserIdList = new ArrayList<Long>();
        for (FscUserOverdueControlConfigImportInfoBO importInfoBo : importInfoList) {
            FscUserOverdueControlConfigModifyAbilityReqBO busiReqBo = FscRu.js(reqBo, FscUserOverdueControlConfigModifyAbilityReqBO.class);
            busiReqBo.setConfigId(null);
            busiReqBo.setOperationType("3");
            busiReqBo.setWarningNum(importInfoBo.getWarningNum());
            busiReqBo.setControlNum(importInfoBo.getControlNum());
            busiReqBo.setRecoveryNum(importInfoBo.getRecoveryNum());
            busiReqBo.setConfigOrgId(importInfoBo.getConfigOrgId());
            busiReqBo.setConfigOrgName(importInfoBo.getConfigOrgName());
            busiReqBo.setConfigOrgPath(importInfoBo.getConfigOrgPath());
            busiReqBo.setConfigOrgFullName(importInfoBo.getConfigOrgFullName());
            busiReqBo.setConfigUserId(importInfoBo.getConfigUserId());
            busiReqBo.setConfigUserAccount(importInfoBo.getConfigUserAccount());
            busiReqBo.setConfigUserName(importInfoBo.getConfigUserName());
            busiReqBo.setConfigAuthRole(importInfoBo.getConfigAuthRole());
            FscUserOverdueControlConfigModifyAbilityRspBO busiRspBo = this.fscUserOverdueControlConfigExceptionSaveBusiService.dealUserOverdueControlConfigExceptionSave(busiReqBo);
            if (FscRu.isSuccess(busiRspBo.getRespCode()).booleanValue()) {
                successUserIdList.add(importInfoBo.getConfigUserId());
                rspBo.getConfigIdList().add(busiRspBo.getConfigId());
                continue;
            }
            this.sendMq(successUserIdList);
            throw new PfscExtBusinessException(busiRspBo.getRespCode(), busiRspBo.getRespDesc());
        }
        this.sendMq(successUserIdList);
        return rspBo;
    }

    private void sendMq(List<Long> successUserIdList) {
        if (!CollectionUtils.isEmpty(successUserIdList)) {
            FscCreditControlTipsUserTaskAbilityReqBO consumerReqBo = new FscCreditControlTipsUserTaskAbilityReqBO();
            consumerReqBo.setOperationFlag("UPDATE_EXCEL");
            consumerReqBo.setConfigUserIdList(successUserIdList);
            JSONObject data = new JSONObject();
            data.put("type", (Object)"TYPE_CONTROL_USER_LIST");
            data.put("busiReqBo", (Object)consumerReqBo);
            ProxySendResult sendResult = this.fscCreditControlUserProvider.send(new ProxyMessage(this.FSC_CREDIT_CONTROL_USER_TOPIC, this.FSC_CREDIT_CONTROL_USER_TAG, data.toJSONString()));
            if (!"SEND_OK".equals(sendResult.getStatus())) {
                log.error("\u5f02\u6b65\u66f4\u65b0\u8ba2\u5355\u903e\u671f\u6570\u91cf\u5931\u8d25\uff0cMQ\u53d1\u9001\u5931\u8d25.");
            }
        }
    }

    private void initUmcOrgData(List<FscUserOverdueControlConfigImportInfoBO> importInfoList) {
        List batchList = ListUtil.batchList(importInfoList, (int)200);
        for (List subList : batchList) {
            FscUmcQryMemListExternalReqBO umcReqBo = new FscUmcQryMemListExternalReqBO();
            List userIdList = subList.stream().map(FscUserOverdueControlConfigImportInfoBO::getConfigUserId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(userIdList)) {
                throw new BusinessException("18000", "\u7528\u6237ID\u4e3a\u7a7a");
            }
            umcReqBo.setPageNo(Integer.valueOf(1));
            umcReqBo.setPageSize(Integer.valueOf(userIdList.size() * 2));
            umcReqBo.setUserIds(userIdList);
            FscUmcQryMemListExternalRspBO umcRspBo = this.fscUmcQryAccountListExternalService.qryMem(umcReqBo);
            if (FscRu.isFailed(umcRspBo.getRespCode()).booleanValue()) {
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u4f1a\u5458\u4e2d\u5fc3\u8d26\u53f7\u4fe1\u606f\u5931\u8d25\uff1a" + umcRspBo.getRespDesc());
            }
            List umcRspRows = umcRspBo.getRows();
            if (CollectionUtils.isEmpty((Collection)umcRspRows)) {
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u4f1a\u5458\u4e2d\u5fc3\u8d26\u53f7\u4fe1\u606f\u4e3a\u7a7a");
            }
            Map mapUmcInfo = umcRspRows.stream().filter(i -> i.getUserId() != null && i.getUserId() != 0L).collect(Collectors.toMap(UmcMemDetailInfoAbilityBO::getUserId, Function.identity(), (old, cur) -> old));
            for (FscUserOverdueControlConfigImportInfoBO importInfoBO : subList) {
                UmcMemDetailInfoAbilityBO umcMemBo = (UmcMemDetailInfoAbilityBO)mapUmcInfo.get(importInfoBO.getConfigUserId());
                if (umcMemBo == null) {
                    throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u4f1a\u5458\u4e2d\u5fc3\u8d26\u53f7\u4fe1\u606f\u5f02\u5e38\uff0c\u7528\u6237ID[" + importInfoBO.getConfigUserId() + "]\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
                }
                importInfoBO.setConfigOrgId(umcMemBo.getOrgId());
                importInfoBO.setConfigOrgName(umcMemBo.getOrgName());
                importInfoBO.setConfigOrgPath(umcMemBo.getOrgTreePath());
                importInfoBO.setConfigOrgFullName(umcMemBo.getOrgFullName());
                importInfoBO.setConfigUserId(umcMemBo.getUserId());
                importInfoBO.setConfigUserAccount(umcMemBo.getRegAccount());
                importInfoBO.setConfigUserName(umcMemBo.getMemName2());
                importInfoBO.setConfigAuthRole(umcMemBo.getUserFullRoleName());
            }
        }
    }

    @PostMapping(value={"dealUserOverdueConfigExport"})
    public FscUserOverdueControlConfigExportAbilityRspBO dealUserOverdueConfigExport(@RequestBody FscUserOverdueControlConfigExportAbilityReqBO reqBo) {
        return new FscUserOverdueControlConfigExportAbilityRspBO();
    }

    private void uploadFile(List<Map<String, Object>> data, FscUserOverdueControlConfigTemplateAbilityRspBO rspBO) {
        String HEAD_STR = "\u6ce8\u610f\u4e8b\u9879\uff1a1\u3001\u7528\u6237ID\u4e0d\u53ef\u91cd\u590d\uff0c\u5bfc\u5165\u540e\u5b58\u5728\u4f8b\u5916\u7684\u5c06\u4fee\u6539\u914d\u7f6e\uff0c\u672a\u914d\u7f6e\u7684\u5c06\u6dfb\u52a0\u4e3a\u4f8b\u5916\u914d\u7f6e\u30022\u3001\u903e\u671f\u8ba2\u5355\u6062\u590d\u6570\u5e94\u5c0f\u4e8e\u903e\u671f\u8ba2\u5355\u7ba1\u63a7\u6570\u3002";
        SXSSFWorkbook workbook = ExcelUtils.createWorkbookWithHead(data, "\u7528\u6237\u903e\u671f\u7ba1\u63a7\u914d\u7f6e\u6279\u91cf\u5bfc\u5165\u7528\u6237", HEAD_STR);
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String uploadPath = "fsc";
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
        String date = df.format(new Date());
        String fileName = "\u7528\u6237\u903e\u671f\u7ba1\u63a7\u914d\u7f6e\u6279\u91cf\u5bfc\u5165\u7528\u6237" + date + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            rspBO.setFilePath(result);
            rspBO.setFileClientType(this.fileType);
            rspBO.setFileName(fileName);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new PfscExtBusinessException("0001", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
    }
}

