/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.ability.FscUserOverdueControlConfigQryAbilityService;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigQryAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueExceptionConfigInfoBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueExceptionConfigQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueExceptionConfigQryAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueStatisticsInfoBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueStatisticsQryAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueStatisticsQryAbilityRspBO;
import com.tydic.pfscext.base.AuthorityInfo;
import com.tydic.pfscext.dao.FscUserOverdueControlConfigMapper;
import com.tydic.pfscext.dao.FscUserOverdueStatisticsMapper;
import com.tydic.pfscext.dao.po.FscUserOverdueControlConfigPO;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.external.umc.api.FscUmcQryAccountListExternalService;
import com.tydic.pfscext.external.umc.bo.FscUmcQryMemListExternalReqBO;
import com.tydic.pfscext.external.umc.bo.FscUmcQryMemListExternalRspBO;
import com.tydic.pfscext.external.uoc.api.FscUocOrderCreditInfoStatisticsQryExternalService;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import com.tydic.umc.ability.bo.UmcMemDetailInfoAbilityBO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.ability.FscUserOverdueControlConfigQryAbilityService"})
public class FscUserOverdueControlConfigQryAbilityServiceImpl
implements FscUserOverdueControlConfigQryAbilityService {
    @Autowired
    private FscUserOverdueControlConfigMapper fscUserOverdueControlConfigMapper;
    @Autowired
    private FscUserOverdueStatisticsMapper fscUserOverdueStatisticsMapper;
    @Autowired
    private FscUmcQryAccountListExternalService fscUmcQryAccountListExternalService;
    @Autowired
    private FscUocOrderCreditInfoStatisticsQryExternalService fscUocOrderCreditInfoStatisticsQryExternalService;
    @Value(value="${FSC_AUTH_SYSTEM_MANAGE:auth:system:manage}")
    private String FSC_AUTH_SYSTEM_MANAGE;
    @Value(value="${FSC_AUTH_PRO_CREDIT_MANAGE:overall:yunyingshouxinguanlizhuanyuan}")
    private String FSC_AUTH_PRO_CREDIT_MANAGE;
    @Value(value="${FSC_AUTH_SECONDARY_COMPANY_MANAGE:overall:erjidanweiguanliyuan}")
    private String FSC_AUTH_SECONDARY_COMPANY_MANAGE;
    @Value(value="${FSC_AUTH_PUR_COMPANY_MANAGE:001}")
    private String FSC_AUTH_PUR_COMPANY_MANAGE;
    @Value(value="${FSC_AUTH_PUR_COMPANY_BUYER:002}")
    private String FSC_AUTH_PUR_COMPANY_BUYER;
    @Value(value="${FSC_AUTH_SUP_MANAGE:201}")
    private String FSC_AUTH_SUP_MANAGE;
    @Value(value="${FSC_AUTH_SUP_MANAGE:890}")
    private String FSC_AUTH_ESTORE_SUP_MANAGE;

    @PostMapping(value={"qryUserOverdueControlConfig"})
    public FscUserOverdueControlConfigQryAbilityRspBO qryUserOverdueControlConfig(@RequestBody FscUserOverdueControlConfigQryAbilityReqBO reqBo) {
        FscUserOverdueControlConfigQryAbilityRspBO rspBo = new FscUserOverdueControlConfigQryAbilityRspBO();
        FscUserOverdueControlConfigPO configPo = new FscUserOverdueControlConfigPO();
        if (reqBo.getConfigId() == null) {
            configPo.setConfigType("1");
        } else {
            configPo.setConfigId(reqBo.getConfigId());
        }
        configPo.setDeleteFlag(YesOrNo.NO.getCode());
        configPo = this.fscUserOverdueControlConfigMapper.getModelBy(configPo);
        if (configPo != null) {
            rspBo.setConfigId(configPo.getConfigId());
            rspBo.setWarningNum(configPo.getOrderWarningNum());
            rspBo.setControlNum(configPo.getOrderControlNum());
            rspBo.setRecoveryNum(configPo.getOrderRecoveryNum());
            rspBo.setRespDesc("\u6210\u529f");
        } else {
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u914d\u7f6e\u4fe1\u606f");
        }
        rspBo.setRespCode("0000");
        return rspBo;
    }

    @PostMapping(value={"listPageUserOverdueControlConfig"})
    public FscUserOverdueExceptionConfigQryAbilityRspBO listPageUserOverdueControlConfig(@RequestBody FscUserOverdueExceptionConfigQryAbilityReqBO reqBo) {
        FscUserOverdueExceptionConfigQryAbilityRspBO rspBo = FscRu.success(FscUserOverdueExceptionConfigQryAbilityRspBO.class);
        rspBo.setPageNo(Integer.valueOf(1));
        rspBo.setRecordsTotal(Integer.valueOf(0));
        rspBo.setTotal(Integer.valueOf(0));
        rspBo.setRows(new ArrayList());
        FscUserOverdueControlConfigPO fscUserOverdueControlConfigQry = new FscUserOverdueControlConfigPO();
        fscUserOverdueControlConfigQry.setConfigIdList(reqBo.getConfigIdList());
        fscUserOverdueControlConfigQry.setConfigUserAccountLike(reqBo.getConfigUserAccount());
        fscUserOverdueControlConfigQry.setConfigUserNameLike(reqBo.getConfigUserName());
        fscUserOverdueControlConfigQry.setConfigUserNameList(reqBo.getConfigUserNameList());
        fscUserOverdueControlConfigQry.setConfigOrgNameLike(reqBo.getConfigOrgName());
        fscUserOverdueControlConfigQry.setConfigOrgFullNameLike(reqBo.getConfigOrgFullName());
        fscUserOverdueControlConfigQry.setConfigId(reqBo.getConfigId());
        fscUserOverdueControlConfigQry.setConfigType("2");
        fscUserOverdueControlConfigQry.setDeleteFlag(YesOrNo.NO.getCode());
        Page pager = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List<FscUserOverdueControlConfigPO> listPage = this.fscUserOverdueControlConfigMapper.getListPage(fscUserOverdueControlConfigQry, (Page<FscUserOverdueControlConfigPO>)pager);
        if (!CollectionUtils.isEmpty(listPage)) {
            List<Long> userIdList = listPage.stream().map(FscUserOverdueControlConfigPO::getConfigUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Long, UmcMemDetailInfoAbilityBO> mapUocUserRole = this.mapUocUserRole(userIdList);
            rspBo.getRows().addAll(listPage.stream().map(i -> {
                FscUserOverdueExceptionConfigInfoBO infoBo = FscRu.js(i, FscUserOverdueExceptionConfigInfoBO.class);
                infoBo.setConfigId(i.getConfigId());
                infoBo.setControlNum(i.getOrderControlNum());
                infoBo.setRecoveryNum(i.getOrderRecoveryNum());
                infoBo.setWarningNum(i.getOrderWarningNum());
                if (mapUocUserRole.containsKey(i.getConfigUserId())) {
                    UmcMemDetailInfoAbilityBO umcUserBo = (UmcMemDetailInfoAbilityBO)mapUocUserRole.get(i.getConfigUserId());
                    infoBo.setConfigOrgId(umcUserBo.getOrgId());
                    infoBo.setConfigOrgName(umcUserBo.getOrgName());
                    infoBo.setConfigOrgPath(umcUserBo.getOrgTreePath());
                    infoBo.setConfigOrgFullName(umcUserBo.getOrgFullName());
                    infoBo.setConfigUserId(umcUserBo.getUserId());
                    infoBo.setConfigUserAccount(umcUserBo.getRegAccount());
                    infoBo.setConfigUserName(umcUserBo.getMemName2());
                    infoBo.setConfigAuthRole(umcUserBo.getUserFullRoleName());
                }
                return infoBo;
            }).collect(Collectors.toList()));
        }
        rspBo.setPageNo(Integer.valueOf(pager.getPageNo()));
        rspBo.setRecordsTotal(Integer.valueOf(pager.getTotalCount()));
        rspBo.setTotal(Integer.valueOf(pager.getTotalPages()));
        return rspBo;
    }

    @PostMapping(value={"listPageUserOverdueStatistics"})
    public FscUserOverdueStatisticsQryAbilityRspBO listPageUserOverdueStatistics(@RequestBody FscUserOverdueStatisticsQryAbilityReqBO reqBo) {
        FscUserOverdueStatisticsQryAbilityRspBO rspBo = FscRu.success(FscUserOverdueStatisticsQryAbilityRspBO.class);
        rspBo.setPageNo(Integer.valueOf(1));
        rspBo.setRecordsTotal(Integer.valueOf(1));
        rspBo.setTotal(Integer.valueOf(1));
        rspBo.setRows(new ArrayList());
        if (!StringUtils.hasText((String)reqBo.getOrgPath())) {
            rspBo.setRespDesc("\u673a\u6784\u6811\u4e3a\u7a7a");
            return rspBo;
        }
        if (reqBo.getCompanyId() == null) {
            rspBo.setRespDesc("\u5355\u4f4dID\u4e3a\u7a7a");
            return rspBo;
        }
        if (reqBo.getUserId() == null) {
            rspBo.setRespDesc("\u7528\u6237ID\u4e3a\u7a7a");
            return rspBo;
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getPermission())) {
            rspBo.setRespDesc("\u89d2\u8272\u96c6\u5408\u4e3a\u7a7a");
            return rspBo;
        }
        List roleList = reqBo.getPermission().stream().map(AuthorityInfo::getKey).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(roleList)) {
            rspBo.setRespDesc("\u89d2\u8272\u96c6\u5408key\u4e3a\u7a7a");
            return rspBo;
        }
        FscUserOverdueControlConfigPO fscUserOverdueControlConfigQry = new FscUserOverdueControlConfigPO();
        fscUserOverdueControlConfigQry.setConfigId(reqBo.getConfigId());
        fscUserOverdueControlConfigQry.setConfigIdList(reqBo.getConfigIdList());
        fscUserOverdueControlConfigQry.setStatisticsId(reqBo.getStatisticsId());
        fscUserOverdueControlConfigQry.setStatisticsIdList(reqBo.getStatisticsIdList());
        fscUserOverdueControlConfigQry.setCurrentUserControlStatus(reqBo.getCurrentUserControlStatus());
        fscUserOverdueControlConfigQry.setConfigUserAccountLike(reqBo.getConfigUserAccount());
        fscUserOverdueControlConfigQry.setConfigUserNameList(reqBo.getConfigUserNameList());
        fscUserOverdueControlConfigQry.setConfigUserAccountList(reqBo.getConfigUserAccountList());
        fscUserOverdueControlConfigQry.setConfigOrgNameLike(reqBo.getConfigOrgName());
        fscUserOverdueControlConfigQry.setOrderWarningNumStart(reqBo.getWarningNumStart());
        fscUserOverdueControlConfigQry.setOrderWarningNumEnd(reqBo.getWarningNumEnd());
        fscUserOverdueControlConfigQry.setOrderControlNumStart(reqBo.getControlNumStart());
        fscUserOverdueControlConfigQry.setOrderControlNumEnd(reqBo.getControlNumEnd());
        fscUserOverdueControlConfigQry.setOrderRecoveryNumStart(reqBo.getRecoveryNumStart());
        fscUserOverdueControlConfigQry.setOrderRecoveryNumEnd(reqBo.getRecoveryNumEnd());
        fscUserOverdueControlConfigQry.setConfigOrgIdList(reqBo.getConfigOrgIdList());
        if (!roleList.contains(this.FSC_AUTH_SYSTEM_MANAGE) && !roleList.contains(this.FSC_AUTH_PRO_CREDIT_MANAGE)) {
            if (roleList.contains(this.FSC_AUTH_SECONDARY_COMPANY_MANAGE)) {
                fscUserOverdueControlConfigQry.setConfigOrgPathLike(reqBo.getOrgPath());
            } else if (roleList.contains(this.FSC_AUTH_PUR_COMPANY_MANAGE)) {
                String orgPath = reqBo.getOrgPath();
                Long companyId = reqBo.getCompanyId();
                orgPath = StrUtil.subBefore((CharSequence)orgPath, (CharSequence)(companyId + ""), (boolean)true) + companyId;
                fscUserOverdueControlConfigQry.setConfigOrgPathLike(orgPath);
            } else if (roleList.contains(this.FSC_AUTH_PUR_COMPANY_BUYER)) {
                fscUserOverdueControlConfigQry.setConfigUserId(reqBo.getUserId());
            } else {
                rspBo.setRespDesc("\u6ca1\u6709\u5177\u5907\u67e5\u770b\u6743\u9650\u7684\u89d2\u8272");
                return rspBo;
            }
        }
        fscUserOverdueControlConfigQry.setQueryCriteria("1");
        Page pager = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List<FscUserOverdueControlConfigPO> listPage = this.fscUserOverdueControlConfigMapper.getListPageUserOverdueControlConfig(fscUserOverdueControlConfigQry, (Page<FscUserOverdueControlConfigPO>)pager);
        if (!CollectionUtils.isEmpty(listPage)) {
            List<Long> userIdList = listPage.stream().map(FscUserOverdueControlConfigPO::getConfigUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Long, UmcMemDetailInfoAbilityBO> mapUocUserRole = this.mapUocUserRole(userIdList);
            rspBo.setPageNo(Integer.valueOf(pager.getPageNo()));
            rspBo.setTotal(Integer.valueOf(pager.getTotalPages()));
            rspBo.setRecordsTotal(Integer.valueOf(pager.getTotalCount()));
            rspBo.getRows().addAll(listPage.stream().map(i -> {
                FscUserOverdueStatisticsInfoBO infoBo = FscRu.js(i, FscUserOverdueStatisticsInfoBO.class);
                infoBo.setConfigUserId(i.getConfigUserId());
                infoBo.setConfigId(i.getConfigId());
                infoBo.setControlNum(i.getOrderControlNum());
                infoBo.setControlNumStr(Optional.ofNullable(i.getOrderControlNum()).map(num -> num == 0 ? "" : num.toString()).orElse(""));
                infoBo.setRecoveryNum(i.getOrderRecoveryNum());
                infoBo.setRecoveryNumStr(Optional.ofNullable(i.getOrderRecoveryNum()).map(num -> num == 0 ? "" : num.toString()).orElse(""));
                infoBo.setWarningNum(i.getOrderWarningNum());
                infoBo.setWarningNumStr(Optional.ofNullable(i.getOrderWarningNum()).map(num -> num == 0 ? "" : num.toString()).orElse(""));
                infoBo.setCurrentCreditNum(i.getCurrentOrderCreditNum());
                infoBo.setCurrentCreditNumStr(Optional.ofNullable(i.getCurrentOrderCreditNum()).map(num -> num == 0 ? "" : num.toString()).orElse(""));
                infoBo.setCurrentOverdueNum(i.getCurrentOrderOverdueNum());
                infoBo.setCurrentOverdueNumStr(Optional.ofNullable(i.getCurrentOrderOverdueNum()).map(num -> num == 0 ? "" : num.toString()).orElse(""));
                infoBo.setCurrentCreditAmount(i.getOrderCreditAmount());
                infoBo.setCurrentCreditAmountStr(this.decimalToString(i.getOrderCreditAmount()));
                infoBo.setCurrentOverdueAmount(i.getOrderOverdueAmount());
                infoBo.setCurrentOverdueAmountStr(this.decimalToString(i.getOrderOverdueAmount()));
                infoBo.setCurrentUserControlStatusStr("\u4e0b\u5355\u6743\u9650" + FscPayConfigControlStatus.desc((String)infoBo.getCurrentUserControlStatus()));
                if (mapUocUserRole.containsKey(i.getConfigUserId())) {
                    UmcMemDetailInfoAbilityBO umcUserBo = (UmcMemDetailInfoAbilityBO)mapUocUserRole.get(i.getConfigUserId());
                    infoBo.setConfigOrgId(umcUserBo.getOrgId());
                    infoBo.setConfigOrgName(umcUserBo.getOrgName());
                    infoBo.setConfigOrgPath(umcUserBo.getOrgTreePath());
                    infoBo.setConfigOrgFullName(umcUserBo.getOrgFullName());
                    infoBo.setConfigUserId(umcUserBo.getUserId());
                    infoBo.setConfigUserAccount(umcUserBo.getRegAccount());
                    infoBo.setConfigUserName(umcUserBo.getMemName2());
                    infoBo.setConfigAuthRole(umcUserBo.getUserFullRoleName());
                }
                infoBo.setOpeEditAuth(YesNo.NO.getCode());
                if (roleList.contains(this.FSC_AUTH_SYSTEM_MANAGE) || roleList.contains(this.FSC_AUTH_PRO_CREDIT_MANAGE)) {
                    infoBo.setOpeEditAuth(YesNo.YES.getCode());
                }
                return infoBo;
            }).collect(Collectors.toList()));
        }
        return rspBo;
    }

    private Map<Long, UmcMemDetailInfoAbilityBO> mapUocUserRole(List<Long> userIdList) {
        HashMap<Long, UmcMemDetailInfoAbilityBO> mapUserInfo = new HashMap<Long, UmcMemDetailInfoAbilityBO>();
        for (List subUserIdList : ListUtil.batchList(userIdList)) {
            if (CollUtil.isEmpty((Collection)subUserIdList)) continue;
            FscUmcQryMemListExternalReqBO umcReqBo = new FscUmcQryMemListExternalReqBO();
            umcReqBo.setPageNo(Integer.valueOf(1));
            umcReqBo.setPageSize(Integer.valueOf(subUserIdList.size() * 2));
            umcReqBo.setUserIds(subUserIdList);
            FscUmcQryMemListExternalRspBO umcRspBo = this.fscUmcQryAccountListExternalService.qryMem(umcReqBo);
            if (CollUtil.isEmpty((Collection)umcRspBo.getRows())) continue;
            mapUserInfo.putAll(umcRspBo.getRows().stream().collect(Collectors.toMap(UmcMemDetailInfoAbilityBO::getUserId, Function.identity(), (c, o) -> c)));
        }
        return mapUserInfo;
    }

    private String decimalToString(BigDecimal orderCreditAmount) {
        if (orderCreditAmount == null || BigDecimal.ZERO.compareTo(orderCreditAmount) == 0) {
            return "0";
        }
        return new DecimalFormat("#.###").format(orderCreditAmount);
    }
}

