/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.aisino.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.aisino.BuisSajtIssueInvoiceService;
import com.tydic.pfscext.api.aisino.BusiBillManualObtainService;
import com.tydic.pfscext.api.aisino.bo.BuisSajtIssueInvoiceReqBO;
import com.tydic.pfscext.api.aisino.bo.BuisSajtIssueInvoiceRspBO;
import com.tydic.pfscext.api.aisino.bo.BusiBillManualObtainReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiBillManualObtainRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailBillApplyInfoApplyRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailBillApplyInfoItemRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailBillApplyInfoOrderRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailBillApplyInfoReqBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillChildApplyInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceDetailMapper;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceDetailMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyChildInfo;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.PayInvoiceDetail;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleItemInfoBatchVO;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.ApplyType;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.aisino.api.InvoiceIssueExternalService;
import com.tydic.pfscext.external.aisino.api.SajtIssueInvoiceExternalService;
import com.tydic.pfscext.external.aisino.api.bo.BillItemBO;
import com.tydic.pfscext.external.aisino.api.bo.BuisSajtIssueInvoiceBO;
import com.tydic.pfscext.external.aisino.api.bo.BuisSajtIssueInvoiceDetailsBO;
import com.tydic.pfscext.external.aisino.api.bo.GlobalInfoBO;
import com.tydic.pfscext.external.aisino.api.bo.InvoiceIssueBO;
import com.tydic.pfscext.external.aisino.api.bo.InvoiceIssueExtReqBO;
import com.tydic.pfscext.external.aisino.api.bo.InvoiceIssueExtRspBO;
import com.tydic.pfscext.external.aisino.api.bo.OrderInfoBO;
import com.tydic.pfscext.external.aisino.api.bo.SajtIssueInvoiceExternalReqBO;
import com.tydic.pfscext.external.aisino.api.bo.SajtIssueInvoiceExternalRspBO;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.utils.HexUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.aisino.BuisSajtIssueInvoiceService"})
public class BuisSajtIssueInvoiceServiceImpl
implements BuisSajtIssueInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(BuisSajtIssueInvoiceServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SajtIssueInvoiceExternalService sajtIssueInvoiceExternalService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private BillChildApplyInfoMapper billChildApplyInfoMapper;
    @Autowired
    private BusiBillManualObtainService busiBillManualObtainService;
    @Autowired
    private InvoiceIssueExternalService invoiceIssueExternalService;
    private static final int MANUAL_OBTAIN_BILL = 1;
    @Value(value="${taxCode}")
    private String taxCode;
    @Value(value="${clientId}")
    private String clientId;
    @Value(value="${taxNr}")
    private String taxNr;
    @Value(value="${orgnCode}")
    private String orgnCode;
    @Value(value="${version}")
    private String version;
    @Value(value="${branchNr}")
    private String branchNr;
    @Value(value="${issueMethod}")
    private String issueMethod;
    @Value(value="${password}")
    private String password;
    @Value(value="${queryMethod}")
    private String queryMethod;
    @Value(value="${papMaxAmount:100000}")
    private String maxAmountStr;
    @Value(value="${papMaxNum:1000}")
    private int maxNum;
    @Value(value="${dsptbm}")
    private String dsptbm;
    @Value(value="${xsfbank}")
    private String xsfbank;
    @Value(value="${xsfaddr}")
    private String xsfaddr;
    @Value(value="${authorizationCode}")
    private String authorizationCode;

    @PostMapping(value={"buisSajtIssueInvoice"})
    public BuisSajtIssueInvoiceRspBO buisSajtIssueInvoice(@RequestBody BuisSajtIssueInvoiceReqBO buisSajtIssueInvoiceReqBO) {
        log.info("\u5f00\u7968\u7533\u8bf7\u5355-\u7eb8\u7968\u63a8\u9001\u7a0e\u63a7\u63a5\u53e3\u5f00\u59cb\uff1a" + JSON.toJSONString((Object)buisSajtIssueInvoiceReqBO));
        BuisSajtIssueInvoiceRspBO rspBO = new BuisSajtIssueInvoiceRspBO();
        try {
            List<BusiQueryDetailBillApplyInfoApplyRspBO> busiQueryDetailBillApplyInfoApplyRspBOS;
            ArrayList<String> errMsg = new ArrayList<String>();
            String applyNo = buisSajtIssueInvoiceReqBO.getApplyNo();
            BusiQueryDetailBillApplyInfoReqBO reqBO = new BusiQueryDetailBillApplyInfoReqBO();
            reqBO.setApplyNo(applyNo);
            if (buisSajtIssueInvoiceReqBO.getInvoiceIssueType().equals(1)) {
                BusiBillManualObtainReqBO busiBillManualObtainReqBO = new BusiBillManualObtainReqBO();
                busiBillManualObtainReqBO.setApplyNo(applyNo);
                BusiBillManualObtainRspBO busiBillManualObtainRspBO = this.busiBillManualObtainService.manualObtainBill(busiBillManualObtainReqBO);
                if (!busiBillManualObtainRspBO.getRespCode().equals("0000")) {
                    throw new PfscExtBusinessException("8888", busiBillManualObtainRspBO.getRespDesc());
                }
                busiQueryDetailBillApplyInfoApplyRspBOS = busiBillManualObtainRspBO.getBillApplyInfoApplyRspBOS();
            } else {
                BillApplyChildInfo billApplyChildInfoQry = new BillApplyChildInfo();
                billApplyChildInfoQry.setApplyNo(applyNo);
                List<BillApplyChildInfo> childApplyNoList = this.billChildApplyInfoMapper.selectChildList(billApplyChildInfoQry);
                busiQueryDetailBillApplyInfoApplyRspBOS = org.apache.commons.collections.CollectionUtils.isEmpty(childApplyNoList) ? this.queryApplyGroup(reqBO) : this.queryFailChildApplyNo(childApplyNoList, applyNo);
            }
            int successCount = 0;
            for (BusiQueryDetailBillApplyInfoApplyRspBO applyRspBO : busiQueryDetailBillApplyInfoApplyRspBOS) {
                BillApplyChildInfo billApplyChildInfo;
                if (((BusiQueryDetailBillApplyInfoItemRspBO)applyRspBO.getItemList().get(0)).getTaxRate().compareTo(BigDecimal.ZERO) == 0) {
                    successCount = this.invoiceIssue(applyRspBO, successCount, errMsg);
                    continue;
                }
                BillApplyChildInfo billApplyChildInfo1 = new BillApplyChildInfo();
                BuisSajtIssueInvoiceBO buisSajtIssueInvoiceBO = new BuisSajtIssueInvoiceBO();
                buisSajtIssueInvoiceBO.setDocumentNr(applyRspBO.getApplyNo());
                buisSajtIssueInvoiceBO.setInvType(Integer.valueOf(0));
                buisSajtIssueInvoiceBO.setCustomerName(applyRspBO.getInvoceName());
                buisSajtIssueInvoiceBO.setCustomerTaxNr(applyRspBO.getTaxNo());
                buisSajtIssueInvoiceBO.setCustomerAddressTel(applyRspBO.getAddr() + " " + applyRspBO.getPhone());
                buisSajtIssueInvoiceBO.setCustomerBankAccount(applyRspBO.getBankName() + " " + applyRspBO.getBankAcctNo());
                buisSajtIssueInvoiceBO.setMemo(StrUtil.isBlank((CharSequence)applyRspBO.getInvoiceRemark()) ? "\u5907\u6ce8" : applyRspBO.getInvoiceRemark());
                buisSajtIssueInvoiceBO.setSellerAddressTel("");
                buisSajtIssueInvoiceBO.setSellerBankAccount("");
                buisSajtIssueInvoiceBO.setIssuer("\u6881\u6829\u94ed");
                buisSajtIssueInvoiceBO.setChecker("\u5b5f\u5e86\u9f99");
                buisSajtIssueInvoiceBO.setPayee("\u9ad8\u8d8a");
                buisSajtIssueInvoiceBO.setIsIncTax(Integer.valueOf(1));
                buisSajtIssueInvoiceBO.setTaxDeduction(null);
                buisSajtIssueInvoiceBO.setGoodsListName("");
                ArrayList<BuisSajtIssueInvoiceDetailsBO> detailsBOS = new ArrayList<BuisSajtIssueInvoiceDetailsBO>();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)applyRspBO.getItemList())) {
                    for (BusiQueryDetailBillApplyInfoItemRspBO infoItemRspBO : applyRspBO.getItemList()) {
                        log.error("\u5546\u54c1\u660e\u7ec6\u51fa\u53c2============" + infoItemRspBO.toString());
                        BuisSajtIssueInvoiceDetailsBO buisSajtIssueInvoiceDetailsBO = new BuisSajtIssueInvoiceDetailsBO();
                        buisSajtIssueInvoiceDetailsBO.setProductName(this.getWordCount(infoItemRspBO.getSkuName(), 70));
                        if (infoItemRspBO.getSpec() != null) {
                            buisSajtIssueInvoiceDetailsBO.setSpec(infoItemRspBO.getSpec());
                            if (infoItemRspBO.getModel() != null) {
                                buisSajtIssueInvoiceDetailsBO.setSpec(infoItemRspBO.getSpec() + infoItemRspBO.getModel());
                            }
                        }
                        if (!StringUtils.isEmpty((Object)buisSajtIssueInvoiceDetailsBO.getSpec())) {
                            buisSajtIssueInvoiceDetailsBO.setSpec(this.getWordCount(buisSajtIssueInvoiceDetailsBO.getSpec(), 40));
                        }
                        buisSajtIssueInvoiceDetailsBO.setUnit(infoItemRspBO.getUnitName());
                        buisSajtIssueInvoiceDetailsBO.setQuantity(infoItemRspBO.getQuantity());
                        buisSajtIssueInvoiceDetailsBO.setPrice(infoItemRspBO.getSaleUnitPrice());
                        if (infoItemRspBO.getQuantity() == null) {
                            buisSajtIssueInvoiceDetailsBO.setValue(infoItemRspBO.getAmount());
                        } else {
                            buisSajtIssueInvoiceDetailsBO.setValue(infoItemRspBO.getQuantity().multiply(infoItemRspBO.getSaleUnitPrice()));
                        }
                        buisSajtIssueInvoiceDetailsBO.setTaxItem("");
                        buisSajtIssueInvoiceDetailsBO.setTaxRate(infoItemRspBO.getTaxRate());
                        buisSajtIssueInvoiceDetailsBO.setDiscountValue("");
                        buisSajtIssueInvoiceDetailsBO.setDiscountTax("");
                        buisSajtIssueInvoiceDetailsBO.setGoodsNoVer("1");
                        buisSajtIssueInvoiceDetailsBO.setGoodsTaxNo(String.valueOf(infoItemRspBO.getTaxCatCode()));
                        buisSajtIssueInvoiceDetailsBO.setTaxPre("");
                        buisSajtIssueInvoiceDetailsBO.setTaxPreCon("");
                        if (new BigDecimal("0").compareTo(infoItemRspBO.getTaxAmt()) == 0 && new BigDecimal("0").compareTo(infoItemRspBO.getTaxRate()) == 0) {
                            buisSajtIssueInvoiceDetailsBO.setZeroTax("3");
                        } else {
                            buisSajtIssueInvoiceDetailsBO.setZeroTax("");
                        }
                        buisSajtIssueInvoiceDetailsBO.setGoodsNo(infoItemRspBO.getSeq().toString());
                        detailsBOS.add(buisSajtIssueInvoiceDetailsBO);
                    }
                }
                buisSajtIssueInvoiceBO.setItems(detailsBOS);
                SajtIssueInvoiceExternalReqBO sajtIssueInvoiceExternalReqBO = new SajtIssueInvoiceExternalReqBO();
                sajtIssueInvoiceExternalReqBO.setBranchNr(this.branchNr);
                sajtIssueInvoiceExternalReqBO.setClientId(this.clientId);
                sajtIssueInvoiceExternalReqBO.setMethod(this.issueMethod);
                sajtIssueInvoiceExternalReqBO.setOrgnCode(this.orgnCode);
                sajtIssueInvoiceExternalReqBO.setPassword(this.password);
                sajtIssueInvoiceExternalReqBO.setTaxNr(this.taxNr);
                sajtIssueInvoiceExternalReqBO.setVersion(this.version);
                String Str = JSONObject.toJSONString((Object)buisSajtIssueInvoiceBO);
                sajtIssueInvoiceExternalReqBO.setContent(Str);
                SajtIssueInvoiceExternalRspBO sajtIssueInvoiceExternalRspBO = this.sajtIssueInvoiceExternalService.sajtIssueInvoiceExternal(sajtIssueInvoiceExternalReqBO);
                log.error("\u7eb8\u7968\u5f00\u7968\u63a5\u53e3\u8fd4\u56de\u51fa\u53c2:" + sajtIssueInvoiceExternalRspBO.toString());
                if (!"0000".equals(sajtIssueInvoiceExternalRspBO.getRespCode())) {
                    errMsg.add("\u62c6\u5206\u5b50\u7968\u3010" + applyRspBO.getApplyNo() + "\u3011\u5f00\u7968\u5931\u8d25:" + sajtIssueInvoiceExternalRspBO.getRespDesc());
                    billApplyChildInfo = new BillApplyChildInfo();
                    billApplyChildInfo.setChildApplyNo(applyRspBO.getApplyNo());
                    billApplyChildInfo.setApplyStatus("1");
                    billApplyChildInfo.setFailMsg(sajtIssueInvoiceExternalRspBO.getRespDesc());
                    this.billChildApplyInfoMapper.updateByPrimaryKey(billApplyChildInfo);
                    continue;
                }
                billApplyChildInfo = new BillApplyChildInfo();
                billApplyChildInfo.setChildApplyNo(applyRspBO.getApplyNo());
                billApplyChildInfo.setApplyStatus("0");
                billApplyChildInfo.setFailMsg("\u6210\u529f");
                this.billChildApplyInfoMapper.updateByPrimaryKey(billApplyChildInfo);
                billApplyChildInfo1.setSkNr(sajtIssueInvoiceExternalRspBO.getNr());
                billApplyChildInfo1.setSkCode(sajtIssueInvoiceExternalRspBO.getCode());
                billApplyChildInfo1.setInvType(sajtIssueInvoiceExternalRspBO.getInvType());
                billApplyChildInfo1.setChildApplyNo(applyRspBO.getApplyNo());
                this.billChildApplyInfoMapper.updateByPrimaryKey(billApplyChildInfo1);
                if (sajtIssueInvoiceExternalRspBO == null || !"0000".equals(sajtIssueInvoiceExternalRspBO.getRespCode())) continue;
                ++successCount;
            }
            rspBO.setSuccessCounts(Integer.valueOf(successCount));
            rspBO.setTotalCounts(Integer.valueOf(busiQueryDetailBillApplyInfoApplyRspBOS.size()));
            rspBO.setRespCode("0000");
            if (errMsg.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                errMsg.forEach(stringBuilder::append);
                rspBO.setRespDesc(stringBuilder.toString());
                return rspBO;
            }
        }
        catch (Exception e) {
            log.error("\u670d\u52a1\u62a5\u9519\uff1a", (Throwable)e);
            throw new PfscExtBusinessException("8888", e.getMessage());
        }
        return rspBO;
    }

    private int invoiceIssue(BusiQueryDetailBillApplyInfoApplyRspBO applyRspBO, int successCount, List<String> errMsg) {
        InvoiceIssueExtReqBO invoiceIssueExtReqBO = new InvoiceIssueExtReqBO();
        InvoiceIssueBO fpkjxxFptxx = new InvoiceIssueBO();
        fpkjxxFptxx.setFPQQLSH(applyRspBO.getApplyNo());
        fpkjxxFptxx.setNSRSBH(this.taxCode);
        fpkjxxFptxx.setNSRMC(applyRspBO.getOperUnitName());
        fpkjxxFptxx.setDKBZ("0");
        fpkjxxFptxx.setKPXM("\u529e\u516c\u7528\u54c1");
        fpkjxxFptxx.setBMB_BBH("26");
        fpkjxxFptxx.setFJH("");
        fpkjxxFptxx.setNSRDZDAH("");
        fpkjxxFptxx.setDSPTBM(this.dsptbm);
        fpkjxxFptxx.setGHF_YHZH(applyRspBO.getBankName() + " " + applyRspBO.getBankAcctNo());
        fpkjxxFptxx.setSWJG_DM("");
        fpkjxxFptxx.setSGBZ("");
        fpkjxxFptxx.setPYDM("");
        fpkjxxFptxx.setXHF_DH("");
        fpkjxxFptxx.setGHF_NSRSBH("");
        fpkjxxFptxx.setGHF_DZ(applyRspBO.getAddr());
        fpkjxxFptxx.setGHF_SF("");
        fpkjxxFptxx.setGHF_SJ(applyRspBO.getPhone());
        fpkjxxFptxx.setGHF_EMAIL("");
        fpkjxxFptxx.setXHF_YHZH(this.xsfbank);
        fpkjxxFptxx.setHY_DM("");
        fpkjxxFptxx.setHY_MC("");
        fpkjxxFptxx.setSKY("\u9ec4\u6c88\u4e39");
        fpkjxxFptxx.setFHR("\u8881\u536b\u4e1c");
        fpkjxxFptxx.setKPRQ(applyRspBO.getApplyDate());
        fpkjxxFptxx.setXHF_NSRSBH(this.taxCode);
        fpkjxxFptxx.setYFP_DM("");
        fpkjxxFptxx.setYFP_HM("");
        fpkjxxFptxx.setTSCHBZ("");
        fpkjxxFptxx.setQDXMMC("");
        fpkjxxFptxx.setCHYY("");
        fpkjxxFptxx.setBZ(StrUtil.isBlank((CharSequence)applyRspBO.getInvoiceRemark()) ? "\u5907\u6ce8" : applyRspBO.getInvoiceRemark());
        fpkjxxFptxx.setBYZD1("");
        fpkjxxFptxx.setBYZD2("");
        fpkjxxFptxx.setBYZD3("");
        fpkjxxFptxx.setBYZD4("");
        fpkjxxFptxx.setBYZD5("");
        fpkjxxFptxx.setXHFMC(applyRspBO.getOperUnitName());
        fpkjxxFptxx.setXHF_DZ(this.xsfaddr);
        fpkjxxFptxx.setGHFMC(applyRspBO.getInvoceName());
        fpkjxxFptxx.setGHF_GDDH(applyRspBO.getPhone());
        fpkjxxFptxx.setGHF_NSRSBH(applyRspBO.getTaxNo());
        fpkjxxFptxx.setGHFQYLX("01");
        fpkjxxFptxx.setKPY("\u8521\u5072");
        fpkjxxFptxx.setKPLX("1");
        fpkjxxFptxx.setCZDM("10");
        fpkjxxFptxx.setQD_BZ("0");
        fpkjxxFptxx.setKPHJJE(Double.valueOf(applyRspBO.getAmt().doubleValue()));
        BigDecimal taxAmt = applyRspBO.getAmt().divide(BigDecimal.ONE.add(new BigDecimal("0.06")), 5, 4).multiply(new BigDecimal("0.06")).setScale(2, 4);
        fpkjxxFptxx.setHJSE(Double.valueOf(taxAmt.doubleValue()));
        fpkjxxFptxx.setHJBHSJE(Double.valueOf(applyRspBO.getAmt().subtract(taxAmt).doubleValue()));
        GlobalInfoBO globalInfo = new GlobalInfoBO();
        globalInfo.setTerminalCode("0");
        globalInfo.setAppId("DZFP");
        globalInfo.setTaxpayerId(this.taxCode);
        globalInfo.setAuthorizationCode(this.authorizationCode);
        ArrayList<BillItemBO> fpkjxxXmxxs = new ArrayList<BillItemBO>();
        fpkjxxFptxx.setKPXM(((BusiQueryDetailBillApplyInfoItemRspBO)applyRspBO.getItemList().get(0)).getSkuName());
        for (BusiQueryDetailBillApplyInfoItemRspBO infoItemRspBO : applyRspBO.getItemList()) {
            BillItemBO billItemBO = new BillItemBO();
            if (!StringUtils.isEmpty((Object)infoItemRspBO.getSkuName())) {
                billItemBO.setXMMC(this.getWordCount(infoItemRspBO.getSkuName(), 70));
            }
            billItemBO.setHSBZ("1");
            billItemBO.setXMDW(infoItemRspBO.getUnitName());
            String ggxh = "";
            if (infoItemRspBO.getModel() != null || infoItemRspBO.getSpec() != null) {
                ggxh = infoItemRspBO.getSpec() + infoItemRspBO.getModel();
            }
            billItemBO.setGGXH(ggxh);
            if (infoItemRspBO.getQuantityApply() != null) {
                billItemBO.setXMSL(infoItemRspBO.getQuantityApply().setScale(8).toString());
            }
            billItemBO.setKCE(Double.valueOf(0.0));
            billItemBO.setSE(Double.valueOf(0.0));
            billItemBO.setZXBM(infoItemRspBO.getSeq().toString());
            if (new BigDecimal("0").compareTo(infoItemRspBO.getTaxRate()) == 0 && new BigDecimal("0").compareTo(infoItemRspBO.getTaxAmt()) == 0) {
                billItemBO.setLSLBS("3");
            } else {
                billItemBO.setLSLBS("");
            }
            billItemBO.setZZSTSGL("");
            billItemBO.setFPHXZ("0");
            billItemBO.setXMDJ(Double.valueOf(infoItemRspBO.getSaleUnitPrice().doubleValue()));
            if (infoItemRspBO.getTaxCatCode() != null) {
                billItemBO.setSWBM(infoItemRspBO.getTaxCatCode().toString());
                billItemBO.setSPBM(infoItemRspBO.getTaxCatCode().toString());
            }
            billItemBO.setYHZCBS("0");
            billItemBO.setBYZD1("");
            billItemBO.setBYZD2("");
            billItemBO.setBYZD3("");
            billItemBO.setBYZD4("");
            billItemBO.setBYZD5("");
            billItemBO.setXMJE(Double.valueOf(infoItemRspBO.getAmount().doubleValue()));
            billItemBO.setSL(infoItemRspBO.getTaxRate().toString());
            fpkjxxXmxxs.add(billItemBO);
        }
        OrderInfoBO fpkjxxDdxx = new OrderInfoBO();
        fpkjxxDdxx.setDDH(applyRspBO.getApplyNo());
        fpkjxxDdxx.setTHDH("");
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = sd.format(new Date());
        fpkjxxDdxx.setDDDATE(date);
        invoiceIssueExtReqBO.setFpkjxxDdxx(fpkjxxDdxx);
        invoiceIssueExtReqBO.setFpkjxxFptxx(fpkjxxFptxx);
        invoiceIssueExtReqBO.setGlobalInfo(globalInfo);
        invoiceIssueExtReqBO.setFpkjxxXmxxs(fpkjxxXmxxs);
        log.info("\u53d1\u9001\u5f00\u7968\u5165\u53c2\u4e3a:{}", (Object)JSON.toJSONString((Object)invoiceIssueExtReqBO));
        InvoiceIssueExtRspBO invoiceIssueExtRspBO = this.invoiceIssueExternalService.invoiceIssue(invoiceIssueExtReqBO);
        if (invoiceIssueExtRspBO != null && "0000".equals(invoiceIssueExtRspBO.getRespCode())) {
            BillApplyChildInfo billApplyChildInfo = new BillApplyChildInfo();
            billApplyChildInfo.setChildApplyNo(applyRspBO.getApplyNo());
            billApplyChildInfo.setApplyStatus("0");
            billApplyChildInfo.setFailMsg("\u6210\u529f");
            this.billChildApplyInfoMapper.updateByPrimaryKey(billApplyChildInfo);
            ++successCount;
        } else {
            errMsg.add("\u62c6\u5206\u5b50\u7968\u3010" + applyRspBO.getApplyNo() + "\u3011\u5f00\u7968\u5931\u8d25:" + invoiceIssueExtRspBO.getRespDesc());
            BillApplyChildInfo billApplyChildInfo = new BillApplyChildInfo();
            billApplyChildInfo.setChildApplyNo(applyRspBO.getApplyNo());
            billApplyChildInfo.setApplyStatus("1");
            billApplyChildInfo.setFailMsg(invoiceIssueExtRspBO.getRespDesc());
            this.billChildApplyInfoMapper.updateByPrimaryKey(billApplyChildInfo);
        }
        return successCount;
    }

    public BusiQueryDetailBillApplyInfoApplyRspBO queryApply(BusiQueryDetailBillApplyInfoReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getApplyNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            throw new PfscExtBusinessException("18000", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        saleOrderInfoVO.setApplyNo(applyNo);
        saleOrderInfoVO.setSource(billApplyInfo.getSource());
        saleOrderInfoVO.setOrderBy(" tt.inspectionId DESC");
        Page page = new Page(-1, -1);
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPageByApplyNo(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQueryDetailBillApplyInfoOrderRspBO> orderList = new ArrayList<BusiQueryDetailBillApplyInfoOrderRspBO>();
        if (saleOrderInfoList != null) {
            for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
                SaleItemInfoVO condition = new SaleItemInfoVO();
                condition.setInspectionId(saleOrderInfo.getInspectionId());
                condition.setApplyNo(billApplyInfo.getApplyNo());
                List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.selectListByTaxRate(condition);
                ArrayList<Long> skuIds = new ArrayList<Long>();
                for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                    skuIds.add(saleItemInfo.getSkuId());
                }
                HashMap<Long, String> skuIdNameMap = new HashMap<Long, String>();
                List<PayInvoiceDetail> payInvoiceDetails = this.payInvoiceDetailMapper.getItemNameBySkuId(skuIds);
                for (PayInvoiceDetail payInvoiceDetail : payInvoiceDetails) {
                    skuIdNameMap.put(payInvoiceDetail.getSkuId(), payInvoiceDetail.getItemName());
                }
                ArrayList<BusiQueryDetailBillApplyInfoItemRspBO> itemList = new ArrayList<BusiQueryDetailBillApplyInfoItemRspBO>();
                for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                    BusiQueryDetailBillApplyInfoItemRspBO item = new BusiQueryDetailBillApplyInfoItemRspBO();
                    BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                    if (skuIdNameMap.get(saleItemInfo.getSkuId()) != null) {
                        item.setSkuName((String)skuIdNameMap.get(saleItemInfo.getSkuId()));
                    }
                    if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(billApplyInfo.getApplyType())) {
                        item.setAmountApply(saleItemInfo.getAmountApplied());
                        item.setQuantityApply(saleItemInfo.getQuantityApplied());
                    } else {
                        item.setAmountApply(saleItemInfo.getAmount());
                        item.setQuantityApply(saleItemInfo.getQuantity());
                    }
                    itemList.add(item);
                }
                BusiQueryDetailBillApplyInfoOrderRspBO busiQueryDetailBillApplyInfoOrderRspBO = new BusiQueryDetailBillApplyInfoOrderRspBO();
                BeanUtils.copyProperties((Object)saleOrderInfo, (Object)busiQueryDetailBillApplyInfoOrderRspBO);
                busiQueryDetailBillApplyInfoOrderRspBO.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
                busiQueryDetailBillApplyInfoOrderRspBO.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus())));
                busiQueryDetailBillApplyInfoOrderRspBO.setItemList(itemList);
                orderList.add(busiQueryDetailBillApplyInfoOrderRspBO);
            }
        }
        BusiQueryDetailBillApplyInfoApplyRspBO rspBO = new BusiQueryDetailBillApplyInfoApplyRspBO();
        BeanUtils.copyProperties((Object)billApplyInfo, (Object)rspBO);
        rspBO.setOrderCount(Integer.valueOf(page.getTotalCount()));
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }

    public List<BusiQueryDetailBillApplyInfoApplyRspBO> queryApplyGroup(BusiQueryDetailBillApplyInfoReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getApplyNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            throw new PfscExtBusinessException("18000", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        ArrayList<BusiQueryDetailBillApplyInfoApplyRspBO> busiQueryDetailBillApplyInfoApplyRspBOList = new ArrayList<BusiQueryDetailBillApplyInfoApplyRspBO>();
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        saleOrderInfoVO.setApplyNo(applyNo);
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListNoPageByApplyNo(saleOrderInfoVO);
        int count = 1;
        ArrayList orderList = new ArrayList();
        if (!CollectionUtils.isEmpty(saleOrderInfoList)) {
            BigDecimal maxAmount = new BigDecimal(this.maxAmountStr);
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setApplyNo(applyNo);
            List<SaleItemInfo> saleItemInfoTaxGroupList = this.saleItemInfoMapper.selectSaleItemGroupByTax(saleItemInfoVO);
            for (SaleItemInfo groupSaleItem : saleItemInfoTaxGroupList) {
                SaleItemInfoVO condition = new SaleItemInfoVO();
                condition.setApplyNo(billApplyInfo.getApplyNo());
                condition.setTaxRate(groupSaleItem.getTaxRate());
                List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.selectListByTaxRate(condition);
                Map saleItemInfoMap = saleItemInfoList.stream().collect(Collectors.toMap(SaleItemInfo::getSeq, Function.identity(), (key1, key2) -> key2));
                ArrayList<LinkedList<List<SaleItemInfo>>> aboveMaxAmountSaleItems = new ArrayList<LinkedList<List<SaleItemInfo>>>();
                while (saleItemInfoMap.size() > 0) {
                    BigDecimal totalAmount = new BigDecimal("0");
                    ArrayList<SaleItemInfo> saleItemInfoGroup = new ArrayList<SaleItemInfo>();
                    Iterator entries = saleItemInfoMap.entrySet().iterator();
                    List<List<SaleItemInfo>> groupByAmountSaleItems = null;
                    while (entries.hasNext()) {
                        groupByAmountSaleItems = new LinkedList<List<SaleItemInfo>>();
                        SaleItemInfo saleItem = (SaleItemInfo)entries.next().getValue();
                        if (saleItem.getAmount().compareTo(maxAmount) > 0) {
                            groupByAmountSaleItems = this.groupByAmount(saleItem, maxAmount, groupByAmountSaleItems);
                            aboveMaxAmountSaleItems.add((LinkedList<List<SaleItemInfo>>)groupByAmountSaleItems);
                            entries.remove();
                            continue;
                        }
                        if ((totalAmount = totalAmount.add(saleItem.getAmount())).compareTo(maxAmount) > 0 || saleItemInfoGroup.size() >= this.maxNum) break;
                        SaleItemInfo saleItemInfo = new SaleItemInfo();
                        BeanUtils.copyProperties((Object)saleItem, (Object)saleItemInfo);
                        saleItemInfoGroup.add(saleItemInfo);
                        entries.remove();
                    }
                    if (saleItemInfoGroup.size() > 0) {
                        List<BusiQueryDetailBillApplyInfoItemRspBO> itemList = this.getDetailBillApplyInfoItems(billApplyInfo, saleItemInfoGroup);
                        String string = billApplyInfo.getApplyNo() + "_" + count;
                        BusiQueryDetailBillApplyInfoApplyRspBO infoApplyRspBO = new BusiQueryDetailBillApplyInfoApplyRspBO();
                        BeanUtils.copyProperties((Object)billApplyInfo, (Object)infoApplyRspBO);
                        infoApplyRspBO.setItemList(itemList);
                        infoApplyRspBO.setApplyNo(string);
                        infoApplyRspBO.setRows(orderList);
                        busiQueryDetailBillApplyInfoApplyRspBOList.add(infoApplyRspBO);
                        BillApplyChildInfo billApplyChildInfo = new BillApplyChildInfo();
                        billApplyChildInfo.setStatus(0);
                        billApplyChildInfo.setApplyNo(billApplyInfo.getApplyNo());
                        billApplyChildInfo.setChildApplyNo(string);
                        if (itemList.get(0).getTaxRate().compareTo(BigDecimal.ZERO) == 0) {
                            billApplyChildInfo.setInvoiceType(InvoiceType.NORMAL.getCode().toString());
                        } else {
                            billApplyChildInfo.setInvoiceType(billApplyInfo.getInvoiceType());
                        }
                        this.billChildApplyInfoMapper.deleteByPrimaryKey(billApplyChildInfo);
                        this.billChildApplyInfoMapper.insert(billApplyChildInfo);
                        SaleItemInfo saleItemInfo = new SaleItemInfo();
                        LinkedList<Long> itemSeqList = new LinkedList<Long>();
                        for (BusiQueryDetailBillApplyInfoItemRspBO itemInfo : itemList) {
                            itemSeqList.add(itemInfo.getSeq());
                        }
                        SaleItemInfoBatchVO saleItemInfoBatchVO = new SaleItemInfoBatchVO();
                        saleItemInfoBatchVO.setChildApplyNo(string);
                        saleItemInfoBatchVO.setItemSeqList(itemSeqList);
                        log.info("\u66f4\u65b0\u6570\u91cf\u4e3a\uff1a" + itemSeqList.size());
                        this.saleItemInfoMapper.updateSeqByBatch(saleItemInfoBatchVO);
                        ++count;
                    }
                    log.info("\u5355\u6761\u660e\u7ec6\u8d85\u8fc710W\u96c6\u5408\uff1a" + JSON.toJSONString(aboveMaxAmountSaleItems) + "\u6761\u6570\uff1a" + aboveMaxAmountSaleItems.size());
                    if (!CollectionUtils.isEmpty(aboveMaxAmountSaleItems)) {
                        for (List list : aboveMaxAmountSaleItems) {
                            for (List saleItemInfoGroup2 : list) {
                                List<BusiQueryDetailBillApplyInfoItemRspBO> itemList = this.getDetailBillApplyInfoItems(billApplyInfo, saleItemInfoGroup2);
                                String ChildApplyNo = billApplyInfo.getApplyNo() + "_" + count;
                                BusiQueryDetailBillApplyInfoApplyRspBO infoApplyRspBO = new BusiQueryDetailBillApplyInfoApplyRspBO();
                                BeanUtils.copyProperties((Object)billApplyInfo, (Object)infoApplyRspBO);
                                infoApplyRspBO.setItemList(itemList);
                                infoApplyRspBO.setApplyNo(ChildApplyNo);
                                infoApplyRspBO.setRows(orderList);
                                busiQueryDetailBillApplyInfoApplyRspBOList.add(infoApplyRspBO);
                                BillApplyChildInfo billApplyChildInfo = new BillApplyChildInfo();
                                if (!CollectionUtils.isEmpty(itemList) && null != itemList.get(0)) {
                                    billApplyChildInfo.setItemAmount(itemList.get(0).getAmount());
                                    billApplyChildInfo.setItemSeq(itemList.get(0).getSeq());
                                }
                                billApplyChildInfo.setApplyNo(billApplyInfo.getApplyNo());
                                billApplyChildInfo.setChildApplyNo(ChildApplyNo);
                                billApplyChildInfo.setStatus(0);
                                billApplyChildInfo.setInvoiceType(billApplyInfo.getInvoiceType());
                                this.billChildApplyInfoMapper.deleteByPrimaryKey(billApplyChildInfo);
                                this.billChildApplyInfoMapper.insert(billApplyChildInfo);
                                LinkedList<Long> itemSeqList = new LinkedList<Long>();
                                for (BusiQueryDetailBillApplyInfoItemRspBO itemInfo : itemList) {
                                    itemSeqList.add(itemInfo.getSeq());
                                }
                                SaleItemInfoBatchVO saleItemInfoBatchVO = new SaleItemInfoBatchVO();
                                saleItemInfoBatchVO.setChildApplyNo(ChildApplyNo);
                                saleItemInfoBatchVO.setItemSeqList(itemSeqList);
                                log.info("\u66f4\u65b0\u6570\u91cf\u4e3a\uff1a" + itemSeqList.size());
                                this.saleItemInfoMapper.updateSeqByBatch(saleItemInfoBatchVO);
                                ++count;
                            }
                        }
                    }
                    aboveMaxAmountSaleItems.clear();
                }
            }
        }
        return busiQueryDetailBillApplyInfoApplyRspBOList;
    }

    private List<List<SaleItemInfo>> groupByAmount(SaleItemInfo saleItem, BigDecimal maxAmount, List<List<SaleItemInfo>> groupByAmountSaleItems) {
        ArrayList<SaleItemInfo> saleItemInfos = new ArrayList<SaleItemInfo>();
        BigDecimal amount = saleItem.getAmount();
        BigDecimal saleUnitPrice = saleItem.getSaleUnitPrice();
        log.info(saleItem.getSeq() + "\u53f7\u660e\u7ec6\u5f00\u59cb\u62c6\u5206,\u603b\u91d1\u989d\uff1a" + amount + ",\u5355\u4ef7\uff1a" + saleUnitPrice);
        if (saleUnitPrice.compareTo(maxAmount) >= 0) {
            int counts = amount.divideAndRemainder(maxAmount)[0].intValue();
            for (int i = 0; i < counts; ++i) {
                ArrayList<SaleItemInfo> saleItemInfoss = new ArrayList<SaleItemInfo>();
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                BeanUtils.copyProperties((Object)saleItem, (Object)saleItemInfo);
                saleItemInfo.setAmount(maxAmount);
                saleItemInfo.setQuantity(null);
                saleItemInfo.setQuantityApplied(null);
                saleItemInfoss.add(saleItemInfo);
                groupByAmountSaleItems.add(saleItemInfoss);
            }
            BigDecimal leftAmount = amount.subtract(BigDecimal.valueOf(counts).multiply(maxAmount));
            if (leftAmount.compareTo(BigDecimal.ZERO) > 0) {
                SaleItemInfo leftSaleItemInfo = new SaleItemInfo();
                BeanUtils.copyProperties((Object)saleItem, (Object)leftSaleItemInfo);
                leftSaleItemInfo.setAmount(leftAmount);
                leftSaleItemInfo.setQuantityApplied(null);
                leftSaleItemInfo.setQuantity(null);
                saleItemInfos.add(leftSaleItemInfo);
                groupByAmountSaleItems.add(saleItemInfos);
            }
        } else {
            int counts = amount.divide(maxAmount, 1).intValue();
            BigDecimal leftAmount = amount;
            BigDecimal newAmount = maxAmount.divideAndRemainder(saleUnitPrice)[0].multiply(saleUnitPrice);
            for (int i = 0; i < counts; ++i) {
                ArrayList<SaleItemInfo> saleItemInfoss = new ArrayList<SaleItemInfo>();
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                BeanUtils.copyProperties((Object)saleItem, (Object)saleItemInfo);
                saleItemInfo.setAmount(newAmount);
                saleItemInfo.setQuantity(null);
                saleItemInfo.setQuantityApplied(null);
                saleItemInfoss.add(saleItemInfo);
                groupByAmountSaleItems.add(saleItemInfoss);
                leftAmount = leftAmount.subtract(newAmount);
            }
            if (leftAmount.compareTo(BigDecimal.ZERO) > 0) {
                SaleItemInfo leftSaleItemInfo = new SaleItemInfo();
                BeanUtils.copyProperties((Object)saleItem, (Object)leftSaleItemInfo);
                leftSaleItemInfo.setAmount(leftAmount);
                leftSaleItemInfo.setQuantityApplied(null);
                leftSaleItemInfo.setQuantity(null);
                saleItemInfos.add(leftSaleItemInfo);
                groupByAmountSaleItems.add(saleItemInfos);
            }
        }
        log.info("\u5355\u6761\u660e\u7ec6\u62c6\u7968\u540e\u7ed3\u679c\uff1a" + JSON.toJSONString(groupByAmountSaleItems));
        return groupByAmountSaleItems;
    }

    private List<BusiQueryDetailBillApplyInfoItemRspBO> getDetailBillApplyInfoItems(BillApplyInfo billApplyInfo, List<SaleItemInfo> saleItemInfoList) {
        ArrayList<Long> skuIds = new ArrayList<Long>();
        for (SaleItemInfo saleItemInfo : saleItemInfoList) {
            skuIds.add(saleItemInfo.getSkuId());
        }
        HashMap<Long, String> skuIdNameMap = new HashMap<Long, String>();
        List<PayInvoiceDetail> payInvoiceDetails = this.payInvoiceDetailMapper.getItemNameBySkuId(skuIds);
        for (PayInvoiceDetail payInvoiceDetail : payInvoiceDetails) {
            skuIdNameMap.put(payInvoiceDetail.getSkuId(), payInvoiceDetail.getItemName());
        }
        ArrayList<BusiQueryDetailBillApplyInfoItemRspBO> itemList = new ArrayList<BusiQueryDetailBillApplyInfoItemRspBO>();
        for (SaleItemInfo saleItemInfo : saleItemInfoList) {
            BusiQueryDetailBillApplyInfoItemRspBO item = new BusiQueryDetailBillApplyInfoItemRspBO();
            BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
            if (skuIdNameMap.get(saleItemInfo.getSkuId()) != null) {
                item.setSkuName((String)skuIdNameMap.get(saleItemInfo.getSkuId()));
            }
            if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(billApplyInfo.getApplyType())) {
                item.setAmountApply(saleItemInfo.getAmountApplied());
                item.setQuantityApply(saleItemInfo.getQuantityApplied());
            } else {
                item.setAmountApply(saleItemInfo.getAmount());
                item.setQuantityApply(saleItemInfo.getQuantity());
            }
            itemList.add(item);
        }
        return itemList;
    }

    private String getWordCount(String oldName, int len) {
        String newName = "";
        int oldNameLength = 0;
        char[] names = oldName.toCharArray();
        for (int i = 0; i < oldName.length(); ++i) {
            int ascii = Character.codePointAt(oldName, i);
            oldNameLength = ascii >= 0 && ascii <= 255 ? ++oldNameLength : (oldNameLength += 2);
            if (oldNameLength > len) continue;
            char c = names[i];
            newName = newName + c;
        }
        return newName;
    }

    private List<BusiQueryDetailBillApplyInfoApplyRspBO> queryFailChildApplyNo(List<BillApplyChildInfo> childApplyNoList, String applyNo) {
        BigDecimal maxAmount = new BigDecimal(this.maxAmountStr);
        ArrayList<BusiQueryDetailBillApplyInfoApplyRspBO> busiQueryDetailBillApplyInfoApplyRspBOS = new ArrayList<BusiQueryDetailBillApplyInfoApplyRspBO>();
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            throw new PfscExtBusinessException("18000", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        ArrayList<String> failChildNo = new ArrayList<String>();
        for (BillApplyChildInfo billApplyChildInfo : childApplyNoList) {
            if (!"1".equals(billApplyChildInfo.getApplyStatus()) && !StringUtils.isEmpty((Object)billApplyChildInfo.getApplyStatus())) continue;
            failChildNo.add(billApplyChildInfo.getChildApplyNo());
        }
        HashMap<Long, SaleItemInfo> saleItemInfoMap = new HashMap<Long, SaleItemInfo>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(failChildNo)) {
            ArrayList<SaleItemInfo> saleItemInfoList;
            HashMap itemListMap = new HashMap();
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setApplyNo(applyNo);
            saleItemInfoVO.setChildNoList(failChildNo);
            List<SaleItemInfo> saleItemInfos = this.saleItemInfoMapper.getListByApplyNoAndChildNos(saleItemInfoVO);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(saleItemInfos)) {
                for (SaleItemInfo saleItemInfo : saleItemInfos) {
                    saleItemInfo.setSkuName(this.hex2Str(saleItemInfo.getSkuName()));
                    if (saleItemInfo.getAmount().compareTo(maxAmount) < 0) {
                        if (itemListMap.containsKey(saleItemInfo.getChildApplyNo())) {
                            ((List)itemListMap.get(saleItemInfo.getChildApplyNo())).add(saleItemInfo);
                            continue;
                        }
                        saleItemInfoList = new ArrayList();
                        saleItemInfoList.add(saleItemInfo);
                        itemListMap.put(saleItemInfo.getChildApplyNo(), saleItemInfoList);
                        continue;
                    }
                    saleItemInfoMap.put(saleItemInfo.getSeq(), saleItemInfo);
                }
            }
            for (BillApplyChildInfo billApplyChildInfo : childApplyNoList) {
                if (!"1".equals(billApplyChildInfo.getApplyStatus()) && !StringUtils.isEmpty((Object)billApplyChildInfo.getApplyStatus()) || billApplyChildInfo.getItemSeq() == null) continue;
                saleItemInfoList = new ArrayList<SaleItemInfo>();
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                BeanUtils.copyProperties(saleItemInfoMap.get(billApplyChildInfo.getItemSeq()), (Object)saleItemInfo);
                saleItemInfo.setAmount(billApplyChildInfo.getItemAmount());
                saleItemInfo.setQuantityApplied(null);
                saleItemInfo.setQuantity(null);
                saleItemInfoList.add(saleItemInfo);
                itemListMap.put(billApplyChildInfo.getChildApplyNo(), saleItemInfoList);
            }
            for (BillApplyChildInfo billApplyChildInfo : childApplyNoList) {
                if (!"1".equals(billApplyChildInfo.getApplyStatus()) && !StringUtils.isEmpty((Object)billApplyChildInfo.getApplyStatus())) continue;
                List<BusiQueryDetailBillApplyInfoItemRspBO> itemList = this.getDetailBillApplyInfoItems(billApplyInfo, (List)itemListMap.get(billApplyChildInfo.getChildApplyNo()));
                BusiQueryDetailBillApplyInfoApplyRspBO infoApplyRspBO = new BusiQueryDetailBillApplyInfoApplyRspBO();
                BeanUtils.copyProperties((Object)billApplyInfo, (Object)infoApplyRspBO);
                infoApplyRspBO.setItemList(itemList);
                infoApplyRspBO.setApplyNo(billApplyChildInfo.getChildApplyNo());
                busiQueryDetailBillApplyInfoApplyRspBOS.add(infoApplyRspBO);
            }
        } else {
            BillApplyInfo billApply = new BillApplyInfo();
            billApply.setApplyNo(applyNo);
            billApply.setBillStatus("02");
            this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
        }
        return busiQueryDetailBillApplyInfoApplyRspBOS;
    }

    private String hex2Str(String str) {
        String temp = String.valueOf(HexUtils.encodeHex(str.getBytes(), false));
        String result = temp.replace("C2A0", "20");
        return new String(HexUtils.decodeHex(result.toCharArray()));
    }
}

