/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.aisino.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.active.app.ability.ActQryActivitiesByConditionAbilityService;
import com.tydic.order.pec.bo.pay.UocPebUpdateBillStatusReqBO;
import com.tydic.pfscext.api.aisino.BusiBillDownloadZPService;
import com.tydic.pfscext.api.aisino.FscSendApplyAdviceMsgService;
import com.tydic.pfscext.api.aisino.bo.BusiBillDownloadReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiBillDownloadRspBO;
import com.tydic.pfscext.api.aisino.bo.SendApplyAdviceMsgReqBO;
import com.tydic.pfscext.api.busi.BusiCreateOutstockInfoService;
import com.tydic.pfscext.api.busi.FscOssUploadFileService;
import com.tydic.pfscext.api.busi.bo.BusiCreateOutstockInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCreateOutstockInfoRspBO;
import com.tydic.pfscext.api.busi.bo.FscOssUploadFileReqBO;
import com.tydic.pfscext.api.busi.bo.FscOssUploadFileRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillChildApplyInfoMapper;
import com.tydic.pfscext.dao.OutstockInfoMapper;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.PushErpLogMapper;
import com.tydic.pfscext.dao.SaleBillInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceDetailMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyChildInfo;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.OutstockInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceDetail;
import com.tydic.pfscext.dao.po.SaleInvoiceDetailCheckPO;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.dao.vo.OutstockInfoVO;
import com.tydic.pfscext.dao.vo.PayOrderInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.SendApplyAdviceType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.aisino.api.BillDownloadExternalService;
import com.tydic.pfscext.external.aisino.api.BillItemInfoDownloadExtService;
import com.tydic.pfscext.external.aisino.api.SajtIssueInvoiceExternalService;
import com.tydic.pfscext.external.aisino.api.bo.BillItemBO;
import com.tydic.pfscext.external.aisino.api.bo.BillItemInfoExtReqBO;
import com.tydic.pfscext.external.aisino.api.bo.BillItemInfoExtRspBO;
import com.tydic.pfscext.external.aisino.api.bo.BuisSajtIssueInvoiceDetailsBO;
import com.tydic.pfscext.external.aisino.api.bo.ContentBO;
import com.tydic.pfscext.external.aisino.api.bo.FpkjxxFptxxNewBO;
import com.tydic.pfscext.external.aisino.api.bo.GlobalInfoBO;
import com.tydic.pfscext.external.aisino.api.bo.SajtIssueInvoiceExternalReqBO;
import com.tydic.pfscext.external.aisino.api.bo.SajtIssueInvoiceExternalRspBO;
import com.tydic.pfscext.external.api.bo.BillDownloadPushErpInfo;
import com.tydic.pfscext.external.api.bo.BillDownloadPushErpInfoBO;
import com.tydic.pfscext.external.uoc.api.FscUocPebUpdateBillStatusExternalService;
import com.tydic.pfscext.service.busi.BusiPushErpBillService;
import com.tydic.pfscext.service.busi.bo.BusiBillPushErpRspBO;
import com.tydic.pfscext.service.busi.bo.BusiPushErpBillReqBO;
import com.tydic.pfscext.service.busi.bo.BusiPushErpSaleOrderChangeBO;
import com.tydic.pfscext.service.busi.bo.BusiPushErpYsReqBO;
import com.tydic.pfscext.service.busi.bo.BusiPushErpYsRspBO;
import com.tydic.pfscext.utils.DateUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.aisino.BusiBillDownloadZPService"})
public class BusiBillDownloadServiceZPImpl
implements BusiBillDownloadZPService {
    private static final Logger log = LoggerFactory.getLogger(BusiBillDownloadServiceZPImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private BillDownloadExternalService billDownloadExternalService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleBillInfoMapper saleBillInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private BillItemInfoDownloadExtService billItemInfoDownloadExtService;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillChildApplyInfoMapper billChildApplyInfoMapper;
    private boolean isBusy = false;
    @Autowired
    private SajtIssueInvoiceExternalService sajtIssueInvoiceExternalService;
    @Autowired
    private BusiCreateOutstockInfoService busiCreateOutstockInfoService;
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;
    @Autowired
    private FscOssUploadFileService fscOssUploadFileService;
    @Autowired
    private FscSendApplyAdviceMsgService fscSendApplyAdviceMsgService;
    @Autowired
    private FscUocPebUpdateBillStatusExternalService fscUocPebUpdateBillStatusExternalService;
    @Autowired
    private ActQryActivitiesByConditionAbilityService actQryActivitiesByConditionAbilityService;
    @Autowired
    private BusiPushErpBillService busiPushErpBillService;
    @Autowired
    private PushErpLogMapper pushErpLogMapper;
    @Value(value="${taxCode}")
    private String taxCode;
    @Value(value="${clientId}")
    private String clientId;
    @Value(value="${taxNr}")
    private String taxNr;
    @Value(value="${orgnCode}")
    private String orgnCode;
    @Value(value="${version}")
    private String version;
    @Value(value="${branchNr}")
    private String branchNr;
    @Value(value="${issueMethod}")
    private String issueMethod;
    @Value(value="${password}")
    private String password;
    @Value(value="${queryMethod}")
    private String queryMethod;
    @Value(value="${maxAmount:100000}")
    private String maxAmountStr;
    @Value(value="${maxNum:1000}")
    private int maxNum;
    @Value(value="${authorizationCode}")
    private String authorizationCode;
    @Value(value="${FSC_PUSH_ERP_OLD_ORDER_TIME:2022-08-30 20:34:38}")
    private String pushErpOldOrderTime;
    @Value(value="${UNC_MESSAGE_SENDING_FLAG:0}")
    private String UNC_MESSAGE_SENDING_FLAG;

    @PostMapping(value={"billDownloadExternal"})
    public BusiBillDownloadRspBO billDownloadExternal(@RequestBody BusiBillDownloadReqBO reqBO) {
        this.isBusy = true;
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u53d1\u7968\u6570\u636e\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + reqBO.toString());
        }
        try {
            if (StringUtils.isEmpty((Object)reqBO.getApplyNo())) {
                BusiBillDownloadRspBO busiBillDownloadRspBO = this.process();
                return busiBillDownloadRspBO;
            }
            this.updateData(reqBO.getApplyNo());
            BusiBillDownloadRspBO busiBillDownloadRspBO = this.getInvoicesAgain(reqBO.getApplyNo());
            return busiBillDownloadRspBO;
        }
        finally {
            this.isBusy = false;
        }
    }

    private BusiBillDownloadRspBO process() {
        BusiBillDownloadRspBO rspBO = null;
        try {
            rspBO = new BusiBillDownloadRspBO();
            BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
            HashSet<String> BillStatusSet = new HashSet<String>();
            BillStatusSet.add("02");
            BillStatusSet.add("88");
            billApplyInfoVO.setBillStatusSet(BillStatusSet);
            billApplyInfoVO.setInvoiceType("2");
            List<BillApplyInfo> billApplyInfoList = this.billApplyInfoMapper.getNeedApplyList(billApplyInfoVO);
            if (billApplyInfoList.isEmpty()) {
                log.debug("\u65e0\u5f00\u7968\u72b6\u6001\u4e3a02(\u5f00\u7968\u4e2d)\u7684\u8bb0\u5f55,\u7a0b\u5e8f\u9000\u51fa");
                return rspBO;
            }
            if (billApplyInfoList != null && billApplyInfoList.size() > 0) {
                for (BillApplyInfo billApplyInfo : billApplyInfoList) {
                    this.dealInvoiceInfo(billApplyInfo, rspBO);
                }
            }
        }
        catch (PfscExtBusinessException e) {
            log.error("\u65b0\u589e\u53d1\u7968\u548c\u53d1\u7968\u660e\u7ec6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u65b0\u589e\u53d1\u7968\u548c\u53d1\u7968\u660e\u7ec6\u5931\u8d25", e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void updateUocBillStatus(String applyNo, OrderStatus orderStatus) {
        List orderIds;
        if (StrUtil.isBlank((CharSequence)applyNo)) {
            log.error("\u7533\u8bf7\u5355\u53f7\u4e3a\u7a7a");
            return;
        }
        List<SaleOrderInfo> orderInfos = this.saleOrderInfoMapper.getModelByApplyNo(applyNo);
        if (!CollectionUtils.isEmpty(orderInfos) && !CollectionUtils.isEmpty(orderIds = orderInfos.stream().map(SaleOrderInfo::getOrderId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            UocPebUpdateBillStatusReqBO updateBillStatusReqBO = new UocPebUpdateBillStatusReqBO();
            updateBillStatusReqBO.setOrderIds(orderIds);
            updateBillStatusReqBO.setBillState(Integer.valueOf(orderStatus.getCode()));
            this.fscUocPebUpdateBillStatusExternalService.updateBillStatus(updateBillStatusReqBO);
        }
    }

    @PostMapping(value={"isBusy"})
    public boolean isBusy() {
        return this.isBusy;
    }

    private BusiBillDownloadRspBO getInvoicesAgain(String applyNo) {
        log.error("\u7eb8\u7968\u91cd\u65b0\u83b7\u53d6\u53d1\u7968\u7533\u8bf7\u5355\uff1a" + applyNo);
        BusiBillDownloadRspBO rspBO = new BusiBillDownloadRspBO();
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo != null) {
            this.dealInvoiceInfo(billApplyInfo, rspBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealInvoiceInfo(BillApplyInfo billApplyInfo, BusiBillDownloadRspBO rspBO) {
        BusiPushErpYsReqBO pushErpReqBO = new BusiPushErpYsReqBO();
        BusiPushErpBillReqBO pushErpOldReqBO = new BusiPushErpBillReqBO();
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getModelByApplyNo(billApplyInfo.getApplyNo());
        boolean needPushErp = true;
        LinkedList<Long> inspectionIdList = new LinkedList<Long>();
        LinkedList<BusiPushErpSaleOrderChangeBO> changeBOList = new LinkedList<BusiPushErpSaleOrderChangeBO>();
        HashMap<Long, String> mapOrderIdTaxNo = new HashMap<Long, String>();
        LinkedList<String> saleOrderCodeList = new LinkedList<String>();
        boolean isPushErpOldCode = true;
        for (SaleOrderInfo orderInfo : saleOrderInfoList) {
            Date pushErpOldOrderTimeDate;
            saleOrderCodeList.add(orderInfo.getSaleOrderCode());
            inspectionIdList.add(orderInfo.getInspectionId());
            mapOrderIdTaxNo.put(orderInfo.getOrderId(), Optional.ofNullable(orderInfo.getTaxNo()).orElse(""));
            if (orderInfo.getIsErp() == null || !"1".equals(orderInfo.getIsErp())) {
                needPushErp = false;
                break;
            }
            if (!billApplyInfo.getInvoceName().equals(orderInfo.getInvoceName())) {
                BusiPushErpSaleOrderChangeBO changeBO = new BusiPushErpSaleOrderChangeBO();
                changeBO.setMallDocNo(orderInfo.getSaleOrderCode());
                changeBO.setUpCustomer(billApplyInfo.getTaxNo());
                changeBOList.add(changeBO);
            }
            if ((pushErpOldOrderTimeDate = DateUtil.strToDate(this.pushErpOldOrderTime, "yyyy-MM-dd HH:mm:ss")) != null && orderInfo.getRecvDate() != null) {
                if (pushErpOldOrderTimeDate.getTime() >= orderInfo.getRecvDate().getTime()) continue;
                isPushErpOldCode = false;
                continue;
            }
            isPushErpOldCode = false;
        }
        if (needPushErp) {
            pushErpReqBO.setInspectionIdList(inspectionIdList);
            pushErpReqBO.setApplyNo(billApplyInfo.getApplyNo());
            if (isPushErpOldCode) {
                pushErpOldReqBO.setInspectionIdList(inspectionIdList);
                pushErpOldReqBO.setApplyNo(billApplyInfo.getApplyNo());
                pushErpOldReqBO.setSaleOrderChangeBOList(changeBOList);
            }
        }
        LinkedList<BillDownloadPushErpInfoBO> ysList = new LinkedList<BillDownloadPushErpInfoBO>();
        BillApplyChildInfo childInfo = new BillApplyChildInfo();
        childInfo.setApplyNo(billApplyInfo.getApplyNo());
        childInfo.setStatus(0);
        int successCount = 0;
        List<BillApplyChildInfo> billApplyChildInfos = this.billChildApplyInfoMapper.selectChildList(childInfo);
        if (billApplyChildInfos.size() > 0) {
            BillApplyInfo billApply;
            BillDownloadPushErpInfoBO pushErpInfoBO = new BillDownloadPushErpInfoBO();
            TreeSet<String> idList = new TreeSet<String>();
            for (BillApplyChildInfo billApplyChildInfo : billApplyChildInfos) {
                if (InvoiceType.NORMAL.getCode().toString().equals(billApplyChildInfo.getInvoiceType())) {
                    successCount = this.billDownLoadElcInvoice(successCount, billApplyChildInfo);
                    continue;
                }
                SajtIssueInvoiceExternalReqBO sajtIssueInvoiceExternalReqBO1 = new SajtIssueInvoiceExternalReqBO();
                sajtIssueInvoiceExternalReqBO1.setMethod(this.queryMethod);
                sajtIssueInvoiceExternalReqBO1.setBranchNr(this.branchNr);
                sajtIssueInvoiceExternalReqBO1.setClientId(this.clientId);
                sajtIssueInvoiceExternalReqBO1.setOrgnCode(this.orgnCode);
                sajtIssueInvoiceExternalReqBO1.setPassword(this.password);
                sajtIssueInvoiceExternalReqBO1.setTaxNr(this.taxNr);
                sajtIssueInvoiceExternalReqBO1.setVersion(this.version);
                ContentBO contentBO = new ContentBO();
                contentBO.setNr(billApplyChildInfo.getSkNr());
                contentBO.setCode(billApplyChildInfo.getSkCode());
                contentBO.setInvType(billApplyChildInfo.getInvType());
                String Str1 = JSONObject.toJSONString((Object)contentBO);
                sajtIssueInvoiceExternalReqBO1.setContent(Str1);
                SajtIssueInvoiceExternalRspBO sajtIssueInvoiceExternalRspBO1 = this.sajtIssueInvoiceExternalService.sajtIssueInvoiceExternal(sajtIssueInvoiceExternalReqBO1);
                log.info("\u7eb8\u7968\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u51fa\u53c2:" + sajtIssueInvoiceExternalRspBO1.toString());
                if (!"0000".equals(sajtIssueInvoiceExternalRspBO1.getRespCode())) {
                    log.error("\u7eb8\u7968\u5f00\u7968\u5931\u8d25\u5355\u53f7:" + billApplyChildInfo.getChildApplyNo());
                    billApplyChildInfo.setStatus(0);
                    billApplyChildInfo.setSkMsg(sajtIssueInvoiceExternalRspBO1.getRespDesc());
                    billApplyChildInfo.setChildApplyNo(billApplyChildInfo.getChildApplyNo());
                    this.billChildApplyInfoMapper.updateByPrimaryKey(billApplyChildInfo);
                    continue;
                }
                SaleInvoiceInfo saleInvoiceInfo = new SaleInvoiceInfo();
                saleInvoiceInfo.setInvoiceNo(sajtIssueInvoiceExternalRspBO1.getNr());
                billApplyChildInfo.setInvoiceNo(sajtIssueInvoiceExternalRspBO1.getNr());
                saleInvoiceInfo.setInvoiceCode(sajtIssueInvoiceExternalRspBO1.getCode());
                billApplyChildInfo.setInvoiceCode(sajtIssueInvoiceExternalRspBO1.getCode());
                saleInvoiceInfo.setInvoiceDate(new Date(Long.valueOf(sajtIssueInvoiceExternalRspBO1.getIssueDate())));
                billApplyChildInfo.setInvoiceDate(saleInvoiceInfo.getInvoiceDate());
                saleInvoiceInfo.setApplyNo(billApplyInfo.getApplyNo());
                saleInvoiceInfo.setElectronicInvoiceName(billApplyInfo.getApplyNo() + "\u7eb8\u8d28\u53d1\u7968");
                BigDecimal values = BigDecimal.ZERO;
                BigDecimal taxs = BigDecimal.ZERO;
                for (BuisSajtIssueInvoiceDetailsBO detailsBO : sajtIssueInvoiceExternalRspBO1.getItems()) {
                    BigDecimal taxs1;
                    BigDecimal values1;
                    values = values1 = values.add(detailsBO.getValue());
                    taxs = taxs1 = taxs.add(detailsBO.getTax());
                }
                saleInvoiceInfo.setUntaxAmt(values);
                saleInvoiceInfo.setTaxAmt(taxs);
                saleInvoiceInfo.setAmt(saleInvoiceInfo.getUntaxAmt().add(saleInvoiceInfo.getTaxAmt()));
                saleInvoiceInfo.setInvoiceStatus("1");
                saleInvoiceInfo.setElectronicInvoiceUrl("");
                saleInvoiceInfo.setName(sajtIssueInvoiceExternalRspBO1.getCustomerName());
                saleInvoiceInfo.setTaxNo(sajtIssueInvoiceExternalRspBO1.getCustomerTaxNr());
                String[] addrandtel = sajtIssueInvoiceExternalRspBO1.getCustomerAddressTel().split("\\s");
                saleInvoiceInfo.setPhone(addrandtel[addrandtel.length - 1]);
                StringBuilder addr = new StringBuilder();
                for (int i = 0; i < addrandtel.length - 1; ++i) {
                    addr.append(addrandtel[i]);
                }
                saleInvoiceInfo.setAddress(addr.toString());
                String[] nameandcount = sajtIssueInvoiceExternalRspBO1.getCustomerBankAccount().split("\\s");
                saleInvoiceInfo.setBankAcNo(nameandcount[1]);
                saleInvoiceInfo.setBankName(nameandcount[0]);
                saleInvoiceInfo.setTaxAmt(taxs);
                saleInvoiceInfo.setInvoiceType(InvoiceType.SPECIAL.getCode());
                this.saleInvoiceInfoMapper.deleteByPrimaryKey(saleInvoiceInfo.getInvoiceNo());
                this.saleInvoiceInfoMapper.insertSelective(saleInvoiceInfo);
                if (needPushErp) {
                    pushErpInfoBO.setCustCode(saleInvoiceInfo.getTaxNo());
                    pushErpInfoBO.setInvoiceNum(saleInvoiceInfo.getInvoiceNo());
                    pushErpInfoBO.setInvoiceDate(DateUtil.dateToStr(saleInvoiceInfo.getInvoiceDate(), "yyyy-MM-dd"));
                    pushErpInfoBO.setInvoiceCode(saleInvoiceInfo.getInvoiceCode());
                    pushErpInfoBO.setPlatformSign("1");
                }
                List<SaleItemInfo> saleItemInfos = this.saleItemInfoMapper.selectByApplyNoAndOrderId(billApplyInfo.getApplyNo(), null, null);
                HashMap<Long, String> map = new HashMap<Long, String>();
                for (SaleItemInfo saleItemInfo : saleItemInfos) {
                    map.put(saleItemInfo.getSeq(), saleItemInfo.getSkuName());
                }
                if (sajtIssueInvoiceExternalRspBO1 != null && sajtIssueInvoiceExternalRspBO1.getItems() != null && sajtIssueInvoiceExternalRspBO1.getItems().size() > 0) {
                    for (BuisSajtIssueInvoiceDetailsBO fpmxxzXmxx : sajtIssueInvoiceExternalRspBO1.getItems()) {
                        SaleInvoiceDetail saleInvoiceDetail = new SaleInvoiceDetail();
                        saleInvoiceDetail.setItemName(fpmxxzXmxx.getProductName());
                        saleInvoiceDetail.setSpecModel(fpmxxzXmxx.getSpec());
                        saleInvoiceDetail.setUnitName(fpmxxzXmxx.getUnit());
                        if (fpmxxzXmxx.getGoodsNo() != null) {
                            saleInvoiceDetail.setItemSeq(Long.parseLong(fpmxxzXmxx.getGoodsNo()));
                        }
                        saleInvoiceDetail.setQuantity(fpmxxzXmxx.getQuantity());
                        saleInvoiceDetail.setUntaxAmt(fpmxxzXmxx.getValue());
                        saleInvoiceDetail.setTaxAmt(fpmxxzXmxx.getTax());
                        saleInvoiceDetail.setAmount(saleInvoiceDetail.getUntaxAmt().add(saleInvoiceDetail.getTaxAmt()));
                        if (fpmxxzXmxx.getTaxRate() != null) {
                            saleInvoiceDetail.setTaxRate(fpmxxzXmxx.getTaxRate());
                        }
                        saleInvoiceDetail.setTaxClassCode(fpmxxzXmxx.getGoodsTaxNo());
                        saleInvoiceDetail.setInvoiceNo(sajtIssueInvoiceExternalRspBO1.getNr());
                        saleInvoiceDetail.setSaleUnitPrice(fpmxxzXmxx.getPrice());
                        this.saleInvoiceDetailMapper.insertSelective(saleInvoiceDetail);
                    }
                    if (needPushErp) {
                        List<SaleInvoiceDetailCheckPO> invoiceDetailList = this.saleInvoiceDetailMapper.getSaleInvoiceInspectionIds(billApplyInfo.getApplyNo(), pushErpInfoBO.getInvoiceNum(), pushErpInfoBO.getInvoiceCode(), DateUtil.strToDate(pushErpInfoBO.getInvoiceDate(), "yyyy-MM-dd"));
                        if (mapOrderIdTaxNo.size() > 1) {
                            Map<Long, List<SaleInvoiceDetailCheckPO>> mapInvoiceDetail = invoiceDetailList.stream().collect(Collectors.groupingBy(SaleInvoiceDetailCheckPO::getOrderId));
                            int index = 1;
                            for (Map.Entry<Long, List<SaleInvoiceDetailCheckPO>> entry : mapInvoiceDetail.entrySet()) {
                                Long orderId = entry.getKey();
                                List<SaleInvoiceDetailCheckPO> orderInvoiceDetailList = entry.getValue();
                                BillDownloadPushErpInfoBO subPushErpInfoBO = new BillDownloadPushErpInfoBO();
                                BeanUtils.copyProperties((Object)pushErpInfoBO, (Object)subPushErpInfoBO);
                                subPushErpInfoBO.setCustCode((String)mapOrderIdTaxNo.get(orderId));
                                subPushErpInfoBO.setInvoiceNum(pushErpInfoBO.getInvoiceNum() + "-" + index);
                                subPushErpInfoBO.setInvoiceCode(pushErpInfoBO.getInvoiceCode() + "-" + index);
                                ArrayList<BillDownloadPushErpInfo> pushErpInfoList = new ArrayList<BillDownloadPushErpInfo>();
                                for (SaleInvoiceDetailCheckPO invoiceDetail : orderInvoiceDetailList) {
                                    BillDownloadPushErpInfo pushErpInfo = new BillDownloadPushErpInfo();
                                    pushErpInfo.setQty(new BigDecimal(invoiceDetail.getInvoiceQuantity()));
                                    pushErpInfo.setTaxMoney(invoiceDetail.getTaxAmt());
                                    pushErpInfo.setNoTaxMoney(invoiceDetail.getUntaxAmt());
                                    pushErpInfo.setTotalMoney(invoiceDetail.getInvoiceAmount());
                                    pushErpInfo.setTaxPrice(new BigDecimal(invoiceDetail.getOrderSaleUnitPrice()));
                                    idList.add(invoiceDetail.getInspectionId());
                                    pushErpInfo.setSrcDocNo(invoiceDetail.getInspectionId());
                                    pushErpInfo.setSrcorderitemid(invoiceDetail.getItemNo());
                                    pushErpInfo.setOrderitemid(invoiceDetail.getPurchaseItemNo());
                                    pushErpInfoList.add(pushErpInfo);
                                }
                                subPushErpInfoBO.setRows(pushErpInfoList);
                                subPushErpInfoBO.setInspectionIdList(idList);
                                ysList.add(subPushErpInfoBO);
                                ++index;
                            }
                        } else {
                            pushErpInfoBO.setCustCode((String)mapOrderIdTaxNo.entrySet().iterator().next().getValue());
                            ArrayList<BillDownloadPushErpInfo> pushErpInfoList = new ArrayList<BillDownloadPushErpInfo>();
                            for (SaleInvoiceDetailCheckPO invoiceDetail : invoiceDetailList) {
                                BillDownloadPushErpInfo pushErpInfo = new BillDownloadPushErpInfo();
                                pushErpInfo.setQty(new BigDecimal(invoiceDetail.getInvoiceQuantity()));
                                pushErpInfo.setTaxMoney(invoiceDetail.getTaxAmt());
                                pushErpInfo.setNoTaxMoney(invoiceDetail.getUntaxAmt());
                                pushErpInfo.setTotalMoney(invoiceDetail.getInvoiceAmount());
                                pushErpInfo.setTaxPrice(new BigDecimal(invoiceDetail.getOrderSaleUnitPrice()));
                                idList.add(invoiceDetail.getInspectionId());
                                pushErpInfo.setSrcDocNo(invoiceDetail.getInspectionId());
                                pushErpInfo.setSrcorderitemid(invoiceDetail.getItemNo());
                                pushErpInfo.setOrderitemid(invoiceDetail.getPurchaseItemNo());
                                pushErpInfoList.add(pushErpInfo);
                            }
                            pushErpInfoBO.setRows(pushErpInfoList);
                            pushErpInfoBO.setInspectionIdList(idList);
                            ysList.add(pushErpInfoBO);
                        }
                    }
                }
                billApplyChildInfo.setStatus(1);
                billApplyChildInfo.setChildApplyNo(billApplyChildInfo.getChildApplyNo());
                int i = this.billChildApplyInfoMapper.updateByPrimaryKey(billApplyChildInfo);
                if (i <= 0) continue;
                ++successCount;
            }
            if (successCount == billApplyChildInfos.size()) {
                billApply = new BillApplyInfo();
                billApply.setBillStatus("03");
                billApply.setApplyNo(billApplyInfo.getApplyNo());
                billApply.setReceiveDate(new Date());
                billApply.setInvoiceRemark(this.getWordCount(((Object)saleOrderCodeList).toString(), 200));
                this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
                PayOrderInfoVO payOrderInfoVO = new PayOrderInfoVO();
                payOrderInfoVO.setPayOrderStatus("6");
                ArrayList<String> applyNoList = new ArrayList<String>();
                applyNoList.add(billApplyInfo.getApplyNo());
                payOrderInfoVO.setApplyNoList(applyNoList);
                this.payOrderInfoMapper.updateForBillApply(payOrderInfoVO);
                this.saleOrderInfoMapper.updateStatusByApplyNo(billApplyInfo.getApplyNo(), "02");
                BusiCreateOutstockInfoRspBO busiCreateOutstockInfoRspBO = null;
                try {
                    OutstockInfoVO outstockInfoVO = new OutstockInfoVO();
                    outstockInfoVO.setApplyNo(billApplyInfo.getApplyNo());
                    OutstockInfo outstockInfo = this.outstockInfoMapper.selectSelective(outstockInfoVO);
                    if (outstockInfo == null) {
                        log.debug("\u51c6\u5907\u4ea7\u751f\u51fa\u5e93\u5355\u53f7,\u901a\u77e5\u5355\u53f7=" + billApplyInfo.getApplyNo());
                        BusiCreateOutstockInfoReqBO busiCreateOutstockInfoReqBO = new BusiCreateOutstockInfoReqBO();
                        busiCreateOutstockInfoReqBO.setApplyNo(billApplyInfo.getApplyNo());
                        busiCreateOutstockInfoReqBO.setWriteoffAmt(BigDecimal.ZERO);
                        busiCreateOutstockInfoReqBO.setUserId(billApplyInfo.getUserId());
                        busiCreateOutstockInfoRspBO = this.busiCreateOutstockInfoService.addOutstockInfo(busiCreateOutstockInfoReqBO);
                    }
                }
                catch (Exception e) {
                    log.error("\u4ea7\u751f\u51fa\u5e93\u5355\u5f02\u5e38\uff1a" + billApplyInfo.getApplyNo(), (Throwable)e);
                    throw new PfscExtBusinessException(busiCreateOutstockInfoRspBO.getRespCode(), busiCreateOutstockInfoRspBO.getRespDesc());
                }
                if (needPushErp) {
                    Serializable busiBillPushErpRspBO;
                    if (isPushErpOldCode) {
                        pushErpOldReqBO.setYsList(ysList);
                        busiBillPushErpRspBO = this.busiPushErpBillService.pushErp(pushErpOldReqBO);
                        if (!((BusiBillPushErpRspBO)busiBillPushErpRspBO).getRespCode().equals("0000")) {
                            rspBO.setFailLog(((BusiBillPushErpRspBO)busiBillPushErpRspBO).getRespDesc());
                        }
                    } else {
                        pushErpReqBO.setYsList(ysList);
                        busiBillPushErpRspBO = this.busiPushErpBillService.pushErpYs(pushErpReqBO);
                        if (!((BusiPushErpYsRspBO)busiBillPushErpRspBO).getRespCode().equals("0000")) {
                            rspBO.setFailLog(((BusiPushErpYsRspBO)busiBillPushErpRspBO).getRespDesc());
                        }
                    }
                }
                this.updateUocBillStatus(billApplyInfo.getApplyNo(), OrderStatus.SEND_BILL);
                if (!StringUtils.isEmpty((Object)billApplyInfo.getApplyNo()) && !StringUtils.isEmpty((Object)billApplyInfo.getPurchaseNo())) {
                    this.sendAdvice(billApplyInfo.getApplyNo(), billApplyInfo.getPurchaseNo());
                }
            } else if (successCount > 0) {
                billApply = new BillApplyInfo();
                billApply.setBillStatus("88");
                billApply.setApplyNo(billApplyInfo.getApplyNo());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
            }
        }
    }

    private void sendAdvice(String applyNo, Long purchaseNo) {
        try {
            if (!YesOrNo.YES.getCodeAsString().equals(this.UNC_MESSAGE_SENDING_FLAG)) {
                log.info("\u901a\u77e5\u914d\u7f6e\u4e0d\u53d1\u9001\u901a\u77e5\uff0c\u76f4\u63a5\u7ed3\u675f");
                return;
            }
            SendApplyAdviceMsgReqBO sendApplyAdviceMsgReqBO = new SendApplyAdviceMsgReqBO();
            sendApplyAdviceMsgReqBO.setBusinessDate(DateUtil.dateToStr(new Date()));
            sendApplyAdviceMsgReqBO.setNotificationNo(applyNo);
            sendApplyAdviceMsgReqBO.setOrgId(purchaseNo);
            sendApplyAdviceMsgReqBO.setTemplateName("\u5f85\u6536\u7968\u7ed3\u7b97\u901a\u77e5");
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setApplyNo(applyNo);
            List<SaleOrderInfo> listByApplyNo = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
            if (CollectionUtils.isEmpty(listByApplyNo)) {
                throw new PfscExtBusinessException("18003", "\u672a\u67e5\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f!");
            }
            if (StringUtils.isEmpty((Object)listByApplyNo.get(0).getActivityId())) {
                sendApplyAdviceMsgReqBO.setTitle(SendApplyAdviceType.UNIFIED_SIGNATURE_DOWN_STAY_TICKET.getAdviceName());
                sendApplyAdviceMsgReqBO.setReceiverId(listByApplyNo.get(0).getPurchaserId());
            } else {
                sendApplyAdviceMsgReqBO.setTitle(SendApplyAdviceType.STAFF_STAY_TICKET.getAdviceName());
                sendApplyAdviceMsgReqBO.setActivityId(listByApplyNo.get(0).getActivityId());
            }
            this.fscSendApplyAdviceMsgService.sendApplyAdvice(sendApplyAdviceMsgReqBO);
        }
        catch (Exception e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38\uff0c\u53d1\u9001\u5f85\u6536\u7968\u901a\u77e5\u5931\u8d25\uff01");
        }
    }

    private int billDownLoadElcInvoice(int successCount, BillApplyChildInfo billApplyChildInfo) {
        GlobalInfoBO globalInfo = new GlobalInfoBO();
        globalInfo.setTerminalCode("0");
        globalInfo.setAppId("DZFP");
        globalInfo.setTaxpayerId(this.taxCode);
        globalInfo.setAuthorizationCode(this.authorizationCode);
        FpkjxxFptxxNewBO fpkjxxFptxxNew = new FpkjxxFptxxNewBO();
        fpkjxxFptxxNew.setDDH(billApplyChildInfo.getChildApplyNo());
        fpkjxxFptxxNew.setFPQQLSH(billApplyChildInfo.getChildApplyNo());
        fpkjxxFptxxNew.setNSRSBH(this.taxCode);
        fpkjxxFptxxNew.setPDF_XZFS("3");
        BillItemInfoExtReqBO billItemInfoExtReqBO = new BillItemInfoExtReqBO();
        billItemInfoExtReqBO.setFpkjxxFptxxNew(fpkjxxFptxxNew);
        billItemInfoExtReqBO.setGlobalInfo(globalInfo);
        BillItemInfoExtRspBO billItemInfoExtRspBO = this.billItemInfoDownloadExtService.billItemInfoExt(billItemInfoExtReqBO);
        if (billItemInfoExtRspBO != null && "0000".equals(billItemInfoExtRspBO.getRespCode())) {
            BillApplyChildInfo billApplyChildInfo1 = new BillApplyChildInfo();
            if (billItemInfoExtRspBO.getRESPONSE_FPMXXZ() != null) {
                SaleInvoiceInfo saleInvoiceInfo = new SaleInvoiceInfo();
                billApplyChildInfo1.setInvoiceCode(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_DM());
                billApplyChildInfo1.setInvoiceNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_HM());
                billApplyChildInfo1.setInvoiceDate(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKPRQ());
                saleInvoiceInfo.setInvoiceNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_HM());
                saleInvoiceInfo.setInvoiceCode(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_DM());
                saleInvoiceInfo.setInvoiceDate(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKPRQ());
                saleInvoiceInfo.setApplyNo(billApplyChildInfo.getApplyNo());
                saleInvoiceInfo.setUntaxAmt(new BigDecimal(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getHJBHSJE()));
                saleInvoiceInfo.setTaxAmt(new BigDecimal(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKPHJSE()));
                saleInvoiceInfo.setAmt(saleInvoiceInfo.getUntaxAmt().add(saleInvoiceInfo.getTaxAmt()));
                saleInvoiceInfo.setInvoiceStatus("1");
                FscOssUploadFileReqBO fscOssUploadFileReqBO = new FscOssUploadFileReqBO();
                fscOssUploadFileReqBO.setFileName(saleInvoiceInfo.getInvoiceNo() + "_" + saleInvoiceInfo.getInvoiceCode() + ".pdf");
                fscOssUploadFileReqBO.setBusinessId("FSC");
                fscOssUploadFileReqBO.setBase64Img(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getPDF_FILE());
                FscOssUploadFileRspBO fscOssUploadFileRspBO = this.fscOssUploadFileService.uploadFile(fscOssUploadFileReqBO);
                if (fscOssUploadFileRspBO != null && "0000".equals(fscOssUploadFileRspBO.getRespCode())) {
                    saleInvoiceInfo.setElectronicInvoiceUrl(fscOssUploadFileRspBO.getFileUrl());
                } else {
                    saleInvoiceInfo.setElectronicInvoiceUrl(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getPDF_URL());
                }
                saleInvoiceInfo.setElectronicInvoiceName(billApplyChildInfo.getChildApplyNo() + "\u7535\u5b50\u53d1\u7968");
                saleInvoiceInfo.setName(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHFMC());
                saleInvoiceInfo.setTaxNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_NSRSBH());
                saleInvoiceInfo.setAddress(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_DZDH());
                saleInvoiceInfo.setInvoiceType(InvoiceType.NORMAL.getCode());
                if (billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_DZDH() != null && billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_DZDH().contains(" ")) {
                    saleInvoiceInfo.setAddress(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_DZDH().split(" ")[0]);
                }
                saleInvoiceInfo.setPhone(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_SJ());
                saleInvoiceInfo.setBankAcNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH());
                saleInvoiceInfo.setBankName(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH());
                if (billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH() != null && billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH().contains(" ")) {
                    saleInvoiceInfo.setBankAcNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH().split(" ")[1]);
                    saleInvoiceInfo.setBankName(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH().split(" ")[0]);
                }
                if (billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKCE() != null) {
                    saleInvoiceInfo.setTaxAmt(new BigDecimal(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKPHJSE()));
                }
                this.saleInvoiceInfoMapper.deleteByPrimaryKey(saleInvoiceInfo.getInvoiceNo());
                this.saleInvoiceInfoMapper.insertSelective(saleInvoiceInfo);
            }
            List<SaleItemInfo> saleItemInfos = this.saleItemInfoMapper.selectByApplyNoAndOrderIdAndChild(null, null, null, billApplyChildInfo.getChildApplyNo());
            HashMap<Long, String> map = new HashMap<Long, String>();
            for (SaleItemInfo saleItemInfo : saleItemInfos) {
                map.put(saleItemInfo.getSeq(), saleItemInfo.getSkuName());
            }
            if (billItemInfoExtRspBO != null && billItemInfoExtRspBO.getFPMXXZ_XMXXS() != null && billItemInfoExtRspBO.getFPMXXZ_XMXXS().size() > 0) {
                for (BillItemBO fpmxxzXmxx : billItemInfoExtRspBO.getFPMXXZ_XMXXS()) {
                    SaleInvoiceDetail saleInvoiceDetail = new SaleInvoiceDetail();
                    if (map.get(fpmxxzXmxx.getZXBM()) != null) {
                        saleInvoiceDetail.setItemName((String)map.get(fpmxxzXmxx.getZXBM()));
                    } else {
                        saleInvoiceDetail.setItemName(fpmxxzXmxx.getXMMC());
                    }
                    saleInvoiceDetail.setSpecModel(fpmxxzXmxx.getGGXH());
                    saleInvoiceDetail.setUnitName(fpmxxzXmxx.getXMDW());
                    if (fpmxxzXmxx.getZXBM() != null) {
                        saleInvoiceDetail.setItemSeq(Long.parseLong(fpmxxzXmxx.getZXBM()));
                    }
                    saleInvoiceDetail.setQuantity(new BigDecimal(fpmxxzXmxx.getXMSL()));
                    saleInvoiceDetail.setUntaxAmt(new BigDecimal(fpmxxzXmxx.getXMJE()));
                    saleInvoiceDetail.setTaxAmt(new BigDecimal(fpmxxzXmxx.getSE()));
                    saleInvoiceDetail.setAmount(saleInvoiceDetail.getUntaxAmt().add(saleInvoiceDetail.getTaxAmt()));
                    saleInvoiceDetail.setTaxRate(new BigDecimal(fpmxxzXmxx.getSL()));
                    saleInvoiceDetail.setTaxClassCode(fpmxxzXmxx.getSWBM());
                    saleInvoiceDetail.setInvoiceNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_HM());
                    saleInvoiceDetail.setSaleUnitPrice(new BigDecimal(fpmxxzXmxx.getXMDJ()));
                    this.saleInvoiceDetailMapper.insertSelective(saleInvoiceDetail);
                }
            }
            billApplyChildInfo1.setChildApplyNo(billApplyChildInfo.getChildApplyNo());
            billApplyChildInfo1.setStatus(1);
            this.billChildApplyInfoMapper.updateByPrimaryKey(billApplyChildInfo1);
            ++successCount;
        } else {
            BillApplyChildInfo billApplyChildInfo1 = new BillApplyChildInfo();
            billApplyChildInfo1.setChildApplyNo(billApplyChildInfo.getChildApplyNo());
            billApplyChildInfo1.setStatus(0);
            billApplyChildInfo1.setSkMsg(billItemInfoExtRspBO.getRespDesc() == null ? " " : billItemInfoExtRspBO.getRespDesc());
            this.billChildApplyInfoMapper.updateByPrimaryKey(billApplyChildInfo1);
        }
        return successCount;
    }

    private void updateData(String applyNo) {
        List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectByApplyNoOrderBy(applyNo);
        if (!CollectionUtils.isEmpty(saleInvoiceInfoList)) {
            ArrayList<String> invoiceNos = new ArrayList<String>();
            for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfoList) {
                invoiceNos.add(saleInvoiceInfo.getInvoiceNo());
            }
            this.saleInvoiceInfoMapper.deleteByApplyNo(applyNo);
            this.billChildApplyInfoMapper.updateByApplyNo(applyNo);
            this.saleInvoiceDetailMapper.deleteByInvoiceNos(invoiceNos);
        }
        BillApplyInfo billApply = new BillApplyInfo();
        billApply.setApplyNo(applyNo);
        billApply.setBillStatus(BillStatus.SENDING_BILL.getCode());
        int update = this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
        if (update < 1) {
            throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u5f02\u5e38");
        }
    }

    private String getWordCount(String oldName, int len) {
        String newName = "";
        int oldNameLength = 0;
        char[] names = oldName.toCharArray();
        for (int i = 0; i < oldName.length(); ++i) {
            int ascii = Character.codePointAt(oldName, i);
            oldNameLength = ascii >= 0 && ascii <= 255 ? ++oldNameLength : (oldNameLength += 2);
            if (oldNameLength > len) continue;
            char c = names[i];
            newName = newName + c;
        }
        return newName;
    }
}

