/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.aisino.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.aisino.BusiBillManualObtainService;
import com.tydic.pfscext.api.aisino.BusiInvoiceIssueService;
import com.tydic.pfscext.api.aisino.bo.BusiBillManualObtainReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiBillManualObtainRspBO;
import com.tydic.pfscext.api.aisino.bo.BusiInvoiceIssueReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiInvoiceIssueRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailBillApplyInfoApplyRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailBillApplyInfoItemRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailBillApplyInfoOrderRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailBillApplyInfoReqBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillChildApplyInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceDetailMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyChildInfo;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.PayInvoiceDetail;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleItemInfoBatchVO;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.ApplyType;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.aisino.api.InvoiceIssueExternalService;
import com.tydic.pfscext.external.aisino.api.bo.BillItemBO;
import com.tydic.pfscext.external.aisino.api.bo.GlobalInfoBO;
import com.tydic.pfscext.external.aisino.api.bo.InvoiceIssueBO;
import com.tydic.pfscext.external.aisino.api.bo.InvoiceIssueExtReqBO;
import com.tydic.pfscext.external.aisino.api.bo.InvoiceIssueExtRspBO;
import com.tydic.pfscext.external.aisino.api.bo.OrderInfoBO;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.utils.HexUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.aisino.BusiInvoiceIssueService"})
public class BusiInvoiceIssueServiceImpl
implements BusiInvoiceIssueService {
    private static final Logger log = LoggerFactory.getLogger(BusiInvoiceIssueServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillChildApplyInfoMapper billChildApplyInfoMapper;
    @Autowired
    private InvoiceIssueExternalService invoiceIssueExternalService;
    @Value(value="${authorizationCode}")
    private String authorizationCode;
    @Value(value="${taxCode}")
    private String taxCode;
    @Value(value="${dsptbm}")
    private String dsptbm;
    @Value(value="${xsfaddr}")
    private String xsfaddr;
    @Value(value="${xsfbank}")
    private String xsfbank;
    @Value(value="${elcMaxAmount:100000}")
    private String maxAmountStr;
    @Value(value="${elcMaxNum:1000}")
    private int maxNum;
    private static final int MANUAL_OBTAIN_BILL = 1;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private BusiBillManualObtainService busiBillManualObtainService;

    @PostMapping(value={"invoiceIssue"})
    public BusiInvoiceIssueRspBO invoiceIssue(@RequestBody BusiInvoiceIssueReqBO busiInvoiceIssueReqBO) {
        log.info("\u5f00\u7968\u7533\u8bf7\u5355-\u7535\u7968\u63a8\u9001\u7a0e\u63a7\u63a5\u53e3\u5f00\u59cb\uff1a" + JSON.toJSONString((Object)busiInvoiceIssueReqBO));
        BusiInvoiceIssueRspBO rspBO = new BusiInvoiceIssueRspBO();
        try {
            List<BusiQueryDetailBillApplyInfoApplyRspBO> applyInfoApplyRspBOS;
            ArrayList<String> errMsg = new ArrayList<String>();
            String applyNo = busiInvoiceIssueReqBO.getApplyNo();
            BusiQueryDetailBillApplyInfoReqBO reqBO = new BusiQueryDetailBillApplyInfoReqBO();
            reqBO.setApplyNo(applyNo);
            if (busiInvoiceIssueReqBO.getInvoiceIssueType().equals(1)) {
                BusiBillManualObtainReqBO busiBillManualObtainReqBO = new BusiBillManualObtainReqBO();
                busiBillManualObtainReqBO.setApplyNo(applyNo);
                BusiBillManualObtainRspBO busiBillManualObtainRspBO = this.busiBillManualObtainService.manualObtainBill(busiBillManualObtainReqBO);
                if (!busiBillManualObtainRspBO.getRespCode().equals("0000")) {
                    throw new PfscExtBusinessException("8888", busiBillManualObtainRspBO.getRespDesc());
                }
                applyInfoApplyRspBOS = busiBillManualObtainRspBO.getBillApplyInfoApplyRspBOS();
            } else {
                BillApplyChildInfo billApplyChildInfoQry = new BillApplyChildInfo();
                billApplyChildInfoQry.setApplyNo(applyNo);
                List<BillApplyChildInfo> childApplyNoList = this.billChildApplyInfoMapper.selectChildList(billApplyChildInfoQry);
                applyInfoApplyRspBOS = CollectionUtils.isEmpty(childApplyNoList) ? this.queryByTaxGroup(reqBO) : this.queryFailChildApplyNo(childApplyNoList, applyNo);
            }
            log.info("\u5f00\u7968\u53c2\u6570:{}" + JSON.toJSONString(applyInfoApplyRspBOS));
            int counts = 0;
            for (BusiQueryDetailBillApplyInfoApplyRspBO applyRspBO : applyInfoApplyRspBOS) {
                BillApplyChildInfo billApplyChildInfo;
                InvoiceIssueExtReqBO invoiceIssueExtReqBO = new InvoiceIssueExtReqBO();
                InvoiceIssueBO fpkjxxFptxx = new InvoiceIssueBO();
                fpkjxxFptxx.setFPQQLSH(applyRspBO.getApplyNo());
                fpkjxxFptxx.setNSRSBH(this.taxCode);
                fpkjxxFptxx.setNSRMC(applyRspBO.getOperUnitName());
                fpkjxxFptxx.setDKBZ("0");
                fpkjxxFptxx.setKPXM("\u529e\u516c\u7528\u54c1");
                fpkjxxFptxx.setBMB_BBH("26");
                fpkjxxFptxx.setFJH("");
                fpkjxxFptxx.setNSRDZDAH("");
                fpkjxxFptxx.setDSPTBM(this.dsptbm);
                fpkjxxFptxx.setGHF_YHZH(applyRspBO.getBankName() + " " + applyRspBO.getBankAcctNo());
                fpkjxxFptxx.setSWJG_DM("");
                fpkjxxFptxx.setSGBZ("");
                fpkjxxFptxx.setPYDM("");
                fpkjxxFptxx.setXHF_DH("");
                fpkjxxFptxx.setGHF_NSRSBH("");
                fpkjxxFptxx.setGHF_DZ(applyRspBO.getAddr());
                fpkjxxFptxx.setGHF_SF("");
                fpkjxxFptxx.setGHF_SJ(applyRspBO.getPhone());
                fpkjxxFptxx.setGHF_EMAIL("");
                fpkjxxFptxx.setXHF_YHZH(this.xsfbank);
                fpkjxxFptxx.setHY_DM("");
                fpkjxxFptxx.setHY_MC("");
                fpkjxxFptxx.setSKY("\u9ad8\u8d8a");
                fpkjxxFptxx.setFHR("\u5b5f\u5e86\u9f99");
                fpkjxxFptxx.setKPRQ(applyRspBO.getApplyDate());
                fpkjxxFptxx.setXHF_NSRSBH(this.taxCode);
                fpkjxxFptxx.setYFP_DM("");
                fpkjxxFptxx.setYFP_HM("");
                fpkjxxFptxx.setTSCHBZ("");
                fpkjxxFptxx.setQDXMMC("");
                fpkjxxFptxx.setCHYY("");
                fpkjxxFptxx.setBZ(StrUtil.isBlank((CharSequence)applyRspBO.getInvoiceRemark()) ? "\u5907\u6ce8" : applyRspBO.getInvoiceRemark());
                fpkjxxFptxx.setBYZD1("");
                fpkjxxFptxx.setBYZD2("");
                fpkjxxFptxx.setBYZD3("");
                fpkjxxFptxx.setBYZD4("");
                fpkjxxFptxx.setBYZD5("");
                fpkjxxFptxx.setXHFMC(applyRspBO.getOperUnitName());
                fpkjxxFptxx.setXHF_DZ(this.xsfaddr);
                fpkjxxFptxx.setGHFMC(applyRspBO.getInvoceName());
                fpkjxxFptxx.setGHF_GDDH(applyRspBO.getPhone());
                fpkjxxFptxx.setGHF_NSRSBH(applyRspBO.getTaxNo());
                fpkjxxFptxx.setGHFQYLX("01");
                fpkjxxFptxx.setKPY("\u6881\u6829\u94ed");
                fpkjxxFptxx.setKPLX("1");
                fpkjxxFptxx.setCZDM("10");
                fpkjxxFptxx.setQD_BZ("0");
                fpkjxxFptxx.setKPHJJE(Double.valueOf(applyRspBO.getAmt().doubleValue()));
                BigDecimal taxAmt = applyRspBO.getAmt().divide(BigDecimal.ONE.add(new BigDecimal("0.06")), 5, 4).multiply(new BigDecimal("0.06")).setScale(2, 4);
                fpkjxxFptxx.setHJSE(Double.valueOf(taxAmt.doubleValue()));
                fpkjxxFptxx.setHJBHSJE(Double.valueOf(applyRspBO.getAmt().subtract(taxAmt).doubleValue()));
                GlobalInfoBO globalInfo = new GlobalInfoBO();
                globalInfo.setTerminalCode("0");
                if (applyRspBO != null && "2".equals(applyRspBO.getInvoiceType())) {
                    globalInfo.setAppId("ZZS_PT_DZFP");
                } else {
                    globalInfo.setAppId("DZFP");
                }
                globalInfo.setTaxpayerId(this.taxCode);
                globalInfo.setAuthorizationCode(this.authorizationCode);
                ArrayList<BillItemBO> fpkjxxXmxxs = new ArrayList<BillItemBO>();
                fpkjxxFptxx.setKPXM(((BusiQueryDetailBillApplyInfoItemRspBO)applyRspBO.getItemList().get(0)).getSkuName());
                for (BusiQueryDetailBillApplyInfoItemRspBO infoItemRspBO : applyRspBO.getItemList()) {
                    BillItemBO billItemBO = new BillItemBO();
                    if (!StringUtils.isEmpty((Object)infoItemRspBO.getSkuName())) {
                        billItemBO.setXMMC(this.getWordCount(infoItemRspBO.getSkuName()));
                    }
                    billItemBO.setHSBZ("1");
                    billItemBO.setXMDW(infoItemRspBO.getUnitName());
                    String ggxh = "";
                    if (infoItemRspBO.getModel() != null || infoItemRspBO.getSpec() != null) {
                        ggxh = infoItemRspBO.getSpec() + infoItemRspBO.getModel();
                    }
                    billItemBO.setGGXH(this.getWordCount(ggxh, 40));
                    if (infoItemRspBO.getQuantityApply() != null) {
                        billItemBO.setXMSL(infoItemRspBO.getQuantityApply().setScale(8).toString());
                    }
                    billItemBO.setKCE(Double.valueOf(0.0));
                    billItemBO.setSE(Double.valueOf(0.0));
                    billItemBO.setZXBM(infoItemRspBO.getSeq().toString());
                    if (new BigDecimal("0").compareTo(infoItemRspBO.getTaxRate()) == 0 && new BigDecimal("0").compareTo(infoItemRspBO.getTaxAmt()) == 0) {
                        billItemBO.setLSLBS("3");
                    } else {
                        billItemBO.setLSLBS("");
                    }
                    billItemBO.setZZSTSGL("");
                    billItemBO.setFPHXZ("0");
                    billItemBO.setXMDJ(Double.valueOf(infoItemRspBO.getSaleUnitPrice().doubleValue()));
                    if (infoItemRspBO.getTaxCatCode() != null) {
                        billItemBO.setSWBM(infoItemRspBO.getTaxCatCode().toString());
                        billItemBO.setSPBM(infoItemRspBO.getTaxCatCode().toString());
                    }
                    billItemBO.setYHZCBS("0");
                    billItemBO.setBYZD1("");
                    billItemBO.setBYZD2("");
                    billItemBO.setBYZD3("");
                    billItemBO.setBYZD4("");
                    billItemBO.setBYZD5("");
                    billItemBO.setXMJE(Double.valueOf(infoItemRspBO.getAmount().doubleValue()));
                    billItemBO.setSL(infoItemRspBO.getTaxRate().toString());
                    fpkjxxXmxxs.add(billItemBO);
                }
                OrderInfoBO fpkjxxDdxx = new OrderInfoBO();
                fpkjxxDdxx.setDDH(applyRspBO.getApplyNo());
                fpkjxxDdxx.setTHDH("");
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String date = sd.format(new Date());
                fpkjxxDdxx.setDDDATE(date);
                invoiceIssueExtReqBO.setFpkjxxDdxx(fpkjxxDdxx);
                invoiceIssueExtReqBO.setFpkjxxFptxx(fpkjxxFptxx);
                invoiceIssueExtReqBO.setGlobalInfo(globalInfo);
                invoiceIssueExtReqBO.setFpkjxxXmxxs(fpkjxxXmxxs);
                log.info("\u53d1\u9001\u5f00\u7968\u5165\u53c2\u4e3a:{}", (Object)JSON.toJSONString((Object)invoiceIssueExtReqBO));
                InvoiceIssueExtRspBO invoiceIssueExtRspBO = this.invoiceIssueExternalService.invoiceIssue(invoiceIssueExtReqBO);
                if (invoiceIssueExtRspBO != null && "0000".equals(invoiceIssueExtRspBO.getRespCode())) {
                    billApplyChildInfo = new BillApplyChildInfo();
                    billApplyChildInfo.setChildApplyNo(applyRspBO.getApplyNo());
                    billApplyChildInfo.setApplyStatus("0");
                    billApplyChildInfo.setFailMsg("\u6210\u529f");
                    this.billChildApplyInfoMapper.updateByPrimaryKey(billApplyChildInfo);
                    ++counts;
                    continue;
                }
                errMsg.add("\u62c6\u5206\u5b50\u7968\u3010" + applyRspBO.getApplyNo() + "\u3011\u5f00\u7968\u5931\u8d25:" + invoiceIssueExtRspBO.getRespDesc());
                billApplyChildInfo = new BillApplyChildInfo();
                billApplyChildInfo.setChildApplyNo(applyRspBO.getApplyNo());
                billApplyChildInfo.setApplyStatus("1");
                billApplyChildInfo.setFailMsg(invoiceIssueExtRspBO.getRespDesc());
                this.billChildApplyInfoMapper.updateByPrimaryKey(billApplyChildInfo);
            }
            rspBO.setTotalCounts(Integer.valueOf(applyInfoApplyRspBOS.size()));
            rspBO.setSuccessCounts(Integer.valueOf(counts));
            rspBO.setRespCode("0000");
            if (!CollectionUtils.isEmpty(errMsg)) {
                StringBuilder stringBuilder = new StringBuilder();
                errMsg.forEach(stringBuilder::append);
                rspBO.setRespDesc(stringBuilder.toString());
                return rspBO;
            }
        }
        catch (Exception e) {
            log.error("\u670d\u52a1\u62a5\u9519\uff1a", (Throwable)e);
            throw new PfscExtBusinessException("8888", e.getMessage());
        }
        return rspBO;
    }

    public BusiQueryDetailBillApplyInfoApplyRspBO queryApply(BusiQueryDetailBillApplyInfoReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getApplyNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            throw new PfscExtBusinessException("18000", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        saleOrderInfoVO.setApplyNo(applyNo);
        saleOrderInfoVO.setSource(billApplyInfo.getSource());
        saleOrderInfoVO.setOrderBy(" tt.inspectionId DESC");
        Page page = new Page(-1, -1);
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPageByApplyNo(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQueryDetailBillApplyInfoOrderRspBO> orderList = new ArrayList<BusiQueryDetailBillApplyInfoOrderRspBO>();
        if (saleOrderInfoList != null) {
            for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
                SaleItemInfoVO condition = new SaleItemInfoVO();
                condition.setInspectionId(saleOrderInfo.getInspectionId());
                condition.setApplyNo(billApplyInfo.getApplyNo());
                List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getListContainsItemApplyInfo(condition);
                ArrayList<Long> skuIds = new ArrayList<Long>();
                for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                    skuIds.add(saleItemInfo.getSkuId());
                }
                HashMap<Long, String> skuIdNameMap = new HashMap<Long, String>();
                List<PayInvoiceDetail> payInvoiceDetails = this.payInvoiceDetailMapper.getItemNameBySkuId(skuIds);
                for (PayInvoiceDetail payInvoiceDetail : payInvoiceDetails) {
                    skuIdNameMap.put(payInvoiceDetail.getSkuId(), payInvoiceDetail.getItemName());
                }
                ArrayList<BusiQueryDetailBillApplyInfoItemRspBO> itemList = new ArrayList<BusiQueryDetailBillApplyInfoItemRspBO>();
                for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                    BusiQueryDetailBillApplyInfoItemRspBO item = new BusiQueryDetailBillApplyInfoItemRspBO();
                    BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                    if (skuIdNameMap.get(saleItemInfo.getSkuId()) != null) {
                        item.setSkuName((String)skuIdNameMap.get(saleItemInfo.getSkuId()));
                    }
                    if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(billApplyInfo.getApplyType())) {
                        item.setAmountApply(saleItemInfo.getAmountApplied());
                        item.setQuantityApply(saleItemInfo.getQuantityApplied());
                    } else {
                        item.setAmountApply(saleItemInfo.getAmount());
                        item.setQuantityApply(saleItemInfo.getQuantity());
                    }
                    itemList.add(item);
                }
                BusiQueryDetailBillApplyInfoOrderRspBO busiQueryDetailBillApplyInfoOrderRspBO = new BusiQueryDetailBillApplyInfoOrderRspBO();
                BeanUtils.copyProperties((Object)saleOrderInfo, (Object)busiQueryDetailBillApplyInfoOrderRspBO);
                busiQueryDetailBillApplyInfoOrderRspBO.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
                busiQueryDetailBillApplyInfoOrderRspBO.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus())));
                busiQueryDetailBillApplyInfoOrderRspBO.setItemList(itemList);
                orderList.add(busiQueryDetailBillApplyInfoOrderRspBO);
            }
        }
        BusiQueryDetailBillApplyInfoApplyRspBO rspBO = new BusiQueryDetailBillApplyInfoApplyRspBO();
        BeanUtils.copyProperties((Object)billApplyInfo, (Object)rspBO);
        rspBO.setOrderCount(Integer.valueOf(page.getTotalCount()));
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }

    private List<BusiQueryDetailBillApplyInfoApplyRspBO> queryByTaxGroup(BusiQueryDetailBillApplyInfoReqBO reqBO) {
        ArrayList<BusiQueryDetailBillApplyInfoApplyRspBO> busiQueryDetailBillApplyInfoApplyRspBOS = new ArrayList<BusiQueryDetailBillApplyInfoApplyRspBO>();
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getApplyNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            throw new PfscExtBusinessException("18000", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        saleOrderInfoVO.setApplyNo(applyNo);
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListNoPageByApplyNo(saleOrderInfoVO);
        int count = 1;
        if (!CollectionUtils.isEmpty(saleOrderInfoList)) {
            BigDecimal maxAmount = new BigDecimal(this.maxAmountStr);
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setApplyNo(applyNo);
            List<SaleItemInfo> saleItemInfoTaxGroupList = this.saleItemInfoMapper.selectSaleItemGroupByTax(saleItemInfoVO);
            for (SaleItemInfo groupSaleItem : saleItemInfoTaxGroupList) {
                SaleItemInfoVO condition = new SaleItemInfoVO();
                condition.setApplyNo(billApplyInfo.getApplyNo());
                condition.setTaxRate(groupSaleItem.getTaxRate());
                List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.selectListByTaxRate(condition);
                Map saleItemInfoMap = saleItemInfoList.stream().collect(Collectors.toMap(SaleItemInfo::getSeq, Function.identity(), (key1, key2) -> key2));
                ArrayList<LinkedList<List<SaleItemInfo>>> aboveMaxAmountSaleItems = new ArrayList<LinkedList<List<SaleItemInfo>>>();
                while (saleItemInfoMap.size() > 0) {
                    BigDecimal totalAmount = new BigDecimal("0");
                    ArrayList<SaleItemInfo> saleItemInfoGroup = new ArrayList<SaleItemInfo>();
                    Iterator entries = saleItemInfoMap.entrySet().iterator();
                    List<List<SaleItemInfo>> groupByAmountSaleItems = null;
                    while (entries.hasNext()) {
                        groupByAmountSaleItems = new LinkedList<List<SaleItemInfo>>();
                        SaleItemInfo saleItem = (SaleItemInfo)entries.next().getValue();
                        if (saleItem.getAmount().compareTo(maxAmount) > 0) {
                            groupByAmountSaleItems = this.groupByAmount(saleItem, maxAmount, groupByAmountSaleItems);
                            aboveMaxAmountSaleItems.add((LinkedList<List<SaleItemInfo>>)groupByAmountSaleItems);
                            entries.remove();
                            continue;
                        }
                        if ((totalAmount = totalAmount.add(saleItem.getAmount())).compareTo(maxAmount) > 0 || saleItemInfoGroup.size() >= this.maxNum) break;
                        SaleItemInfo saleItemInfo = new SaleItemInfo();
                        BeanUtils.copyProperties((Object)saleItem, (Object)saleItemInfo);
                        saleItemInfo.setSkuName(this.hex2Str(saleItemInfo.getSkuName()));
                        saleItemInfoGroup.add(saleItemInfo);
                        entries.remove();
                    }
                    if (saleItemInfoGroup.size() > 0) {
                        List<BusiQueryDetailBillApplyInfoItemRspBO> itemList = this.getDetailBillApplyInfoItems(billApplyInfo, saleItemInfoGroup);
                        String string = billApplyInfo.getApplyNo() + "_" + count;
                        BusiQueryDetailBillApplyInfoApplyRspBO infoApplyRspBO = new BusiQueryDetailBillApplyInfoApplyRspBO();
                        BeanUtils.copyProperties((Object)billApplyInfo, (Object)infoApplyRspBO);
                        infoApplyRspBO.setItemList(itemList);
                        infoApplyRspBO.setApplyNo(string);
                        busiQueryDetailBillApplyInfoApplyRspBOS.add(infoApplyRspBO);
                        BillApplyChildInfo billApplyChildInfo = new BillApplyChildInfo();
                        billApplyChildInfo.setApplyNo(billApplyInfo.getApplyNo());
                        billApplyChildInfo.setChildApplyNo(string);
                        billApplyChildInfo.setStatus(0);
                        billApplyChildInfo.setInvoiceType(billApplyInfo.getInvoiceType());
                        this.billChildApplyInfoMapper.deleteByPrimaryKey(billApplyChildInfo);
                        this.billChildApplyInfoMapper.insert(billApplyChildInfo);
                        SaleItemInfo saleItemInfo = new SaleItemInfo();
                        for (BusiQueryDetailBillApplyInfoItemRspBO itemInfo : itemList) {
                            saleItemInfo.setSeq(itemInfo.getSeq());
                            saleItemInfo.setChildApplyNo(string);
                            this.saleItemInfoMapper.updateByPrimaryKeySelective(saleItemInfo);
                        }
                        ++count;
                    }
                    log.info("\u5355\u6761\u660e\u7ec6\u8d85\u8fc710W\u96c6\u5408\uff1a" + JSON.toJSONString(aboveMaxAmountSaleItems) + "\u6761\u6570\uff1a" + aboveMaxAmountSaleItems.size());
                    if (!CollectionUtils.isEmpty(aboveMaxAmountSaleItems)) {
                        for (List list : aboveMaxAmountSaleItems) {
                            for (List saleItemInfoGroup2 : list) {
                                List<BusiQueryDetailBillApplyInfoItemRspBO> itemList = this.getDetailBillApplyInfoItems(billApplyInfo, saleItemInfoGroup2);
                                String ChildApplyNo = billApplyInfo.getApplyNo() + "_" + count;
                                BusiQueryDetailBillApplyInfoApplyRspBO infoApplyRspBO = new BusiQueryDetailBillApplyInfoApplyRspBO();
                                BeanUtils.copyProperties((Object)billApplyInfo, (Object)infoApplyRspBO);
                                infoApplyRspBO.setItemList(itemList);
                                infoApplyRspBO.setApplyNo(ChildApplyNo);
                                busiQueryDetailBillApplyInfoApplyRspBOS.add(infoApplyRspBO);
                                BillApplyChildInfo billApplyChildInfo = new BillApplyChildInfo();
                                if (!CollectionUtils.isEmpty(itemList) && null != itemList.get(0)) {
                                    billApplyChildInfo.setItemAmount(itemList.get(0).getAmount());
                                    billApplyChildInfo.setItemSeq(itemList.get(0).getSeq());
                                }
                                billApplyChildInfo.setApplyNo(billApplyInfo.getApplyNo());
                                billApplyChildInfo.setChildApplyNo(ChildApplyNo);
                                billApplyChildInfo.setStatus(0);
                                billApplyChildInfo.setInvoiceType(billApplyInfo.getInvoiceType());
                                this.billChildApplyInfoMapper.deleteByPrimaryKey(billApplyChildInfo);
                                this.billChildApplyInfoMapper.insert(billApplyChildInfo);
                                LinkedList<Long> itemSeqList = new LinkedList<Long>();
                                for (BusiQueryDetailBillApplyInfoItemRspBO itemInfo : itemList) {
                                    itemSeqList.add(itemInfo.getSeq());
                                }
                                SaleItemInfoBatchVO saleItemInfoBatchVO = new SaleItemInfoBatchVO();
                                saleItemInfoBatchVO.setChildApplyNo(ChildApplyNo);
                                saleItemInfoBatchVO.setItemSeqList(itemSeqList);
                                log.info("\u66f4\u65b0\u6570\u91cf\u4e3a\uff1a" + itemSeqList.size());
                                this.saleItemInfoMapper.updateSeqByBatch(saleItemInfoBatchVO);
                                ++count;
                            }
                        }
                    }
                    aboveMaxAmountSaleItems.clear();
                }
            }
        }
        return busiQueryDetailBillApplyInfoApplyRspBOS;
    }

    private List<List<SaleItemInfo>> groupByAmount(SaleItemInfo saleItem, BigDecimal maxAmount, List<List<SaleItemInfo>> groupByAmountSaleItems) {
        ArrayList<SaleItemInfo> saleItemInfos = new ArrayList<SaleItemInfo>();
        BigDecimal amount = saleItem.getAmount();
        BigDecimal saleUnitPrice = saleItem.getSaleUnitPrice();
        log.info(saleItem.getSeq() + "\u53f7\u660e\u7ec6\u5f00\u59cb\u62c6\u5206,\u603b\u91d1\u989d\uff1a" + amount + ",\u5355\u4ef7\uff1a" + saleUnitPrice);
        if (saleUnitPrice.compareTo(maxAmount) >= 0) {
            int counts = amount.divideAndRemainder(maxAmount)[0].intValue();
            for (int i = 0; i < counts; ++i) {
                ArrayList<SaleItemInfo> saleItemInfoss = new ArrayList<SaleItemInfo>();
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                BeanUtils.copyProperties((Object)saleItem, (Object)saleItemInfo);
                saleItemInfo.setAmount(maxAmount);
                saleItemInfo.setQuantity(null);
                saleItemInfo.setQuantityApplied(null);
                saleItemInfo.setSkuName(this.hex2Str(saleItemInfo.getSkuName()));
                saleItemInfoss.add(saleItemInfo);
                groupByAmountSaleItems.add(saleItemInfoss);
            }
            BigDecimal leftAmount = amount.subtract(BigDecimal.valueOf(counts).multiply(maxAmount));
            if (leftAmount.compareTo(BigDecimal.ZERO) > 0) {
                SaleItemInfo leftSaleItemInfo = new SaleItemInfo();
                BeanUtils.copyProperties((Object)saleItem, (Object)leftSaleItemInfo);
                leftSaleItemInfo.setAmount(leftAmount);
                leftSaleItemInfo.setQuantityApplied(null);
                leftSaleItemInfo.setQuantity(null);
                saleItemInfos.add(leftSaleItemInfo);
                leftSaleItemInfo.setSkuName(this.hex2Str(leftSaleItemInfo.getSkuName()));
                groupByAmountSaleItems.add(saleItemInfos);
            }
        } else {
            int counts = amount.divide(maxAmount, 1).intValue();
            BigDecimal leftAmount = amount;
            BigDecimal newAmount = maxAmount.divideAndRemainder(saleUnitPrice)[0].multiply(saleUnitPrice);
            for (int i = 0; i < counts; ++i) {
                ArrayList<SaleItemInfo> saleItemInfoss = new ArrayList<SaleItemInfo>();
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                BeanUtils.copyProperties((Object)saleItem, (Object)saleItemInfo);
                saleItemInfo.setAmount(newAmount);
                saleItemInfo.setQuantity(null);
                saleItemInfo.setQuantityApplied(null);
                saleItemInfo.setSkuName(this.hex2Str(saleItemInfo.getSkuName()));
                saleItemInfoss.add(saleItemInfo);
                groupByAmountSaleItems.add(saleItemInfoss);
                leftAmount = leftAmount.subtract(newAmount);
            }
            if (leftAmount.compareTo(BigDecimal.ZERO) > 0) {
                SaleItemInfo leftSaleItemInfo = new SaleItemInfo();
                BeanUtils.copyProperties((Object)saleItem, (Object)leftSaleItemInfo);
                leftSaleItemInfo.setAmount(leftAmount);
                leftSaleItemInfo.setQuantityApplied(null);
                leftSaleItemInfo.setQuantity(null);
                leftSaleItemInfo.setSkuName(this.hex2Str(leftSaleItemInfo.getSkuName()));
                saleItemInfos.add(leftSaleItemInfo);
                groupByAmountSaleItems.add(saleItemInfos);
            }
        }
        log.info("\u5355\u6761\u660e\u7ec6\u62c6\u7968\u540e\u7ed3\u679c\uff1a" + JSON.toJSONString(groupByAmountSaleItems));
        return groupByAmountSaleItems;
    }

    private List<BusiQueryDetailBillApplyInfoItemRspBO> getDetailBillApplyInfoItems(BillApplyInfo billApplyInfo, List<SaleItemInfo> saleItemInfoList) {
        ArrayList<Long> skuIds = new ArrayList<Long>();
        for (SaleItemInfo saleItemInfo : saleItemInfoList) {
            skuIds.add(saleItemInfo.getSkuId());
        }
        HashMap<Long, String> skuIdNameMap = new HashMap<Long, String>();
        List<PayInvoiceDetail> payInvoiceDetails = this.payInvoiceDetailMapper.getItemNameBySkuId(skuIds);
        for (PayInvoiceDetail payInvoiceDetail : payInvoiceDetails) {
            skuIdNameMap.put(payInvoiceDetail.getSkuId(), payInvoiceDetail.getItemName());
        }
        ArrayList<BusiQueryDetailBillApplyInfoItemRspBO> itemList = new ArrayList<BusiQueryDetailBillApplyInfoItemRspBO>();
        for (SaleItemInfo saleItemInfo : saleItemInfoList) {
            BusiQueryDetailBillApplyInfoItemRspBO item = new BusiQueryDetailBillApplyInfoItemRspBO();
            BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
            if (skuIdNameMap.get(saleItemInfo.getSkuId()) != null) {
                item.setSkuName((String)skuIdNameMap.get(saleItemInfo.getSkuId()));
                item.setSkuName(this.hex2Str(item.getSkuName()));
            }
            if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(billApplyInfo.getApplyType())) {
                item.setAmountApply(saleItemInfo.getAmountApplied());
                item.setQuantityApply(saleItemInfo.getQuantityApplied());
            } else {
                item.setAmountApply(saleItemInfo.getAmount());
                item.setQuantityApply(saleItemInfo.getQuantity());
            }
            itemList.add(item);
        }
        return itemList;
    }

    private String getWordCount(String oldName) {
        String newName = "";
        int oldNameLength = 0;
        char[] names = oldName.toCharArray();
        for (int i = 0; i < oldName.length(); ++i) {
            int ascii = Character.codePointAt(oldName, i);
            oldNameLength = ascii >= 0 && ascii <= 255 ? ++oldNameLength : (oldNameLength += 2);
            if (oldNameLength > 70) continue;
            char c = names[i];
            newName = newName + c;
        }
        return newName;
    }

    private String getWordCount(String oldName, int length) {
        String newName = "";
        int oldNameLength = 0;
        char[] names = oldName.toCharArray();
        for (int i = 0; i < oldName.length(); ++i) {
            int ascii = Character.codePointAt(oldName, i);
            oldNameLength = ascii >= 0 && ascii <= 255 ? ++oldNameLength : (oldNameLength += 2);
            if (oldNameLength > length) continue;
            char c = names[i];
            newName = newName + c;
        }
        return newName;
    }

    private String hex2Str(String str) {
        String temp = String.valueOf(HexUtils.encodeHex(str.getBytes(), false));
        String result = temp.replace("C2A0", "20");
        return new String(HexUtils.decodeHex(result.toCharArray()));
    }

    private List<BusiQueryDetailBillApplyInfoApplyRspBO> queryFailChildApplyNo(List<BillApplyChildInfo> childApplyNoList, String applyNo) {
        BigDecimal maxAmount = new BigDecimal(this.maxAmountStr);
        ArrayList<BusiQueryDetailBillApplyInfoApplyRspBO> busiQueryDetailBillApplyInfoApplyRspBOS = new ArrayList<BusiQueryDetailBillApplyInfoApplyRspBO>();
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            throw new PfscExtBusinessException("18000", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        ArrayList<String> failChildNo = new ArrayList<String>();
        for (BillApplyChildInfo billApplyChildInfo : childApplyNoList) {
            if (!"1".equals(billApplyChildInfo.getApplyStatus()) && !StringUtils.isEmpty((Object)billApplyChildInfo.getApplyStatus())) continue;
            failChildNo.add(billApplyChildInfo.getChildApplyNo());
        }
        HashMap<Long, SaleItemInfo> saleItemInfoMap = new HashMap<Long, SaleItemInfo>();
        if (!CollectionUtils.isEmpty(failChildNo)) {
            ArrayList<SaleItemInfo> saleItemInfoList;
            HashMap itemListMap = new HashMap();
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setApplyNo(applyNo);
            saleItemInfoVO.setChildNoList(failChildNo);
            List<SaleItemInfo> saleItemInfos = this.saleItemInfoMapper.getListByApplyNoAndChildNos(saleItemInfoVO);
            if (!CollectionUtils.isEmpty(saleItemInfos)) {
                for (SaleItemInfo saleItemInfo : saleItemInfos) {
                    saleItemInfo.setSkuName(this.hex2Str(saleItemInfo.getSkuName()));
                    if (saleItemInfo.getAmount().compareTo(maxAmount) < 0) {
                        if (itemListMap.containsKey(saleItemInfo.getChildApplyNo())) {
                            ((List)itemListMap.get(saleItemInfo.getChildApplyNo())).add(saleItemInfo);
                            continue;
                        }
                        saleItemInfoList = new ArrayList();
                        saleItemInfoList.add(saleItemInfo);
                        itemListMap.put(saleItemInfo.getChildApplyNo(), saleItemInfoList);
                        continue;
                    }
                    saleItemInfoMap.put(saleItemInfo.getSeq(), saleItemInfo);
                }
            }
            for (BillApplyChildInfo billApplyChildInfo : childApplyNoList) {
                if (!"1".equals(billApplyChildInfo.getApplyStatus()) && !StringUtils.isEmpty((Object)billApplyChildInfo.getApplyStatus()) || billApplyChildInfo.getItemSeq() == null) continue;
                saleItemInfoList = new ArrayList<SaleItemInfo>();
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                BeanUtils.copyProperties(saleItemInfoMap.get(billApplyChildInfo.getItemSeq()), (Object)saleItemInfo);
                saleItemInfo.setAmount(billApplyChildInfo.getItemAmount());
                saleItemInfo.setQuantityApplied(null);
                saleItemInfo.setQuantity(null);
                saleItemInfoList.add(saleItemInfo);
                itemListMap.put(billApplyChildInfo.getChildApplyNo(), saleItemInfoList);
            }
            for (BillApplyChildInfo billApplyChildInfo : childApplyNoList) {
                if (!"1".equals(billApplyChildInfo.getApplyStatus()) && !StringUtils.isEmpty((Object)billApplyChildInfo.getApplyStatus())) continue;
                List<BusiQueryDetailBillApplyInfoItemRspBO> itemList = this.getDetailBillApplyInfoItems(billApplyInfo, (List)itemListMap.get(billApplyChildInfo.getChildApplyNo()));
                BusiQueryDetailBillApplyInfoApplyRspBO infoApplyRspBO = new BusiQueryDetailBillApplyInfoApplyRspBO();
                BeanUtils.copyProperties((Object)billApplyInfo, (Object)infoApplyRspBO);
                infoApplyRspBO.setItemList(itemList);
                infoApplyRspBO.setApplyNo(billApplyChildInfo.getChildApplyNo());
                busiQueryDetailBillApplyInfoApplyRspBOS.add(infoApplyRspBO);
            }
        } else {
            BillApplyInfo billApply = new BillApplyInfo();
            billApply.setApplyNo(applyNo);
            billApply.setBillStatus("02");
            this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
        }
        return busiQueryDetailBillApplyInfoApplyRspBOS;
    }
}

