/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.aisino.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.user.bo.SelectByUserIdsWebReqBO;
import com.ohaotian.authority.user.bo.SelectByUserIdsWebRspBO;
import com.ohaotian.authority.user.bo.SelectUserInfoWebBO;
import com.ohaotian.authority.user.service.SelectByUserIdsWebService;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.active.app.ability.ActQryActivitiesByConditionAbilityService;
import com.tydic.active.app.ability.bo.ActQryActivitiesByConditionAbilityReqBO;
import com.tydic.active.app.ability.bo.ActQryActivitiesByConditionAbilityRspBO;
import com.tydic.active.app.common.bo.ActivitiesBO;
import com.tydic.order.extend.ability.notify.PebExtQueryNotifyConfListAbilityServer;
import com.tydic.order.extend.bo.notify.PebExtQueryNotifyConfListInfoBO;
import com.tydic.order.extend.bo.notify.PebExtQueryNotifyConfListReqBO;
import com.tydic.order.extend.bo.notify.PebExtQueryNotifyConfListRspBO;
import com.tydic.pfscext.api.aisino.FscSendApplyAdviceMsgService;
import com.tydic.pfscext.api.aisino.bo.SendApplyAdviceMsgReqBO;
import com.tydic.pfscext.api.aisino.bo.SendApplyAdviceMsgRspBO;
import com.tydic.pfscext.dao.po.ToDoDetail;
import com.tydic.pfscext.dao.vo.ToDoDetailMapper;
import com.tydic.pfscext.enums.SendApplyAdviceType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.bo.FscSendMsgReqBO;
import com.tydic.umc.ability.bo.UmcMemDetailInfoAbilityBO;
import com.tydic.umcext.ability.member.UmcZhMemDetailQueryAbilityService;
import com.tydic.umcext.ability.member.bo.UmcZhMemDetailQueryAbilityReqBO;
import com.tydic.umcext.ability.member.bo.UmcZhMemDetailQueryAbilityRspBO;
import com.tydic.umcext.ability.org.UmcEnterpriseOrgSettleModelAbilityService;
import com.tydic.umcext.ability.org.UmcSelectMemByOrgAndRoleAbilityService;
import com.tydic.umcext.ability.org.bo.UmcEnterpriseOrgSettleModelAbilityReqBO;
import com.tydic.umcext.ability.org.bo.UmcEnterpriseOrgSettleModelAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcSelectMemByOrgAndRoleAbilityReqBO;
import com.tydic.umcext.ability.org.bo.UmcSelectMemByOrgAndRoleAbilityRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.aisino.FscSendApplyAdviceMsgService"})
public class FscSendApplyAdviceMsgServiceImpl
implements FscSendApplyAdviceMsgService {
    private static final Logger log = LoggerFactory.getLogger(FscSendApplyAdviceMsgServiceImpl.class);
    @Value(value="${FSC_SEND_ADVICE_TOPIC:FSC_SEND_ADVICE_TOPIC}")
    private String sendAdviceTopic;
    @Value(value="${FSC_SEND_ADVICE_TAG:*}")
    private String tag;
    @Resource(name="fscSendAdviceMsgProducer")
    private ProxyMessageProducer proxyMessageProducer;
    @Autowired
    private ToDoDetailMapper toDoDetailMapper;
    @Autowired
    private PebExtQueryNotifyConfListAbilityServer pebExtQueryNotifyConfListAbilityServer;
    @Autowired
    private UmcSelectMemByOrgAndRoleAbilityService umcSelectMemByOrgAndRoleAbilityService;
    @Autowired
    private UmcEnterpriseOrgSettleModelAbilityService umcEnterpriseOrgSettleModelAbilityService;
    @Autowired
    private SelectByUserIdsWebService selectByUserIdsWebService;
    @Autowired
    private ActQryActivitiesByConditionAbilityService actQryActivitiesByConditionAbilityService;
    @Autowired
    private UmcZhMemDetailQueryAbilityService umcZhMemDetailQueryAbilityService;
    private final String PURCHASER = "purchaser";
    private final String SETTLE = "settle";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"sendApplyAdvice"})
    public SendApplyAdviceMsgRspBO sendApplyAdvice(@RequestBody SendApplyAdviceMsgReqBO reqBO) {
        log.debug("\u53d1\u9001\u5f00\u7968\u901a\u77e5\u5165\u53c2\uff1a" + reqBO.toString());
        FscSendMsgReqBO sendMsgReqBO = new FscSendMsgReqBO();
        sendMsgReqBO.setTitel(reqBO.getTitle());
        sendMsgReqBO.setSubject(reqBO.getTitle());
        sendMsgReqBO.setUserId(1L);
        PebExtQueryNotifyConfListReqBO notifyVo = new PebExtQueryNotifyConfListReqBO();
        notifyVo.setNotifyName(reqBO.getTemplateName());
        PebExtQueryNotifyConfListRspBO pebExtQueryNotifyConfListRspBO = this.pebExtQueryNotifyConfListAbilityServer.queryNotifyConfList(notifyVo);
        if (!"0000".equals(pebExtQueryNotifyConfListRspBO.getRespCode())) throw new PfscExtBusinessException("18003", "\u83b7\u53d6\u5185\u5bb9\u6a21\u7248\u5931\u8d25!");
        String notifyContent = ((PebExtQueryNotifyConfListInfoBO)pebExtQueryNotifyConfListRspBO.getRows().get(0)).getContent();
        String text = notifyContent.replace("XXX", reqBO.getNotificationNo()).replace("YYYY-MM-DD", reqBO.getBusinessDate());
        if (!StringUtils.isEmpty((Object)reqBO.getQxApplyResult())) {
            text = text.replace("XX", reqBO.getQxApplyResult());
        }
        List notifyWayList = ((PebExtQueryNotifyConfListInfoBO)pebExtQueryNotifyConfListRspBO.getRows().get(0)).getNotifyWayList();
        sendMsgReqBO.setText(text);
        sendMsgReqBO.setSendTypeList(notifyWayList);
        ToDoDetail toDoDetail = new ToDoDetail();
        if (StringUtils.isEmpty((Object)reqBO.getReceiver())) {
            LinkedList<Long> purchaseNoList = new LinkedList<Long>();
            purchaseNoList.add(reqBO.getOrgId());
            UmcEnterpriseOrgSettleModelAbilityReqBO enterpriseOrgSettleModelAbilityReqBO = new UmcEnterpriseOrgSettleModelAbilityReqBO();
            enterpriseOrgSettleModelAbilityReqBO.setOrgIds(purchaseNoList);
            log.info("\u67e5\u8be2\u4f1a\u5458\u83b7\u53d6\u673a\u6784\u7ed3\u7b97\u6a21\u5f0f\u5165\u53c2" + JSON.toJSONString((Object)enterpriseOrgSettleModelAbilityReqBO));
            UmcEnterpriseOrgSettleModelAbilityRspBO enterpriseOrgSettleModelAbilityRspBO = this.umcEnterpriseOrgSettleModelAbilityService.qryOrgSettleModel(enterpriseOrgSettleModelAbilityReqBO);
            log.info("\u67e5\u8be2\u4f1a\u5458\u83b7\u53d6\u673a\u6784\u7ed3\u7b97\u6a21\u5f0f\u51fa\u53c2" + JSON.toJSONString((Object)enterpriseOrgSettleModelAbilityRspBO));
            Map settleModelMap = enterpriseOrgSettleModelAbilityRspBO.getSettleModelMap();
            if (CollectionUtils.isEmpty((Map)settleModelMap)) throw new PfscExtBusinessException("18003", "\u672a\u67e5\u5230\u91c7\u8d2d\u65b9!");
            String settleModel = (String)settleModelMap.get(reqBO.getOrgId());
            if (settleModel.equals("purchaser")) {
                if (reqBO.getTitle().equals(SendApplyAdviceType.STAFF_STAY_TICKET.getAdviceName()) || reqBO.getTitle().equals(SendApplyAdviceType.STAFF_CANCEL_RESULT.getAdviceName())) {
                    this.sendAdviceByActivityId(reqBO, sendMsgReqBO);
                } else {
                    toDoDetail.setRoleName("\u91c7\u8d2d\u5355\u4f4d\u91c7\u8d2d\u5458");
                    this.sendAdviceByUserId(reqBO, sendMsgReqBO);
                }
            } else if (settleModel.equals("settle")) {
                toDoDetail.setRoleName("\u91c7\u8d2d\u5355\u4f4d\u7ed3\u7b97\u5458");
                this.sendAdviceByRole(toDoDetail, reqBO, sendMsgReqBO);
            }
        } else {
            toDoDetail.setRoleName(reqBO.getReceiver());
            this.sendAdviceByRole(toDoDetail, reqBO, sendMsgReqBO);
        }
        SendApplyAdviceMsgRspBO rspBO = new SendApplyAdviceMsgRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendAdviceByActivityId(SendApplyAdviceMsgReqBO reqBO, FscSendMsgReqBO sendMsgReqBO) {
        ActQryActivitiesByConditionAbilityReqBO actQryActivitiesByConditionAbilityReqBO = new ActQryActivitiesByConditionAbilityReqBO();
        actQryActivitiesByConditionAbilityReqBO.setActiveId(reqBO.getActivityId());
        ActQryActivitiesByConditionAbilityRspBO rspBO = this.actQryActivitiesByConditionAbilityService.qryActivitiesByCondition(actQryActivitiesByConditionAbilityReqBO);
        List rows = rspBO.getRows();
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            String memId = ((ActivitiesBO)rows.get(0)).getCreateLoginId();
            UmcZhMemDetailQueryAbilityReqBO umcZhMemDetailQueryAbilityReqBO = new UmcZhMemDetailQueryAbilityReqBO();
            umcZhMemDetailQueryAbilityReqBO.setMemId(Long.valueOf(memId));
            UmcZhMemDetailQueryAbilityRspBO umcZhMemDetailQueryAbilityRspBO = this.umcZhMemDetailQueryAbilityService.memDetailQuery(umcZhMemDetailQueryAbilityReqBO);
            UmcMemDetailInfoAbilityBO umcMemDetailInfoAbilityRspBO = umcZhMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO();
            reqBO.setReceiverId(umcMemDetailInfoAbilityRspBO.getUserId());
            this.sendAdviceByUserId(reqBO, sendMsgReqBO);
        } else {
            log.error("\u83b7\u53d6\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25!");
        }
    }

    private void sendAdviceByUserId(SendApplyAdviceMsgReqBO reqBO, FscSendMsgReqBO sendMsgReqBO) {
        Long receiverId = reqBO.getReceiverId();
        LinkedList<Long> receiverIdList = new LinkedList<Long>();
        receiverIdList.add(receiverId);
        SelectByUserIdsWebReqBO selectByUserIdsWebReqBO = new SelectByUserIdsWebReqBO();
        selectByUserIdsWebReqBO.setUserIds(receiverIdList);
        SelectByUserIdsWebRspBO selectByUserIdsWebRspBO = this.selectByUserIdsWebService.selectUserInfoByIds(selectByUserIdsWebReqBO);
        if (!CollectionUtils.isEmpty((Collection)selectByUserIdsWebRspBO.getUserInfoList())) {
            for (SelectUserInfoWebBO selectUserInfoWebBO : selectByUserIdsWebRspBO.getUserInfoList()) {
                HashMap<String, FscSendMsgReqBO> map = new HashMap<String, FscSendMsgReqBO>(1);
                sendMsgReqBO.setReceiveId(selectUserInfoWebBO.getUserId());
                sendMsgReqBO.setEmail(selectUserInfoWebBO.getEmail());
                map.put("sendAdvice", sendMsgReqBO);
                ProxyMessage proxyMessage = new ProxyMessage(this.sendAdviceTopic, this.tag, JSON.toJSONString(map));
                this.proxyMessageProducer.send(proxyMessage);
            }
        } else {
            log.error("\u53d1\u9001\u901a\u77e5\u65f6\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606fid:" + reqBO.getReceiverId());
        }
    }

    private void sendAdviceByRole(ToDoDetail toDoDetail, SendApplyAdviceMsgReqBO reqBO, FscSendMsgReqBO sendMsgReqBO) {
        List<ToDoDetail> toDoDetails = this.toDoDetailMapper.getListByCondition(toDoDetail);
        List<String> authIdentities = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)toDoDetails.get(0).getRoleAuth()) && toDoDetails.get(0).getRoleAuth().contains(",")) {
            authIdentities = Arrays.asList(toDoDetails.get(0).getRoleAuth().split(","));
        } else if (!StringUtils.isEmpty((Object)toDoDetails.get(0).getRoleAuth())) {
            authIdentities.add(toDoDetails.get(0).getRoleAuth());
        }
        UmcSelectMemByOrgAndRoleAbilityReqBO umcSelectMemByOrgAndRoleAbilityReqBO = new UmcSelectMemByOrgAndRoleAbilityReqBO();
        umcSelectMemByOrgAndRoleAbilityReqBO.setAuthIdentities(authIdentities);
        umcSelectMemByOrgAndRoleAbilityReqBO.setCompanyId(reqBO.getOrgId());
        UmcSelectMemByOrgAndRoleAbilityRspBO userRspBO = this.umcSelectMemByOrgAndRoleAbilityService.selectMemByOrgAndRole(umcSelectMemByOrgAndRoleAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)userRspBO.getMemDetailInfos())) {
            List userList = userRspBO.getMemDetailInfos();
            for (UmcMemDetailInfoAbilityBO user : userList) {
                HashMap<String, FscSendMsgReqBO> map = new HashMap<String, FscSendMsgReqBO>(2);
                sendMsgReqBO.setReceiveId(user.getUserId());
                sendMsgReqBO.setEmail(user.getRegEmail());
                map.put("sendAdvice", sendMsgReqBO);
                ProxyMessage proxyMessage = new ProxyMessage(this.sendAdviceTopic, this.tag, JSON.toJSONString(map));
                this.proxyMessageProducer.send(proxyMessage);
            }
        }
    }
}

