/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.aisino.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.sdk.PayCenterUtils;
import com.tydic.pfscext.api.aisino.IntermediateStatusUpdateService;
import com.tydic.pfscext.api.aisino.bo.IntermediateStatusUpdateReqBO;
import com.tydic.pfscext.api.aisino.bo.IntermediateStatusUpdateRspBO;
import com.tydic.pfscext.api.busi.BusiIntermediateStatusUpdateService;
import com.tydic.pfscext.api.busi.bo.BusiIntermediateStatusUpdateReq;
import com.tydic.pfscext.api.busi.bo.FscPayableCallBackBO;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.service.busi.BusiUpdateApplyPayStatusService;
import com.tydic.pfscext.service.busi.bo.BusiUpdateApplyPayStatusReqBO;
import com.tydic.pfscext.service.busi.impl.BusiIntermediateStatusUpdateServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.aisino.IntermediateStatusUpdateService"})
public class IntermediateStatusUpdateServiceImpl
implements IntermediateStatusUpdateService {
    private static final Logger logger = LoggerFactory.getLogger(BusiIntermediateStatusUpdateServiceImpl.class);
    @Autowired
    private BusiIntermediateStatusUpdateService busiIntermediateStatusUpdateService;
    @Autowired
    private BusiUpdateApplyPayStatusService busiUpdateApplyPayStatusService;
    @Value(value="${publicKey}")
    private String publicKey;

    @PostMapping(value={"updateStatus"})
    public IntermediateStatusUpdateRspBO updateStatus(@RequestBody IntermediateStatusUpdateReqBO reqBO) {
        IntermediateStatusUpdateRspBO intermediateStatusUpdateRspBO = new IntermediateStatusUpdateRspBO();
        String content = PayCenterUtils.deCode((String)reqBO.getContent(), (String)this.publicKey);
        FscPayableCallBackBO fscPayableCallBackBO = (FscPayableCallBackBO)JSON.parseObject((String)content, FscPayableCallBackBO.class);
        String[] split = fscPayableCallBackBO.getOutOrderId().split("-");
        String payNo = split[1];
        logger.info("\u8d22\u4f01\u901a\u7b2c\u4e00\u6b21\u652f\u4ed8\u4e2d\u5fc3\u56de\u8c03\uff1a" + payNo + "\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)fscPayableCallBackBO));
        BusiUpdateApplyPayStatusReqBO updateApplyPayStatusReqBO = new BusiUpdateApplyPayStatusReqBO();
        updateApplyPayStatusReqBO.setPayNo(payNo);
        if (!StringUtils.isEmpty((CharSequence)fscPayableCallBackBO.getPayMethod())) {
            if (PayMethod.GYLJR.getCode().equals(fscPayableCallBackBO.getPayMethod())) {
                updateApplyPayStatusReqBO.setPayMethod(fscPayableCallBackBO.getPayMethod());
                updateApplyPayStatusReqBO.setPayChannels(PayChannel.GYLJR.getCode());
            } else if (PayMethod.ZH_BF.getCode().equals(fscPayableCallBackBO.getPayMethod())) {
                updateApplyPayStatusReqBO.setPayMethod(fscPayableCallBackBO.getPayMethod());
                updateApplyPayStatusReqBO.setPayChannels(PayChannel.ZGYH.getCode());
            } else if (PayMethod.ZHCQT.getCode().equals(fscPayableCallBackBO.getPayMethod())) {
                updateApplyPayStatusReqBO.setPayMethod(fscPayableCallBackBO.getPayMethod());
                updateApplyPayStatusReqBO.setPayChannels(PayChannel.ZHCQT.getCode());
            }
        }
        this.busiUpdateApplyPayStatusService.updateApplyPayStatus(updateApplyPayStatusReqBO);
        String jsonString = JSONObject.toJSONString((Object)reqBO);
        BusiIntermediateStatusUpdateReq noticeUpdateReq = (BusiIntermediateStatusUpdateReq)JSONObject.parseObject((String)jsonString, BusiIntermediateStatusUpdateReq.class);
        try {
            this.busiIntermediateStatusUpdateService.noticeOrderupdateStatus(noticeUpdateReq);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u8ba2\u5355\u4e2d\u5fc3\u7684\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25\uff01");
        }
        return intermediateStatusUpdateRspBO;
    }
}

