/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.aisino.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.pfscext.annotation.DuplicateCommitLimit;
import com.tydic.pfscext.api.aisino.MakeNotiMsgService;
import com.tydic.pfscext.api.aisino.bo.BusiMakeNotificationReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiMakeNotificationRspBO;
import com.tydic.pfscext.api.busi.VerifyPurchaseEmployeeOrderInfoService;
import com.tydic.pfscext.api.busi.VerifyPurchaseOrderInfoService;
import com.tydic.pfscext.api.busi.bo.PurchaseOrderVerifyReqBO;
import com.tydic.pfscext.api.busi.bo.VerifyPurchaseEmployeeOrderReqBO;
import com.tydic.pfscext.api.busi.bo.VerifyPurchaseEmployeeOrderRspBO;
import com.tydic.pfscext.api.busi.bo.VerifyPurchaseOrderRspBO;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.enums.FscBillBusiSystem;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.aisino.MakeNotiMsgService"})
public class MakeNotiMsgServiceImpl
implements MakeNotiMsgService {
    private static final Logger log = LoggerFactory.getLogger(MakeNotiMsgServiceImpl.class);
    private final String SEND_SUCCESS = "SEND_OK";
    @Value(value="${FSC_MAKE_NOTI_TOPIC:FSC_MAKE_NOTI_TOPIC}")
    private String makeNotiTopic;
    @Value(value="${FSC_MAKE_NOTI_TAG:*}")
    private String tag;
    @Autowired
    private VerifyPurchaseOrderInfoService verifyPurchaseOrderInfoService;
    @Resource(name="fscMakeNotiMsgProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    private final String PURCHASE = "purchaser";
    @Autowired
    private VerifyPurchaseEmployeeOrderInfoService verifyPurchaseEmployeeOrderInfoService;

    @DuplicateCommitLimit
    @PostMapping(value={"makeNotificationMsg"})
    public BusiMakeNotificationRspBO makeNotificationMsg(@RequestBody BusiMakeNotificationReqBO reqBO) {
        log.info("\u5f00\u7968\u901a\u77e5\u53d1\u8d77-\u6d88\u606f\u751f\u4ea7\u8005\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        BusiMakeNotificationRspBO rspBO = new BusiMakeNotificationRspBO();
        if (reqBO.getQueryPayPurchaseOrderInfoAwaitReqBO() == null && CollectionUtils.isEmpty((Collection)reqBO.getInspectionIdList())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getGroupWay())) {
            throw new PfscExtBusinessException("0001", "\u5206\u7ec4\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceInfo() || !StringUtils.hasText((String)reqBO.getInvoiceInfo().getInvoiceTitle())) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (null == reqBO.getMailAddrInfo() || !StringUtils.hasText((String)reqBO.getMailAddrInfo().getName())) {
            throw new PfscExtBusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.hasText((String)reqBO.getBillMakeSystem())) {
            reqBO.setBillMakeSystem(FscBillBusiSystem.PC.getCode());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getVerifyFrom()) && "5".equals(reqBO.getVerifyFrom())) {
            VerifyPurchaseEmployeeOrderReqBO employeeOrderReqBO = new VerifyPurchaseEmployeeOrderReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)employeeOrderReqBO);
            VerifyPurchaseEmployeeOrderRspBO verifyPurchaseEmployeeOrderRspBO = this.verifyPurchaseEmployeeOrderInfoService.purchaseOrderAwaitVerify(employeeOrderReqBO);
            if (!"0000".equals(verifyPurchaseEmployeeOrderRspBO.getRespCode())) {
                throw new PfscExtBusinessException("0001", verifyPurchaseEmployeeOrderRspBO.getRespDesc());
            }
        } else {
            PurchaseOrderVerifyReqBO purchaseOrderVerifyReqBO = new PurchaseOrderVerifyReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)purchaseOrderVerifyReqBO);
            VerifyPurchaseOrderRspBO pfscExtRspBaseBO = this.verifyPurchaseOrderInfoService.purchaseOrderVerify(purchaseOrderVerifyReqBO);
            if (!"0000".equals(pfscExtRspBaseBO.getRespCode())) {
                throw new PfscExtBusinessException("0001", pfscExtRspBaseBO.getRespDesc());
            }
        }
        HashMap<String, BusiMakeNotificationReqBO> map = new HashMap<String, BusiMakeNotificationReqBO>();
        map.put("makeNotification", reqBO);
        ProxyMessage proxyMessage = new ProxyMessage(this.makeNotiTopic, this.tag, JSON.toJSONString(map));
        ProxySendResult sendResult = this.proxyMessageProducer.send(proxyMessage);
        if ("SEND_OK".equals(sendResult.getStatus())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }
}

