/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom;

import cn.hutool.core.util.StrUtil;
import com.tydic.pfscext.api.aisino.FscSendApplyAdviceMsgService;
import com.tydic.pfscext.api.aisino.bo.SendApplyAdviceMsgReqBO;
import com.tydic.pfscext.api.deal.BusiNotificationPushErpYfService;
import com.tydic.pfscext.api.deal.GetElectronicInvoiceService;
import com.tydic.pfscext.api.deal.bo.BusiNotificationPushErpYsReqBO;
import com.tydic.pfscext.api.deal.bo.InvoiceInfoBO;
import com.tydic.pfscext.constants.FscConstants;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.enums.InvoiceMailStatus;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.SendApplyAdviceType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.DateUtil;
import com.tydic.pfscext.utils.FscStringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="payInvoiceService")
public class PayInvoiceService {
    private static final Log log = LogFactory.getLog(PayInvoiceService.class);
    @Autowired
    private BillNotificationInfoMapper notificationInfomapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private FscSendApplyAdviceMsgService fscSendApplyAdviceMsgService;
    @Autowired
    private BusiNotificationPushErpYfService busiNotificationPushErpYfService;
    @Autowired
    private GetElectronicInvoiceService getElectronicInvoiceService;
    @Value(value="${UNC_MESSAGE_SENDING_FLAG:0}")
    private String UNC_MESSAGE_SENDING_FLAG;

    public void createInvoice(PayInvoiceInfo invoiceInfo) {
        String notificationNo = invoiceInfo.getNotificationNo();
        BigDecimal amt = BigDecimal.ZERO;
        HashSet<String> invoiceNos = new HashSet<String>();
        Date invoiceDate = null;
        if (invoiceInfo.getInvoiceCode() == null || invoiceInfo.getInvoiceNo() == null) {
            log.error((Object)("InvoiceCode\u6216InvoiceNo\u4e3a\u7a7a\uff0c\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo));
            throw new PfscExtBusinessException("0001", "InvoiceCode\u6216InvoiceNo\u4e3a\u7a7a\uff0c\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo);
        }
        BillNotificationInfo billNotificationInfo = this.notificationInfomapper.selectByPrimaryKey(notificationNo);
        if (billNotificationInfo == null) {
            log.error((Object)("\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355\u3010\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + "\u3011"));
            throw new PfscExtBusinessException("18001", "\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355\u3010\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + "\u3011");
        }
        List<PayInvoiceInfo> payInvoiceInfoList = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
        for (PayInvoiceInfo invoice : payInvoiceInfoList) {
            if (invoice.getInvoiceNo().contains(invoiceInfo.getInvoiceNo())) {
                this.payInvoiceInfoMapper.deleteByPrimaryKey(invoice.getInvoiceCode(), invoice.getInvoiceNo(), invoice.getInvoiceDate());
                continue;
            }
            amt = amt.add(invoice.getAmt());
            invoiceNos.add(invoice.getInvoiceNo());
            if (invoiceDate != null && !invoiceDate.before(invoice.getInvoiceDate())) continue;
            invoiceDate = invoice.getInvoiceDate();
        }
        amt = amt.add(invoiceInfo.getAmt());
        invoiceNos.add(invoiceInfo.getInvoiceNo());
        if (invoiceDate == null || invoiceDate.before(invoiceInfo.getInvoiceDate())) {
            invoiceDate = invoiceInfo.getInvoiceDate();
        }
        if (invoiceInfo.getInvoiceType() == InvoiceType.NORMAL_ELC.getCode()) {
            String electronicInvoiceSource = invoiceInfo.getElectronicInvoiceUrl();
            invoiceInfo.setElectronicInvoiceSource(electronicInvoiceSource);
            if (StrUtil.isNotBlank((CharSequence)electronicInvoiceSource)) {
                InvoiceInfoBO invoiceInfoBO = new InvoiceInfoBO();
                invoiceInfoBO.setSupplierId(invoiceInfo.getSupplierNo());
                invoiceInfoBO.setNotificationNo(notificationNo);
                invoiceInfoBO.setFlag(Integer.valueOf(1));
                invoiceInfoBO.setElectronicInvoiceUrl(electronicInvoiceSource);
                InvoiceInfoBO invoiceInfoRspBO = this.getElectronicInvoiceService.getElectronicInvoice(invoiceInfoBO);
                if (invoiceInfoRspBO == null) {
                    invoiceInfo.setElectronicInvoiceStatus(FscConstants.ElectronicInvoiceStatus.FAIL);
                    invoiceInfo.setElectronicInvoiceFail("\u67e5\u8be2\u5931\u8d25");
                } else if ("0000".equals(invoiceInfoRspBO.getRespCode())) {
                    invoiceInfo.setElectronicInvoiceName(invoiceInfoRspBO.getElectronicInvoiceName());
                    invoiceInfo.setElectronicInvoiceUrl(invoiceInfoRspBO.getElectronicInvoiceUrl());
                    invoiceInfo.setElectronicInvoiceStatus(FscConstants.ElectronicInvoiceStatus.SUCCESS);
                } else {
                    log.error((Object)("\u83b7\u53d6\u7535\u5b50\u53d1\u7968\u5931\u8d25 \u3010\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + "\u3011"));
                    invoiceInfo.setElectronicInvoiceUrl(null);
                    invoiceInfo.setElectronicInvoiceStatus(FscConstants.ElectronicInvoiceStatus.FAIL);
                    invoiceInfo.setElectronicInvoiceFail(invoiceInfoRspBO.getRespDesc());
                }
            } else {
                invoiceInfo.setElectronicInvoiceStatus(FscConstants.ElectronicInvoiceStatus.FAIL);
                invoiceInfo.setElectronicInvoiceFail("\u7535\u7968\u5730\u5740\u4e3a\u7a7a");
            }
        }
        this.payInvoiceInfoMapper.insert(invoiceInfo);
        if (amt.compareTo(billNotificationInfo.getAmt()) >= 0) {
            billNotificationInfo = new BillNotificationInfo();
            billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.HAS_MAKE.getCode());
            billNotificationInfo.setInvoiceDate(invoiceDate);
            billNotificationInfo.setNotificationNo(notificationNo);
            billNotificationInfo.setInvoiceResult("");
            billNotificationInfo.setReceiveDate(new Date());
            int cnt = this.notificationInfomapper.updateByPrimaryKeySelective(billNotificationInfo);
            log.debug((Object)("\u4fee\u6539\u901a\u77e5\u5355\u53f7\u7684\u72b6\u6001\u4e3a\u5df2\u5f00\u7968,\u901a\u77e5\u5355\u53f7=" + notificationNo + " \u66f4\u65b0\u6570=" + cnt));
            PayPurchaseOrderInfo payOrderUpd = new PayPurchaseOrderInfo();
            payOrderUpd.setNotificationNo(notificationNo);
            payOrderUpd.setOrderStatus(OrderStatus.SEND_BILL.getCode());
            cnt = this.payPurchaseOrderInfoMapper.updateStatus(payOrderUpd);
            log.debug((Object)("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u5f00\u7968(02),\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u6570\u91cf=" + cnt));
            PayItemInfo payItemUpd = new PayItemInfo();
            payItemUpd.setNotificationNo(notificationNo);
            payItemUpd.setItemStatus(OrderStatus.SEND_BILL.getCode());
            payItemUpd.setInvoiceCode(invoiceInfo.getInvoiceCode());
            String invoiceNo = FscStringUtils.list2String(new ArrayList(invoiceNos), ",");
            cnt = this.payItemInfoMapper.updateByPrimaryKeySelective(payItemUpd);
            log.debug((Object)("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u72b6\u6001\u4e3a\u5df2\u5f00\u7968(02),\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u6570\u91cf=" + cnt));
            if (StringUtils.isNotEmpty((String)notificationNo)) {
                this.sendAdvice(notificationNo);
            }
            BusiNotificationPushErpYsReqBO ysReqBO = new BusiNotificationPushErpYsReqBO();
            ysReqBO.setNotificationNo(notificationNo);
            this.busiNotificationPushErpYfService.pushErpYf(ysReqBO);
        }
    }

    private void sendAdvice(String notificationNo) {
        try {
            if (!YesOrNo.YES.getCodeAsString().equals(this.UNC_MESSAGE_SENDING_FLAG)) {
                log.info((Object)"\u901a\u77e5\u914d\u7f6e\u4e0d\u53d1\u9001\u901a\u77e5\uff0c\u76f4\u63a5\u7ed3\u675f");
                return;
            }
            SendApplyAdviceMsgReqBO sendApplyAdviceMsgReqBO = new SendApplyAdviceMsgReqBO();
            sendApplyAdviceMsgReqBO.setNotificationNo(notificationNo);
            sendApplyAdviceMsgReqBO.setBusinessDate(DateUtil.dateToStr(new Date()));
            sendApplyAdviceMsgReqBO.setTemplateName("\u5f85\u6536\u7968\u7ed3\u7b97\u901a\u77e5");
            List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
            if (CollectionUtils.isEmpty(payPurchaseOrderInfos)) {
                throw new PfscExtBusinessException("18003", "\u53d1\u9001\u901a\u77e5\u65f6\u672a\u67e5\u5230\u8ba2\u5355\u4fe1\u606f!");
            }
            if ("0".equals(payPurchaseOrderInfos.get(0).getBusiModel())) {
                sendApplyAdviceMsgReqBO.setTitle(SendApplyAdviceType.UNIFIED_SIGNATURE_UP_STAY_TICKET.getAdviceName());
                sendApplyAdviceMsgReqBO.setOrgId(payPurchaseOrderInfos.get(0).getOperUnitNo());
                sendApplyAdviceMsgReqBO.setReceiver(SendApplyAdviceType.UNIFIED_SIGNATURE_UP_STAY_TICKET.getReceiver());
            } else if ("1".equals(payPurchaseOrderInfos.get(0).getBusiModel())) {
                if (StringUtils.isNotEmpty((String)payPurchaseOrderInfos.get(0).getNoAgreeOrderCategory()) && "0".equals(payPurchaseOrderInfos.get(0).getNoAgreeOrderCategory())) {
                    sendApplyAdviceMsgReqBO.setTitle(SendApplyAdviceType.REDUNDANCY_STAY_TICKET.getAdviceName());
                    sendApplyAdviceMsgReqBO.setOrgId(payPurchaseOrderInfos.get(0).getPurchaseNo());
                } else {
                    sendApplyAdviceMsgReqBO.setTitle(SendApplyAdviceType.SUBCONTRACTING_STAY_TICKET.getAdviceName());
                    sendApplyAdviceMsgReqBO.setOrgId(payPurchaseOrderInfos.get(0).getPurchaseNo());
                }
                sendApplyAdviceMsgReqBO.setReceiverId(payPurchaseOrderInfos.get(0).getPurchaserId());
            }
            this.fscSendApplyAdviceMsgService.sendApplyAdvice(sendApplyAdviceMsgReqBO);
        }
        catch (Exception e) {
            log.error((Object)"\u5206\u7b7e\u7ed3\u7b97\u53d1\u9001\u5f85\u6536\u7968\u901a\u77e5\u5931\u8d25!");
        }
    }

    public void updateMailSendStatus(PayInvoiceInfo updateInvoice, String mailInfo) {
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        billNotificationInfo.setNotificationNo(updateInvoice.getNotificationNo());
        billNotificationInfo.setMailDesc(mailInfo);
        this.notificationInfomapper.updateByConditions(billNotificationInfo);
        updateInvoice.setMailStatus(InvoiceMailStatus.NOT_SIGNED.getCode());
        this.payInvoiceInfoMapper.updateMailStatus(updateInvoice);
    }
}

