/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import cn.hutool.core.util.StrUtil;
import com.tydic.active.app.ability.ActQryActivitiesByConditionAbilityService;
import com.tydic.order.pec.bo.pay.UocPebUpdateBillStatusReqBO;
import com.tydic.pfscext.api.aisino.FscSendApplyAdviceMsgService;
import com.tydic.pfscext.api.aisino.bo.SendApplyAdviceMsgReqBO;
import com.tydic.pfscext.api.notify.bo.CancelApplyInfoBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.CancelApplyInfoMapper;
import com.tydic.pfscext.dao.NotificationRejectOrderInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.NotificationRejectOrderInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.CancelApplyStatus;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.SendApplyAdviceType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.uoc.api.FscUocPebUpdateBillStatusExternalService;
import com.tydic.pfscext.service.atom.CancelApplyAuditAtomService;
import com.tydic.pfscext.service.atom.bo.AuditCancelInfoReqBO;
import com.tydic.pfscext.service.atom.bo.AuditCancelInfoRspBO;
import com.tydic.pfscext.utils.DateUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CancelApplyAuditAtomServiceImpl
implements CancelApplyAuditAtomService {
    private static final Logger log = LoggerFactory.getLogger(CancelApplyAuditAtomServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(CancelApplyAuditAtomServiceImpl.class);
    @Resource
    CancelApplyInfoMapper cancelApplyInfoMapper;
    @Resource
    BillNotificationInfoMapper billNotificationInfoMapper;
    @Resource
    PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Resource
    PayItemInfoMapper payItemInfoMapper;
    @Resource
    BillApplyInfoMapper billApplyInfoMapper;
    @Resource
    SaleOrderInfoMapper saleOrderInfoMapper;
    @Resource
    SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private FscUocPebUpdateBillStatusExternalService fscUocPebUpdateBillStatusExternalService;
    @Autowired
    private NotificationRejectOrderInfoMapper notificationRejectOrderInfoMapper;
    @Autowired
    private FscSendApplyAdviceMsgService fscSendApplyAdviceMsgService;
    @Autowired
    private ActQryActivitiesByConditionAbilityService actQryActivitiesByConditionAbilityService;
    @Value(value="${UNC_MESSAGE_SENDING_FLAG:0}")
    private String UNC_MESSAGE_SENDING_FLAG;

    @Override
    @Transactional
    public AuditCancelInfoRspBO auditCancelInfo(AuditCancelInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5ba1\u6838\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)reqBO.getQxApplyNo())) {
            throw new PfscExtBusinessException("0001", "\u5ba1\u6838\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u53f7[qxApplyNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new PfscExtBusinessException("0001", "\u5ba1\u6838\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-\u5ba1\u6838\u4ebaID[userID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)reqBO.getName())) {
            throw new PfscExtBusinessException("0001", "\u5ba1\u6838\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-\u5ba1\u6838\u4eba\u540d\u79f0[name]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)reqBO.getQxApplyStatus())) {
            throw new PfscExtBusinessException("0001", "\u5ba1\u6838\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-\u72b6\u6001[qxApplyStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AuditCancelInfoRspBO rspBO = new AuditCancelInfoRspBO();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("qxApplyNo", reqBO.getQxApplyNo());
        param.put("applyNo", reqBO.getApplyNo());
        CancelApplyInfoBO info = this.cancelApplyInfoMapper.selectCancelApplyInfoByCondition(param);
        if (null == info) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u8be5\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01\u7533\u8bf7\u5355\u53f7\uff1a" + reqBO.getQxApplyNo());
            return rspBO;
        }
        info.setAuditId(reqBO.getUserId());
        info.setAuditName(reqBO.getName());
        info.setAuditDate(new Date());
        info.setAuditDesc(reqBO.getAuditDesc());
        info.setQxApplyStatus(reqBO.getQxApplyStatus());
        int a = this.cancelApplyInfoMapper.updateCancelApplyInfo(info);
        if (a <= 0) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5ba1\u6838\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25\uff01");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5ba1\u6838\u8bb0\u5f55\u5df2\u66f4\u65b0\uff01");
        if ("1".equals(info.getQxApplyType())) {
            BillNotificationInfo updateInfo = new BillNotificationInfo();
            updateInfo.setNotificationNo(info.getApplyNo());
            List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(info.getApplyNo());
            if (CancelApplyStatus.PASSED.getCode().equals(info.getQxApplyStatus())) {
                updateInfo.setInvoiceStatus(NotificationInvoiceStatus.HAS_CANCEL.getCode());
                this.dealNotifiRejectInsert(info.getApplyNo());
                PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
                vo.setNotificationNo(info.getApplyNo());
                vo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                this.payPurchaseOrderInfoMapper.updateFailResult(vo);
                PayItemInfo itemInfo = new PayItemInfo();
                itemInfo.setNotificationNo(info.getApplyNo());
                this.payItemInfoMapper.updateBackToInit(itemInfo);
                this.updateUocBillStatus(info.getApplyNo(), OrderStatus.NO_APPLY, info.getQxApplyType());
            } else if (CancelApplyStatus.REJECT.getCode().equals(info.getQxApplyStatus())) {
                updateInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
            }
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(updateInfo);
            if (!org.springframework.util.StringUtils.isEmpty((Object)updateInfo.getNotificationNo()) && !org.springframework.util.StringUtils.isEmpty((Object)info.getQxApplyStatus())) {
                this.sendNotificationAdvice(updateInfo.getNotificationNo(), info.getQxApplyStatus(), payPurchaseOrderInfos);
            }
        } else if ("2".equals(info.getQxApplyType())) {
            BillApplyInfo billApplyInfo = new BillApplyInfo();
            billApplyInfo.setApplyNo(info.getApplyNo());
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setApplyNo(info.getApplyNo());
            List<SaleOrderInfo> listByApplyNo = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
            if (CancelApplyStatus.PASSED.getCode().equals(info.getQxApplyStatus())) {
                billApplyInfo.setBillStatus(BillStatus.CANCEL_APPLY.getCode());
                SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                saleOrderInfo.setApplyNo(info.getApplyNo());
                saleOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                this.saleOrderInfoMapper.updateBillStatusToNoApply(saleOrderInfo);
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                saleItemInfo.setApplyNo(info.getApplyNo());
                saleItemInfo.setItemStatus("00");
                this.saleItemInfoMapper.updateItemStatusBackToNew(saleItemInfo);
                this.updateUocBillStatus(info.getApplyNo(), OrderStatus.NO_APPLY, info.getQxApplyType());
            } else if (CancelApplyStatus.REJECT.getCode().equals(info.getQxApplyStatus())) {
                billApplyInfo.setBillStatus(BillStatus.NO_APPLY.getCode());
            }
            this.billApplyInfoMapper.updateByPrimaryKeySelective(billApplyInfo);
            if (!org.springframework.util.StringUtils.isEmpty((Object)billApplyInfo.getApplyNo()) && !org.springframework.util.StringUtils.isEmpty((Object)info.getQxApplyStatus())) {
                this.sendApplyAdvice(billApplyInfo.getApplyNo(), info.getQxApplyStatus(), listByApplyNo);
            }
        }
        return rspBO;
    }

    private void sendApplyAdvice(String applyNo, String qxApplyStatus, List<SaleOrderInfo> listByApplyNo) {
        try {
            if (!YesOrNo.YES.getCodeAsString().equals(this.UNC_MESSAGE_SENDING_FLAG)) {
                log.info("\u901a\u77e5\u914d\u7f6e\u4e0d\u53d1\u9001\u901a\u77e5\uff0c\u76f4\u63a5\u7ed3\u675f");
                return;
            }
            SendApplyAdviceMsgReqBO reqBO = this.initSendAdviceReqBo(applyNo, qxApplyStatus);
            if (org.springframework.util.StringUtils.isEmpty((Object)listByApplyNo.get(0).getActivityId())) {
                reqBO.setTitle(SendApplyAdviceType.UNIFIED_SIGNATURE_DOWN_CANCEL_RESULT.getAdviceName());
                reqBO.setReceiverId(listByApplyNo.get(0).getPurchaserId());
            } else {
                reqBO.setTitle(SendApplyAdviceType.STAFF_CANCEL_RESULT.getAdviceName());
                reqBO.setActivityId(listByApplyNo.get(0).getActivityId());
            }
            reqBO.setOrgId(listByApplyNo.get(0).getPurchaseNo());
            this.fscSendApplyAdviceMsgService.sendApplyAdvice(reqBO);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u53d1\u7968\u7533\u8bf7\u5355\u53d6\u6d88\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5931\u8d25\uff01");
        }
    }

    private void sendNotificationAdvice(String notificationNo, String qxApplyStatus, List<PayPurchaseOrderInfo> payPurchaseOrderInfos) {
        try {
            if (!YesOrNo.YES.getCodeAsString().equals(this.UNC_MESSAGE_SENDING_FLAG)) {
                log.info("\u901a\u77e5\u914d\u7f6e\u4e0d\u53d1\u9001\u901a\u77e5\uff0c\u76f4\u63a5\u7ed3\u675f");
                return;
            }
            SendApplyAdviceMsgReqBO reqBO = this.initSendAdviceReqBo(notificationNo, qxApplyStatus);
            if (CollectionUtils.isEmpty(payPurchaseOrderInfos)) {
                throw new PfscExtBusinessException("18003", "\u53d1\u9001\u901a\u77e5\u65f6\u672a\u67e5\u5230\u8ba2\u5355\u4fe1\u606f!");
            }
            if ("0".equals(payPurchaseOrderInfos.get(0).getBusiModel())) {
                reqBO.setTitle(SendApplyAdviceType.UNIFIED_SIGNATURE_UP_CANCEL_RESULT.getAdviceName());
                reqBO.setReceiver(SendApplyAdviceType.UNIFIED_SIGNATURE_UP_CANCEL_RESULT.getReceiver());
                reqBO.setOrgId(payPurchaseOrderInfos.get(0).getOperUnitNo());
            } else if ("1".equals(payPurchaseOrderInfos.get(0).getBusiModel())) {
                if (StringUtils.isNotEmpty((String)payPurchaseOrderInfos.get(0).getNoAgreeOrderCategory()) && "0".equals(payPurchaseOrderInfos.get(0).getNoAgreeOrderCategory())) {
                    reqBO.setOrgId(payPurchaseOrderInfos.get(0).getPurchaseNo());
                    reqBO.setTitle(SendApplyAdviceType.REDUNDANCY_CANCEL_RESULT.getAdviceName());
                } else {
                    reqBO.setOrgId(payPurchaseOrderInfos.get(0).getPurchaseNo());
                    reqBO.setTitle(SendApplyAdviceType.SUBCONTRACTING_CANCEL_RESULT.getAdviceName());
                }
                reqBO.setReceiverId(payPurchaseOrderInfos.get(0).getPurchaserId());
            }
            this.fscSendApplyAdviceMsgService.sendApplyAdvice(reqBO);
        }
        catch (Exception e) {
            log.error("\u5f00\u7968\u901a\u77e5\u5355\u53d6\u6d88\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u53d1\u9001\u5931\u8d25\uff01");
        }
    }

    public SendApplyAdviceMsgReqBO initSendAdviceReqBo(String applyNo, String qxApplyStatus) {
        SendApplyAdviceMsgReqBO reqBO = new SendApplyAdviceMsgReqBO();
        reqBO.setBusinessDate(DateUtil.dateToStr(new Date()));
        reqBO.setTemplateName("\u7ed3\u7b97\u53d6\u6d88\u7533\u8bf7\u5ba1\u6838\u7ed3\u679c");
        reqBO.setNotificationNo(applyNo);
        if (qxApplyStatus.equals(CancelApplyStatus.PASSED.getCode())) {
            reqBO.setQxApplyResult("\u901a\u8fc7");
        } else if (qxApplyStatus.equals(CancelApplyStatus.REJECT.getCode())) {
            reqBO.setQxApplyResult("\u9a73\u56de");
        }
        return reqBO;
    }

    private void updateUocBillStatus(String applyNo, OrderStatus orderStatus, String qxApplyType) {
        List orderIds;
        List<SaleOrderInfo> orderInfos;
        if (StrUtil.isBlank((CharSequence)applyNo)) {
            log.error("\u5f00\u7968\u7533\u8bf7\u5355\u4e3a\u7a7a");
            return;
        }
        if ("1".equals(qxApplyType)) {
            List orderIds2;
            List<PayPurchaseOrderInfo> orderInfos2 = this.payPurchaseOrderInfoMapper.selectByNotifNo(applyNo);
            if (!CollectionUtils.isEmpty(orderInfos2) && BusiModel.MATCH_UP_MODEL.getCode().equals(orderInfos2.get(0).getBusiModel()) && !CollectionUtils.isEmpty(orderIds2 = orderInfos2.stream().map(PayPurchaseOrderInfo::getOrderId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                UocPebUpdateBillStatusReqBO updateBillStatusReqBO = new UocPebUpdateBillStatusReqBO();
                updateBillStatusReqBO.setOrderIds(orderIds2);
                updateBillStatusReqBO.setBillState(Integer.valueOf(orderStatus.getCode()));
                this.fscUocPebUpdateBillStatusExternalService.updateBillStatus(updateBillStatusReqBO);
            }
        } else if ("2".equals(qxApplyType) && !CollectionUtils.isEmpty(orderInfos = this.saleOrderInfoMapper.getModelByApplyNo(applyNo)) && !CollectionUtils.isEmpty(orderIds = orderInfos.stream().map(SaleOrderInfo::getOrderId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            UocPebUpdateBillStatusReqBO updateBillStatusReqBO = new UocPebUpdateBillStatusReqBO();
            updateBillStatusReqBO.setBillState(Integer.valueOf(orderStatus.getCode()));
            updateBillStatusReqBO.setOrderIds(orderIds);
            this.fscUocPebUpdateBillStatusExternalService.updateBillStatus(updateBillStatusReqBO);
        }
    }

    private void dealNotifiRejectInsert(String notificationNo) {
        List<PayPurchaseOrderInfo> orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
        if (CollectionUtils.isEmpty(orders)) {
            throw new PfscExtBusinessException("18000", "\u901a\u77e5\u5355\u6240\u542b\u8ba2\u5355\u4e3a\u7a7a");
        }
        List<NotificationRejectOrderInfo> rejectOrderInfoList = orders.stream().map(payPurchaseOrderInfo -> {
            NotificationRejectOrderInfo rejectOrderInfo = new NotificationRejectOrderInfo();
            BeanUtils.copyProperties((Object)payPurchaseOrderInfo, (Object)rejectOrderInfo);
            rejectOrderInfo.setCreateDate(new Date());
            rejectOrderInfo.setOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
            return rejectOrderInfo;
        }).collect(Collectors.toList());
        this.notificationRejectOrderInfoMapper.insertBatch(rejectOrderInfoList);
    }
}

