/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.EntryInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.ReceiptInfoMapper;
import com.tydic.pfscext.dao.StocksDetailMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.EntryInfoPO;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.ReceiptInfoPO;
import com.tydic.pfscext.dao.po.StocksDetail;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.dao.vo.Statis;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import com.tydic.pfscext.service.atom.CreateReturnEntryInfoService;
import com.tydic.pfscext.service.atom.bo.CreateReturnEntryInfoReqBO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CreateReturnEntryInfoServiceImpl
implements CreateReturnEntryInfoService {
    private static final Logger logger = LoggerFactory.getLogger(CreateReturnEntryInfoServiceImpl.class);
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private EntryInfoMapper entryInfoMapper;
    @Autowired
    private ReceiptInfoMapper receiptInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private StocksDetailMapper stocksDetailMapper;

    @Override
    public String createEntryInfo(CreateReturnEntryInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u751f\u6210\u5165\u5e93\u5355\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        if (reqBO.getRedNotificationNo() == null && !StringUtils.hasText((String)reqBO.getRedNotificationNo())) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getEntryType() != 1 && reqBO.getEntryType() != 2) {
            throw new PfscExtBusinessException("0001", "\u5165\u5e93\u7c7b\u578b\u503c\u4e0d\u6b63\u786e");
        }
        if (null == reqBO.getWriteoffAmt() || reqBO.getWriteoffAmt().compareTo(BigDecimal.ZERO) < 0) {
            throw new PfscExtBusinessException("0001", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u5c0f\u4e8e0");
        }
        PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
        payItemInfoVO.setNotificationNo(reqBO.getOldNotificationNo());
        payItemInfoVO.setInvoiceNo(reqBO.getInvoiceNo());
        List<PayItemInfo> itemList = this.payItemInfoMapper.selectBy(payItemInfoVO);
        if (null == itemList || itemList.isEmpty()) {
            logger.error("\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f\u8bb0\u5f55\uff0c\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u4e3a\uff1a" + reqBO.getOldNotificationNo());
            return null;
        }
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(reqBO.getRedNotificationNo());
        if (billNotificationInfo == null) {
            logger.error("\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u5bf9\u5e94\u7684\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55\uff0c\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u4e3a\uff1a" + reqBO.getRedNotificationNo());
            return null;
        }
        Statis statis = this.payInvoiceInfoMapper.invoiceStatis(reqBO.getRedNotificationNo());
        Date entryDate = new Date();
        String entryNo = this.billSNService.getSnAsString(BillType.PURCHASE_STORAGE);
        for (PayItemInfo payItemInfo : itemList) {
            ReceiptInfoPO receiptInfoPO = new ReceiptInfoPO();
            BeanUtils.copyProperties((Object)payItemInfo, (Object)receiptInfoPO);
            receiptInfoPO.setOrderNo(payItemInfo.getOrderId());
            receiptInfoPO.setNotTaxAmt(payItemInfo.getUntaxAmt().negate());
            receiptInfoPO.setTaxAmt(receiptInfoPO.getTaxAmt().negate());
            receiptInfoPO.setTaxPercent(payItemInfo.getTaxRate());
            receiptInfoPO.setEntryDate(entryDate);
            receiptInfoPO.setEntryNo(entryNo);
            this.receiptInfoMapper.insert(receiptInfoPO);
            StocksDetail stocksDetail = new StocksDetail();
            BeanUtils.copyProperties((Object)payItemInfo, (Object)stocksDetail);
            stocksDetail.setEntryNo(entryNo);
            stocksDetail.setRemainQuality(payItemInfo.getQuantity());
            stocksDetail.setEntryDate(entryDate);
            this.stocksDetailMapper.insert(stocksDetail);
        }
        EntryInfoPO entryInfoPO = new EntryInfoPO();
        entryInfoPO.setEntryDate(entryDate);
        entryInfoPO.setEntryNo(entryNo);
        entryInfoPO.setEntryType(reqBO.getEntryType());
        entryInfoPO.setNotificationNo(reqBO.getRedNotificationNo());
        entryInfoPO.setPurchaseId(billNotificationInfo.getSupplierNo());
        entryInfoPO.setNotTaxAmt(statis.getTotUntaxAmt().negate());
        entryInfoPO.setTax(statis.getTotTaxAmt().negate());
        entryInfoPO.setAmt(statis.getTotAmt().negate());
        entryInfoPO.setStatus("01");
        entryInfoPO.setSource(billNotificationInfo.getSource());
        entryInfoPO.setOprCompanyId(billNotificationInfo.getOperNo());
        entryInfoPO.setWriteoffAmt(reqBO.getWriteoffAmt());
        entryInfoPO.setCreateUser(reqBO.getUserId());
        entryInfoPO.setBranchCompany(billNotificationInfo.getBranchCompany());
        this.entryInfoMapper.insert(entryInfoPO);
        return entryNo;
    }
}

