/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import com.tydic.pfscext.dao.OutstockInfoMapper;
import com.tydic.pfscext.dao.OutstockTotalMapper;
import com.tydic.pfscext.dao.vo.OutstockInfoVO;
import com.tydic.pfscext.service.atom.FscCancelOutstockTotalAtomService;
import com.tydic.pfscext.service.atom.bo.FscCancelOutstockTotalAtomReqBO;
import com.tydic.pfscext.service.atom.bo.FscCancelOutstockTotalAtomRspBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="fscCancelOutstockTotalAtomService")
public class FscCancelOutstockTotalAtomServiceImpl
implements FscCancelOutstockTotalAtomService {
    private OutstockInfoMapper outstockInfoMapper;
    private OutstockTotalMapper outstockTotalMapper;

    @Autowired
    public FscCancelOutstockTotalAtomServiceImpl(OutstockInfoMapper outstockInfoMapper, OutstockTotalMapper outstockTotalMapper) {
        this.outstockInfoMapper = outstockInfoMapper;
        this.outstockTotalMapper = outstockTotalMapper;
    }

    @Override
    public FscCancelOutstockTotalAtomRspBO cancelOutstockTotal(FscCancelOutstockTotalAtomReqBO reqBO) {
        FscCancelOutstockTotalAtomRspBO rspBO = new FscCancelOutstockTotalAtomRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        String docNumStr = reqBO.getDocNum();
        OutstockInfoVO outstockInfoVO = new OutstockInfoVO();
        outstockInfoVO.setTotalNo(docNumStr);
        int cancelOutstockTotal = this.outstockInfoMapper.cancelOutstockTotal(outstockInfoVO);
        if (cancelOutstockTotal < 1) {
            rspBO.setRespCode("18006");
            rspBO.setRespDesc("\u53d6\u6d88\u51fa\u5e93\u6c47\u603b\u5355\u5931\u8d25");
            return rspBO;
        }
        int delete = this.outstockTotalMapper.deleteByPrimaryKey(docNumStr);
        if (delete < 1) {
            rspBO.setRespCode("18006");
            rspBO.setRespDesc("\u53d6\u6d88\u51fa\u5e93\u6c47\u603b\u5355\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u53d6\u6d88\u51fa\u5e93\u6c47\u603b\u5355\u6210\u529f");
        return rspBO;
    }

    private String validateArg(FscCancelOutstockTotalAtomReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getDocNum()) {
            return "\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

