/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import cn.hutool.crypto.digest.DigestUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.dao.FscExtInterLogMapper;
import com.tydic.pfscext.dao.FscSyntheticMapper;
import com.tydic.pfscext.dao.po.FscExtInterLogPO;
import com.tydic.pfscext.dao.po.FscSyntheticPO;
import com.tydic.pfscext.service.atom.FscExtInterLogAtomService;
import com.tydic.pfscext.service.atom.bo.FscExtInterLogAtomReqBO;
import com.tydic.pfscext.service.atom.bo.FscExtInterLogAtomRspBO;
import com.tydic.pfscext.service.atom.bo.FscExtInterLogBatchAddAtomReqBO;
import com.tydic.pfscext.service.atom.bo.FscExtInterLogBatchAddAtomRspBO;
import com.tydic.pfscext.service.atom.bo.FscExtInterLogBatchAddInfoBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscExtInterLogAtomServiceImpl
implements FscExtInterLogAtomService {
    @Autowired
    private FscExtInterLogMapper fscExtInterLogMapper;
    @Autowired
    private FscSyntheticMapper fscSyntheticMapper;
    @Value(value="${FSC_EXT_INTER_LOG_CONTENT_MAX_LENGTH:1024}")
    private Integer FSC_EXT_INTER_LOG_CONTENT_MAX_LENGTH;

    @Override
    public FscExtInterLogAtomRspBO dealFscExtInterLogAdd(FscExtInterLogAtomReqBO reqBo) {
        FscExtInterLogPO fscExtInterLogPo = FscRu.js((Object)reqBo, FscExtInterLogPO.class);
        fscExtInterLogPo.setId(Sequence.getInstance().nextId());
        ArrayList<FscSyntheticPO> syntheticList = new ArrayList<FscSyntheticPO>();
        fscExtInterLogPo.setInContent(this.initSyntheticPo(syntheticList, reqBo.getInContent()));
        fscExtInterLogPo.setOutContent(this.initSyntheticPo(syntheticList, reqBo.getOutContent()));
        if (!CollectionUtils.isEmpty(syntheticList)) {
            this.fscSyntheticMapper.insertBatch(syntheticList);
        }
        this.fscExtInterLogMapper.insert(fscExtInterLogPo);
        return FscRu.success(FscExtInterLogAtomRspBO.class);
    }

    @Override
    public FscExtInterLogBatchAddAtomRspBO dealFscExtInterLogBatchAdd(FscExtInterLogBatchAddAtomReqBO reqBo) {
        if (!CollectionUtils.isEmpty(reqBo.getInfoList())) {
            ArrayList<FscSyntheticPO> syntheticList = new ArrayList<FscSyntheticPO>();
            ArrayList<FscExtInterLogPO> fscExtInterLogList = new ArrayList<FscExtInterLogPO>();
            for (FscExtInterLogBatchAddInfoBO item : reqBo.getInfoList()) {
                FscExtInterLogPO fscExtInterLogPo = FscRu.js(item, FscExtInterLogPO.class);
                fscExtInterLogPo.setId(Sequence.getInstance().nextId());
                fscExtInterLogPo.setInContent(this.initSyntheticPo(syntheticList, item.getInContent()));
                fscExtInterLogPo.setOutContent(this.initSyntheticPo(syntheticList, item.getOutContent()));
                fscExtInterLogList.add(fscExtInterLogPo);
            }
            if (!CollectionUtils.isEmpty(syntheticList)) {
                for (List subList : ListUtil.batchList(syntheticList, (int)50)) {
                    this.fscSyntheticMapper.insertBatch(subList);
                }
            }
            if (!CollectionUtils.isEmpty(fscExtInterLogList)) {
                for (List subList : ListUtil.batchList(fscExtInterLogList, (int)50)) {
                    this.fscExtInterLogMapper.insertBatch(subList);
                }
            }
        }
        return FscRu.success(FscExtInterLogBatchAddAtomRspBO.class);
    }

    private String initSyntheticPo(List<FscSyntheticPO> syntheticList, String content) {
        if (StringUtils.hasText((String)content) && content.length() > this.FSC_EXT_INTER_LOG_CONTENT_MAX_LENGTH) {
            String fscSyntheticId = String.valueOf(Sequence.getInstance().nextId());
            FscSyntheticPO fscSyntheticPo = new FscSyntheticPO();
            fscSyntheticPo.setId(fscSyntheticId);
            fscSyntheticPo.setContext(content);
            fscSyntheticPo.setHashValue(DigestUtil.md5Hex((String)content));
            syntheticList.add(fscSyntheticPo);
            return fscSyntheticId;
        }
        return content;
    }
}

