/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.constants.FscCommonConstants;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.PropertiesUtil2;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import com.tydic.pfscext.service.atom.FscSendMsgService;
import com.tydic.pfscext.service.atom.bo.FscSendMsgReqBO;
import com.tydic.pfscext.service.atom.bo.FscSendMsgRspBO;
import com.tydic.pfscext.utils.SSLClient;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="fscSendMsgService")
public class FscSendMsgServiceImpl
implements FscSendMsgService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscSendMsgServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    @Override
    public FscSendMsgRspBO dealSendAdvice(FscSendMsgReqBO reqBO) {
        FscSendMsgRspBO rspBO;
        String token = reqBO.getToken();
        if (reqBO.getSendType().equals(FscCommonConstants.ORDER_SEND_MESSAGE)) {
            String requestJsonStr = this.initRequestMessageJsonStr(reqBO);
            LOGGER.debug("\u53d1\u9001\u7ad9\u5185\u4fe1\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
            rspBO = this.sendFrom(requestJsonStr, PropertiesUtil2.getProperty((String)"SEND_INNER_MESSAGE_URL"), token);
        } else if (reqBO.getSendType().equals(FscCommonConstants.ORDER_SEND_EMIL)) {
            String requestJsonStr = this.initRequestEmailJsonStr(reqBO);
            LOGGER.debug("\u53d1\u9001\u90ae\u4ef6\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
            rspBO = this.doUrlPostRequest(requestJsonStr, "NOTIFY_SEND_MAIL_URL", token);
        } else if (reqBO.getSendType().equals(FscCommonConstants.ORDER_SEND_MOBILE)) {
            String requestJsonStr = this.initRequestMobileJsonStr(reqBO);
            LOGGER.debug("\u53d1\u9001\u77ed\u4fe1\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
            rspBO = this.doUrlPostRequest(requestJsonStr, "SEND_ONLY_SMS_MESSAGE_URL", "");
        } else if (reqBO.getSendType().equals(FscCommonConstants.ORDER_SEND_WX)) {
            String requestJsonStr = this.initRequestWXJsonStr(reqBO);
            LOGGER.debug("\u53d1\u9001\u5fae\u4fe1\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
            rspBO = this.doUrlPostRequest(requestJsonStr, "SEND_WX_MESSAGE_URL", "");
        } else {
            rspBO = new FscSendMsgRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u77e5\u901a\u77e5\u7c7b\u578b");
        }
        return rspBO;
    }

    private FscSendMsgRspBO sendFrom(String requestJsonStr, String url, String token) {
        FscSendMsgRspBO rspBO = new FscSendMsgRspBO();
        Map map = (Map)JSONObject.parseObject((String)requestJsonStr, Map.class);
        HashMap<String, String> param = new HashMap<String, String>(map.size());
        for (Map.Entry elem : map.entrySet()) {
            if (elem.getValue() == null) continue;
            param.put((String)elem.getKey(), elem.getValue().toString());
        }
        try {
            HashMap<String, String> header = null;
            if (token != null) {
                header = new HashMap<String, String>(1);
                header.put("auth-token", token);
            }
            String rsp = SSLClient.doPost(url, param, header);
            LOGGER.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a" + rsp);
            rspBO = this.resolveRsp(rsp);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private FscSendMsgRspBO doUrlPostRequest(String requestJsonStr, String url, String token) {
        FscSendMsgRspBO rspBO = new FscSendMsgRspBO();
        try {
            HttpRetBean httpRetBean;
            Header[] headers = HSNHttpHeader.getRequestHeaders((String)"json");
            if (StringUtils.isNotBlank((CharSequence)token)) {
                Header[] header = new Header[headers.length + 1];
                System.arraycopy(headers, 0, header, 0, headers.length);
                header[headers.length] = new BasicHeader("auth-token", token);
                httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil2.getProperty((String)url)), (Header[])header, (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            } else {
                httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil2.getProperty((String)url)), (Header[])headers, (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            }
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil2.getProperty((String)url) + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new PfscExternalBusinessException("2001", "\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        return rspBO;
    }

    private String initRequestEmailJsonStr(FscSendMsgReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("to", (Object)reqBO.getEmail());
        jsonObject.put("content", (Object)reqBO.getText());
        jsonObject.put("subject", (Object)reqBO.getSubject());
        return jsonObject.toJSONString();
    }

    private String initRequestMobileJsonStr(FscSendMsgReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("mobile", (Object)reqBO.getMobile());
        jsonObject.put("content", (Object)reqBO.getText());
        return jsonObject.toJSONString();
    }

    private String initRequestMessageJsonStr(FscSendMsgReqBO reqBO) {
        if (null == reqBO.getUserId()) {
            throw new PfscExternalBusinessException("0001", "\u53d1\u9001\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getReceiveId()) {
            throw new PfscExternalBusinessException("0001", "\u63a5\u6536\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getTitel())) {
            throw new PfscExternalBusinessException("0001", "\u901a\u77e5\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getText())) {
            throw new PfscExternalBusinessException("0001", "\u901a\u77e5\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sendid", (Object)reqBO.getUserId());
        jsonObject.put("recid", (Object)reqBO.getReceiveId());
        jsonObject.put("appid", (Object)PropertiesUtil2.getProperty((String)"APP_ID"));
        jsonObject.put("titel", (Object)reqBO.getTitel());
        jsonObject.put("text", (Object)reqBO.getText());
        jsonObject.put("token", (Object)reqBO.getToken());
        if (null != reqBO.getTemplateId() && reqBO.getTemplateId() != 0L) {
            jsonObject.put("templateId", (Object)reqBO.getTemplateId());
            jsonObject.put("templateParam", (Object)JSON.toJSONString(reqBO.getTemplateParam()));
        }
        return jsonObject.toJSONString();
    }

    private String initRequestWXJsonStr(FscSendMsgReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("touser", (Object)reqBO.getOpenId());
        jsonObject.put("template_id", (Object)reqBO.getTemplateIdWX());
        LinkedHashMap<String, JSONObject> data = new LinkedHashMap<String, JSONObject>();
        JSONObject title = new JSONObject();
        title.put("value", (Object)reqBO.getTitel());
        data.put("first", title);
        JSONObject content = new JSONObject();
        content.put("value", (Object)reqBO.getText());
        data.put("keyword1", content);
        JSONObject time = new JSONObject();
        time.put("value", (Object)DateUtil.formatDateTime((Date)new Date()));
        data.put("keyword2", time);
        jsonObject.put("data", data);
        return jsonObject.toJSONString();
    }

    private FscSendMsgRspBO resolveRsp(String returnString) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        }
        FscSendMsgRspBO rspBO = new FscSendMsgRspBO();
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u63d0\u9192\u6210\u529f!");
        return rspBO;
    }
}

