/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.SplitNotificationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SplitNotificationServiceImpl
implements SplitNotificationService {
    private static final Logger log = LoggerFactory.getLogger(SplitNotificationServiceImpl.class);
    @Value(value="${NOTI_MAX_SPLIT_NUM}")
    private Integer maxSplitNum;
    private final String DEFULT = "0";
    private final String SINGLE = "1";
    private final String EMPLOYEE = "3";

    @Override
    public List<List<PayPurchaseOrderInfo>> splitNotification(List<PayPurchaseOrderInfoVO> orderInfoList, String groupWay) {
        if (CollectionUtils.isEmpty(orderInfoList) || StringUtils.isEmpty((Object)groupWay)) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("\u6b64\u6b21\u5f00\u7968\u901a\u77e5\u5355\u62c6\u5355\u65b9\u5f0f\u4e3a=========" + groupWay);
        List<List<PayPurchaseOrderInfo>> splitOrderInfos = "0".equals(groupWay) ? this.defaultSplitWay(orderInfoList) : ("1".equals(groupWay) ? this.singleSplitWay(orderInfoList) : ("3".equals(groupWay) ? this.employeeSplitWay(orderInfoList) : this.purchaseSplitWay(orderInfoList)));
        return splitOrderInfos;
    }

    private List<List<PayPurchaseOrderInfo>> employeeSplitWay(List<PayPurchaseOrderInfoVO> orderInfoList) {
        LinkedList<List<PayPurchaseOrderInfo>> splitOrderInfos = new LinkedList<List<PayPurchaseOrderInfo>>();
        HashMap orderListMap = new HashMap();
        StringBuffer keyBuffer = new StringBuffer();
        for (PayPurchaseOrderInfoVO payPurchaseOrderInfoVO : orderInfoList) {
            keyBuffer.append(payPurchaseOrderInfoVO.getSupplierNo());
            keyBuffer.append("_").append(payPurchaseOrderInfoVO.getPayType());
            keyBuffer.append("_").append(payPurchaseOrderInfoVO.getSource());
            keyBuffer.append("_").append(payPurchaseOrderInfoVO.getActivityId());
            if (payPurchaseOrderInfoVO.getIsErp() != null) {
                keyBuffer.append("_").append(payPurchaseOrderInfoVO.getIsErp());
            } else {
                keyBuffer.append("_").append("0");
            }
            String key = keyBuffer.toString();
            PayPurchaseOrderInfo orderInfo = new PayPurchaseOrderInfo();
            BeanUtils.copyProperties((Object)payPurchaseOrderInfoVO, (Object)orderInfo);
            if (orderListMap.containsKey(key)) {
                ((List)orderListMap.get(key)).add(orderInfo);
                continue;
            }
            LinkedList<PayPurchaseOrderInfo> orderList = new LinkedList<PayPurchaseOrderInfo>();
            orderList.add(orderInfo);
            orderListMap.put(key, orderList);
        }
        for (Map.Entry entry : orderListMap.entrySet()) {
            List orderInfos = (List)entry.getValue();
            if (orderInfos.size() > this.maxSplitNum) {
                List<List<PayPurchaseOrderInfo>> maxNumSplitOrderList = this.maxNumSplit(orderInfos);
                splitOrderInfos.addAll(maxNumSplitOrderList);
                continue;
            }
            splitOrderInfos.add(orderInfos);
        }
        return splitOrderInfos;
    }

    private List<List<PayPurchaseOrderInfo>> defaultSplitWay(List<PayPurchaseOrderInfoVO> orderInfoList) {
        LinkedList<List<PayPurchaseOrderInfo>> splitOrderInfos = new LinkedList<List<PayPurchaseOrderInfo>>();
        boolean flag = "1".equals(orderInfoList.get(0).getBusiModel());
        HashMap orderListMap = new HashMap();
        for (PayPurchaseOrderInfoVO payPurchaseOrderInfoVO : orderInfoList) {
            StringBuffer keyBuffer = new StringBuffer();
            keyBuffer.append(payPurchaseOrderInfoVO.getSupplierNo());
            if (flag) {
                keyBuffer.append("_").append(payPurchaseOrderInfoVO.getPayType());
            }
            keyBuffer.append("_").append(payPurchaseOrderInfoVO.getSource());
            if ("1".equals(payPurchaseOrderInfoVO.getSource()) && !StringUtils.isEmpty((Object)payPurchaseOrderInfoVO.getAgreementId())) {
                keyBuffer.append("_").append(payPurchaseOrderInfoVO.getAgreementId());
            } else if (!StringUtils.isEmpty((Object)payPurchaseOrderInfoVO.getSettleInContractId())) {
                keyBuffer.append("_").append(payPurchaseOrderInfoVO.getSettleInContractId());
            }
            if (payPurchaseOrderInfoVO.getActivityId() != null) {
                keyBuffer.append("_").append(payPurchaseOrderInfoVO.getActivityId());
            }
            if (payPurchaseOrderInfoVO.getIsErp() != null) {
                keyBuffer.append("_").append(payPurchaseOrderInfoVO.getIsErp());
            } else {
                keyBuffer.append("_").append("0");
            }
            String key = keyBuffer.toString();
            PayPurchaseOrderInfo orderInfo = new PayPurchaseOrderInfo();
            BeanUtils.copyProperties((Object)payPurchaseOrderInfoVO, (Object)orderInfo);
            if (orderListMap.containsKey(key)) {
                ((List)orderListMap.get(key)).add(orderInfo);
                continue;
            }
            LinkedList<PayPurchaseOrderInfo> orderList = new LinkedList<PayPurchaseOrderInfo>();
            orderList.add(orderInfo);
            orderListMap.put(key, orderList);
        }
        for (Map.Entry entry : orderListMap.entrySet()) {
            List orderInfos = (List)entry.getValue();
            if (orderInfos.size() > this.maxSplitNum) {
                List<List<PayPurchaseOrderInfo>> maxNumSplitOrderList = this.maxNumSplit(orderInfos);
                splitOrderInfos.addAll(maxNumSplitOrderList);
                continue;
            }
            splitOrderInfos.add(orderInfos);
        }
        return splitOrderInfos;
    }

    private List<List<PayPurchaseOrderInfo>> singleSplitWay(List<PayPurchaseOrderInfoVO> orderInfoList) {
        LinkedList<List<PayPurchaseOrderInfo>> splitOrderInfos = new LinkedList<List<PayPurchaseOrderInfo>>();
        for (PayPurchaseOrderInfoVO payPurchaseOrderInfoVO : orderInfoList) {
            ArrayList<PayPurchaseOrderInfo> singleList = new ArrayList<PayPurchaseOrderInfo>();
            PayPurchaseOrderInfo orderInfo = new PayPurchaseOrderInfo();
            BeanUtils.copyProperties((Object)payPurchaseOrderInfoVO, (Object)orderInfo);
            singleList.add(orderInfo);
            splitOrderInfos.add(singleList);
        }
        return splitOrderInfos;
    }

    private List<List<PayPurchaseOrderInfo>> purchaseSplitWay(List<PayPurchaseOrderInfoVO> orderInfoList) {
        LinkedList<List<PayPurchaseOrderInfo>> splitOrderInfos = new LinkedList<List<PayPurchaseOrderInfo>>();
        HashMap orderListMap = new HashMap();
        for (PayPurchaseOrderInfoVO payPurchaseOrderInfoVO : orderInfoList) {
            StringBuffer keyBuffer = new StringBuffer();
            keyBuffer.append(payPurchaseOrderInfoVO.getPurchaseNo()).append("_").append(payPurchaseOrderInfoVO.getSupplierNo()).append("_").append(payPurchaseOrderInfoVO.getSource());
            if ("1".equals(payPurchaseOrderInfoVO.getSource())) {
                keyBuffer.append("_").append(payPurchaseOrderInfoVO.getAgreementId());
            } else {
                keyBuffer.append("_").append(payPurchaseOrderInfoVO.getSettleInContractId());
            }
            if (payPurchaseOrderInfoVO.getActivityId() != null) {
                keyBuffer.append("_").append(payPurchaseOrderInfoVO.getActivityId());
            }
            if (payPurchaseOrderInfoVO.getIsErp() != null) {
                keyBuffer.append("_").append(payPurchaseOrderInfoVO.getIsErp());
            } else {
                keyBuffer.append("_").append("0");
            }
            String key = keyBuffer.toString();
            PayPurchaseOrderInfo orderInfo = new PayPurchaseOrderInfo();
            BeanUtils.copyProperties((Object)payPurchaseOrderInfoVO, (Object)orderInfo);
            if (orderListMap.containsKey(key)) {
                ((List)orderListMap.get(key)).add(orderInfo);
                continue;
            }
            LinkedList<PayPurchaseOrderInfo> orderList = new LinkedList<PayPurchaseOrderInfo>();
            orderList.add(orderInfo);
            orderListMap.put(key, orderList);
        }
        for (Map.Entry entry : orderListMap.entrySet()) {
            List orderInfos = (List)entry.getValue();
            if (orderInfos.size() > this.maxSplitNum) {
                List<List<PayPurchaseOrderInfo>> maxNumSplitOrderList = this.maxNumSplit(orderInfos);
                splitOrderInfos.addAll(maxNumSplitOrderList);
                continue;
            }
            splitOrderInfos.add(orderInfos);
        }
        return splitOrderInfos;
    }

    private List<List<PayPurchaseOrderInfo>> maxNumSplit(List<PayPurchaseOrderInfo> orderInfos) {
        LinkedList<List<PayPurchaseOrderInfo>> splitOrderInfos = new LinkedList<List<PayPurchaseOrderInfo>>();
        int count = orderInfos.size() / this.maxSplitNum;
        for (int i = 0; i <= count; ++i) {
            List<PayPurchaseOrderInfo> subList;
            int start = i * this.maxSplitNum;
            int end = (i + 1) * this.maxSplitNum;
            if (i < count) {
                subList = orderInfos.subList(start, end);
                splitOrderInfos.add(subList);
                continue;
            }
            if (start == orderInfos.size()) continue;
            subList = orderInfos.subList(start, orderInfos.size());
            splitOrderInfos.add(subList);
        }
        return splitOrderInfos;
    }
}

