/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.busi.BusiAddPayAbleService;
import com.tydic.pfscext.api.busi.FscCreatePayableNoService;
import com.tydic.pfscext.api.busi.bo.BusiAddPayAbleReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAddPayAbleRspBO;
import com.tydic.pfscext.api.busi.bo.BusiAddPayableRateInfoBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.FscPaymentPenaltyRateMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailChangeMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.FscPaymentPenaltyRatePO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailChange;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.PayablePayType;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import com.tydic.pfscext.service.atom.PayableService;
import com.tydic.pfscext.service.busi.FscPayableDetailUpdateBusiService;
import com.tydic.pfscext.service.busi.bo.FscPayableDetailUpdateOverduePenaltyBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayableDetailUpdateOverduePenaltyBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import com.tydic.pfscext.utils.ValUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiAddPayAbleService"})
public class BusiAddPayAbleServiceImpl
implements BusiAddPayAbleService {
    private static final Logger log = LoggerFactory.getLogger(BusiAddPayAbleServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(BusiAddPayAbleServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private FscPaymentPenaltyRateMapper fscPaymentPenaltyRateMapper;
    @Autowired
    private PayableDetailChangeMapper payableDetailChangeMapper;
    @Autowired
    private PayableService payableService;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private FscCreatePayableNoService fscCreatePayableNoService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private FscPayableDetailUpdateBusiService fscPayableDetailUpdateBusiService;

    @PostMapping(value={"createPayAble"})
    public BusiAddPayAbleRspBO createPayAble(@RequestBody BusiAddPayAbleReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u751f\u6210\u5e94\u4ed8\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getSource() == null || "".equals(reqBO.getSource())) {
            throw new PfscExtBusinessException("0001", "\u6765\u6e90\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayType() || "".equals(reqBO.getPayType())) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayableType()) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayableAmt()) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaserId()) {
            throw new PfscExtBusinessException("0001", "\u4e0b\u5355\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getPaymentType())) {
            throw new PfscExtBusinessException("0001", "\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBusiModel()) {
            throw new PfscExtBusinessException("0001", "\u7ed3\u7b97\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPayableRateInfoList())) {
            for (BusiAddPayableRateInfoBO infoBo : reqBO.getPayableRateInfoList()) {
                ValUtil.isEmpty(infoBo.getBusiId()).exception("\u5408\u540c\u6216\u534f\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
                ValUtil.isEmpty(infoBo.getStartDay()).exception("\u8ba1\u8d39\u8d77\u59cb\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                ValUtil.isEmpty(infoBo.getRate()).exception("\u8d39\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        BusiAddPayAbleRspBO rspBO = new BusiAddPayAbleRspBO();
        try {
            PayableDetailPO po = new PayableDetailPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)po);
            if (reqBO.getPayBusiType() != null && !"".equals(reqBO.getPayBusiType())) {
                if ("4".equals(reqBO.getPayBusiType())) {
                    po.setPayBusiType("7");
                } else if ("5".equals(reqBO.getPayBusiType())) {
                    po.setPayBusiType("8");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)reqBO.getChildPurchaseOrderCodeList())) {
                po.setChildPurchaseOrderCode(reqBO.getChildPurchaseOrderCodeList().stream().filter(StrUtil::isNotBlank).distinct().collect(Collectors.joining(",")));
            }
            String snNo = this.fscCreatePayableNoService.createPayableNoByType(po.getPayableType());
            po.setPayableNo(snNo);
            po.setPayType(PayablePayType.PAY.getCode());
            po.setPaidAmt(BigDecimal.ZERO);
            po.setPendingAmt(BigDecimal.ZERO);
            po.setNeedAgainstAmt(BigDecimal.ZERO);
            Integer days = 0;
            if (null != po.getPaymentDays()) {
                days = days + po.getPaymentDays();
            }
            if (po.getDelayDays() != null) {
                days = days + po.getDelayDays();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(5, days);
            if (PayableType.EXPIRE.getCode().equals(po.getPayableType().toString())) {
                po.setPaidDate(calendar.getTime());
            }
            po.setSendGoodsNo(reqBO.getSendGoodsNo());
            po.setPaymentType(reqBO.getPaymentType());
            po.setSupplierNoList(reqBO.getSupplierId().toString());
            this.payableDetailMapper.insert(po);
            PayableDetailChange change = new PayableDetailChange();
            change.setPayableNo(snNo);
            change.setChangeType("1");
            change.setChangeAmt(po.getPayableAmt());
            change.setUpdateTime(new Date());
            change.setChangeReason(reqBO.getChangeReason());
            change.setOrderCode(po.getPurchaseOrderCode());
            this.payableDetailChangeMapper.insert(change);
            rspBO.setPayableNo(snNo);
            ArrayList<FscPaymentPenaltyRatePO> rateInsertList = new ArrayList<FscPaymentPenaltyRatePO>();
            List payableRateInfoList = reqBO.getPayableRateInfoList();
            if (!CollectionUtils.isEmpty((Collection)payableRateInfoList)) {
                Collections.sort(payableRateInfoList, Comparator.comparing(BusiAddPayableRateInfoBO::getStartDay));
                for (int i = 0; i < payableRateInfoList.size(); ++i) {
                    FscPaymentPenaltyRatePO ratePo = FscRu.js(payableRateInfoList.get(i), FscPaymentPenaltyRatePO.class);
                    ratePo.setRateId(Sequence.getInstance().nextId());
                    ratePo.setSortNo(i);
                    ratePo.setPayableNo(snNo);
                    rateInsertList.add(ratePo);
                }
                if (!CollectionUtils.isEmpty(rateInsertList)) {
                    List batchList = ListUtil.batchList(rateInsertList, (int)50);
                    for (List subList : batchList) {
                        this.fscPaymentPenaltyRateMapper.insertBatch(subList);
                    }
                }
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u65b0\u589e\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25:" + e.toString());
            logger.error("\u65b0\u589e\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25:", (Throwable)e);
            throw new PfscExtBusinessException("0001", "\u65b0\u589e\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25");
        }
        return rspBO;
    }

    @PostMapping(value={"createNotificationPayAble"})
    public BusiAddPayAbleRspBO createNotificationPayAble(@RequestBody BusiAddPayAbleReqBO busiAddPayAbleReqBO) {
        if (StringUtils.isEmpty((Object)busiAddPayAbleReqBO.getNotificationNo())) {
            throw new PfscExtBusinessException("0001", "\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PayableDetailPO po = new PayableDetailPO();
        po.setNotificationNo(busiAddPayAbleReqBO.getNotificationNo());
        PayableDetailPO payableDetailPO = this.payableDetailMapper.getModelBy(po);
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(busiAddPayAbleReqBO.getNotificationNo());
        if (null == payableDetailPO) {
            List<PayPurchaseOrderInfo> payPurchaseOrderInfos;
            Long companyId = billNotificationInfo.getOperNo();
            List<PayableDetailPO> payLs = this.payableService.createPayableBill(busiAddPayAbleReqBO.getNotificationNo(), companyId, "1", "1");
            if (!CollectionUtils.isEmpty(payLs) && !CollectionUtils.isEmpty(payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(busiAddPayAbleReqBO.getNotificationNo()))) {
                List<Long> inspectionIds = payPurchaseOrderInfos.stream().map(PayPurchaseOrderInfo::getInspectionId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                this.updatePayableDetailOverduePenalty(payLs.get(0), inspectionIds);
            }
        }
        BusiAddPayAbleRspBO payAbleRspBO = new BusiAddPayAbleRspBO();
        payAbleRspBO.setRespCode("0000");
        payAbleRspBO.setRespDesc("\u6210\u529f");
        return payAbleRspBO;
    }

    private void updatePayableDetailOverduePenalty(PayableDetailPO payableDetailPo, List<Long> inspectionIds) {
        if (!CollectionUtils.isEmpty(inspectionIds)) {
            FscPayableDetailUpdateOverduePenaltyBusiReqBO reqBo = new FscPayableDetailUpdateOverduePenaltyBusiReqBO();
            reqBo.setPayableNo(payableDetailPo.getPayableNo());
            reqBo.setInspectionIds(inspectionIds);
            FscPayableDetailUpdateOverduePenaltyBusiRspBO rspBo = this.fscPayableDetailUpdateBusiService.dealOverduePenaltyUpdate(reqBo);
            log.debug("\u66f4\u65b0\u8fdd\u7ea6\u91d1\u6267\u884c\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)((Object)rspBo), (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        }
    }
}

