/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.api.busi.BusiCancelApplyPayService;
import com.tydic.pfscext.api.busi.bo.BusiCancelApplyPayReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCancelApplyPayRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.aisino.api.NoticePayHcxCancelPayService;
import com.tydic.pfscext.external.aisino.api.bo.NoticePayHcxCancelPayReqBO;
import com.tydic.pfscext.external.aisino.api.bo.NoticePayHcxCancelPayRspBO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiCancelApplyPayService"})
public class BusiCancelApplyPayServiceImpl
implements BusiCancelApplyPayService {
    private static final Logger log = LoggerFactory.getLogger(BusiCancelApplyPayServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private NoticePayHcxCancelPayService noticePayHcxCancelPayService;

    @PostMapping(value={"cancelApply"})
    public BusiCancelApplyPayRspBO cancelApply(@RequestBody BusiCancelApplyPayReqBO reqBO) {
        log.info("\u6838\u8d22\u4fe1\u53d6\u6d88\u652f\u4ed8\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)reqBO));
        if (StringUtils.isEmpty((CharSequence)reqBO.getPayNo())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2payNo\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCancelReason())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2cancelReason\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        BusiCancelApplyPayRspBO rspBO = new BusiCancelApplyPayRspBO();
        ApplyPayInfoPO applyPayInfo = this.applyPayInfoMapper.getModelById(reqBO.getPayNo());
        if (applyPayInfo == null) {
            throw new PfscExtBusinessException("18001", "\u4ed8\u6b3e\u7533\u8bf7\u4e0d\u5b58\u5728!");
        }
        List<ApplyDetail> applyDetailList = this.applyDetailMapper.selectPayableList(reqBO.getPayNo());
        List<PayableDetailPO> payableDetailPoList = this.payableDetailMapper.getListByApplyNo(reqBO.getPayNo());
        if (CollectionUtils.isEmpty(applyDetailList) || CollectionUtils.isEmpty(payableDetailPoList)) {
            throw new PfscExtBusinessException("18001", "\u8be5\u4ed8\u6b3e\u7533\u8bf7\u672a\u4ea7\u751f\u5e94\u4ed8\u5355!");
        }
        applyPayInfo.setPayStatus(ApplyPayStatus.FAILED.getCode());
        int i = this.applyPayInfoMapper.updateStatus(applyPayInfo);
        if (i <= 0) {
            throw new PfscExtBusinessException("18001", "\u8be5\u4ed8\u6b3e\u5355\u5df2\u4f5c\u5e9f!");
        }
        Map<String, BigDecimal> amtMap = applyDetailList.stream().collect(Collectors.toMap(ApplyDetail::getPayableNo, ApplyDetail::getAmt));
        for (PayableDetailPO payableDetailPo : payableDetailPoList) {
            payableDetailPo.setPayableStatus(PayableStatus.PENDING.getCode());
            BigDecimal amt = amtMap.get(payableDetailPo.getPayableNo());
            payableDetailPo.setPayableAmt(amt);
            payableDetailPo.setCancelReason(reqBO.getCancelReason());
        }
        int j = this.payableDetailMapper.updateByBatch(payableDetailPoList);
        if (j <= 0) {
            throw new PfscExtBusinessException("18001", "\u8be5\u5e94\u4ed8\u5df2\u4e3a\u5f85\u4ed8\u6b3e!");
        }
        int k = this.applyDetailMapper.deleteBatch(applyDetailList);
        if (k <= 0) {
            throw new PfscExtBusinessException("18001", "\u6539\u4ed8\u6b3e\u5355\u5df2\u4f5c\u5e9f!");
        }
        NoticePayHcxCancelPayReqBO noticeReqBO = new NoticePayHcxCancelPayReqBO();
        noticeReqBO.setCancelReason(reqBO.getCancelReason());
        noticeReqBO.setOperatorIdType("RESIDENT_IDC");
        noticeReqBO.setOperatorIdCode("zhds");
        noticeReqBO.setOutOrderId("PAYMENT-" + applyPayInfo.getPayno());
        noticeReqBO.setOperatorName(reqBO.getUsername());
        NoticePayHcxCancelPayRspBO noticeRspBO = this.noticePayHcxCancelPayService.noticePayCenterCancelPay(noticeReqBO);
        if (StringUtils.isEmpty((CharSequence)noticeRspBO.getRespCode())) {
            throw new PfscExtBusinessException("18001", "\u53d6\u6d88\u4ed8\u6b3e\u64cd\u4f5c\u5931\u8d25!");
        }
        if (!noticeRspBO.getRespCode().equals("0000")) {
            throw new PfscExtBusinessException("18000", noticeRspBO.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

