/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.logistics.api.UlcOrderCancelAbilityService;
import com.tydic.logistics.api.bo.UlcOrderCancelAbilityReqBo;
import com.tydic.logistics.api.bo.UlcOrderCancelAbilityRspBo;
import com.tydic.pfscext.api.busi.BusiCancelExpressService;
import com.tydic.pfscext.api.busi.bo.BusiCancelExpressReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCancelExpressRspBO;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceMailInfoMapper;
import com.tydic.pfscext.dao.po.SaleInvoiceMailInfo;
import com.tydic.pfscext.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfscext.enums.InvoiceMailSentStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiCancelExpressService"})
public class BusiCancelExpressServiceImpl
implements BusiCancelExpressService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCancelExpressServiceImpl.class);
    @Autowired
    private SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private UlcOrderCancelAbilityService ulcOrderCancelAbilityService;

    @PostMapping(value={"cancelExpress"})
    public BusiCancelExpressRspBO cancelExpress(@RequestBody BusiCancelExpressReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d6\u6d88\u90ae\u5bc4\u53d1\u7968\u670d\u52a1(\u4e13\u4e1a\u516c\u53f8) \u5165\u53c2\uff1a" + reqBO);
        }
        BusiCancelExpressRspBO rspBO = new BusiCancelExpressRspBO();
        if (reqBO.getCompanyId() == null) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getExpressNo() == null) {
            throw new PfscExtBusinessException("0001", "\u5feb\u9012\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String eachExpressNo : reqBO.getExpressNo()) {
            List<SaleInvoiceMailInfo> expressInfos = this.saleInvoiceMailInfoMapper.selectByExpressNo(eachExpressNo);
            if (expressInfos.isEmpty()) {
                throw new PfscExtBusinessException("18001", "\u5feb\u9012\u5355\u53f7:" + eachExpressNo + "\u5f55\u5165\u4e0d\u6b63\u786e");
            }
            SaleInvoiceMailInfo firstExpressInfo = expressInfos.get(0);
            if (!InvoiceMailSentStatus.NOT_SENT.getCode().equals(firstExpressInfo.getMailStatus())) {
                throw new PfscExtBusinessException("18000", "\u5feb\u9012\u5355\u53f7:" + eachExpressNo + "\u72b6\u6001\u4e3a" + InvoiceMailSentStatus.getInstance(firstExpressInfo.getMailStatus().toString()).getDescr() + "\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88");
            }
            rspBO = this.processCancelExpress(eachExpressNo, firstExpressInfo, rspBO);
        }
        rspBO.setEffectRecord(Integer.valueOf(reqBO.getExpressNo().size()));
        return rspBO;
    }

    private BusiCancelExpressRspBO processCancelExpress(String eachExpressNo, SaleInvoiceMailInfo firstExpressInfo, BusiCancelExpressRspBO rspBO) {
        logger.debug("\u53d6\u6d88\u90ae\u5bc4-\u5feb\u9012\u5355\u53f7:" + eachExpressNo + "\u6b63\u5728\u53d6\u6d88");
        try {
            UlcOrderCancelAbilityReqBo ulcOrderCancelAbilityReqBo = new UlcOrderCancelAbilityReqBo();
            ulcOrderCancelAbilityReqBo.setOutLogisticsOrderId(firstExpressInfo.getLogisticsCenterId());
            ulcOrderCancelAbilityReqBo.setBusiCode("ULC");
            UlcOrderCancelAbilityRspBo ulcOrderCancelAbilityRspBo = this.ulcOrderCancelAbilityService.dealCancel(ulcOrderCancelAbilityReqBo);
            logger.debug("\u7269\u6d41\u4e2d\u5fc3\u53d6\u6d88\u90ae\u5bc4\u53d1\u7968\u670d\u52a1\u51fa\u53c2\uff1a" + ulcOrderCancelAbilityRspBo.getRespCode() + ulcOrderCancelAbilityRspBo.getRespDesc());
            if (ulcOrderCancelAbilityRspBo != null && "0000".equals(ulcOrderCancelAbilityRspBo.getRespCode())) {
                SaleInvoiceMailInfo saleInvoiceMailInfo = new SaleInvoiceMailInfo();
                saleInvoiceMailInfo.setMailTicketNo(eachExpressNo);
                saleInvoiceMailInfo.setMailStatus(InvoiceMailSentStatus.SENT_CANCEL.getCode());
                this.saleInvoiceMailInfoMapper.updateByPrimaryKeySelective(saleInvoiceMailInfo);
                SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
                saleInvoiceInfoVO.setOldMailTicketNo(eachExpressNo);
                saleInvoiceInfoVO.setMailTicketNo(null);
                this.saleInvoiceInfoMapper.updateMailTicketNoByMailTicketNo(saleInvoiceInfoVO);
            } else {
                rspBO.setRespCode(ulcOrderCancelAbilityRspBo.getRespCode());
                rspBO.setRespDesc(ulcOrderCancelAbilityRspBo.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", "\u5feb\u9012\u5355\u53f7:" + eachExpressNo + ",\u53d6\u6d88\u5931\u8d25\uff0c\u64cd\u4f5c\u6570\u636e\u5e93\u9519\u8bef", e);
        }
        return rspBO;
    }
}

