/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiCheckBillCompareService;
import com.tydic.pfscext.api.busi.bo.BusiCheckBillCompareReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCheckBillCompareRspBO;
import com.tydic.pfscext.dao.BillCheckDetailMapper;
import com.tydic.pfscext.dao.BillCheckResultMapper;
import com.tydic.pfscext.dao.FscCheckDataMapper;
import com.tydic.pfscext.dao.PayCheckDataMapper;
import com.tydic.pfscext.dao.po.BillCheckDetailPO;
import com.tydic.pfscext.dao.po.BillCheckResultPO;
import com.tydic.pfscext.dao.po.BillCheckResultSummaryPO;
import com.tydic.pfscext.dao.po.FscCheckDataPO;
import com.tydic.pfscext.dao.po.PayCheckDataPO;
import com.tydic.pfscext.enums.BillCheckDIffType;
import com.tydic.pfscext.enums.BillCheckResult;
import com.tydic.pfscext.enums.PayFlowPayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiCheckBillCompareService"})
public class BusiCheckBillCompareServiceImpl
implements BusiCheckBillCompareService {
    private static final Logger log = LoggerFactory.getLogger(BusiCheckBillCompareServiceImpl.class);
    @Autowired
    private FscCheckDataMapper fscCheckDataMapper;
    @Autowired
    private BillCheckDetailMapper billCheckDetailMapper;
    @Autowired
    private PayCheckDataMapper payCheckDataMapper;
    @Autowired
    private BillCheckResultMapper billCheckResultMapper;

    @PostMapping(value={"dealCheckBillData"})
    public BusiCheckBillCompareRspBO dealCheckBillData(@RequestBody BusiCheckBillCompareReqBO reqBO) {
        log.info("\u7ed3\u7b97\u4e2d\u5fc3\u6570\u636e\u4e0e\u652f\u4ed8\u4e2d\u5fc3\u6570\u636e\u5bf9\u8d26\u5f00\u59cb\uff0cBusiCheckBillCompareReqBO" + reqBO.getBillDate());
        BusiCheckBillCompareRspBO rspBO = new BusiCheckBillCompareRspBO();
        try {
            String indexResult;
            String index;
            FscCheckDataPO record = new FscCheckDataPO();
            record.setBillDate(reqBO.getBillDate());
            List<BillCheckDetailPO> billCompareSameList = this.fscCheckDataMapper.selectBillSame(record);
            List<BillCheckDetailPO> billCompareRefundSameList = this.fscCheckDataMapper.selectBillRefundSame(record);
            billCompareSameList.addAll(billCompareRefundSameList);
            List<BillCheckDetailPO> billCompareDiffList = this.fscCheckDataMapper.selectBillDiffByMore(record);
            List<BillCheckDetailPO> billCompareRefundDiffList = this.fscCheckDataMapper.selectBillDiffRefundByMore(record);
            billCompareDiffList.addAll(billCompareRefundDiffList);
            List<BillCheckDetailPO> billCompareDiffListLess = this.fscCheckDataMapper.selectBillDiffByLess(record);
            List<BillCheckDetailPO> billCompareRefundDiffListLess = this.fscCheckDataMapper.selectBillDiffRefundByLess(record);
            billCompareDiffListLess.addAll(billCompareRefundDiffListLess);
            if (!CollectionUtils.isEmpty(billCompareSameList)) {
                for (BillCheckDetailPO po : billCompareSameList) {
                    po.setCheckResult(BillCheckResult.CHECK_SAME.getCode());
                    po.setCreateTime(new Date());
                    po.setPaymentFinishTime(po.getPaymentTime());
                    if (!StringUtils.isEmpty((Object)po.getOutOrderId())) {
                        index = po.getOutOrderId().substring(0, po.getOutOrderId().indexOf("-"));
                        indexResult = po.getOutOrderId().substring(index.length() + 1, po.getOutOrderId().length());
                        po.setPayBillNo(indexResult);
                    }
                    if ("SUCCESS".equals(po.getPaymentStatus())) {
                        po.setPaymentStatusName("\u652f\u4ed8\u6210\u529f");
                    }
                    if (StringUtils.isEmpty((Object)po.getPayMethod())) continue;
                    po.setPayMethodName(PayFlowPayType.getInstance(po.getPayMethod()).getDescr());
                }
                this.billCheckDetailMapper.insertBatch(billCompareSameList);
            }
            if (!CollectionUtils.isEmpty(billCompareDiffList)) {
                for (BillCheckDetailPO po : billCompareDiffList) {
                    po.setCheckResult(BillCheckResult.CHECK_DIFF.getCode());
                    po.setCreateTime(new Date());
                    po.setDiffType(BillCheckDIffType.MORE.getCode());
                    po.setPaymentFinishTime(po.getPaymentTime());
                    if (!StringUtils.isEmpty((Object)po.getOutOrderId())) {
                        index = po.getOutOrderId().substring(0, po.getOutOrderId().indexOf("-"));
                        indexResult = po.getOutOrderId().substring(index.length() + 1, po.getOutOrderId().length());
                        po.setPayBillNo(indexResult);
                    }
                    if (!"SUCCESS".equals(po.getPaymentStatus())) continue;
                    po.setPaymentStatusName("\u652f\u4ed8\u6210\u529f");
                }
                this.billCheckDetailMapper.insertBatch(billCompareDiffList);
            }
            if (!CollectionUtils.isEmpty(billCompareDiffListLess)) {
                for (BillCheckDetailPO po : billCompareDiffListLess) {
                    po.setCreateTime(new Date());
                    po.setCheckResult(BillCheckResult.CHECK_DIFF.getCode());
                    if (StringUtils.isEmpty((Object)po.getOrderCode())) {
                        po.setDiffType(BillCheckDIffType.LESS.getCode());
                    } else {
                        po.setDiffType(BillCheckDIffType.FEE.getCode());
                    }
                    po.setPaymentFinishTime(po.getPaymentTime());
                    if (!StringUtils.isEmpty((Object)po.getOutOrderId())) {
                        index = po.getOutOrderId().substring(0, po.getOutOrderId().indexOf("-"));
                        indexResult = po.getOutOrderId().substring(index.length() + 1, po.getOutOrderId().length());
                        po.setPayBillNo(indexResult);
                    }
                    if (!"SUCCESS".equals(po.getPaymentStatus())) continue;
                    po.setPaymentStatusName("\u652f\u4ed8\u6210\u529f");
                }
                this.billCheckDetailMapper.insertBatch(billCompareDiffListLess);
            }
            FscCheckDataPO fscCheckDataPO = new FscCheckDataPO();
            fscCheckDataPO.setBillDate(reqBO.getBillDate());
            BillCheckResultSummaryPO fscResultSummaryPO = this.fscCheckDataMapper.selectBillResult(fscCheckDataPO);
            PayCheckDataPO payCheckDataPO = new PayCheckDataPO();
            payCheckDataPO.setBillDate(reqBO.getBillDate());
            BillCheckResultSummaryPO payResultSummaryPO = this.payCheckDataMapper.selectBillResult(payCheckDataPO);
            BillCheckResultPO billCheckResultPO = new BillCheckResultPO();
            billCheckResultPO.setBillDate(reqBO.getBillDate());
            billCheckResultPO.setBillMonth(Long.parseLong(String.valueOf(reqBO.getBillDate()).substring(0, 6)));
            if (fscResultSummaryPO != null) {
                billCheckResultPO.setFscCenterPayCount(fscResultSummaryPO.getTotalCount().longValue());
                billCheckResultPO.setFscCenterPayFee(fscResultSummaryPO.getTotalFee());
            } else {
                billCheckResultPO.setFscCenterPayCount(0L);
                billCheckResultPO.setFscCenterPayFee(BigDecimal.ZERO);
            }
            if (payResultSummaryPO != null) {
                billCheckResultPO.setPayCenterPayCount(payResultSummaryPO.getTotalCount().longValue());
                billCheckResultPO.setPayCenterPayFee(payResultSummaryPO.getTotalFee());
            } else {
                billCheckResultPO.setPayCenterPayCount(0L);
                billCheckResultPO.setPayCenterPayFee(BigDecimal.ZERO);
            }
            if (billCheckResultPO.getFscCenterPayCount().equals(billCheckResultPO.getPayCenterPayCount())) {
                billCheckResultPO.setPayCountResult(BillCheckResult.CHECK_SAME.getCode());
            } else {
                billCheckResultPO.setPayCountResult(BillCheckResult.CHECK_DIFF.getCode());
            }
            if (billCheckResultPO.getFscCenterPayFee().compareTo(billCheckResultPO.getPayCenterPayFee()) == 0) {
                billCheckResultPO.setPayFeeResult(BillCheckResult.CHECK_SAME.getCode());
            } else {
                billCheckResultPO.setPayFeeResult(BillCheckResult.CHECK_DIFF.getCode());
            }
            this.billCheckResultMapper.insert(billCheckResultPO);
            FscCheckDataPO fscCheckDataDelPO = new FscCheckDataPO();
            fscCheckDataDelPO.setBillDate(reqBO.getBillDate());
            this.fscCheckDataMapper.deleteByBillDate(fscCheckDataDelPO);
            PayCheckDataPO payCheckDataDelPO = new PayCheckDataPO();
            payCheckDataDelPO.setBillDate(reqBO.getBillDate());
            this.payCheckDataMapper.deleteByBillDate(payCheckDataDelPO);
        }
        catch (Exception e) {
            log.error("\u5728\u7ebf\u5bf9\u8d26\u6bd4\u5bf9\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u5728\u7ebf\u5bf9\u8d26\u6bd4\u5bf9\u670d\u52a1\u5f02\u5e38:" + e.getMessage(), e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7ed3\u7b97\u4e0e\u652f\u4ed8\u6570\u636e\u6bd4\u5bf9\u5b8c\u6210");
        return rspBO;
    }
}

