/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiCreditLineSupplierModelDetailQryService;
import com.tydic.pfscext.api.busi.bo.BusiCreditLineSupplierModelBO;
import com.tydic.pfscext.api.busi.bo.BusiCreditLineSupplierModelDetailQryReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCreditLineSupplierModelDetailQryRspBO;
import com.tydic.pfscext.dao.CreditLineMapper;
import com.tydic.pfscext.dao.PayConfigDetailMapper;
import com.tydic.pfscext.dao.po.CreditLine;
import com.tydic.pfscext.dao.po.PayConfigDetail;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.umc.perf.common.UmcSupplierInfoBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoListAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoListAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoListAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiCreditLineSupplierModelDetailQryService"})
public class BusiCreditLineSupplierModelDetailQryServiceImpl
implements BusiCreditLineSupplierModelDetailQryService {
    private static final Logger log = LoggerFactory.getLogger(BusiCreditLineSupplierModelDetailQryServiceImpl.class);
    @Autowired
    private PayConfigDetailMapper payConfigDetailMapper;
    @Autowired
    private CreditLineMapper creditLineMapper;
    @Autowired
    private UmcQrySupplierInfoListAbilityService umcQrySupplierInfoListAbilityService;

    @PostMapping(value={"qryCreditLineSupplierModel"})
    public BusiCreditLineSupplierModelDetailQryRspBO qryCreditLineSupplierModel(@RequestBody BusiCreditLineSupplierModelDetailQryReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getPayConfigDetailId())) {
            throw new PfscExtBusinessException("0001", "\u652f\u4ed8\u914d\u7f6e\u660e\u7ec6ID[payConfigDetailId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayConfigDetail payConfigDetail = this.payConfigDetailMapper.selectByPrimaryKey(reqBO.getPayConfigDetailId());
        if (payConfigDetail == null) {
            throw new PfscExtBusinessException("0001", "\u672a\u67e5\u8be2\u5230\u914d\u7f6e\u76f8\u5173\u4fe1\u606f\uff01");
        }
        CreditLine queryVo = new CreditLine();
        queryVo.setSupplierNo(reqBO.getSupplierNo());
        queryVo.setPayConfigDetailId(reqBO.getPayConfigDetailId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<CreditLine> creditLineList = this.creditLineMapper.getSupplierSum(queryVo, page);
        List supplierNoList = creditLineList.stream().map(CreditLine::getSupplierNo).collect(Collectors.toList());
        UmcQrySupplierInfoListAbilityReqBO qrySupplierInfoListAbilityReqBO = new UmcQrySupplierInfoListAbilityReqBO();
        qrySupplierInfoListAbilityReqBO.setSupplierIds(supplierNoList);
        qrySupplierInfoListAbilityReqBO.setPageSize(Integer.valueOf(100));
        log.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u670d\u52a1\u67e5\u8be2\u4f9b\u5e94\u5546\u540d\u79f0\u5165\u53c2\uff1a" + JSON.toJSONString((Object)qrySupplierInfoListAbilityReqBO));
        UmcQrySupplierInfoListAbilityRspBO qrySupplierInfoListAbilityRspBO = this.umcQrySupplierInfoListAbilityService.qrySupplierInfoList(qrySupplierInfoListAbilityReqBO);
        log.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u670d\u52a1\u67e5\u8be2\u4f9b\u5e94\u5546\u540d\u79f0\u8fd4\u56de\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)qrySupplierInfoListAbilityRspBO));
        HashMap<Long, String> supplierMap = new HashMap<Long, String>(supplierNoList.size());
        if (null != qrySupplierInfoListAbilityRspBO && !CollectionUtils.isEmpty((Collection)qrySupplierInfoListAbilityRspBO.getRows())) {
            for (UmcSupplierInfoBO row : qrySupplierInfoListAbilityRspBO.getRows()) {
                supplierMap.put(row.getSupplierId(), row.getSupplierName());
            }
        }
        ArrayList<BusiCreditLineSupplierModelBO> modelBoList = new ArrayList<BusiCreditLineSupplierModelBO>(creditLineList.size());
        for (CreditLine creditLine : creditLineList) {
            BusiCreditLineSupplierModelBO modelBo = new BusiCreditLineSupplierModelBO();
            BeanUtils.copyProperties((Object)creditLine, (Object)modelBo);
            modelBo.setSupplierName((String)supplierMap.get(modelBo.getSupplierNo()));
            modelBo.setMatchingAmount(modelBo.getMatchingAmount().abs());
            modelBo.setTotalAmount(modelBo.getTotalAmount().abs());
            modelBo.setTradeAmount(modelBo.getTradeAmount().abs());
            modelBoList.add(modelBo);
        }
        BusiCreditLineSupplierModelDetailQryRspBO rspBO = new BusiCreditLineSupplierModelDetailQryRspBO();
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRows(modelBoList);
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

