/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiApplyCreateNotificationService;
import com.tydic.pfscext.api.busi.BusiDealActivityNotificationService;
import com.tydic.pfscext.api.busi.bo.BusiDealActivityNotificationReqBO;
import com.tydic.pfscext.api.busi.bo.BusiDealActivityNotificationRspBO;
import com.tydic.pfscext.api.busi.bo.BusiNotificationReqBO;
import com.tydic.pfscext.api.busi.bo.BusiNotificationRspBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoReqBO;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.DateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiDealActivityNotificationService"})
public class BusiDealActivityNotificationServiceImpl
implements BusiDealActivityNotificationService {
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private BusiApplyCreateNotificationService busiApplyCreateNotificationService;

    @PostMapping(value={"dealActivityNotification"})
    public BusiDealActivityNotificationRspBO dealActivityNotification(@RequestBody BusiDealActivityNotificationReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getActivityId() == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u6d3b\u52a8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrderDateBeg())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u8ba2\u5355\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrderDateBeg())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u8ba2\u5355\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierId() == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiDealActivityNotificationRspBO rspBO = new BusiDealActivityNotificationRspBO();
        SaleOrderInfo orderInfo = new SaleOrderInfo();
        orderInfo.setActivityId(reqBO.getActivityId());
        ArrayList<Long> supplierIds = new ArrayList<Long>();
        supplierIds.add(reqBO.getSupplierId());
        orderInfo.setSupplierIds(supplierIds);
        int count = this.saleOrderInfoMapper.getCheckByReconciliation(orderInfo);
        if (count > 0) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u8be5\u6d3b\u52a8\u5bf9\u5e94\u7684\u8ba2\u5355\u672a\u5168\u90e8\u5bf9\u8d26\uff0c\u8bf7\u5148\u5bf9\u8c61\u5bf9\u8d26\u64cd\u4f5c");
            return rspBO;
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        saleOrderInfoVO.setOrderDateStart(DateUtil.strToDateLong(reqBO.getOrderDateBeg()));
        saleOrderInfoVO.setOrderDateEnd(DateUtil.strToDateLong(reqBO.getOrderDateEnd()));
        saleOrderInfoVO.setActivityId(reqBO.getActivityId());
        saleOrderInfoVO.setReconciliationStatus("1");
        saleOrderInfoVO.setSupplierIds(supplierIds);
        List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getListPageJoinActivityNoNollOnlyPrivate(saleOrderInfoVO);
        if (!CollectionUtils.isEmpty(saleOrderInfos)) {
            Long openUnitNo = saleOrderInfos.get(0).getOperUnitNo();
            HashMap<Long, QueryPayPurchaseOrderInfoReqBO> map = new HashMap<Long, QueryPayPurchaseOrderInfoReqBO>();
            HashMap purMap = new HashMap();
            for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                if ("2".equals(saleOrderInfo.getSource())) {
                    QueryPayPurchaseOrderInfoReqBO reqBO1 = new QueryPayPurchaseOrderInfoReqBO();
                    QueryPayPurchaseOrderInfoReqBO reqBO2 = new QueryPayPurchaseOrderInfoReqBO();
                    BeanUtils.copyProperties((Object)reqBO, (Object)reqBO2);
                    reqBO1.setOrderId(saleOrderInfo.getOrderId());
                    reqBO1.setInspectionId(saleOrderInfo.getInspectionId());
                    reqBO1.setOrderDate(saleOrderInfo.getOrderDate());
                    reqBO1.setOrderAmt(saleOrderInfo.getOrderAmt());
                    reqBO1.setPurchaseOrderCode(saleOrderInfo.getSaleOrderCode());
                    reqBO1.setExtOrderId(saleOrderInfo.getExtOrderId());
                    reqBO1.setJdOrgId(saleOrderInfo.getJdOrgId());
                    if (map.get(saleOrderInfo.getSupplierNo()) != null) {
                        ((QueryPayPurchaseOrderInfoReqBO)map.get(saleOrderInfo.getSupplierNo())).getQueryPayPurchaseOrderInfoReqBOs().add(reqBO1);
                        continue;
                    }
                    ArrayList<QueryPayPurchaseOrderInfoReqBO> reqBOs = new ArrayList<QueryPayPurchaseOrderInfoReqBO>();
                    reqBOs.add(reqBO1);
                    reqBO2.setSupplierName(saleOrderInfo.getSupplierName());
                    reqBO2.setQueryPayPurchaseOrderInfoReqBOs(reqBOs);
                    map.put(saleOrderInfo.getSupplierNo(), reqBO2);
                    continue;
                }
                if (purMap.get(saleOrderInfo.getPurchaseNo()) != null) {
                    ((List)purMap.get(saleOrderInfo.getPurchaseNo())).add(saleOrderInfo);
                    continue;
                }
                ArrayList<SaleOrderInfo> saleOrderInfoList = new ArrayList<SaleOrderInfo>();
                saleOrderInfoList.add(saleOrderInfo);
                purMap.put(saleOrderInfo.getPurchaseNo(), saleOrderInfoList);
            }
            if (map.size() > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    Long supplierId = (Long)entry.getKey();
                    QueryPayPurchaseOrderInfoReqBO orderInfos = (QueryPayPurchaseOrderInfoReqBO)entry.getValue();
                    ArrayList codes = new ArrayList();
                    for (QueryPayPurchaseOrderInfoReqBO queryPayPurchaseOrderInfoReqBO : orderInfos.getQueryPayPurchaseOrderInfoReqBOs()) {
                        codes.add(queryPayPurchaseOrderInfoReqBO.getPurchaseOrderCode());
                    }
                    BusiNotificationReqBO busiNotificationReqBO = new BusiNotificationReqBO();
                    BeanUtils.copyProperties((Object)reqBO, (Object)busiNotificationReqBO);
                    busiNotificationReqBO.setOrderCodes((List)codes);
                    busiNotificationReqBO.setOperUnitNo(openUnitNo);
                    busiNotificationReqBO.setSupplierNo(supplierId);
                    busiNotificationReqBO.setSource("2");
                    busiNotificationReqBO.setUserId(null);
                    busiNotificationReqBO.setBusiModel(BusiModel.TRADE_MODEL.getCode());
                    busiNotificationReqBO.setName("\u6d3b\u52a8\u8ba2\u5355\u4e0a\u6e38\u624b\u52a8\u5f00\u7968");
                    BusiNotificationRspBO busiNotificationRspBO = this.busiApplyCreateNotificationService.applyCreateNotification(busiNotificationReqBO);
                    if ("0000".equals(busiNotificationRspBO.getRespCode())) continue;
                    rspBO.setRespCode("18000");
                    rspBO.setRespDesc(busiNotificationRspBO.getRespDesc());
                    return rspBO;
                }
            }
            if (purMap.size() > 0) {
                for (Map.Entry entry : purMap.entrySet()) {
                    List orderInfos = (List)entry.getValue();
                    if (orderInfos.size() <= 0) continue;
                    ArrayList<String> codes = new ArrayList<String>();
                    for (SaleOrderInfo SaleOrderInfo2 : orderInfos) {
                        codes.add(SaleOrderInfo2.getSaleOrderCode());
                    }
                    BusiNotificationReqBO busiNotificationReqBO = new BusiNotificationReqBO();
                    BeanUtils.copyProperties((Object)reqBO, (Object)busiNotificationReqBO);
                    busiNotificationReqBO.setOrderCodes(codes);
                    busiNotificationReqBO.setOperUnitNo(((SaleOrderInfo)orderInfos.get(0)).getOperUnitNo());
                    busiNotificationReqBO.setSupplierNo(((SaleOrderInfo)orderInfos.get(0)).getSupplierNo());
                    busiNotificationReqBO.setBusiModel(BusiModel.TRADE_MODEL.getCode());
                    busiNotificationReqBO.setSource("1");
                    busiNotificationReqBO.setName("\u6d3b\u52a8\u8ba2\u5355\u4e0a\u6e38\u624b\u52a8\u5f00\u7968");
                    BusiNotificationRspBO busiNotificationRspBO = this.busiApplyCreateNotificationService.applyCreateNotification(busiNotificationReqBO);
                    if ("0000".equals(busiNotificationRspBO.getRespCode())) continue;
                    rspBO.setRespCode("18000");
                    rspBO.setRespDesc(busiNotificationRspBO.getRespDesc());
                    return rspBO;
                }
            }
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8be5\u6d3b\u52a8\u4e0b\u4e0a\u6e38\u6ca1\u6709\u672a\u63d0\u4ea4\u5f00\u7968\u7684\u8ba2\u5355");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d3b\u52a8\u4e0a\u6e38\u5f00\u7968\u63d0\u4ea4\u6210\u529f");
        return rspBO;
    }
}

