/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiDealOutPushMsgService;
import com.tydic.pfscext.api.busi.bo.BusiDealOutPushMsgReqBO;
import com.tydic.pfscext.api.busi.bo.BusiDealOutPushMsgRspBO;
import com.tydic.pfscext.api.notify.bo.CancelApplyInfoBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.CancelApplyInfoMapper;
import com.tydic.pfscext.dao.MsgPoolMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.MsgPool;
import com.tydic.pfscext.enums.CancelApplyStatus;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.CancelApplyAuditAtomService;
import com.tydic.pfscext.service.atom.bo.AuditCancelInfoReqBO;
import com.tydic.pfscext.service.atom.bo.AuditCancelInfoRspBO;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiDealOutPushMsgService"})
public class BusiDealOutPushMsgServiceImpl
implements BusiDealOutPushMsgService {
    private static final Logger log = LoggerFactory.getLogger(BusiDealOutPushMsgServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private CancelApplyAuditAtomService cancelApplyAuditAtomService;
    @Autowired
    private CancelApplyInfoMapper cancelApplyInfoMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private MsgPoolMapper msgPoolMapper;

    @PostMapping(value={"dealOutPushMsg"})
    public BusiDealOutPushMsgRspBO dealOutPushMsg(@RequestBody BusiDealOutPushMsgReqBO reqBO) {
        BusiDealOutPushMsgRspBO rspBO = new BusiDealOutPushMsgRspBO();
        this.validParam(reqBO);
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(reqBO.getOrderId());
        if (billNotificationInfo == null) {
            rspBO.setRespDesc("\u901a\u77e5\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728");
            rspBO.setRespCode("18001");
            return rspBO;
        }
        if (!NotificationInvoiceStatus.CANCELING.getCode().equals(billNotificationInfo.getInvoiceStatus())) {
            rspBO.setRespDesc("\u901a\u77e5\u5355\u72b6\u6001\u4e0d\u662f\u53d6\u6d88\u7533\u8bf7\u4e2d");
            rspBO.setRespCode("18001");
            return rspBO;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("applyNo", reqBO.getOrderId());
        param.put("qxApplyType", "1");
        param.put("qxApplyStatus", "0");
        CancelApplyInfoBO info = this.cancelApplyInfoMapper.selectCancelApplyInfoByCondition(param);
        if (info == null) {
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u901a\u77e5\u5355[" + reqBO.getOrderId() + "]\u53d6\u6d88\u7533\u8bf7\u4e2d\u7684\u53d6\u6d88\u7533\u8bf7\u8bb0\u5f55");
            rspBO.setRespCode("18001");
            return rspBO;
        }
        AuditCancelInfoReqBO auditCancelInfoReqBO = new AuditCancelInfoReqBO();
        if ("0".equals(reqBO.getStatus())) {
            auditCancelInfoReqBO.setQxApplyStatus(CancelApplyStatus.PASSED.getCode());
        } else if ("1".equals(reqBO.getStatus())) {
            auditCancelInfoReqBO.setQxApplyStatus(CancelApplyStatus.REJECT.getCode());
            auditCancelInfoReqBO.setAuditDesc(reqBO.getRemark());
        }
        auditCancelInfoReqBO.setQxApplyNo(info.getQxApplyNo());
        auditCancelInfoReqBO.setApplyNo(info.getApplyNo());
        auditCancelInfoReqBO.setUserId(99999L);
        auditCancelInfoReqBO.setName("\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u6d88\u606f");
        AuditCancelInfoRspBO auditCancelInfoRspBO = this.cancelApplyAuditAtomService.auditCancelInfo(auditCancelInfoReqBO);
        if (!"0000".equals(auditCancelInfoRspBO.getRespCode())) {
            this.updateMsgPool(reqBO, 0);
            throw new PfscExtBusinessException(auditCancelInfoRspBO.getRespCode(), auditCancelInfoRspBO.getRespDesc());
        }
        MsgPool msgPool = new MsgPool();
        msgPool.setMsgId(reqBO.getMsgId());
        msgPool.setId(reqBO.getId());
        msgPool.setRunResult(1);
        msgPool.setChngTime(new Date());
        this.msgPoolMapper.update(msgPool);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7535\u5546\u53d1\u7968\u5ba1\u6838\u6d88\u606f\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private void validParam(BusiDealOutPushMsgReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrderId())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getSupplierId())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getMsgId())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u6d88\u606fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getStatus())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u6d88\u606f\u5ba1\u6838\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void updateMsgPool(BusiDealOutPushMsgReqBO reqBO, int result) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            MsgPool msgPool = new MsgPool();
            msgPool.setMsgId(reqBO.getMsgId());
            msgPool.setOrderId(reqBO.getOrderId());
            msgPool.setSupNo(reqBO.getSupplierId());
            msgPool.setRunResult(result);
            msgPool.setChngTime(new Date());
            this.msgPoolMapper.updateResult(msgPool);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

