/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiElecRefundOperateService;
import com.tydic.pfscext.api.busi.bo.BusiElecRefundOperateReqBO;
import com.tydic.pfscext.api.busi.bo.BusiElecRefundOperateRspBO;
import com.tydic.pfscext.enums.ElecRefundOprType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.ElecRefundService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiElecRefundOperateServiceImpl
implements BusiElecRefundOperateService {
    private static final Logger logger = LoggerFactory.getLogger(BusiElecRefundOperateServiceImpl.class);
    @Autowired
    private ElecRefundService elecRefundService;

    public BusiElecRefundOperateRspBO processRefund(BusiElecRefundOperateReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u9000\u8d27\u64cd\u4f5c\u5904\u7406reqBO:" + reqBO);
        }
        String saleOrdId = reqBO.getSaleOrderId();
        String inspId = reqBO.getInspectionId();
        String operUnitNo = reqBO.getOperUnitNo();
        String purchaseNo = reqBO.getPurchaseNo();
        if (!StringUtils.hasText((String)operUnitNo)) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u673a\u6784\u65e0\u6548(operUnitNo)");
        }
        if (!StringUtils.hasText((String)purchaseNo)) {
            throw new PfscExtBusinessException("0001", "\u65e0\u6cd5\u786e\u5b9a\u91c7\u8d2d\u5355\u4f4d\u7684\u673a\u6784(purchaseNo)");
        }
        if (!StringUtils.hasText((String)saleOrdId)) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u53f7\u5fc5\u987b\u8f93\u5165(saleOrderId)");
        }
        if (!StringUtils.hasText((String)inspId)) {
            throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355\u53f7\u5fc5\u987b\u8f93\u5165(inspectionId)");
        }
        Integer oprType = reqBO.getOprType();
        ElecRefundOprType opr = ElecRefundOprType.getInstance(oprType);
        if (opr == null) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u6307\u5b9a\u64cd\u4f5c\u7c7b\u578b(oprType)");
        }
        List items = reqBO.getRefundItems();
        if (items == null || items.size() == 0) {
            throw new PfscExtBusinessException("0001", "\u672a\u53d1\u73b0\u9700\u7533\u8bf7\u9000\u8d27\u7684\u5546\u54c1\u6570\u636e(refundItems)");
        }
        this.elecRefundService.operate(opr, saleOrdId, inspId, purchaseNo, operUnitNo, items);
        return new BusiElecRefundOperateRspBO();
    }
}

