/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.order.extend.ability.saleorder.PebErpFscOrderAbilityService;
import com.tydic.order.extend.bo.order.PebExtPayResultReqBO;
import com.tydic.order.extend.bo.order.PebExtPayResultRspBO;
import com.tydic.order.extend.bo.saleorder.PebErpFscOrderReqBO;
import com.tydic.order.extend.bo.saleorder.PebErpFscOrderRspBO;
import com.tydic.order.uoc.bo.inspection.OrdInspectionRspBO;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.pfscext.api.busi.BusiExtNewErpPaymentInfoService;
import com.tydic.pfscext.api.busi.bo.BusiExtErpInvoiceInfoBO;
import com.tydic.pfscext.api.busi.bo.BusiExtErpInvoiceInfoDetailBO;
import com.tydic.pfscext.api.busi.bo.BusiExtNewErpPaymentInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiExtNewErpPaymentInfoRspBO;
import com.tydic.pfscext.dao.FscPaymentFlowInfoDetailMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.po.FscPaymentFlowInfoDetailPO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.enums.FlowFlag;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.uoc.api.FscPebExtFscPayResultExternalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiExtNewErpPaymentInfoService"})
public class BusiExtNewErpPaymentInfoServiceImpl
implements BusiExtNewErpPaymentInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusiExtNewErpPaymentInfoServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(BusiExtNewErpPaymentInfoServiceImpl.class);
    @Autowired
    private PebErpFscOrderAbilityService pebErpFscOrderAbilityService;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private FscPaymentFlowInfoDetailMapper fscPaymentFlowInfoDetailMapper;
    @Autowired
    private FscPebExtFscPayResultExternalService fscPebExtFscPayResultExternalService;
    private static final String SUCCESS = "SUCCESS";

    @PostMapping(value={"addErpPaymentInfo"})
    public BusiExtNewErpPaymentInfoRspBO addErpPaymentInfo(@RequestBody BusiExtNewErpPaymentInfoReqBO reqBO) {
        this.valid(reqBO);
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u589eErp\u4ed8\u6b3e\u6d41\u6c34\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)reqBO));
        }
        BusiExtNewErpPaymentInfoRspBO rspBO = new BusiExtNewErpPaymentInfoRspBO();
        PaymentFlowInfo flowInfo = new PaymentFlowInfo();
        BeanUtils.copyProperties((Object)reqBO, (Object)flowInfo);
        flowInfo.setOrderDesc(reqBO.getDesc());
        flowInfo.setOrderAmt(reqBO.getAmt());
        flowInfo.setOutOrderId(reqBO.getPayNo());
        flowInfo.setFlowFlag(FlowFlag.ERP_PAY.getCode());
        LinkedList srcNoList = new LinkedList();
        for (BusiExtErpInvoiceInfoBO row : reqBO.getRows()) {
            List noList = row.getDetails().stream().map(BusiExtErpInvoiceInfoDetailBO::getSrcDocNo).collect(Collectors.toList());
            srcNoList.addAll(noList);
        }
        PebErpFscOrderReqBO fscOrderReqBO = new PebErpFscOrderReqBO();
        fscOrderReqBO.setSaleNoList(srcNoList);
        List<Object> inspectionIdList = new ArrayList();
        try {
            PebErpFscOrderRspBO fscOrderRspBO = this.pebErpFscOrderAbilityService.queryDetailList(fscOrderReqBO);
            log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u6765\u6e90\u8ba2\u5355\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)fscOrderReqBO));
            if (!fscOrderRspBO.getRespCode().equals("0000")) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u6765\u6e90\u8ba2\u5355\u8fd4\u56de\uff1a" + fscOrderRspBO.getRespDesc());
                return rspBO;
            }
            if (CollectionUtils.isEmpty((Collection)fscOrderRspBO.getList())) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6765\u6e90\u8ba2\u5355[" + JSONObject.toJSONString(srcNoList) + "]\u76f8\u5173\u4fe1\u606f\uff1a");
                return rspBO;
            }
            inspectionIdList = fscOrderRspBO.getList().stream().map(OrdInspectionRspBO::getInspectionVoucherId).distinct().collect(Collectors.toList());
        }
        catch (Exception e) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u6765\u6e90\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
            return rspBO;
        }
        if (inspectionIdList.size() > 0) {
            List<PayPurchaseOrderInfo> orderInfoList = this.payPurchaseOrderInfoMapper.getListByInspectionIdList(inspectionIdList);
            if (orderInfoList.size() > 0) {
                flowInfo.setRecOrgNo(orderInfoList.get(0).getSupplierNo());
                flowInfo.setPayOrgNo(orderInfoList.get(0).getOperUnitNo());
                StringBuilder orderCode = new StringBuilder();
                StringBuilder notificationNo = new StringBuilder();
                for (PayPurchaseOrderInfo payPurchaseOrderInfo : orderInfoList) {
                    orderCode.append(payPurchaseOrderInfo.getPurchaseOrderCode()).append(",");
                    notificationNo.append(payPurchaseOrderInfo.getNotificationNo()).append(",");
                    if (StringUtils.isEmpty((CharSequence)reqBO.getPaymentStatus()) || !reqBO.getPaymentStatus().equals(SUCCESS)) continue;
                    PebExtPayResultReqBO payResultReqBO = new PebExtPayResultReqBO();
                    payResultReqBO.setOrderId(payPurchaseOrderInfo.getOrderId().toString());
                    payResultReqBO.setInspectionVoucherId(payPurchaseOrderInfo.getInspectionId());
                    payResultReqBO.setPayMethod(reqBO.getPayType());
                    payResultReqBO.setPaymentFinishTime(reqBO.getPayTime());
                    try {
                        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u72b6\u6001\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)payResultReqBO));
                        PebExtPayResultRspBO pebExtPayResultRspBO = this.fscPebExtFscPayResultExternalService.dealPayResult(payResultReqBO);
                        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u72b6\u6001\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)payResultReqBO));
                        if (SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) continue;
                        throw new BusinessException("18000", pebExtPayResultRspBO.getResultMsg());
                    }
                    catch (Exception e) {
                        throw new BusinessException("8888", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u72b6\u6001\u5931\u8d25\uff01");
                    }
                }
                flowInfo.setOrderCode(orderCode.substring(0, orderCode.length() - 1));
                flowInfo.setNotificationNo(this.getWordCount(notificationNo.toString(), 1000));
            }
        } else {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u6765\u6e90\u8ba2\u5355\u53f7" + JSONObject.toJSONString(srcNoList) + "\u672a\u627e\u5230\u3002");
        }
        long flowId = this.paymentFlowInfoMapper.insert(flowInfo);
        FscPaymentFlowInfoDetailPO fscPaymentFlowInfoDetail = new FscPaymentFlowInfoDetailPO();
        fscPaymentFlowInfoDetail.setFlowId(flowInfo.getSeq());
        fscPaymentFlowInfoDetail.setOutOrderId(flowInfo.getOutOrderId());
        fscPaymentFlowInfoDetail.setFlowFlag(FlowFlag.ERP_PAY.getCode());
        fscPaymentFlowInfoDetail.setCreateDate(new Date());
        this.fscPaymentFlowInfoDetailMapper.insert(fscPaymentFlowInfoDetail);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(BusiExtNewErpPaymentInfoReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getRows())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[rows]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAmt() == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[amt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPayName())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[payName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getRecName())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[recName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPayNo())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[payNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String getWordCount(String oldName, int len) {
        String newName = "";
        int oldNameLength = 0;
        char[] names = oldName.toCharArray();
        for (int i = 0; i < oldName.length(); ++i) {
            int ascii = Character.codePointAt(oldName, i);
            oldNameLength = ascii >= 0 && ascii <= 255 ? ++oldNameLength : (oldNameLength += 2);
            if (oldNameLength > len) continue;
            char c = names[i];
            newName = newName + c;
        }
        return newName;
    }
}

