/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.pfscext.api.busi.NotificationSendRequestService;
import com.tydic.pfscext.api.busi.vo.InvoiceHeaderVO;
import com.tydic.pfscext.api.busi.vo.InvoiceMailAddrInfoVO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfoExt;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.FscBillBusiType;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import com.tydic.pfscext.service.atom.FscBillBusiLogAtomService;
import com.tydic.pfscext.service.atom.bo.FscBillBusiLogAtomReqBO;
import com.tydic.pfscext.service.busi.BusiGenerateNotificationService;
import com.tydic.pfscext.service.busi.bo.BusiGenerateNotificationReqBO;
import com.tydic.pfscext.service.busi.bo.BusiGenerateNotificationRspBO;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountListAbilityService;
import com.tydic.umcext.ability.account.bo.UmcEnterpriseAccountAbilityBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountListAbilityReqBO;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgQueryAbilityReqBO;
import com.tydic.umcext.bo.base.UmcRspListBO;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiGenerateNotificationServiceImpl
implements BusiGenerateNotificationService {
    private static final Logger log = LoggerFactory.getLogger(BusiGenerateNotificationServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private NotificationSendRequestService notificationSendRequestService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Autowired
    private UmcQryEnterpriseAccountListAbilityService umcQryEnterpriseAccountListAbilityService;
    @Autowired
    private FscBillBusiLogAtomService fscBillBusiLogAtomService;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Resource(name="billNotificationBatchNoSeq")
    private OrderSequence billNotificationBatchNoSeq;
    private final String DEFAULT = "0";
    private final String MANUAL = "1";

    @Override
    public BusiGenerateNotificationRspBO generateNotification(BusiGenerateNotificationReqBO reqBO) {
        if (reqBO == null || CollectionUtils.isEmpty(reqBO.getOrderInfoList())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceInfo() || !StringUtils.hasText((String)reqBO.getInvoiceInfo().getInvoiceTitle())) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (null == reqBO.getMailAddrInfo() || !StringUtils.hasText((String)reqBO.getMailAddrInfo().getName())) {
            throw new PfscExtBusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        BusiGenerateNotificationRspBO rspBO = new BusiGenerateNotificationRspBO();
        try {
            int updCount;
            int updateResult;
            String s;
            List<PayPurchaseOrderInfo> orderInfoList = reqBO.getOrderInfoList();
            PayPurchaseOrderInfo purchaseOrderInfo = orderInfoList.get(0);
            InvoiceHeaderVO invoiceInfo = reqBO.getInvoiceInfo();
            InvoiceMailAddrInfoVO mailAddrInfo = reqBO.getMailAddrInfo();
            String batchNo = this.generateSeqNoFormated(new SimpleDateFormat("yyyyMMdd").format(new Date()));
            String notifyNo = this.billSNService.getSnAsString(BillType.INVOICE_NOTIFYCATION);
            BigDecimal sumAmt = BigDecimal.ZERO;
            HashSet<Long> purchaseNoSet = new HashSet<Long>();
            HashSet<String> purchaseNameSet = new HashSet<String>();
            HashSet<Long> purchaseProjectIdSet = new HashSet<Long>();
            LinkedList<String> orderCodeList = new LinkedList<String>();
            for (PayPurchaseOrderInfo orderInfo : orderInfoList) {
                sumAmt = sumAmt.add(orderInfo.getOrderAmt());
                orderCodeList.add(orderInfo.getPurchaseOrderCode());
                purchaseNoSet.add(orderInfo.getPurchaseNo());
                purchaseNameSet.add(orderInfo.getPurchaseName());
                purchaseProjectIdSet.add(orderInfo.getPurchaseProjectId());
            }
            BillNotificationInfoExt notifyInfo = new BillNotificationInfoExt();
            notifyInfo.setNotificationNo(notifyNo);
            notifyInfo.setAmt(sumAmt);
            notifyInfo.setApplyDate(new Date());
            notifyInfo.setIsApply(reqBO.getIsApply());
            notifyInfo.setSource(purchaseOrderInfo.getSource());
            notifyInfo.setIsPay(1);
            notifyInfo.setSupplierNo(purchaseOrderInfo.getSupplierNo());
            notifyInfo.setSupplierName(purchaseOrderInfo.getSupplierName());
            notifyInfo.setUserId(reqBO.getUserId());
            notifyInfo.setDrawerId(reqBO.getUserId());
            notifyInfo.setDrawerName(reqBO.getName());
            notifyInfo.setBatchNo(batchNo);
            notifyInfo.setPurchaseSaleType(purchaseOrderInfo.getPurchaseSaleType());
            notifyInfo.setNoAgreeOrderCategory(purchaseOrderInfo.getNoAgreeOrderCategory());
            notifyInfo.setIsApply(reqBO.getIsApply());
            notifyInfo.setBillNotificationType(0);
            if (!CollectionUtils.isEmpty(purchaseNoSet)) {
                s = ((Object)purchaseNoSet).toString();
                notifyInfo.setPurchaseNo(s.substring(1, s.length() - 1));
            }
            if (!CollectionUtils.isEmpty(purchaseNameSet)) {
                s = ((Object)purchaseNameSet).toString();
                notifyInfo.setPurchaseName(s.substring(1, s.length() - 1));
            }
            if (!CollectionUtils.isEmpty(purchaseProjectIdSet)) {
                s = ((Object)purchaseProjectIdSet).toString();
                notifyInfo.setPurchaseProjectId(s.substring(1, s.length() - 1));
                UmcQryEnterpriseAccountListAbilityReqBO accountListAbilityReqBO = new UmcQryEnterpriseAccountListAbilityReqBO();
                ArrayList<Long> accountIds = new ArrayList<Long>();
                accountIds.addAll(purchaseProjectIdSet);
                accountListAbilityReqBO.setInAccountIds(accountIds);
                UmcRspListBO abilityBOUmcRspListBO = this.umcQryEnterpriseAccountListAbilityService.qryEnterpriseAccountAll(accountListAbilityReqBO);
                List rspListBORows = abilityBOUmcRspListBO.getRows();
                if (abilityBOUmcRspListBO != null && !CollectionUtils.isEmpty((Collection)rspListBORows)) {
                    LinkedList<String> purchaseProjectNameList = new LinkedList<String>();
                    for (UmcEnterpriseAccountAbilityBO rspListBORow : rspListBORows) {
                        purchaseProjectNameList.add(rspListBORow.getAccountName());
                    }
                    if (!CollectionUtils.isEmpty(purchaseProjectNameList)) {
                        String name = ((Object)purchaseProjectNameList).toString();
                        notifyInfo.setPurchaseProjectName(name.substring(1, name.length() - 1));
                    }
                }
            }
            if (OrderSource.ELECTRIC_MARKET.getCode().equals(purchaseOrderInfo.getSource())) {
                notifyInfo.setInvoiceStatus(NotificationInvoiceStatus.NO_SUBMITED.getCode());
            } else {
                notifyInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
            }
            if (reqBO.getOrgId() != null) {
                notifyInfo.setStartOrgId(String.valueOf(reqBO.getOrgId()));
            }
            if ("0".equals(purchaseOrderInfo.getBusiModel())) {
                notifyInfo.setOperNo(purchaseOrderInfo.getOperUnitNo());
                notifyInfo.setOperName(purchaseOrderInfo.getOperUnitName());
            } else {
                notifyInfo.setOperNo(purchaseOrderInfo.getPurchaseNo());
                notifyInfo.setOperName(purchaseOrderInfo.getPurchaseName());
            }
            notifyInfo.setAddr(invoiceInfo.getAddress());
            notifyInfo.setBankAccNo(invoiceInfo.getAccount());
            notifyInfo.setBankName(invoiceInfo.getBank());
            notifyInfo.setInvoceName(invoiceInfo.getInvoiceTitle());
            notifyInfo.setInvoceType(invoiceInfo.getInvoiceType() == 0 ? InvoiceType.SPECIAL.getCode() : InvoiceType.NORMAL.getCode());
            notifyInfo.setPhone(invoiceInfo.getPhone());
            notifyInfo.setTaxNo(invoiceInfo.getTaxpayerId());
            if ("0".equals(reqBO.getRemarkWay()) && !CollectionUtils.isEmpty(orderCodeList)) {
                s = ((Object)orderCodeList).toString();
                notifyInfo.setInvoiceRemark(this.getWordCount(s, 200));
            } else if ("1".equals(reqBO.getRemarkWay()) && !StringUtils.isEmpty((Object)invoiceInfo.getInvoiceRemark())) {
                notifyInfo.setInvoiceRemark(this.getWordCount(invoiceInfo.getInvoiceRemark(), 200));
            }
            notifyInfo.setAddrDesc(mailAddrInfo.getAddrDesc());
            notifyInfo.setProvince(mailAddrInfo.getProvince());
            notifyInfo.setCity(mailAddrInfo.getCity());
            notifyInfo.setCounty(mailAddrInfo.getCounty());
            notifyInfo.setTown(mailAddrInfo.getTown());
            notifyInfo.setProvId(mailAddrInfo.getProvId());
            notifyInfo.setCityId(mailAddrInfo.getCityId());
            notifyInfo.setCountyId(mailAddrInfo.getCountyId());
            notifyInfo.setTownId(mailAddrInfo.getTownId());
            notifyInfo.setCompany(mailAddrInfo.getCompany());
            notifyInfo.setMobile(mailAddrInfo.getTel());
            notifyInfo.setTel(mailAddrInfo.getSpecialPlane());
            notifyInfo.setName(mailAddrInfo.getName());
            notifyInfo.setPostCode(mailAddrInfo.getPostCode());
            notifyInfo.setFailCount(0);
            int insert = this.billNotificationInfoMapper.insert(notifyInfo);
            if (insert < 1) {
                throw new PfscExtBusinessException("18000", "\u751f\u6210\u5f00\u7968\u901a\u77e5\u4fe1\u606f\u5f02\u5e38");
            }
            PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
            vo.setNotificationNo(notifyInfo.getNotificationNo());
            vo.setPayPurchaseOrderInfos(orderInfoList);
            UmcZhEnterpriseOrgQueryAbilityReqBO umcZhEnterpriseOrgQueryAbilityReqBO = new UmcZhEnterpriseOrgQueryAbilityReqBO();
            umcZhEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(reqBO.getOrgId());
            UmcZhEnterpriseOrgDetailAbilityRspBO abilityRspBO = this.umcZhEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcZhEnterpriseOrgQueryAbilityReqBO);
            if (abilityRspBO != null && abilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
                vo.setPayModel(abilityRspBO.getUmcEnterpriseOrgAbilityBO().getSettleModel());
            }
            if (!OrderSource.ELECTRIC_MARKET.getCode().equals(purchaseOrderInfo.getSource())) {
                vo.setOrderStatus(OrderStatus.APPLIED.getCode());
            }
            if ((updateResult = this.payPurchaseOrderInfoMapper.updateStatusAndNotifyNoBatch(vo)) < orderInfoList.size()) {
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
            }
            PayItemInfoVO item = new PayItemInfoVO();
            item.setNotificationNo(notifyInfo.getNotificationNo());
            item.setPayPurchaseOrderInfos(orderInfoList);
            if (!OrderSource.ELECTRIC_MARKET.getCode().equals(purchaseOrderInfo.getSource())) {
                item.setItemStatus(OrderStatus.APPLIED.getCode());
            }
            if ((updCount = this.payItemInfoMapper.updateNotifyNoBatch(item)) == 0) {
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38");
            }
            this.saveBusiLog(notifyInfo, reqBO);
            rspBO.setBillNotificationInfoExt(notifyInfo);
            rspBO.setNotificationNo(notifyNo);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u5f00\u7968\u901a\u77e5\u5355\u5931\u8d25\uff1a" + e);
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        return rspBO;
    }

    @Override
    public BusiGenerateNotificationRspBO generateNotificationException(BusiGenerateNotificationReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getOrderInfoList())) {
            throw new PfscExtBusinessException("18000", "\u751f\u6210\u7ed3\u7b97\u5f02\u5e38\u901a\u77e5\u5355\uff0c\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiGenerateNotificationRspBO rspBO = new BusiGenerateNotificationRspBO();
        PayPurchaseOrderInfo payPurchaseOrderInfo = reqBO.getOrderInfoList().get(0);
        String notifyNo = this.billSNService.getSnAsString(BillType.INVOICE_NOTIFYCATION);
        BillNotificationInfoExt notifyInfo = new BillNotificationInfoExt();
        notifyInfo.setNotificationNo(notifyNo);
        notifyInfo.setAmt(payPurchaseOrderInfo.getOrderAmt());
        notifyInfo.setApplyDate(new Date());
        notifyInfo.setOperNo(payPurchaseOrderInfo.getPurchaseNo());
        notifyInfo.setSource(String.valueOf(payPurchaseOrderInfo.getSource()));
        notifyInfo.setSupplierNo(payPurchaseOrderInfo.getSupplierNo());
        notifyInfo.setSupplierName(payPurchaseOrderInfo.getSupplierName());
        notifyInfo.setUserId(reqBO.getUserId());
        notifyInfo.setPurchaseSaleType(payPurchaseOrderInfo.getPurchaseSaleType());
        notifyInfo.setStartOrgId(String.valueOf(reqBO.getOrgId()));
        notifyInfo.setIsPay(1);
        notifyInfo.setDrawerId(reqBO.getUserId());
        notifyInfo.setDrawerName(reqBO.getName());
        notifyInfo.setBillNotificationType(1);
        notifyInfo.setInvoiceStatus(NotificationInvoiceStatus.RECEIVED.getCode());
        int insert = this.billNotificationInfoMapper.insert(notifyInfo);
        if (insert > 0) {
            PayPurchaseOrderInfo payOrderInfo = new PayPurchaseOrderInfo();
            payOrderInfo.setNotificationNo(notifyNo);
            payOrderInfo.setOrderStatus(OrderStatus.RECEIVE_BILL.getCode());
            payOrderInfo.setPurchaseOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
            this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(payOrderInfo);
            PayItemInfo item = new PayItemInfo();
            item.setNotificationNo(notifyNo);
            item.setPurchaseOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
            item.setItemStatus(OrderStatus.RECEIVE_BILL.getCode());
            this.payItemInfoMapper.updateByPrimaryKeySelective(item);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setNotificationNo(notifyNo);
        return rspBO;
    }

    private void saveBusiLog(BillNotificationInfoExt notifyInfo, BusiGenerateNotificationReqBO reqBO) {
        try {
            FscBillBusiLogAtomReqBO atomReqBo = new FscBillBusiLogAtomReqBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)atomReqBo));
            atomReqBo.setBusiBillNo(notifyInfo.getNotificationNo());
            atomReqBo.setOperId(reqBO.getUsername());
            atomReqBo.setBusiSystem(reqBO.getBillMakeSystem());
            atomReqBo.setBusiType(FscBillBusiType.BILL_NOTIFICATION.getCode());
            atomReqBo.setBusiName(FscBillBusiType.BILL_NOTIFICATION.getDesc());
            atomReqBo.setDealDesc(YesNo.YES.getCode().equals(reqBO.getIsApply() + "") ? "\u4e0b\u6e38\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968" : "\u5f00\u7968\u901a\u77e5");
            this.fscBillBusiLogAtomService.dealBillBusiLog(atomReqBo);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u5f00\u7968\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    private String generateSeqNoFormated(String prefix) {
        String withoutPrefix;
        prefix = StringUtils.hasText((String)prefix) ? prefix : "";
        int lengthWithoutPrefix = 12 - prefix.length();
        try {
            withoutPrefix = String.format("%0" + lengthWithoutPrefix + "d", this.billNotificationBatchNoSeq.nextId());
        }
        catch (SQLException e) {
            log.error("\u751f\u6210\u5e8f\u5217\u53f7\u5f02\u5e38" + e);
            throw new PfscExtBusinessException("18000", "\u751f\u6210\u6279\u6b21\u53f7\u5f02\u5e38");
        }
        return prefix + withoutPrefix;
    }

    private String getWordCount(String oldName, int len) {
        String newName = "";
        int oldNameLength = 0;
        char[] names = oldName.toCharArray();
        for (int i = 0; i < oldName.length(); ++i) {
            int ascii = Character.codePointAt(oldName, i);
            oldNameLength = ascii >= 0 && ascii <= 255 ? ++oldNameLength : (oldNameLength += 2);
            if (oldNameLength > len) continue;
            char c = names[i];
            newName = newName + c;
        }
        return newName;
    }
}

