/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.order.extend.ability.saleorder.PebErpFscOrderAbilityService;
import com.tydic.order.extend.bo.order.PebExtPayResultReqBO;
import com.tydic.order.extend.bo.order.PebExtPayResultRspBO;
import com.tydic.order.extend.bo.saleorder.PebErpFscOrderReqBO;
import com.tydic.order.extend.bo.saleorder.PebErpFscOrderRspBO;
import com.tydic.order.uoc.bo.inspection.OrdInspectionRspBO;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.pfscext.api.busi.BusiGetErpPayResultService;
import com.tydic.pfscext.api.busi.bo.BusiGetErpPayResultReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetErpPayResultRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.uoc.api.FscPebExtFscPayResultExternalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiGetErpPayResultService"})
public class BusiGetErpPayResultServiceImpl
implements BusiGetErpPayResultService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetErpPayResultServiceImpl.class);
    @Autowired
    private FscPebExtFscPayResultExternalService fscPebExtFscPayResultExternalService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private PebErpFscOrderAbilityService pebErpFscOrderAbilityService;
    private static final String SUCCESS = "SUCCESS";

    @PostMapping(value={"getErpPayResult"})
    public BusiGetErpPayResultRspBO getErpPayResult(@RequestBody BusiGetErpPayResultReqBO reqBO) {
        this.valid(reqBO);
        BusiGetErpPayResultRspBO rspBO = new BusiGetErpPayResultRspBO();
        for (String srcDocNo : reqBO.getSrcDocNoList()) {
            Long inspectionId = 0L;
            PebErpFscOrderReqBO fscOrderReqBO = new PebErpFscOrderReqBO();
            ArrayList<String> inspectionNoList = new ArrayList<String>(1);
            inspectionNoList.add(srcDocNo);
            fscOrderReqBO.setSaleNoList(inspectionNoList);
            try {
                PebErpFscOrderRspBO fscOrderRspBO = this.pebErpFscOrderAbilityService.queryDetailList(fscOrderReqBO);
                if (!fscOrderRspBO.getRespCode().equals("0000")) {
                    throw new BusinessException("8888", fscOrderRspBO.getRespDesc());
                }
                if (CollectionUtils.isEmpty((Collection)fscOrderRspBO.getList())) {
                    throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230[" + srcDocNo + "]\u4fe1\u606f\uff01");
                }
                inspectionId = ((OrdInspectionRspBO)fscOrderRspBO.getList().get(0)).getInspectionVoucherId();
            }
            catch (Exception e) {
                throw new BusinessException("8888", e.getMessage());
            }
            PebExtPayResultReqBO payResultReqBO = new PebExtPayResultReqBO();
            String orderId = this.saleOrderInfoMapper.getOrderIdByInspectionId(inspectionId);
            payResultReqBO.setOrderId(orderId);
            payResultReqBO.setInspectionVoucherId(inspectionId);
            payResultReqBO.setPayMethod(reqBO.getPayMethod());
            payResultReqBO.setPaymentFinishTime(new Date());
            try {
                log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u72b6\u6001\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)payResultReqBO));
                PebExtPayResultRspBO pebExtPayResultRspBO = this.fscPebExtFscPayResultExternalService.dealPayResult(payResultReqBO);
                log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u72b6\u6001\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)payResultReqBO));
                if (SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) continue;
                throw new BusinessException("18000", pebExtPayResultRspBO.getResultMsg());
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u72b6\u6001\u5931\u8d25\uff01");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(BusiGetErpPayResultReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getInvoiceNoList())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[invoiceNoList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPayMethod())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[payMethod]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSrcDocNoList())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[srcDocNoList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

