/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfscext.api.busi.BusiGetInvoiceService;
import com.tydic.pfscext.api.busi.BusiUpdateNotificationExcepService;
import com.tydic.pfscext.api.busi.bo.BusiGetInvoiceServiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInvoiceServiceRspBO;
import com.tydic.pfscext.api.busi.vo.BusiGetInvoiceResultVO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.NotificationRejectOrderInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceDetailMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.NotificationRejectOrderInfo;
import com.tydic.pfscext.dao.po.PayInvoiceDetail;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayItemInfoPO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.InvoiceMailStatus;
import com.tydic.pfscext.enums.InvoiceStatus;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.SupplierId;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiGetInvoiceDataService;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceDataRspVO;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceDataServiceReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceItemBO;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceItemListRspBO;
import com.tydic.pfscext.service.atom.PayInvoiceService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiGetInvoiceService"})
public class BusiGetInvoiceServiceImpl
implements BusiGetInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetInvoiceServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiGetInvoiceServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper notificationInfomapper;
    @Autowired
    private BusiGetInvoiceDataService apiGetInvoiceDataService;
    @Autowired
    private PayInvoiceService payInvoiceService;
    @Autowired
    private BusiUpdateNotificationExcepService busiUpdateNotificationExcepService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private NotificationRejectOrderInfoMapper notificationRejectOrderInfoMapper;
    private boolean isBusy = false;
    private static final Long SUPPLIER_NO = 100055L;
    private static final Long SUPPLIER_ID_JD_FL = 2022081501L;
    private static final Long SUPPLIER_ID_JD_PC = 1000550L;

    @PostMapping(value={"isBusy"})
    public boolean isBusy() {
        return this.isBusy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"dealInvoice"})
    public BusiGetInvoiceServiceRspBO dealInvoice(@RequestBody BusiGetInvoiceServiceReqBO busiGetInvoiceServiceReqBO) {
        this.isBusy = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u83b7\u53d6\u53d1\u7968\u6570\u636e\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + busiGetInvoiceServiceReqBO.toString());
        }
        List notifiations = busiGetInvoiceServiceReqBO.getNotificationNos();
        try {
            if (notifiations == null || notifiations.isEmpty()) {
                BusiGetInvoiceServiceRspBO busiGetInvoiceServiceRspBO = this.process();
                return busiGetInvoiceServiceRspBO;
            }
            BusiGetInvoiceServiceRspBO busiGetInvoiceServiceRspBO = this.getInvoiceInfoAgain(notifiations);
            return busiGetInvoiceServiceRspBO;
        }
        finally {
            this.isBusy = false;
        }
    }

    private BusiGetInvoiceServiceRspBO process() {
        BusiGetInvoiceServiceRspBO rspBO = new BusiGetInvoiceServiceRspBO();
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        billNotificationInfo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        List<BillNotificationInfo> invoiceList = this.notificationInfomapper.selectList(billNotificationInfo);
        if (invoiceList.isEmpty()) {
            LOGGER.debug("\u65e0\u5f00\u7968\u72b6\u6001\u4e3a01(\u5df2\u63d0\u4ea4)\u7684\u8bb0\u5f55,\u7a0b\u5e8f\u9000\u51fa");
            return rspBO;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        HashMap<String, Long> orgIdMap = new HashMap<String, Long>();
        for (BillNotificationInfo info : invoiceList) {
            List<PayPurchaseOrderInfo> orders;
            String markId = info.getNotificationNo();
            String id = String.valueOf(info.getSupplierNo());
            dataMap.put(markId, id);
            if (!StringUtils.hasText((String)id) || !SupplierId.JD.getCode().equals(id) && !SupplierId.JD_FL.getCode().equals(id) && !SupplierId.JD_PC.getCode().equals(id) || null == (orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(info.getNotificationNo())) || orders.size() <= 0 || !BusiModel.MATCH_UP_MODEL.getCode().equals(orders.get(0).getBusiModel())) continue;
            orgIdMap.put(markId, orders.get(0).getJdOrgId());
        }
        LOGGER.debug("\u83b7\u53d6\u53d1\u7968---\u4eac\u4e1ctoken\u6d4b\u8bd5--------orgIdMap=" + orgIdMap);
        LOGGER.debug("\u9700\u8981\u8f6e\u8be2\u53d1\u7968\u8d44\u6599\u7684\u901a\u77e5\u5355,count=" + invoiceList.size() + ",dataMap=" + dataMap + ",orgIdMap" + orgIdMap);
        BusiGetInvoiceDataServiceReqBO getInvoiceDataReqBO = new BusiGetInvoiceDataServiceReqBO();
        getInvoiceDataReqBO.setIdMap(dataMap);
        getInvoiceDataReqBO.setOrgIdMap(orgIdMap);
        List invoiceDataList = this.apiGetInvoiceDataService.getInvoiceData(getInvoiceDataReqBO).getDataList();
        if (CollectionUtils.isEmpty((Collection)invoiceDataList)) {
            LOGGER.debug("\u6ca1\u6709\u67e5\u8be2\u5230\u5f00\u7968\u6570\u636e\uff0c\u7a0b\u5e8f\u9000\u51fa");
            return rspBO;
        }
        ArrayList list = new ArrayList();
        rspBO.setResultList(list);
        return this.dealDataNew(invoiceDataList, rspBO);
    }

    private BusiGetInvoiceServiceRspBO dealData(List<BusiGetInvoiceDataRspVO> invoiceDataList, BusiGetInvoiceServiceRspBO rspBO) {
        String supplierNo = "";
        ArrayList<PayInvoiceDetail> payInvoiceDetails = new ArrayList<PayInvoiceDetail>();
        for (BusiGetInvoiceDataRspVO invoiceData : invoiceDataList) {
            try {
                BusiGetInvoiceResultVO resultVO = new BusiGetInvoiceResultVO();
                LOGGER.debug("\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u7ed3\u679c:" + invoiceData.getNotificationNo() + "," + invoiceData.getResultCode() + "," + invoiceData.getResultMsg() + ",sup=" + invoiceData.getSupplierNo() + "(" + invoiceData.getSupplierCode() + ")");
                BeanUtils.copyProperties((Object)invoiceData, (Object)resultVO);
                rspBO.getResultList().add(resultVO);
                PayInvoiceInfo invoiceInfo = new PayInvoiceInfo();
                BeanUtils.copyProperties((Object)invoiceData, (Object)invoiceInfo);
                if (StringUtils.hasText((String)invoiceData.getInvoiceNo())) {
                    if (!this.checkInvoiceInfo(invoiceData)) continue;
                    invoiceInfo.setInvoiceStatus(InvoiceStatus.HAS_MAKE.getCode());
                    invoiceInfo.setMailStatus(InvoiceMailStatus.NOT_SENT.getCode());
                    try {
                        List<PayPurchaseOrderInfo> orders;
                        BusiGetInvoiceDataServiceReqBO busiGetInvoiceDataServiceReqBO = new BusiGetInvoiceDataServiceReqBO();
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("invoiceId", invoiceInfo.getInvoiceNo());
                        map.put("invoiceCode", invoiceInfo.getInvoiceCode());
                        map.put("supplierId", invoiceInfo.getSupplierNo());
                        if (StringUtils.hasText((String)invoiceInfo.getSupplierNo()) && (SupplierId.JD.getCode().equals(invoiceInfo.getSupplierNo()) || SupplierId.JD_FL.getCode().equals(invoiceInfo.getSupplierNo()) || SupplierId.JD_PC.getCode().equals(invoiceInfo.getSupplierNo())) && null != (orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(invoiceData.getNotificationNo())) && orders.size() > 0 && null != orders && orders.size() > 0 && BusiModel.MATCH_UP_MODEL.getCode().equals(orders.get(0).getBusiModel()) && null != orders.get(0).getJdOrgId()) {
                            map.put("orgId", orders.get(0).getJdOrgId().toString());
                        }
                        busiGetInvoiceDataServiceReqBO.setIdMap(map);
                        LOGGER.debug("\u83b7\u53d6\u53d1\u7968\u660e\u7ec6---\u4eac\u4e1ctoken\u6d4b\u8bd5=" + busiGetInvoiceDataServiceReqBO.getOrgIdMap());
                        BusiGetInvoiceItemListRspBO busiGetInvoiceItemListRspBO = this.apiGetInvoiceDataService.getInvoiceItems(busiGetInvoiceDataServiceReqBO);
                        if (busiGetInvoiceItemListRspBO != null && busiGetInvoiceItemListRspBO.getBusiGetInvoiceItemBOs() != null && busiGetInvoiceItemListRspBO.getBusiGetInvoiceItemBOs().size() > 0 && !this.checkInvoiceItem(busiGetInvoiceItemListRspBO.getBusiGetInvoiceItemBOs(), invoiceInfo)) {
                            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u660e\u7ec6\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u62d2\u7edd\u6536\u7968\uff01");
                        }
                        this.payInvoiceService.createInvoice(invoiceInfo);
                        if (SUPPLIER_NO.toString().equals(invoiceInfo.getSupplierNo()) || SUPPLIER_ID_JD_FL.toString().equals(invoiceInfo.getSupplierNo()) || SUPPLIER_ID_JD_PC.toString().equals(invoiceInfo.getSupplierNo())) {
                            BusiGetInvoiceDataRspVO busiGetInvoiceDataRspVO = busiGetInvoiceItemListRspBO.getBusiGetInvoiceDataRspVO();
                            PayInvoiceInfo record = new PayInvoiceInfo();
                            record.setInvoiceCode(invoiceInfo.getInvoiceCode());
                            record.setInvoiceNo(invoiceInfo.getInvoiceNo());
                            record.setInvoiceDate(invoiceInfo.getInvoiceDate());
                            record.setName(busiGetInvoiceDataRspVO.getName());
                            record.setTaxNo(busiGetInvoiceDataRspVO.getTaxNo());
                            record.setAddress(busiGetInvoiceDataRspVO.getAddress());
                            record.setPhone(busiGetInvoiceDataRspVO.getPhone());
                            record.setBankName(busiGetInvoiceDataRspVO.getBankName());
                            record.setBankAcNo(busiGetInvoiceDataRspVO.getBankAcNo());
                            record.setAmt(busiGetInvoiceDataRspVO.getAmt());
                            record.setNotTaxAmt(busiGetInvoiceDataRspVO.getNotTaxAmt());
                            record.setTaxAmt(busiGetInvoiceDataRspVO.getTaxAmt());
                            record.setNotificationNo(invoiceInfo.getNotificationNo());
                            this.payInvoiceInfoMapper.updateByNotificationNo(record);
                        }
                        if (busiGetInvoiceItemListRspBO == null || busiGetInvoiceItemListRspBO.getBusiGetInvoiceItemBOs() == null || busiGetInvoiceItemListRspBO.getBusiGetInvoiceItemBOs().size() <= 0) continue;
                        List<PayInvoiceDetail> invoiceDetails = this.payInvoiceDetailMapper.selectByInvoiceListPK(invoiceInfo.getInvoiceCode(), invoiceInfo.getInvoiceNo(), invoiceInfo.getInvoiceDate());
                        if (!invoiceDetails.isEmpty()) {
                            try {
                                this.payInvoiceDetailMapper.deleteByInvoiceNo(invoiceInfo.getInvoiceCode(), invoiceInfo.getInvoiceNo(), invoiceInfo.getInvoiceDate());
                            }
                            catch (Exception e) {
                                LOGGER.error("\u5904\u7406\u63a5\u53e3\u53d1\u7968\u660e\u7ec6\u4fe1\u606f\u5931\u8d25!" + invoiceInfo, (Throwable)e);
                                continue;
                            }
                        }
                        List<PayItemInfoPO> list = this.payItemInfoMapper.selectByNotifNo2(invoiceData.getNotificationNo());
                        List<PayPurchaseOrderInfo> orders2 = this.payPurchaseOrderInfoMapper.selectByNotifNo(invoiceData.getNotificationNo());
                        HashMap<String, String> mapExtOrderId = new HashMap<String, String>();
                        for (PayPurchaseOrderInfo po : orders2) {
                            StringBuffer str = new StringBuffer();
                            str.append(po.getOrderId()).append("-").append(po.getInspectionId());
                            mapExtOrderId.put(str.toString(), po.getExtOrderId());
                        }
                        Map orderIdMap = list.stream().collect(Collectors.toMap(PayItemInfo::getOrderId, Function.identity(), (key1, key2) -> key2));
                        Map exSkuIdCodeMap = list.stream().collect(Collectors.toMap(PayItemInfo::getExtSkuId, Function.identity(), (key1, key2) -> key2));
                        HashMap<String, PayItemInfoPO> orderIdAndExSkuIdCodeMap = new HashMap<String, PayItemInfoPO>();
                        for (PayItemInfoPO payItemInfo : list) {
                            String key = "";
                            key = SUPPLIER_NO.toString().equals(invoiceInfo.getSupplierNo()) || SUPPLIER_ID_JD_FL.toString().equals(invoiceInfo.getSupplierNo()) || SUPPLIER_ID_JD_PC.toString().equals(invoiceInfo.getSupplierNo()) ? payItemInfo.getExtOrderId() + "_" + payItemInfo.getExtSkuId() : payItemInfo.getOrderId() + "_" + payItemInfo.getExtSkuId();
                            orderIdAndExSkuIdCodeMap.put(key, payItemInfo);
                        }
                        for (BusiGetInvoiceItemBO busiGetInvoiceItemBO : busiGetInvoiceItemListRspBO.getBusiGetInvoiceItemBOs()) {
                            PayItemInfoPO payItemInfo;
                            BigDecimal taxRate = busiGetInvoiceItemBO.getTaxRate().divide(new BigDecimal(100));
                            if (!(SUPPLIER_NO.toString().equals(invoiceInfo.getSupplierNo()) || SUPPLIER_ID_JD_FL.toString().equals(invoiceInfo.getSupplierNo()) || SUPPLIER_ID_JD_PC.toString().equals(invoiceInfo.getSupplierNo()))) {
                                if (orderIdMap.get(Long.valueOf(busiGetInvoiceItemBO.getOrderCode())) == null || exSkuIdCodeMap.get(busiGetInvoiceItemBO.getExtSkuId()) == null) continue;
                                payItemInfo = (PayItemInfoPO)orderIdAndExSkuIdCodeMap.get(busiGetInvoiceItemBO.getOrderCode() + "_" + busiGetInvoiceItemBO.getExtSkuId());
                                PayInvoiceDetail payInvoiceDetail = new PayInvoiceDetail();
                                BeanUtils.copyProperties((Object)busiGetInvoiceItemBO, (Object)payInvoiceDetail);
                                payInvoiceDetail.setInvoiceCode(invoiceInfo.getInvoiceCode());
                                payInvoiceDetail.setInvoiceNo(invoiceInfo.getInvoiceNo());
                                payInvoiceDetail.setInvoiceDate(invoiceInfo.getInvoiceDate());
                                payInvoiceDetail.setTaxId(busiGetInvoiceItemBO.getTaxId());
                                payInvoiceDetail.setTaxRate(taxRate);
                                payInvoiceDetail.setOrderId(payItemInfo.getOrderId());
                                payInvoiceDetail.setInspectionId(payItemInfo.getInspectionId());
                                payInvoiceDetail.setItemNo(payItemInfo.getItemNo());
                                payInvoiceDetail.setSkuId(payItemInfo.getSkuId());
                                LOGGER.info("taxRate" + payInvoiceDetail.getTaxRate());
                                payInvoiceDetails.add(payInvoiceDetail);
                                continue;
                            }
                            if (exSkuIdCodeMap.get(busiGetInvoiceItemBO.getExtSkuId()) == null) continue;
                            payItemInfo = (PayItemInfoPO)orderIdAndExSkuIdCodeMap.get(busiGetInvoiceItemBO.getOrderCode() + "_" + busiGetInvoiceItemBO.getExtSkuId());
                            supplierNo = invoiceInfo.getSupplierNo();
                            StringBuffer str = new StringBuffer();
                            str.append(payItemInfo.getOrderId()).append("-").append(payItemInfo.getInspectionId());
                            if (!((String)mapExtOrderId.get(str.toString())).equals(busiGetInvoiceItemBO.getOrderCode())) continue;
                            PayInvoiceDetail payInvoiceDetail = new PayInvoiceDetail();
                            BeanUtils.copyProperties((Object)busiGetInvoiceItemBO, (Object)payInvoiceDetail);
                            payInvoiceDetail.setInvoiceCode(invoiceInfo.getInvoiceCode());
                            payInvoiceDetail.setInvoiceNo(invoiceInfo.getInvoiceNo());
                            payInvoiceDetail.setInvoiceDate(invoiceInfo.getInvoiceDate());
                            payInvoiceDetail.setTaxId(busiGetInvoiceItemBO.getTaxId());
                            payInvoiceDetail.setOrderId(payItemInfo.getOrderId());
                            payInvoiceDetail.setInspectionId(payItemInfo.getInspectionId());
                            payInvoiceDetail.setItemNo(payItemInfo.getItemNo());
                            payInvoiceDetail.setSkuId(payItemInfo.getSkuId());
                            payInvoiceDetail.setTaxRate(taxRate);
                            LOGGER.info("taxRate" + payInvoiceDetail.getTaxRate());
                            payInvoiceDetails.add(payInvoiceDetail);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5904\u7406\u63a5\u53e3\u53d1\u7968\u4fe1\u606f\u5931\u8d25!" + invoiceInfo.getInvoiceNo() + e);
                        LOGGER.error(e.getMessage());
                        continue;
                    }
                }
                if (null != invoiceData.getResultCode() && invoiceData.getResultCode().equals("3302")) {
                    this.updateBillStatusAndOrderStatus(invoiceData);
                }
                this.busiUpdateNotificationExcepService.updateNotificationException(invoiceData.getResultMsg(), invoiceData.getNotificationNo());
            }
            catch (Exception e) {
                LOGGER.error("\u65b0\u589e\u53d1\u7968\u660e\u7ec6\u5931\u8d25:", (Throwable)e);
            }
        }
        if (payInvoiceDetails.size() > 0) {
            this.addPayInvocieDetail(payInvoiceDetails, rspBO);
            log.debug("\u4f9b\u5e94\u5546\u4e3a===" + supplierNo);
            if (!(SUPPLIER_NO.toString().equals(supplierNo) || SUPPLIER_ID_JD_FL.toString().equals(supplierNo) || SUPPLIER_ID_JD_PC.toString().equals(supplierNo))) {
                this.updateTaxId(payInvoiceDetails, rspBO);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private BusiGetInvoiceServiceRspBO dealDataNew(List<BusiGetInvoiceDataRspVO> invoiceDataList, BusiGetInvoiceServiceRspBO rspBO) {
        for (BusiGetInvoiceDataRspVO invoiceData : invoiceDataList) {
            try {
                ArrayList<PayInvoiceDetail> payInvoiceDetails = new ArrayList<PayInvoiceDetail>();
                BusiGetInvoiceResultVO resultVO = new BusiGetInvoiceResultVO();
                LOGGER.debug("\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)invoiceData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                BeanUtils.copyProperties((Object)invoiceData, (Object)resultVO);
                rspBO.getResultList().add(resultVO);
                PayInvoiceInfo invoiceInfo = new PayInvoiceInfo();
                BeanUtils.copyProperties((Object)invoiceData, (Object)invoiceInfo);
                if (StringUtils.hasText((String)invoiceData.getInvoiceNo())) {
                    if (!this.checkInvoiceInfo(invoiceData)) continue;
                    invoiceInfo.setInvoiceStatus(InvoiceStatus.HAS_MAKE.getCode());
                    invoiceInfo.setMailStatus(InvoiceMailStatus.NOT_SENT.getCode());
                    try {
                        String supplierNo = "";
                        BusiGetInvoiceItemListRspBO invoiceItemListRspBo = this.getInvoiceItemList(invoiceData, invoiceInfo);
                        if (!CollectionUtils.isEmpty((Collection)invoiceItemListRspBo.getBusiGetInvoiceItemBOs())) {
                            if (!this.deleteInvoiceDetails(invoiceInfo)) continue;
                            List<PayItemInfoPO> list = this.payItemInfoMapper.selectByNotifNo2(invoiceData.getNotificationNo());
                            List<PayPurchaseOrderInfo> orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(invoiceData.getNotificationNo());
                            Map<String, String> mapExtOrderId = orders.stream().collect(Collectors.toMap(i -> i.getOrderId() + "-" + i.getInspectionId(), PayPurchaseOrderInfo::getExtOrderId, (old, cur) -> cur));
                            Map orderIdMap = list.stream().collect(Collectors.toMap(PayItemInfo::getOrderId, Function.identity(), (key1, key2) -> key2));
                            Map exSkuIdCodeMap = list.stream().collect(Collectors.toMap(PayItemInfo::getExtSkuId, Function.identity(), (key1, key2) -> key2));
                            HashMap<String, PayItemInfoPO> orderIdAndExSkuIdCodeMap = new HashMap<String, PayItemInfoPO>();
                            for (PayItemInfoPO payItemInfo : list) {
                                StringBuilder key = new StringBuilder("");
                                if (SUPPLIER_NO.toString().equals(invoiceInfo.getSupplierNo()) || SUPPLIER_ID_JD_FL.toString().equals(invoiceInfo.getSupplierNo()) || SUPPLIER_ID_JD_PC.toString().equals(invoiceInfo.getSupplierNo())) {
                                    key.append(payItemInfo.getExtOrderId()).append("_").append(payItemInfo.getExtSkuId());
                                } else {
                                    key.append(payItemInfo.getOrderId()).append("_").append(payItemInfo.getExtSkuId());
                                }
                                orderIdAndExSkuIdCodeMap.put(key.toString(), payItemInfo);
                            }
                            for (BusiGetInvoiceItemBO busiGetInvoiceItemBO : invoiceItemListRspBo.getBusiGetInvoiceItemBOs()) {
                                PayItemInfoPO payItemInfo;
                                BigDecimal taxRate = busiGetInvoiceItemBO.getTaxRate().divide(new BigDecimal(100), 5);
                                if (!(SUPPLIER_NO.toString().equals(invoiceInfo.getSupplierNo()) || SUPPLIER_ID_JD_FL.toString().equals(invoiceInfo.getSupplierNo()) || SUPPLIER_ID_JD_PC.toString().equals(invoiceInfo.getSupplierNo()))) {
                                    if (orderIdMap.get(Long.valueOf(busiGetInvoiceItemBO.getOrderCode())) == null || exSkuIdCodeMap.get(busiGetInvoiceItemBO.getExtSkuId()) == null) continue;
                                    payItemInfo = (PayItemInfoPO)orderIdAndExSkuIdCodeMap.get(busiGetInvoiceItemBO.getOrderCode() + "_" + busiGetInvoiceItemBO.getExtSkuId());
                                    payInvoiceDetails.add(this.getPayInvoiceDetail(invoiceInfo, busiGetInvoiceItemBO, taxRate, payItemInfo));
                                    continue;
                                }
                                if (exSkuIdCodeMap.get(busiGetInvoiceItemBO.getExtSkuId()) == null) continue;
                                payItemInfo = (PayItemInfoPO)orderIdAndExSkuIdCodeMap.get(busiGetInvoiceItemBO.getOrderCode() + "_" + busiGetInvoiceItemBO.getExtSkuId());
                                supplierNo = invoiceInfo.getSupplierNo();
                                StringBuilder mapKey = new StringBuilder().append(payItemInfo.getOrderId()).append("-").append(payItemInfo.getInspectionId());
                                if (!mapExtOrderId.get(mapKey.toString()).equals(busiGetInvoiceItemBO.getOrderCode())) continue;
                                payInvoiceDetails.add(this.getJDInvoiceDetail(invoiceInfo, busiGetInvoiceItemBO, taxRate, payItemInfo));
                            }
                        }
                        if (payInvoiceDetails.size() > 0) {
                            this.addPayInvocieDetail(payInvoiceDetails, rspBO);
                            log.debug("\u4f9b\u5e94\u5546\u4e3a===" + supplierNo);
                            if (!(SUPPLIER_NO.toString().equals(supplierNo) || SUPPLIER_ID_JD_FL.toString().equals(supplierNo) || SUPPLIER_ID_JD_PC.toString().equals(supplierNo))) {
                                this.updateTaxId(payInvoiceDetails, rspBO);
                            }
                        }
                        this.payInvoiceService.createInvoice(invoiceInfo);
                        if (!SUPPLIER_NO.toString().equals(invoiceInfo.getSupplierNo()) && !SUPPLIER_ID_JD_FL.toString().equals(invoiceInfo.getSupplierNo()) && !SUPPLIER_ID_JD_PC.toString().equals(invoiceInfo.getSupplierNo())) continue;
                        BusiGetInvoiceDataRspVO busiGetInvoiceDataRspVO = invoiceItemListRspBo.getBusiGetInvoiceDataRspVO();
                        PayInvoiceInfo record = new PayInvoiceInfo();
                        record.setInvoiceCode(invoiceInfo.getInvoiceCode());
                        record.setInvoiceNo(invoiceInfo.getInvoiceNo());
                        record.setInvoiceDate(invoiceInfo.getInvoiceDate());
                        record.setName(busiGetInvoiceDataRspVO.getName());
                        record.setTaxNo(busiGetInvoiceDataRspVO.getTaxNo());
                        record.setAddress(busiGetInvoiceDataRspVO.getAddress());
                        record.setPhone(busiGetInvoiceDataRspVO.getPhone());
                        record.setBankName(busiGetInvoiceDataRspVO.getBankName());
                        record.setBankAcNo(busiGetInvoiceDataRspVO.getBankAcNo());
                        record.setAmt(busiGetInvoiceDataRspVO.getAmt());
                        record.setNotTaxAmt(busiGetInvoiceDataRspVO.getNotTaxAmt());
                        record.setTaxAmt(busiGetInvoiceDataRspVO.getTaxAmt());
                        record.setNotificationNo(invoiceInfo.getNotificationNo());
                        this.payInvoiceInfoMapper.updateByNotificationNo(record);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5904\u7406\u63a5\u53e3\u53d1\u7968\u4fe1\u606f\u5931\u8d25!" + invoiceInfo.getInvoiceNo() + e);
                        LOGGER.error(e.getMessage());
                    }
                    continue;
                }
                if ("3302".equals(invoiceData.getResultCode())) {
                    this.updateBillStatusAndOrderStatus(invoiceData);
                }
                this.busiUpdateNotificationExcepService.updateNotificationException(invoiceData.getResultMsg(), invoiceData.getNotificationNo());
            }
            catch (Exception e) {
                LOGGER.error("\u65b0\u589e\u53d1\u7968\u53ca\u53d1\u7968\u660e\u7ec6\u5931\u8d25:" + e.toString());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private PayInvoiceDetail getJDInvoiceDetail(PayInvoiceInfo invoiceInfo, BusiGetInvoiceItemBO busiGetInvoiceItemBO, BigDecimal taxRate, PayItemInfoPO payItemInfo) {
        PayInvoiceDetail payInvoiceDetail = new PayInvoiceDetail();
        BeanUtils.copyProperties((Object)busiGetInvoiceItemBO, (Object)payInvoiceDetail);
        payInvoiceDetail.setInvoiceCode(invoiceInfo.getInvoiceCode());
        payInvoiceDetail.setInvoiceNo(invoiceInfo.getInvoiceNo());
        payInvoiceDetail.setInvoiceDate(invoiceInfo.getInvoiceDate());
        payInvoiceDetail.setTaxId(busiGetInvoiceItemBO.getTaxId());
        payInvoiceDetail.setOrderId(payItemInfo.getOrderId());
        payInvoiceDetail.setInspectionId(payItemInfo.getInspectionId());
        payInvoiceDetail.setItemNo(payItemInfo.getItemNo());
        payInvoiceDetail.setSkuId(payItemInfo.getSkuId());
        payInvoiceDetail.setTaxRate(taxRate);
        LOGGER.info("taxRate" + payInvoiceDetail.getTaxRate());
        return payInvoiceDetail;
    }

    private PayInvoiceDetail getPayInvoiceDetail(PayInvoiceInfo invoiceInfo, BusiGetInvoiceItemBO busiGetInvoiceItemBO, BigDecimal taxRate, PayItemInfoPO payItemInfo) {
        PayInvoiceDetail payInvoiceDetail = new PayInvoiceDetail();
        BeanUtils.copyProperties((Object)busiGetInvoiceItemBO, (Object)payInvoiceDetail);
        payInvoiceDetail.setInvoiceCode(invoiceInfo.getInvoiceCode());
        payInvoiceDetail.setInvoiceNo(invoiceInfo.getInvoiceNo());
        payInvoiceDetail.setInvoiceDate(invoiceInfo.getInvoiceDate());
        payInvoiceDetail.setTaxId(busiGetInvoiceItemBO.getTaxId());
        payInvoiceDetail.setTaxRate(taxRate);
        payInvoiceDetail.setOrderId(payItemInfo.getOrderId());
        payInvoiceDetail.setInspectionId(payItemInfo.getInspectionId());
        payInvoiceDetail.setItemNo(payItemInfo.getItemNo());
        payInvoiceDetail.setSkuId(payItemInfo.getSkuId());
        LOGGER.info("taxRate" + payInvoiceDetail.getTaxRate());
        return payInvoiceDetail;
    }

    private boolean deleteInvoiceDetails(PayInvoiceInfo invoiceInfo) {
        List<PayInvoiceDetail> invoiceDetails = this.payInvoiceDetailMapper.selectByInvoiceListPK(invoiceInfo.getInvoiceCode(), invoiceInfo.getInvoiceNo(), invoiceInfo.getInvoiceDate());
        if (!invoiceDetails.isEmpty()) {
            try {
                this.payInvoiceDetailMapper.deleteByInvoiceNo(invoiceInfo.getInvoiceCode(), invoiceInfo.getInvoiceNo(), invoiceInfo.getInvoiceDate());
            }
            catch (Exception e) {
                LOGGER.error("\u5904\u7406\u63a5\u53e3\u53d1\u7968\u660e\u7ec6\u4fe1\u606f\u5931\u8d25!" + invoiceInfo, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private BusiGetInvoiceItemListRspBO getInvoiceItemList(BusiGetInvoiceDataRspVO invoiceData, PayInvoiceInfo invoiceInfo) {
        List<PayPurchaseOrderInfo> orders;
        BusiGetInvoiceDataServiceReqBO busiGetInvoiceDataServiceReqBO = new BusiGetInvoiceDataServiceReqBO();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("invoiceId", invoiceInfo.getInvoiceNo());
        map.put("invoiceCode", invoiceInfo.getInvoiceCode());
        map.put("supplierId", invoiceInfo.getSupplierNo());
        if (StringUtils.hasText((String)invoiceInfo.getSupplierNo()) && (SupplierId.JD.getCode().equals(invoiceInfo.getSupplierNo()) || SupplierId.JD_FL.getCode().equals(invoiceInfo.getSupplierNo()) || SupplierId.JD_PC.getCode().equals(invoiceInfo.getSupplierNo())) && null != (orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(invoiceData.getNotificationNo())) && orders.size() > 0 && null != orders && orders.size() > 0 && BusiModel.MATCH_UP_MODEL.getCode().equals(orders.get(0).getBusiModel()) && null != orders.get(0).getJdOrgId()) {
            map.put("orgId", orders.get(0).getJdOrgId().toString());
        }
        busiGetInvoiceDataServiceReqBO.setIdMap(map);
        LOGGER.debug("\u83b7\u53d6\u53d1\u7968\u660e\u7ec6---\u4eac\u4e1ctoken\u6d4b\u8bd5=" + busiGetInvoiceDataServiceReqBO.getOrgIdMap());
        BusiGetInvoiceItemListRspBO busiGetInvoiceItemListRspBO = this.apiGetInvoiceDataService.getInvoiceItems(busiGetInvoiceDataServiceReqBO);
        if (busiGetInvoiceItemListRspBO == null) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38-\u51fa\u53c2\u4e3a\u7a7a");
        }
        List busiGetInvoiceItemBos = busiGetInvoiceItemListRspBO.getBusiGetInvoiceItemBOs();
        if (CollectionUtils.isEmpty((Collection)busiGetInvoiceItemBos)) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38-\u53d1\u7968\u660e\u7ec6\u67e5\u8be2\u4e3a\u7a7a");
        }
        if (!this.checkInvoiceItem(busiGetInvoiceItemBos, invoiceInfo)) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u660e\u7ec6\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u62d2\u7edd\u6536\u7968\uff01");
        }
        return busiGetInvoiceItemListRspBO;
    }

    private boolean checkInvoiceInfo(BusiGetInvoiceDataRspVO invoiceData) {
        if (StringUtils.isEmpty((Object)invoiceData.getInvoiceNo())) {
            this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u53d1\u7968\u53f7\u7801\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", invoiceData.getNotificationNo());
            LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u53d1\u7968\u53f7\u7801\u4e3a\u7a7a!");
            return false;
        }
        if (StringUtils.isEmpty((Object)invoiceData.getInvoiceCode())) {
            this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u53d1\u7968\u4ee3\u7801\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", invoiceData.getNotificationNo());
            LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u53d1\u7968\u4ee3\u7801\u4e3a\u7a7a!");
            return false;
        }
        if (StringUtils.isEmpty((Object)invoiceData.getInvoiceDate())) {
            this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u53d1\u7968\u65e5\u671f\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", invoiceData.getNotificationNo());
            LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u53d1\u7968\u65e5\u671f\u4e3a\u7a7a!");
            return false;
        }
        if (invoiceData.getAmt() == null || invoiceData.getAmt().compareTo(BigDecimal.ZERO) == 0) {
            this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u4ef7\u7a0e\u5408\u8ba1\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", invoiceData.getNotificationNo());
            LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u4ef7\u7a0e\u5408\u8ba1\u4e3a\u7a7a!");
            return false;
        }
        if (!(String.valueOf(SUPPLIER_NO).equals(invoiceData.getSupplierNo()) || SUPPLIER_ID_JD_FL.toString().equals(invoiceData.getSupplierNo()) || SUPPLIER_ID_JD_PC.toString().equals(invoiceData.getSupplierNo()))) {
            if (invoiceData.getNotTaxAmt() == null || invoiceData.getNotTaxAmt().compareTo(BigDecimal.ZERO) == 0) {
                this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", invoiceData.getNotificationNo());
                LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a\u7a7a!");
                return false;
            }
            if (invoiceData.getTaxAmt() == null || invoiceData.getTaxAmt().compareTo(BigDecimal.ZERO) == 0) {
                this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u53d1\u7968\u7a0e\u989d\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", invoiceData.getNotificationNo());
                LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u53d1\u7968\u7a0e\u989d\u4e3a\u7a7a!");
                return false;
            }
            if (StringUtils.isEmpty((Object)invoiceData.getInvoiceType())) {
                this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u53d1\u7968\u7c7b\u578b\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", invoiceData.getNotificationNo());
                LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u53d1\u7968\u7c7b\u578b\u4e3a\u7a7a!");
                return false;
            }
            if (StringUtils.isEmpty((Object)invoiceData.getName())) {
                this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u53d1\u7968\u62ac\u5934\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", invoiceData.getNotificationNo());
                LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u53d1\u7968\u62ac\u5934\u4e3a\u7a7a!");
                return false;
            }
            if (StringUtils.isEmpty((Object)invoiceData.getTaxNo())) {
                this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", invoiceData.getNotificationNo());
                LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a\u7a7a!");
                return false;
            }
        }
        return true;
    }

    private boolean checkInvoiceItem(List<BusiGetInvoiceItemBO> busiGetInvoiceItemBOs, PayInvoiceInfo invoiceInfo) {
        String notificationNo = invoiceInfo.getNotificationNo();
        block0: for (BusiGetInvoiceItemBO bo : busiGetInvoiceItemBOs) {
            if (StringUtils.isEmpty((Object)invoiceInfo.getInvoiceCode())) {
                this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u660e\u7ec6\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u53d1\u7968\u4ee3\u7801\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", notificationNo);
                LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u53d1\u7968\u4ee3\u7801\u4e3a\u7a7a!");
                return false;
            }
            if (StringUtils.isEmpty((Object)bo.getOrderCode())) {
                this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u660e\u7ec6\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", notificationNo);
                LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a!");
                return false;
            }
            if (StringUtils.isEmpty((Object)bo.getExtSkuId())) {
                this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u660e\u7ec6\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u5546\u54c1\u7f16\u53f7\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", notificationNo);
                LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u5546\u54c1\u7f16\u53f7\u4e3a\u7a7a!");
                return false;
            }
            if (bo.getAmount() == null || bo.getAmount().compareTo(BigDecimal.ZERO) == 0) {
                this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u660e\u7ec6\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u603b\u91d1\u989d\uff08\u542b\u7a0e\uff09\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", notificationNo);
                LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u603b\u91d1\u989d\uff08\u542b\u7a0e\uff09\u4e3a\u7a7a!");
                return false;
            }
            if (bo.getUntaxAmt() == null || bo.getUntaxAmt().compareTo(BigDecimal.ZERO) == 0) {
                this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u660e\u7ec6\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u603b\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", notificationNo);
                LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u603b\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\u4e3a\u7a7a!");
                return false;
            }
            if (bo.getTaxAmt() == null) {
                this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u660e\u7ec6\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-[ItemNo:" + bo.getItemNo() + "]\u7a0e\u989d\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", notificationNo);
                LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u7a0e\u989d\u4e3a\u7a7a!");
                return false;
            }
            if (String.valueOf(SUPPLIER_NO).equals(invoiceInfo.getSupplierNo()) || SUPPLIER_ID_JD_FL.toString().equals(invoiceInfo.getSupplierNo()) || SUPPLIER_ID_JD_PC.toString().equals(invoiceInfo.getSupplierNo())) continue;
            int number = this.saleItemInfoMapper.getNoTaxCatCodeNumber(bo.getOrderCode());
            if (number > 0) {
                if (!StringUtils.isEmpty((Object)bo.getTaxId())) continue;
                this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u660e\u7ec6\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a!\uff0c\u5b9a\u65f6\u518d\u6b21\u83b7\u53d6", notificationNo);
                LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a!");
                return false;
            }
            List<PayItemInfo> payItemInfos = this.payItemInfoMapper.selectByNotifNo(notificationNo);
            for (PayItemInfo payItemInfo : payItemInfos) {
                if (!bo.getOrderCode().equals(String.valueOf(payItemInfo.getOrderId())) || !payItemInfo.getExtSkuId().equals(bo.getExtSkuId())) continue;
                Long itemNo = payItemInfo.getItemNo();
                SaleItemInfo saleItemInfo = this.saleItemInfoMapper.selectByItemNo(itemNo);
                if (StringUtils.isEmpty((Object)saleItemInfo.getTaxCatCode()) || StringUtils.isEmpty((Object)bo.getTaxId()) || bo.getTaxId().equals(String.valueOf(saleItemInfo.getTaxCatCode()))) continue block0;
                this.busiUpdateNotificationExcepService.updateNotificationException("\u83b7\u53d6\u53d1\u7968\u660e\u7ec6\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0e\u4e0a\u6e38\u5206\u7c7b\u7f16\u7801\u4e0d\u4e00\u81f4![ItemNo:" + itemNo + "],\u8ba2\u5355\u660e\u7ec6\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a:" + saleItemInfo.getTaxCatCode() + ",\u53d1\u7968\u660e\u7ec6\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:" + bo.getTaxId(), notificationNo);
                LOGGER.error("\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff1a\u6839\u636e\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u53ca\u660e\u7ec6\u4fe1\u606f-\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0e\u4e0a\u6e38\u5206\u7c7b\u7f16\u7801\u4e0d\u4e00\u81f4!");
                return false;
            }
        }
        return true;
    }

    private void updateBillStatusAndOrderStatus(BusiGetInvoiceDataRspVO invoiceData) {
        if (invoiceData.getNotificationNo() == null) {
            throw new PfscExtBusinessException("8888", "\u65e0\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff0c\u65e0\u6cd5\u66f4\u65b0\u9a73\u56de\u72b6\u6001");
        }
        String notificationNo = invoiceData.getNotificationNo();
        List<PayPurchaseOrderInfo> payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
        if (!CollectionUtils.isEmpty(payPurchaseOrderInfoList)) {
            List<NotificationRejectOrderInfo> rejectOrderInfoList = payPurchaseOrderInfoList.stream().map(payPurchaseOrderInfo -> {
                NotificationRejectOrderInfo rejectOrderInfo = new NotificationRejectOrderInfo();
                BeanUtils.copyProperties((Object)payPurchaseOrderInfo, (Object)rejectOrderInfo);
                rejectOrderInfo.setCreateDate(new Date());
                rejectOrderInfo.setOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
                return rejectOrderInfo;
            }).collect(Collectors.toList());
            log.info("\u8bb0\u5f55\u9a73\u56de\u901a\u77e5\u5355\u548c\u8ba2\u5355\u5173\u7cfb:" + JSON.toJSONString(rejectOrderInfoList));
            this.notificationRejectOrderInfoMapper.insertBatch(rejectOrderInfoList);
        }
        BillNotificationInfo notificationInfo = new BillNotificationInfo();
        notificationInfo.setNotificationNo(notificationNo);
        notificationInfo.setInvoiceStatus(NotificationInvoiceStatus.REJECT.getCode());
        this.notificationInfomapper.updateByPrimaryKeySelective(notificationInfo);
        PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
        vo.setNotificationNo(notificationNo);
        vo.setOrderStatus(OrderStatus.AUTO_HANG_UP.getCode());
        vo.setHangDate(new Date());
        this.payPurchaseOrderInfoMapper.updateFailResult(vo);
        PayItemInfoVO itemInfoVO = new PayItemInfoVO();
        itemInfoVO.setNotificationNo(notificationNo);
        itemInfoVO.setItemStatus("00");
        this.payItemInfoMapper.updateStatus(itemInfoVO);
    }

    public void addPayInvocieDetail(List<PayInvoiceDetail> payInvoiceDetails, BusiGetInvoiceServiceRspBO rspBO) {
        LOGGER.error("\u65b0\u589e\u53d1\u7968\u660e\u7ec6\u6570\u91cf", (Object)payInvoiceDetails.size());
        try {
            LOGGER.error("payInvoiceDetails\u6253\u5370", (Object)payInvoiceDetails.toString());
            this.payInvoiceDetailMapper.insertByBatch(payInvoiceDetails);
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u53d1\u7968\u660e\u7ec6\u5931\u8d25", (Throwable)e);
            rspBO.setRespDesc("\u65b0\u589e\u53d1\u7968\u660e\u7ec6\u5931\u8d25");
            throw new RuntimeException("\u65b0\u589e\u53d1\u7968\u660e\u7ec6\u5931\u8d25", e);
        }
    }

    public void updateTaxId(List<PayInvoiceDetail> payInvoiceDetails, BusiGetInvoiceServiceRspBO rspBO) {
        Long itemNo = null;
        try {
            ArrayList<PayItemInfo> payItemInfoList = new ArrayList<PayItemInfo>();
            ArrayList<SaleItemInfo> saleItemInfoList = new ArrayList<SaleItemInfo>();
            for (PayInvoiceDetail payInvoiceDetail : payInvoiceDetails) {
                if (null != payInvoiceDetail.getTaxId() && !"".equals(payInvoiceDetail.getTaxId())) {
                    PayItemInfo payItemInfo = new PayItemInfo();
                    payItemInfo.setItemNo(payInvoiceDetail.getItemNo());
                    payItemInfo.setTaxId(payInvoiceDetail.getTaxId());
                    payItemInfo.setInspectionId(payInvoiceDetail.getInspectionId());
                    payItemInfoList.add(payItemInfo);
                    SaleItemInfo saleItemInfo = new SaleItemInfo();
                    saleItemInfo.setItemNo(payInvoiceDetail.getItemNo());
                    saleItemInfo.setTaxCatCode(Long.valueOf(payInvoiceDetail.getTaxId()));
                    saleItemInfo.setInspectionId(payInvoiceDetail.getInspectionId());
                    saleItemInfoList.add(saleItemInfo);
                    continue;
                }
                itemNo = payInvoiceDetail.getItemNo();
                rspBO.setRespDesc("\"\u53d1\u7968\u660e\u7ec6\uff1a\"+itemNo+\"\uff0c\u5bf9\u5e94\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a\"");
                throw new RuntimeException("\u53d1\u7968\u660e\u7ec6\uff1a" + itemNo + "\uff0c\u5bf9\u5e94\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty(payItemInfoList)) {
                this.payItemInfoMapper.updateByBatch(payItemInfoList);
            }
            if (!CollectionUtils.isEmpty(saleItemInfoList)) {
                this.saleItemInfoMapper.updateByBatch(saleItemInfoList);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u7968\u660e\u7ec6\uff1a" + itemNo + "\uff0c\u5bf9\u5e94\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a", (Throwable)e);
            rspBO.setRespDesc("\"\u53d1\u7968\u660e\u7ec6\uff1a\"+itemNo+\"\uff0c\u5bf9\u5e94\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a\"");
            throw new RuntimeException("\u53d1\u7968\u660e\u7ec6\uff1a" + itemNo + "\uff0c\u5bf9\u5e94\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a");
        }
    }

    private BusiGetInvoiceServiceRspBO getInvoiceInfoAgain(List<String> billNotificationInfos) {
        BusiGetInvoiceServiceRspBO rspBO = new BusiGetInvoiceServiceRspBO();
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        billNotificationInfo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        billNotificationInfo.setNotificationNos(billNotificationInfos);
        List<BillNotificationInfo> invoiceList = this.notificationInfomapper.selectList(billNotificationInfo);
        if (invoiceList.isEmpty()) {
            LOGGER.debug("\u65e0\u5f00\u7968\u72b6\u6001\u4e3a01(\u5df2\u63d0\u4ea4)\u7684\u8bb0\u5f55,\u7a0b\u5e8f\u9000\u51fa");
            return rspBO;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        HashMap<String, Long> orgIdMap = new HashMap<String, Long>();
        for (BillNotificationInfo info : invoiceList) {
            List<PayPurchaseOrderInfo> orders;
            String markId = info.getNotificationNo();
            String id = String.valueOf(info.getSupplierNo());
            dataMap.put(markId, id);
            if (!StringUtils.hasText((String)id) || !SupplierId.JD.getCode().equals(id) && !SupplierId.JD_FL.getCode().equals(id) && !SupplierId.JD_PC.getCode().equals(id) || null == (orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(info.getNotificationNo())) || orders.size() <= 0 || !BusiModel.MATCH_UP_MODEL.getCode().equals(orders.get(0).getBusiModel())) continue;
            orgIdMap.put(markId, orders.get(0).getJdOrgId());
        }
        LOGGER.debug("\u91cd\u65b0\u83b7\u53d6\u53d1\u7968---\u4eac\u4e1ctoken\u6d4b\u8bd5--------orgIdMap=" + orgIdMap);
        LOGGER.debug("\u9700\u8981\u8f6e\u8be2\u53d1\u7968\u8d44\u6599\u7684\u901a\u77e5\u5355,count=" + invoiceList.size() + ",dataMap=" + dataMap);
        BusiGetInvoiceDataServiceReqBO getInvoiceDataReqBO = new BusiGetInvoiceDataServiceReqBO();
        getInvoiceDataReqBO.setIdMap(dataMap);
        getInvoiceDataReqBO.setOrgIdMap(orgIdMap);
        List invoiceDataList = this.apiGetInvoiceDataService.getInvoiceData(getInvoiceDataReqBO).getDataList();
        if (CollectionUtils.isEmpty((Collection)invoiceDataList)) {
            LOGGER.debug("\u6ca1\u6709\u67e5\u8be2\u5230\u5f00\u7968\u6570\u636e\uff0c\u7a0b\u5e8f\u9000\u51fa");
            return rspBO;
        }
        ArrayList list = new ArrayList();
        rspBO.setResultList(list);
        return this.dealDataNew(invoiceDataList, rspBO);
    }
}

