/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.order.extend.bo.order.PebExtPayResultReqBO;
import com.tydic.order.extend.bo.order.PebExtPayResultRspBO;
import com.tydic.payment.pay.sdk.PayCenterUtils;
import com.tydic.pfscext.api.busi.BusiIntermediateStatusUpdateService;
import com.tydic.pfscext.api.busi.bo.BusiIntermediateStatusUpdateReq;
import com.tydic.pfscext.api.busi.bo.BusiIntermediateStatusUpdateRsp;
import com.tydic.pfscext.api.busi.bo.FscPayableCallBackBO;
import com.tydic.pfscext.api.busi.bo.FscPayableCallBackUocRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.uoc.api.FscPebExtFscPayResultExternalService;
import com.tydic.pfscext.utils.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiIntermediateStatusUpdateService"})
public class BusiIntermediateStatusUpdateServiceImpl
implements BusiIntermediateStatusUpdateService {
    private static final Logger logger = LoggerFactory.getLogger(BusiIntermediateStatusUpdateServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Value(value="${publicKey}")
    private String publicKey;
    private static final String SUCCESS = "SUCCESS";
    private static final String FAILURE = "FAILURE";
    @Autowired
    private FscPebExtFscPayResultExternalService fscPebExtFscPayResultExternalService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    @PostMapping(value={"noticeOrderupdateStatus"})
    public BusiIntermediateStatusUpdateRsp noticeOrderupdateStatus(@RequestBody BusiIntermediateStatusUpdateReq reqBO) {
        FscPayableCallBackUocRspBO rspBO = new FscPayableCallBackUocRspBO();
        String content = PayCenterUtils.deCode((String)reqBO.getContent(), (String)this.publicKey);
        BusiIntermediateStatusUpdateRsp busiIntermediateStatusUpdateRsp = new BusiIntermediateStatusUpdateRsp();
        FscPayableCallBackBO fscPayableCallBackBO = (FscPayableCallBackBO)JSON.parseObject((String)content, FscPayableCallBackBO.class);
        String[] split = fscPayableCallBackBO.getOutOrderId().split("-");
        String payNo = split[1];
        List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(payNo);
        ArrayList payableNos = new ArrayList(applyDetails.size());
        applyDetails.forEach(applyDetail -> payableNos.add(applyDetail.getPayableNo()));
        for (String payableNo : payableNos) {
            PayableDetailPO payableDetailPO = new PayableDetailPO();
            payableDetailPO.setPayableNo(payableNo);
            payableDetailPO.setPayableStatus(ApplyPayStatus.PIDNG_DEALING.getCode());
            this.payableDetailMapper.updateByPayableNo(payableDetailPO);
            PebExtPayResultReqBO extPayResultReqBO = (PebExtPayResultReqBO)JSON.parseObject((String)content, PebExtPayResultReqBO.class);
            ArrayList<String> payableNosList = new ArrayList<String>();
            payableNosList.add(payableNo);
            extPayResultReqBO.setPayableNos(payableNosList);
            extPayResultReqBO.setOrderId(null);
            PayableDetailPO payableDetailPOQry = this.payableDetailMapper.getModelById(payableNo);
            if (payableDetailPOQry.getOrderId() != null) {
                extPayResultReqBO.setInspectionVoucherId(payableDetailPOQry.getInspectionId());
                extPayResultReqBO.setOrderId(payableDetailPOQry.getOrderId().toString());
            } else {
                List<SaleOrderInfo> saleOrderInfoList;
                List<PayPurchaseOrderInfo> payPurchaseOrderInfoList;
                if ("1".equals(payableDetailPOQry.getBusiModel()) && !StringUtils.isEmpty((CharSequence)payableDetailPOQry.getNotificationNo()) && !CollectionUtils.isEmpty(payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.selectByNotifNo(payableDetailPOQry.getNotificationNo()))) {
                    for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoList) {
                        PebExtPayResultReqBO extPayResultReqBO1 = new PebExtPayResultReqBO();
                        extPayResultReqBO1.setInspectionVoucherId(payPurchaseOrderInfo.getInspectionId());
                        extPayResultReqBO1.setOrderId(payPurchaseOrderInfo.getOrderId().toString());
                        extPayResultReqBO1.setPaymentFinishTime(this.getTradeTime(fscPayableCallBackBO.getTradeTime()));
                        logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + JSON.toJSONString((Object)extPayResultReqBO1));
                        PebExtPayResultRspBO pebExtPayResultRspBO = this.fscPebExtFscPayResultExternalService.dealPayResult(extPayResultReqBO1);
                        logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + pebExtPayResultRspBO);
                        if (pebExtPayResultRspBO != null && SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) {
                            rspBO.setNotifyResult(SUCCESS);
                            continue;
                        }
                        rspBO.setNotifyResult(FAILURE);
                        throw new PfscExtBusinessException("0001", "\u4fee\u6539\u8ba2\u5355\u4e2d\u5fc3\u7684\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25");
                    }
                    return busiIntermediateStatusUpdateRsp;
                }
                if ("0".equals(payableDetailPOQry.getBusiModel()) && !StringUtils.isEmpty((CharSequence)payableDetailPOQry.getApplyNo()) && !CollectionUtils.isEmpty(saleOrderInfoList = this.saleOrderInfoMapper.getModelByApplyNo(payableDetailPOQry.getApplyNo()))) {
                    for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
                        PebExtPayResultReqBO extPayResultReqBO1 = new PebExtPayResultReqBO();
                        extPayResultReqBO1.setInspectionVoucherId(saleOrderInfo.getInspectionId());
                        extPayResultReqBO1.setOrderId(saleOrderInfo.getOrderId().toString());
                        extPayResultReqBO1.setPaymentFinishTime(this.getTradeTime(fscPayableCallBackBO.getTradeTime()));
                        logger.info("\u8c03\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + JSON.toJSONString((Object)extPayResultReqBO1));
                        PebExtPayResultRspBO pebExtPayResultRspBO = this.fscPebExtFscPayResultExternalService.dealPayResult(extPayResultReqBO1);
                        logger.info("\u8c03\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + pebExtPayResultRspBO);
                        if (pebExtPayResultRspBO != null && SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) {
                            rspBO.setNotifyResult(SUCCESS);
                            continue;
                        }
                        rspBO.setNotifyResult(FAILURE);
                        throw new PfscExtBusinessException("0001", "\u4fee\u6539\u8ba2\u5355\u4e2d\u5fc3\u7684\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25");
                    }
                    return busiIntermediateStatusUpdateRsp;
                }
            }
            extPayResultReqBO.setPaymentFinishTime(this.getTradeTime(fscPayableCallBackBO.getTradeTime()));
            logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + JSON.toJSONString((Object)extPayResultReqBO));
            PebExtPayResultRspBO pebExtPayResultRspBO = this.fscPebExtFscPayResultExternalService.dealPayResult(extPayResultReqBO);
            logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + pebExtPayResultRspBO);
            if (pebExtPayResultRspBO != null && SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) {
                rspBO.setNotifyResult(SUCCESS);
                continue;
            }
            rspBO.setNotifyResult(FAILURE);
            throw new PfscExtBusinessException("0001", "\u4fee\u6539\u8ba2\u5355\u4e2d\u5fc3\u7684\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25");
        }
        return busiIntermediateStatusUpdateRsp;
    }

    private Date getTradeTime(String tradeTime) {
        if (StringUtils.isNotBlank((CharSequence)tradeTime)) {
            try {
                Date payTime = DateUtil.strToDate(tradeTime, "yyyyMMddHHmmss");
                return payTime;
            }
            catch (Exception e) {
                logger.error("\u652f\u4ed8\u4e2d\u5fc3\u65f6\u95f4\u8bfb\u53d6\u9519\u8bef\uff1a{}", (Object)tradeTime);
            }
        }
        return null;
    }
}

