/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.pfscext.api.busi.bo.NotifyOrderInfoBO;
import com.tydic.pfscext.dao.PayInvoiceDetailMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayInvoiceDetail;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.external.api.bo.BillNotificationPushErpInfo;
import com.tydic.pfscext.external.api.bo.BusiNotificationPushErpInfoBO;
import com.tydic.pfscext.service.busi.BusiNotificationPushErpMsgService;
import com.tydic.pfscext.service.busi.bo.BusiNotificationPushErpReqBO;
import com.tydic.pfscext.service.busi.bo.BusiNotificationPushErpRspBO;
import com.tydic.pfscext.utils.DateUtil;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiNotificationPushErpMsgServiceImpl
implements BusiNotificationPushErpMsgService {
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;

    @Override
    public BusiNotificationPushErpRspBO getPushErpNotificationMsg(BusiNotificationPushErpReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getApplyNo())) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[applyNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BusiNotificationPushErpRspBO rspBO = new BusiNotificationPushErpRspBO();
        LinkedList<BusiNotificationPushErpInfoBO> yfList = new LinkedList<BusiNotificationPushErpInfoBO>();
        Page page = new Page(1, 99999999);
        List<NotifyOrderInfoBO> notifyOrderInfoList = this.saleOrderInfoMapper.getNotifyOrderListByApplyNo(reqBO.getApplyNo(), (Page<Map<String, Object>>)page);
        List supNoList = notifyOrderInfoList.stream().map(NotifyOrderInfoBO::getSupplierNo).distinct().collect(Collectors.toList());
        HashMap<String, String> supCodeMap = new HashMap<String, String>(supNoList.size());
        for (String supplierNo : supNoList) {
            UmcQrySupplierInfoDetailAbilityReqBO umcQrySupplierInfoDetailAbilityReqBO = new UmcQrySupplierInfoDetailAbilityReqBO();
            umcQrySupplierInfoDetailAbilityReqBO.setSupplierId(Long.valueOf(supplierNo));
            UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(umcQrySupplierInfoDetailAbilityReqBO);
            if (!umcQrySupplierInfoDetailAbilityRspBO.getRespCode().equals("0000")) continue;
            supCodeMap.put(supplierNo, umcQrySupplierInfoDetailAbilityRspBO.getCreditNo());
        }
        for (NotifyOrderInfoBO notifyOrderInfoBO : notifyOrderInfoList) {
            List<PayInvoiceInfo> payInvoiceInfoList = this.payInvoiceInfoMapper.selectByNotifyNo(notifyOrderInfoBO.getNotificationNo());
            for (PayInvoiceInfo payInvoiceInfo : payInvoiceInfoList) {
                BusiNotificationPushErpInfoBO pushErpInfoBO = new BusiNotificationPushErpInfoBO();
                TreeSet<String> idList = new TreeSet<String>();
                pushErpInfoBO.setInvoiceNum(payInvoiceInfo.getInvoiceNo());
                pushErpInfoBO.setInvoiceDate(DateUtil.dateToStr(payInvoiceInfo.getInvoiceDate(), "yyyy-MM-dd"));
                pushErpInfoBO.setInvoiceCode(payInvoiceInfo.getInvoiceCode());
                pushErpInfoBO.setSuppCode((String)supCodeMap.get(notifyOrderInfoBO.getSupplierNo()));
                pushErpInfoBO.setPlatformSign("1");
                List<PayInvoiceDetail> invoiceDetailList = this.payInvoiceDetailMapper.selectByInvoiceListPK(payInvoiceInfo.getInvoiceCode(), payInvoiceInfo.getInvoiceNo(), payInvoiceInfo.getInvoiceDate());
                LinkedList<BillNotificationPushErpInfo> pushErpInfoList = new LinkedList<BillNotificationPushErpInfo>();
                for (PayInvoiceDetail payInvoiceDetail : invoiceDetailList) {
                    BillNotificationPushErpInfo pushErpInfo = new BillNotificationPushErpInfo();
                    pushErpInfo.setQty(payInvoiceDetail.getQuantity());
                    pushErpInfo.setTaxMoney(payInvoiceDetail.getTaxAmt());
                    pushErpInfo.setNoTaxMoney(payInvoiceDetail.getUntaxAmt());
                    pushErpInfo.setTotalMoney(payInvoiceDetail.getAmount());
                    pushErpInfo.setTaxPrice(payInvoiceDetail.getPriceIntax());
                    pushErpInfo.setSrcDocNo(String.valueOf(payInvoiceDetail.getInspectionId()));
                    idList.add(String.valueOf(payInvoiceDetail.getInspectionId()));
                    pushErpInfo.setSrcorderitemid(String.valueOf(payInvoiceDetail.getItemNo()));
                    SaleItemInfo saleItemInfo = this.saleItemInfoMapper.selectByItemNo(payInvoiceDetail.getItemNo());
                    if (saleItemInfo != null) {
                        pushErpInfo.setOrderitemid(String.valueOf(saleItemInfo.getPurchaseItemNo()));
                    }
                    pushErpInfoList.add(pushErpInfo);
                }
                pushErpInfoBO.setInspectionIdList(idList);
                pushErpInfoBO.setRows(pushErpInfoList);
                yfList.add(pushErpInfoBO);
            }
            rspBO.setYfList(yfList);
        }
        return rspBO;
    }
}

