/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.constants.FscCommonConstants;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.NotificationRejectOrderInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SupplierInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfoExt;
import com.tydic.pfscext.dao.po.NotificationRejectOrderInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SupplierInfo;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiApplyInvoiceService;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceReqBO;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceRspBO;
import com.tydic.pfscext.external.esb.api.FscEsbJDAddressExternalService;
import com.tydic.pfscext.external.esb.bo.FscEsbGetJDAddressFromAddressExternalReqBO;
import com.tydic.pfscext.external.esb.bo.FscEsbGetJDAddressFromAddressExternalRspBO;
import com.tydic.pfscext.external.esb.bo.FscEsbGetJDAddressFromAddressInfoBO;
import com.tydic.pfscext.external.esb.bo.FscEsbJDAddressCheckAreaExternalReqBO;
import com.tydic.pfscext.external.esb.bo.FscEsbJDAddressCheckAreaExternalRspBO;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.busi.BusiNotifyEcommerceInvoiceService;
import com.tydic.pfscext.service.busi.bo.BusiNotifyEcommerceInvoiceServiceReqBo;
import com.tydic.pfscext.service.busi.bo.BusiNotifyEcommerceInvoiceServiceRspBo;
import com.tydic.pfscext.utils.FscCommonUtils;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BusiNotifyEcommerceInvoiceServiceImpl
implements BusiNotifyEcommerceInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(BusiNotifyEcommerceInvoiceServiceImpl.class);
    @Autowired
    private BusiApplyInvoiceService busiApplyInvoiceService;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Autowired
    private FscEsbJDAddressExternalService fscEsbJDAddressExternalService;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private NotificationRejectOrderInfoMapper notificationRejectOrderInfoMapper;
    @Autowired
    private EnumsService enumsService;
    private static final Long SUPPLIER_ID = 100055L;
    private static final Long SUPPLIER_ID_JD_FL = 2022081501L;
    private static final Long SUPPLIER_ID_JD_PC = 1000550L;
    @Value(value="${FAIL_COUNT}")
    private String failCountStr;
    @Value(value="${cnnc.verify.jd.address.switch:1}")
    private String VERIFY_JD_ADDRESS_SWITCH;

    @Override
    public BusiNotifyEcommerceInvoiceServiceRspBo notifyEcommerceForInvoice(BusiNotifyEcommerceInvoiceServiceReqBo reqBO) {
        if (reqBO.getBillNotificationInfoExt() == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiNotifyEcommerceInvoiceServiceRspBo rspBO = new BusiNotifyEcommerceInvoiceServiceRspBo();
        BillNotificationInfoExt notifyInfo = reqBO.getBillNotificationInfoExt();
        List<PayPurchaseOrderInfo> orderInfoList = reqBO.getPayPurchaseOrderInfoList();
        if (CollectionUtils.isEmpty(orderInfoList)) {
            PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
            payPurchaseOrderInfo.setNotificationNo(notifyInfo.getNotificationNo());
            orderInfoList = this.payPurchaseOrderInfoMapper.getListByCondition(payPurchaseOrderInfo);
        }
        log.info("\u672c\u6b21\u5f00\u7968\u901a\u77e5\u7535\u5546\u901a\u77e5\u5355\u4e3a=================" + notifyInfo);
        BusiApplyInvoiceReqBO applyInvoiceReqBO = new BusiApplyInvoiceReqBO();
        PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
        payItemInfoVO.setNotificationNo(notifyInfo.getNotificationNo());
        PayItemInfo payItemInfo = this.payItemInfoMapper.selectAmtByNoti(payItemInfoVO);
        if (payItemInfo != null) {
            applyInvoiceReqBO.setSettlementNakedPrice(payItemInfo.getUntaxAmt());
            applyInvoiceReqBO.setSettlementTaxPrice(payItemInfo.getTaxAmt());
        }
        LinkedList<String> orderIdCombStr = new LinkedList<String>();
        LinkedList<String> eorderIds = new LinkedList<String>();
        LinkedList<BigDecimal> orderAmt = new LinkedList<BigDecimal>();
        BusiApplyInvoiceRspBO busiApplyInvoiceRspBO = new BusiApplyInvoiceRspBO();
        try {
            applyInvoiceReqBO.setSupplierId(notifyInfo.getSupplierNo());
            if (BusiModel.MATCH_UP_MODEL.getCode().equals(orderInfoList.get(0).getBusiModel()) && (SUPPLIER_ID.equals(notifyInfo.getSupplierNo()) || SUPPLIER_ID_JD_FL.equals(notifyInfo.getSupplierNo()) || SUPPLIER_ID_JD_PC.equals(notifyInfo.getSupplierNo()))) {
                applyInvoiceReqBO.setJdOrgId(orderInfoList.get(0).getJdOrgId());
            }
            for (PayPurchaseOrderInfo orderInfo : orderInfoList) {
                orderIdCombStr.add(orderInfo.getExtOrderId());
                eorderIds.add(orderInfo.getPurchaseOrderCode());
                orderAmt.add(orderInfo.getOrderAmt());
            }
            applyInvoiceReqBO.setSupplierOrder(orderIdCombStr);
            applyInvoiceReqBO.setEorderId(eorderIds);
            applyInvoiceReqBO.setSettleAmt(orderAmt);
            applyInvoiceReqBO.setMarkId(notifyInfo.getNotificationNo());
            applyInvoiceReqBO.setSettlementId(notifyInfo.getNotificationNo());
            String curBatchStr = notifyInfo.getNotificationNo();
            String regEx = "[^0-9]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(curBatchStr);
            curBatchStr = m.replaceAll("").trim();
            curBatchStr = curBatchStr.substring(curBatchStr.length() - 6, curBatchStr.length());
            applyInvoiceReqBO.setCurrentBatch(curBatchStr);
            SimpleDateFormat sfWithSlash = new SimpleDateFormat("yyyy-MM-dd");
            String dateWithSlashStr = sfWithSlash.format(new Date());
            applyInvoiceReqBO.setInvoiceDate(dateWithSlashStr);
            applyInvoiceReqBO.setInvoiceNum(Integer.valueOf(orderIdCombStr.size()));
            applyInvoiceReqBO.setTotalBatch(FscCommonConstants.BASIC_INVOICE_BATCH_NUM);
            if (notifyInfo.getInvoceType() == 1) {
                applyInvoiceReqBO.setInvoiceType(Integer.valueOf(3));
            } else {
                applyInvoiceReqBO.setInvoiceType(notifyInfo.getInvoceType());
            }
            SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(notifyInfo.getSupplierNo());
            if (supplierInfo == null) {
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4f9b\u5e94\u5546\u5f00\u7968\u9650\u989d\u914d\u7f6e\u8868\uff0c\u4f9b\u5e94\u5546ID:" + String.valueOf(notifyInfo.getSupplierNo()) + "\u627e\u4e0d\u5230\u5bf9\u5e94\u914d\u7f6e\u4fe1\u606f");
            }
            String invoiceOrgSetting = supplierInfo.getBillOrg();
            applyInvoiceReqBO.setInvoiceOrg(invoiceOrgSetting);
            applyInvoiceReqBO.setTitle(notifyInfo.getInvoceName());
            applyInvoiceReqBO.setBizInvoiceContent(Integer.valueOf(1));
            applyInvoiceReqBO.setInvoicePrice(notifyInfo.getAmt());
            applyInvoiceReqBO.setTotalBatchInvoiceAmount(notifyInfo.getAmt());
            applyInvoiceReqBO.setEnterpriseTaxpayer(notifyInfo.getTaxNo());
            String accountStr = notifyInfo.getBankAccNo();
            accountStr = accountStr.replaceAll("\\s*", "");
            applyInvoiceReqBO.setBillToParty(notifyInfo.getCompany());
            applyInvoiceReqBO.setBillToer(notifyInfo.getName());
            applyInvoiceReqBO.setBillToContact(notifyInfo.getMobile());
            applyInvoiceReqBO.setBillToProvince(FscCommonUtils.long2Integer((Long)notifyInfo.getProvId()));
            applyInvoiceReqBO.setBillToCity(FscCommonUtils.long2Integer((Long)notifyInfo.getCityId()));
            applyInvoiceReqBO.setBillToCounty(Integer.valueOf(FscCommonUtils.long2Integer((Long)notifyInfo.getCountyId()) == null ? 0 : FscCommonUtils.long2Integer((Long)notifyInfo.getCountyId())));
            applyInvoiceReqBO.setBillToTown(Integer.valueOf(FscCommonUtils.long2Integer((Long)notifyInfo.getTownId()) == null ? 0 : FscCommonUtils.long2Integer((Long)notifyInfo.getTownId())));
            applyInvoiceReqBO.setBillToAddress(notifyInfo.getAddrDesc());
            applyInvoiceReqBO.setOpenSwitch(this.enumsService.queryOpenSwitch(applyInvoiceReqBO.getSupplierId()));
            applyInvoiceReqBO.setInvoiceRemark(notifyInfo.getInvoiceRemark());
            if (SUPPLIER_ID.equals(notifyInfo.getSupplierNo()) || SUPPLIER_ID_JD_FL.equals(notifyInfo.getSupplierNo()) || SUPPLIER_ID_JD_PC.equals(notifyInfo.getSupplierNo())) {
                applyInvoiceReqBO.setEnterpriseRegAddress(notifyInfo.getAddr());
                applyInvoiceReqBO.setEnterpriseRegPhone(notifyInfo.getPhone());
                applyInvoiceReqBO.setEnterpriseBankName(notifyInfo.getBankName());
                applyInvoiceReqBO.setEnterpriseBankAccount(accountStr);
                this.checkJDAddress(applyInvoiceReqBO, notifyInfo);
            } else {
                applyInvoiceReqBO.setAddress(notifyInfo.getAddr());
                applyInvoiceReqBO.setTel(notifyInfo.getPhone());
                applyInvoiceReqBO.setBank(notifyInfo.getBankName());
                applyInvoiceReqBO.setAccount(accountStr);
            }
            busiApplyInvoiceRspBO = this.busiApplyInvoiceService.applyInvoice(applyInvoiceReqBO);
        }
        catch (Exception e) {
            log.error("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u51fa\u9519:" + e.getMessage());
            this.returnFail(reqBO, e.getMessage());
            rspBO.setRespCode("18000");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        if (busiApplyInvoiceRspBO == null || !busiApplyInvoiceRspBO.getSuccess().booleanValue()) {
            log.error("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u7535\u5546\u8fd4\u56de\u7ed3\u679c\u5931\u8d25:" + busiApplyInvoiceRspBO.getResultMessage());
            this.returnFail(reqBO, busiApplyInvoiceRspBO.getResultMessage());
            rspBO.setRespCode("18000");
            rspBO.setRespDesc(busiApplyInvoiceRspBO.getResultMessage());
        } else {
            this.returnSuccess(reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private void checkJDAddress(BusiApplyInvoiceReqBO applyInvoiceReqBo, BillNotificationInfoExt notifyInfo) {
        if (YesNo.YES.getCode().equals(this.VERIFY_JD_ADDRESS_SWITCH)) {
            if (applyInvoiceReqBo.getBillToProvince() == null || applyInvoiceReqBo.getBillToProvince() == 0 || applyInvoiceReqBo.getBillToCity() == null || applyInvoiceReqBo.getBillToCity() == 0) {
                throw new PfscExtBusinessException("18000", "\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u5f02\u5e38\uff0c\u4e00\u7ea7\u5730\u5740\u7f16\u7801\u548c\u4e8c\u7ea7\u5730\u5740\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            FscEsbJDAddressCheckAreaExternalReqBO checkAreaReqBo = new FscEsbJDAddressCheckAreaExternalReqBO();
            checkAreaReqBo.setProvinceId(applyInvoiceReqBo.getBillToProvince());
            checkAreaReqBo.setCityId(applyInvoiceReqBo.getBillToCity());
            checkAreaReqBo.setCountyId(applyInvoiceReqBo.getBillToCounty());
            checkAreaReqBo.setTownId(applyInvoiceReqBo.getBillToTown());
            checkAreaReqBo.setSupplierId(applyInvoiceReqBo.getSupplierId());
            checkAreaReqBo.setMarkId(applyInvoiceReqBo.getMarkId());
            FscEsbJDAddressCheckAreaExternalRspBO checkAreaRspBo = this.fscEsbJDAddressExternalService.dealCheckAreaJD(checkAreaReqBo);
            if (FscRu.isFailed(checkAreaRspBo.getRespCode()).booleanValue()) {
                StringJoiner addressJoiner = new StringJoiner("");
                addressJoiner.add(Optional.ofNullable(notifyInfo.getProvince()).map(String::trim).orElse(""));
                addressJoiner.add(Optional.ofNullable(notifyInfo.getCity()).map(String::trim).orElse(""));
                addressJoiner.add(Optional.ofNullable(notifyInfo.getCounty()).map(String::trim).orElse(""));
                addressJoiner.add(Optional.ofNullable(notifyInfo.getTown()).map(String::trim).orElse(""));
                addressJoiner.add(Optional.ofNullable(notifyInfo.getAddr()).map(String::trim).orElse(""));
                log.error("\u83b7\u53d6\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u5730\u5740\u8be6\u60c5\u8f6c\u6362\u4eac\u4e1c\u5730\u5740\u7f16\u7801:{}", (Object)addressJoiner.toString());
                if (addressJoiner.length() > 0) {
                    FscEsbGetJDAddressFromAddressExternalReqBO addressReqBo = new FscEsbGetJDAddressFromAddressExternalReqBO();
                    addressReqBo.setAddress(addressJoiner.toString());
                    addressReqBo.setSupplierId(applyInvoiceReqBo.getSupplierId());
                    addressReqBo.setMarkId(applyInvoiceReqBo.getMarkId());
                    FscEsbGetJDAddressFromAddressExternalRspBO addressRspBo = this.fscEsbJDAddressExternalService.gerJDAddressFromAddress(addressReqBo);
                    FscEsbGetJDAddressFromAddressInfoBO addressInfo = addressRspBo.getAddressInfo();
                    if (FscRu.isSuccess(addressRspBo.getRespCode()).booleanValue() && addressInfo != null) {
                        applyInvoiceReqBo.setBillToProvince(addressInfo.getProvinceId());
                        applyInvoiceReqBo.setBillToCity(addressInfo.getCityId());
                        applyInvoiceReqBo.setBillToCounty(Optional.ofNullable(addressInfo.getCountyId()).orElse(0));
                        applyInvoiceReqBo.setBillToTown(Optional.ofNullable(addressInfo.getTownId()).orElse(0));
                    } else {
                        log.error("\u83b7\u53d6\u4eac\u4e1c\u5730\u5740\u670d\u52a1-\u5730\u5740\u8be6\u60c5\u8f6c\u6362\u4eac\u4e1c\u5730\u5740\u7f16\u7801-\u67e5\u8be2\u5931\u8d25");
                        throw new PfscExtBusinessException("18000", "\u4eac\u4e1c\u5730\u5740\u8f6c\u6362\u5931\u8d25");
                    }
                }
            }
        }
    }

    private void returnSuccess(BusiNotifyEcommerceInvoiceServiceReqBo reqBO) {
        BillNotificationInfoExt notifyInfo = reqBO.getBillNotificationInfoExt();
        List<PayPurchaseOrderInfo> orderInfoList = reqBO.getPayPurchaseOrderInfoList();
        BillNotificationInfo updateBill = new BillNotificationInfo();
        updateBill.setNotificationNo(notifyInfo.getNotificationNo());
        updateBill.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        this.billNotificationInfoMapper.updateByPrimaryKeySelective(updateBill);
        PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
        vo.setNotificationNo(notifyInfo.getNotificationNo());
        vo.setOrderStatus(OrderStatus.APPLIED.getCode());
        int updateResult = this.payPurchaseOrderInfoMapper.updateStatusBatchByNoti(vo);
        if (updateResult < orderInfoList.size()) {
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
        }
        PayItemInfoVO item = new PayItemInfoVO();
        item.setNotificationNo(notifyInfo.getNotificationNo());
        item.setItemStatus(OrderStatus.APPLIED.getCode());
        int updCount = this.payItemInfoMapper.updateStatusByNotifyNoBatch(item);
        if (updCount == 0) {
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38");
        }
    }

    private void returnFail(BusiNotifyEcommerceInvoiceServiceReqBo reqBO, String resultMessage) {
        BillNotificationInfoExt notifyInfo = reqBO.getBillNotificationInfoExt();
        Integer failCount = Integer.valueOf(this.failCountStr);
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(notifyInfo.getNotificationNo());
        if (failCount > billNotificationInfo.getFailCount()) {
            BillNotificationInfo notificationInfo = new BillNotificationInfo();
            notificationInfo.setFailCount(1);
            notificationInfo.setNotificationNo(billNotificationInfo.getNotificationNo());
            notificationInfo.setInvoiceResult(resultMessage);
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(notificationInfo);
        } else {
            List<NotificationRejectOrderInfo> rejectOrderInfoList;
            List<PayPurchaseOrderInfo> payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.selectByNotifNo(notifyInfo.getNotificationNo());
            BillNotificationInfo notificationInfo = new BillNotificationInfo();
            notificationInfo.setNotificationNo(billNotificationInfo.getNotificationNo());
            notificationInfo.setInvoiceStatus(NotificationInvoiceStatus.REJECT.getCode());
            notificationInfo.setInvoiceResult(resultMessage);
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(notificationInfo);
            PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
            vo.setNotificationNo(billNotificationInfo.getNotificationNo());
            vo.setOrderStatus(OrderStatus.AUTO_HANG_UP.getCode());
            vo.setHangDate(new Date());
            vo.setReconciliationStatus(ReconciliationStatus.NOT_RECONCILED.getCode());
            this.payPurchaseOrderInfoMapper.updateFailResult(vo);
            if (!CollectionUtils.isEmpty(payPurchaseOrderInfoList) && !CollectionUtils.isEmpty(rejectOrderInfoList = payPurchaseOrderInfoList.stream().map(payPurchaseOrderInfo -> {
                NotificationRejectOrderInfo rejectOrderInfo = new NotificationRejectOrderInfo();
                rejectOrderInfo.setRejectReason(resultMessage);
                rejectOrderInfo.setCreateDate(new Date());
                rejectOrderInfo.setOrderId(payPurchaseOrderInfo.getOrderId());
                rejectOrderInfo.setInspectionId(payPurchaseOrderInfo.getInspectionId());
                rejectOrderInfo.setOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
                rejectOrderInfo.setNotificationNo(payPurchaseOrderInfo.getNotificationNo());
                return rejectOrderInfo;
            }).collect(Collectors.toList()))) {
                try {
                    this.notificationRejectOrderInfoMapper.insertBatch(rejectOrderInfoList);
                }
                catch (Exception e) {
                    log.error("\u65b0\u589e\u5f00\u7968\u901a\u77e5\u9a73\u56de\u5173\u7cfb\u8868\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.toString());
                }
            }
        }
    }
}

