/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.order.extend.bo.credit.ability.PebExtDealOrderPayConfirmFailAbilityReqBO;
import com.tydic.order.extend.bo.credit.ability.UocOrderPayConfirmFailInfo;
import com.tydic.order.extend.bo.order.PebExtPayResultReqBO;
import com.tydic.order.extend.bo.order.PebExtPayResultRspBO;
import com.tydic.order.pec.ability.pay.UocPebUpdatePayStatusAbilityService;
import com.tydic.pfscext.api.busi.BusiAddCreditLineService;
import com.tydic.pfscext.api.busi.BusiPayResultModifyService;
import com.tydic.pfscext.api.busi.FscOrderPayStatusUpdateService;
import com.tydic.pfscext.api.busi.bo.AddCreditLineFscReqBo;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyRspBO;
import com.tydic.pfscext.api.busi.bo.FscOrderPayStatusUpdateReqBO;
import com.tydic.pfscext.base.PfscExtReqBaseBO;
import com.tydic.pfscext.constants.FscConstants;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.FscCreditRecordMapper;
import com.tydic.pfscext.dao.FscEsSyncTodoTemporaryMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.FscCreditRecordPO;
import com.tydic.pfscext.dao.po.FscEsSyncTodoTemporaryPO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.FscCreditBusiCategory;
import com.tydic.pfscext.enums.FscCreditBusiType;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.enums.SaleOrderPayStatus;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiPayOfflineNotifyService;
import com.tydic.pfscext.external.uoc.api.FscPebExtDealOrderPayConfirmFailAbilityService;
import com.tydic.pfscext.external.uoc.api.FscPebExtFscPayResultExternalService;
import com.tydic.pfscext.service.atom.FscExtInterLogAtomService;
import com.tydic.pfscext.service.atom.bo.FscExtInterLogAtomReqBO;
import com.tydic.pfscext.service.busi.FscCreditRecordBusiService;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordPayBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordPayBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordPayInfoBO;
import com.tydic.pfscext.service.notify.SSLClient;
import com.tydic.pfscext.utils.DateUtil;
import com.tydic.pfscext.utils.FscRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiPayResultModifyService"})
public class BusiPayResultModifyServiceImpl
implements BusiPayResultModifyService {
    private static final Logger log = LoggerFactory.getLogger(BusiPayResultModifyServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(BusiPayResultModifyServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private UocPebUpdatePayStatusAbilityService uocPebUpdatePayStatusAbilityService;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private FscPebExtFscPayResultExternalService fscPebExtFscPayResultExternalService;
    @Autowired
    private FscOrderPayStatusUpdateService fscOrderPayStatusUpdateService;
    @Autowired
    private BusiPayOfflineNotifyService busiPayOfflineNotifyService;
    @Autowired
    private BusiAddCreditLineService busiAddCreditLineService;
    @Value(value="${WRITE_OFF_TIME_STR}")
    private String writeOffTimeStr;
    private static final String SUCCESS = "SUCCESS";
    @Value(value="${PAY_OFFLINE_NOTIFY_URL}")
    private String offlineNotifyUrl;
    @Autowired
    private FscCreditRecordMapper fscCreditRecordMapper;
    @Autowired
    private FscEsSyncTodoTemporaryMapper fscEsSyncTodoTemporaryMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private FscExtInterLogAtomService fscExtInterLogAtomService;
    @Autowired
    private FscCreditRecordBusiService fscCreditRecordBusiService;
    @Autowired
    private FscPebExtDealOrderPayConfirmFailAbilityService fscPebExtDealOrderPayConfirmFailAbilityService;

    @PostMapping(value={"modifyResult"})
    public BusiPayResultModifyRspBO modifyResult(@RequestBody BusiPayResultModifyReqBO busiPayResultModifyReqBO) {
        logger.info("\u4ed8\u6b3e\u67e5\u8be2-\u786e\u8ba4\u7f34\u8d39\u72b6\u6001BO=" + busiPayResultModifyReqBO);
        BusiPayResultModifyRspBO resp = new BusiPayResultModifyRspBO();
        List payNos = busiPayResultModifyReqBO.getPayNos();
        if (payNos == null || payNos.size() == 0) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355\u53f7(payNo)\u5fc5\u987b\u8f93\u5165");
        }
        List statuss = busiPayResultModifyReqBO.getStatuss();
        for (String status : statuss) {
            PayResultStatus newStatus = PayResultStatus.getInstance(status);
            if (newStatus == null) {
                throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u7ed3\u679c\u72b6\u6001\u4e0d\u5408\u6cd5");
            }
            if (newStatus == PayResultStatus.PAY_CONFIRMED) continue;
            throw new PfscExtBusinessException("0001", "\u53ea\u6709\uff1a" + PayResultStatus.PAY_CONFIRMED.getDescr() + "\u72b6\u6001\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u624d\u80fd\uff0c\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001\u4e3a\uff1a" + newStatus.getDescr());
        }
        Date writeOffDate = DateUtil.strToDate(this.writeOffTimeStr, "yyyy-MM-dd HH:mm:ss");
        for (String payNo : payNos) {
            ApplyPayInfoPO applyPay = this.applyPayInfoMapper.getModelById(payNo);
            if (applyPay == null) {
                throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355" + payNo + "\u4e0d\u5b58\u5728");
            }
            List<ApplyDetail> details = this.applyDetailMapper.selectPayableList(payNo);
            int size = details.size();
            if (size == 0) {
                throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u6b64\u4ed8\u6b3e\u5355\u4e0b\u7684\u5e94\u4ed8\u6b3e\u5355\u660e\u7ec6\u8bb0\u5f55");
            }
            logger.info("\u4ed8\u6b3e\u5355\u8bbe\u7f6e\u4ed8\u6b3e\u7ed3\u679c,\u6d89\u53ca\u5e94\u4ed8\u5355\u6570\u91cf=" + size + ",\u4ed8\u6b3e\u5355\u53f7=" + payNo);
            ArrayList<String> payableNos = new ArrayList<String>();
            for (ApplyDetail applyDetail : details) {
                payableNos.add(applyDetail.getPayableNo());
            }
            Map<String, BigDecimal> amtMap = details.stream().collect(Collectors.toMap(ApplyDetail::getPayableNo, ApplyDetail::getAmt, (key1, key2) -> key2));
            if (!"0".equals(busiPayResultModifyReqBO.getSuccessOrFail())) {
                StringBuffer payNotifyTransId = new StringBuffer();
                payNotifyTransId.append(DateUtil.dateToStr(new Date(), "yyyyMMddHHmmss")).append(System.currentTimeMillis()).append((int)((Math.random() * 9.0 + 1.0) * Math.pow(10.0, 7.0)));
                applyPay.setPayStatus(PayResultStatus.SUCCESS.getCode());
                applyPay.setRemark(busiPayResultModifyReqBO.getRemark());
                applyPay.setPayChannel("3");
                applyPay.setSsn(payNotifyTransId.toString());
                this.applyPayInfoMapper.updateStatus(applyPay);
                PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
                StringBuilder payOrderNo = new StringBuilder();
                payOrderNo.append("PAYMENT-").append(applyPay.getPayno());
                paymentFlowInfo.setOutOrderId(payOrderNo.toString());
                paymentFlowInfo.setPayTime(new Date());
                paymentFlowInfo.setPaymentStatus(SUCCESS);
                this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
                ApplyDetail applyDetail = new ApplyDetail();
                applyDetail.setApplyNo(payNo);
                applyDetail.setStatus(PayResultStatus.SUCCESS.getCode());
                this.applyDetailMapper.updateByApplyNo(applyDetail);
                PayableDetailVO payableDetailVO = new PayableDetailVO();
                payableDetailVO.setPayableNos(payableNos);
                List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.selectList(payableDetailVO);
                for (PayableDetailPO payableDetailPO : payableDetailPOS) {
                    PebExtPayResultRspBO pebExtPayResultRspBO;
                    PebExtPayResultReqBO pebExtPayResultReqBO;
                    ArrayList<String> payAbleNos = new ArrayList<String>();
                    for (ApplyDetail apply : details) {
                        payAbleNos.add(apply.getPayableNo());
                    }
                    if (!payAbleNos.isEmpty()) {
                        String status = PayableStatus.PAYING.getCode();
                        BigDecimal ingAmt = payableDetailPO.getPendingAmt();
                        if (payableDetailPO.getPaidAmt() != null) {
                            ingAmt = payableDetailPO.getPaidAmt().add(payableDetailPO.getPendingAmt());
                        }
                        if (ingAmt.compareTo(payableDetailPO.getPayableAmt()) >= 0) {
                            status = PayableStatus.SUCCESS.getCode();
                        }
                        this.payableDetailMapper.updateAmtByNOs(payAbleNos, status);
                    }
                    if (null != payableDetailPO.getOrderId()) {
                        FscOrderPayStatusUpdateReqBO reqBO = new FscOrderPayStatusUpdateReqBO();
                        reqBO.setOrderId(payableDetailPO.getOrderId());
                        this.fscOrderPayStatusUpdateService.updateOrderPayStatus(reqBO);
                    }
                    ArrayList<String> nopId = new ArrayList<String>();
                    ArrayList orderIds = new ArrayList();
                    if (null != payableDetailPO) {
                        List<PayPurchaseOrderInfo> payPurchaseOrderInfoList;
                        if (applyPay.getApplyDate().compareTo(writeOffDate) > 0) {
                            this.dealConfirmPaySuccessCreditNew(busiPayResultModifyReqBO, applyPay, amtMap, payableDetailPO);
                        }
                        if (null != (payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.selectByNotifNo(payableDetailPO.getNotificationNo())) && payPurchaseOrderInfoList.size() > 0) {
                            for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoList) {
                                payPurchaseOrderInfo.setPayType("01");
                                this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(payPurchaseOrderInfo);
                                if (!nopId.contains(payPurchaseOrderInfo.getNotificationNo())) {
                                    nopId.add(payPurchaseOrderInfo.getNotificationNo());
                                }
                                if (!nopId.isEmpty()) {
                                    this.billNotificationInfoMapper.updatePayStatus(nopId, 2);
                                }
                                if (!"1".equals(payPurchaseOrderInfo.getBusiModel())) continue;
                                pebExtPayResultReqBO = new PebExtPayResultReqBO();
                                pebExtPayResultReqBO.setOrderId(payPurchaseOrderInfo.getOrderId().toString());
                                pebExtPayResultReqBO.setInspectionVoucherId(payPurchaseOrderInfo.getInspectionId());
                                if (PayChannel.PAY_OFFLINE.getCode().equals(applyPay.getPayChannel())) {
                                    pebExtPayResultReqBO.setPayMethod(PayMethod.OFFLINE_PAY.getCode());
                                } else {
                                    pebExtPayResultReqBO.setPayMethod(applyPay.getPayMathod());
                                }
                                pebExtPayResultReqBO.setPaymentFinishTime(paymentFlowInfo.getPayTime());
                                logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)pebExtPayResultReqBO));
                                pebExtPayResultRspBO = this.fscPebExtFscPayResultExternalService.dealPayResult(pebExtPayResultReqBO);
                                if (pebExtPayResultRspBO != null && SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) continue;
                                logger.error("\u5e94\u4ed8\u5355\u56de\u8c03\u8ba2\u5355\u9519\u8bef,\u8ba2\u5355id:" + payPurchaseOrderInfo.getOrderId() + ",\u9519\u8bef\u4fe1\u606f" + pebExtPayResultRspBO.getResultMsg());
                            }
                        }
                    }
                    if (null != payableDetailPO.getApplyNo() && !"".equals(payableDetailPO.getApplyNo())) {
                        List<SaleOrderInfo> list = this.saleOrderInfoMapper.getSaleOrderListByApplyNo(payableDetailPO.getApplyNo());
                        if (null != list && !list.isEmpty()) {
                            for (SaleOrderInfo saleOrderInfo : list) {
                                pebExtPayResultReqBO = new PebExtPayResultReqBO();
                                pebExtPayResultReqBO.setInspectionVoucherId(saleOrderInfo.getInspectionId());
                                pebExtPayResultReqBO.setOrderId(saleOrderInfo.getOrderId().toString());
                                if (PayChannel.PAY_OFFLINE.getCode().equals(applyPay.getPayChannel())) {
                                    pebExtPayResultReqBO.setPayMethod(PayMethod.OFFLINE_PAY.getCode());
                                } else {
                                    pebExtPayResultReqBO.setPayMethod(applyPay.getPayMathod());
                                }
                                pebExtPayResultReqBO.setPaymentFinishTime(paymentFlowInfo.getPayTime());
                                logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)pebExtPayResultReqBO));
                                pebExtPayResultRspBO = this.fscPebExtFscPayResultExternalService.dealPayResult(pebExtPayResultReqBO);
                                if (pebExtPayResultRspBO != null && SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) continue;
                                logger.error("\u5e94\u4ed8\u5355\u56de\u8c03\u8ba2\u5355\u9519\u8bef,\u8ba2\u5355id\uff1a" + saleOrderInfo.getOrderId() + ",\u9519\u8bef\u4fe1\u606f" + pebExtPayResultRspBO.getResultMsg());
                            }
                            SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                            saleOrderInfo.setApplyNo(payableDetailPO.getApplyNo());
                            saleOrderInfo.setPayStatus(SaleOrderPayStatus.SUCCESS.getCode());
                            this.saleOrderInfoMapper.updateByApplyNo(saleOrderInfo);
                        }
                        BillApplyInfo billApplyInfo = new BillApplyInfo();
                        billApplyInfo.setApplyNo(payableDetailPO.getApplyNo());
                        billApplyInfo.setIsPay(2);
                        this.billApplyInfoMapper.updateByPrimaryKeySelective(billApplyInfo);
                    }
                    if (null == payableDetailPO || !StringUtils.isBlank((CharSequence)payableDetailPO.getApplyNo()) || !StringUtils.isBlank((CharSequence)payableDetailPO.getNotificationNo())) continue;
                    PebExtPayResultReqBO extPayResultReqBO = new PebExtPayResultReqBO();
                    extPayResultReqBO.setPayableNos(payableNos);
                    ArrayList<Long> orders = new ArrayList<Long>();
                    orders.add(payableDetailPO.getOrderId());
                    payableDetailPO.setOrderIdList(orders);
                    List<PayableDetailPO> payableDetailPOS1 = this.payableDetailMapper.querysumAmtByOrderId(payableDetailPO);
                    PaymentFlowInfo paymentFlowInfo1 = this.paymentFlowInfoMapper.selectByOrderCodeRefund(payableDetailPO.getPurchaseOrderCode());
                    logger.info("\u8ba1\u7b97\u9000\u6b3e" + paymentFlowInfo1);
                    logger.info("\u6253\u5370payableAmt=" + payableDetailPOS1.get(0).getPayableAmt());
                    logger.info("totalFee" + extPayResultReqBO.getTotalFee());
                    extPayResultReqBO.setTotalFee(payableDetailPOS1.get(0).getPayableAmt().subtract(paymentFlowInfo1 == null ? BigDecimal.ZERO : paymentFlowInfo1.getOrderAmt()).toString());
                    logger.info("totalFee\u8bbe\u7f6e\u4ee5\u540e" + extPayResultReqBO.getTotalFee());
                    extPayResultReqBO.setOrderId(null != payableDetailPO.getOrderId() ? payableDetailPO.getOrderId().toString() : null);
                    extPayResultReqBO.setInspectionVoucherId(payableDetailPO.getInspectionId());
                    if (PayChannel.PAY_OFFLINE.getCode().equals(applyPay.getPayChannel())) {
                        extPayResultReqBO.setPayMethod(PayMethod.OFFLINE_PAY.getCode());
                    } else {
                        extPayResultReqBO.setPayMethod(applyPay.getPayMathod());
                    }
                    extPayResultReqBO.setPaymentFinishTime(paymentFlowInfo.getPayTime());
                    extPayResultReqBO.setPayableNos(Collections.singletonList(payableDetailPO.getPayableNo()));
                    logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + extPayResultReqBO);
                    pebExtPayResultRspBO = this.fscPebExtFscPayResultExternalService.dealPayResult(extPayResultReqBO);
                    logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + pebExtPayResultRspBO);
                    if (pebExtPayResultRspBO != null && SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) continue;
                    logger.error("\u5e94\u4ed8\u5355\u56de\u8c03\u8ba2\u5355\u9519\u8bef,\u8ba2\u5355id:" + payableDetailPO.getOrderId() + ",\u9519\u8bef\u4fe1\u606f" + pebExtPayResultRspBO.getResultMsg());
                }
                PaymentFlowInfo paymentFlowInfoQry = this.paymentFlowInfoMapper.selectByOutOrderId("PAYMENT-" + payNo);
                if (paymentFlowInfoQry != null && !StringUtils.isEmpty((CharSequence)paymentFlowInfoQry.getPayOrderId())) {
                    String transDate = DateUtil.dateToStr(new Date(), "yyyyMMddHHmmss");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("tradeTime", transDate);
                    map.put("payNotifyTransId", payNotifyTransId.toString());
                    map.put("payOrderId", paymentFlowInfoQry.getPayOrderId());
                    try {
                        logger.info("\u7ebf\u4e0b\u652f\u4ed8\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5165\u53c2\uff1a" + JSON.toJSONString(map) + ",\u8c03\u7528\u5730\u5740\uff1a" + this.offlineNotifyUrl);
                        String returnStr = SSLClient.doPost(this.offlineNotifyUrl, map, null);
                        logger.info("\u7ebf\u4e0b\u652f\u4ed8\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u51fa\u53c2\uff1a" + returnStr);
                    }
                    catch (Exception e) {
                        logger.error("\u7ebf\u4e0b\u652f\u4ed8\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
            if (!"0".equals(busiPayResultModifyReqBO.getSuccessOrFail())) continue;
            applyPay.setPayStatus(PayResultStatus.PAY_FAILED.getCode());
            if (StringUtils.isEmpty((CharSequence)busiPayResultModifyReqBO.getRejectReason().trim())) {
                throw new PfscExtBusinessException("0001", "\u4f9b\u5e94\u5546\u6838\u9500\u5931\u8d25\uff0c\u9000\u56de\u539f\u56e0\u5fc5\u586b");
            }
            applyPay.setRejectReason(busiPayResultModifyReqBO.getRejectReason());
            this.applyPayInfoMapper.updateStatus(applyPay);
            PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
            StringBuilder payOrderNo = new StringBuilder();
            payOrderNo.append("PAYMENT-").append(applyPay.getPayno());
            paymentFlowInfo.setOutOrderId(payOrderNo.toString());
            paymentFlowInfo.setPayTime(new Date());
            paymentFlowInfo.setPaymentStatus("PAY_FAILED");
            this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
            ApplyDetail applyDetail = new ApplyDetail();
            applyDetail.setApplyNo(payNo);
            applyDetail.setStatus(PayResultStatus.PAY_FAILED.getCode());
            this.applyDetailMapper.updateByApplyNo(applyDetail);
            for (ApplyDetail detail : details) {
                PayableDetailPO payableDetailPO = new PayableDetailPO();
                payableDetailPO.setPayableNo(detail.getPayableNo());
                payableDetailPO.setPayableStatus(PayableStatus.PENDING.getCode());
                payableDetailPO.setPendingAmt(detail.getAmt());
                this.payableDetailMapper.updatePayModifyFailed(payableDetailPO);
            }
            PayableDetailVO payableDetailVO = new PayableDetailVO();
            payableDetailVO.setPayableNos(payableNos);
            List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.selectList(payableDetailVO);
            this.dealOrderPayConfirmFail(payableDetailPOS);
            if (applyPay.getApplyDate().compareTo(writeOffDate) >= 0) continue;
            for (PayableDetailPO payableDetailPO : payableDetailPOS) {
                this.dealConfirmPayFailCreditNew(busiPayResultModifyReqBO, applyPay, amtMap, payableDetailPO);
            }
        }
        resp.setRespCode("0000");
        return resp;
    }

    private void dealOrderPayConfirmFail(List<PayableDetailPO> payableDetailPOS) {
        if (CollectionUtils.isEmpty(payableDetailPOS)) {
            return;
        }
        ArrayList<UocOrderPayConfirmFailInfo> infosList = new ArrayList<UocOrderPayConfirmFailInfo>();
        for (PayableDetailPO payableDetailPo : payableDetailPOS) {
            UocOrderPayConfirmFailInfo info;
            if (PayableType.APPLY.getCode().equals(payableDetailPo.getPayableType().toString())) {
                List<SaleOrderInfo> saleOrderInfos;
                if (!org.springframework.util.StringUtils.hasText((String)payableDetailPo.getApplyNo()) || CollectionUtils.isEmpty(saleOrderInfos = this.saleOrderInfoMapper.getModelByApplyNo(payableDetailPo.getApplyNo()))) continue;
                for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                    info = new UocOrderPayConfirmFailInfo();
                    info.setInspectionId(saleOrderInfo.getInspectionId());
                    info.setOrderId(saleOrderInfo.getOrderId());
                    info.setPayableType(payableDetailPo.getPayableType().toString());
                    infosList.add(info);
                }
                continue;
            }
            if (PayableType.NOTIFICATION.getCode().equals(payableDetailPo.getPayableType().toString())) {
                List<PayPurchaseOrderInfo> payPurchaseOrderInfos;
                if (!org.springframework.util.StringUtils.hasText((String)payableDetailPo.getNotificationNo()) || CollectionUtils.isEmpty(payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(payableDetailPo.getNotificationNo()))) continue;
                for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
                    info = new UocOrderPayConfirmFailInfo();
                    info.setInspectionId(payPurchaseOrderInfo.getInspectionId());
                    info.setOrderId(payPurchaseOrderInfo.getOrderId());
                    info.setPayableType(payableDetailPo.getPayableType().toString());
                    infosList.add(info);
                }
                continue;
            }
            UocOrderPayConfirmFailInfo info2 = new UocOrderPayConfirmFailInfo();
            info2.setInspectionId(payableDetailPo.getInspectionId());
            info2.setOrderId(payableDetailPo.getOrderId());
            info2.setPayableType(payableDetailPo.getPayableType().toString());
            infosList.add(info2);
        }
        if (!CollectionUtils.isEmpty(infosList)) {
            PebExtDealOrderPayConfirmFailAbilityReqBO pebExtDealOrderPayConfirmFailAbilityReqBo = new PebExtDealOrderPayConfirmFailAbilityReqBO();
            pebExtDealOrderPayConfirmFailAbilityReqBo.setOrderPayConfirmFailInfoList(infosList);
            this.fscPebExtDealOrderPayConfirmFailAbilityService.dealOrderPayConfirmFail(pebExtDealOrderPayConfirmFailAbilityReqBo);
        }
    }

    private void dealConfirmPaySuccessCreditNew(BusiPayResultModifyReqBO reqBO, ApplyPayInfoPO applyPay, Map<String, BigDecimal> amtMap, PayableDetailPO payableDetailPo) {
        if (log.isDebugEnabled()) {
            log.debug("\u4ed8\u6b3e\u9000\u6388\u4fe1\u989d\u5ea6\u5165\u53c2\uff1a{}.\u4ed8\u6b3e\u7533\u8bf7\uff1a{}.\u91d1\u989d\uff1a{}.\u5e94\u4ed8\u4fe1\u606f\uff1a{}", new Object[]{JSON.toJSONString((Object)reqBO), JSON.toJSONString((Object)applyPay), JSON.toJSONString(amtMap), JSON.toJSONString((Object)payableDetailPo)});
        }
        PfscExtReqBaseBO reqBaseBo = FscRu.js(reqBO, PfscExtReqBaseBO.class);
        if (payableDetailPo.getPayableType() != null) {
            if (PayableType.NOTIFICATION.getCode().equals(payableDetailPo.getPayableType().toString())) {
                String notificationNo;
                List<PayPurchaseOrderInfo> payPurchaseOrderInfos;
                if (payableDetailPo.getBusiModel() != null && BusiModel.MATCH_UP_MODEL.getCode().equals(payableDetailPo.getBusiModel().toString()) && !CollectionUtils.isEmpty(payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo = payableDetailPo.getNotificationNo()))) {
                    FscOrderCreditRecordPayBusiRspBO orderCreditRecordPayBusiRspBo;
                    FscOrderCreditRecordPayBusiReqBO orderCreditRecordPayBusiReqBo = new FscOrderCreditRecordPayBusiReqBO();
                    BeanUtils.copyProperties((Object)reqBaseBo, (Object)((Object)orderCreditRecordPayBusiReqBo));
                    ArrayList<FscOrderCreditRecordPayInfoBO> creditRecordList = new ArrayList<FscOrderCreditRecordPayInfoBO>();
                    orderCreditRecordPayBusiReqBo.setCreditRecordList(creditRecordList);
                    for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
                        FscOrderCreditRecordPayInfoBO itemPayInfoBo = new FscOrderCreditRecordPayInfoBO();
                        itemPayInfoBo.setBusiCategory(FscCreditBusiCategory.ORD_PAY.getCode());
                        itemPayInfoBo.setPayApplyCode(String.valueOf(applyPay.getPayno()));
                        itemPayInfoBo.setOrderId(payPurchaseOrderInfo.getOrderId());
                        itemPayInfoBo.setOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
                        if (org.springframework.util.StringUtils.hasText((String)payPurchaseOrderInfo.getBusiModel())) {
                            itemPayInfoBo.setBusiModel(Integer.valueOf(payPurchaseOrderInfo.getBusiModel()));
                        }
                        itemPayInfoBo.setRemark("\u5e94\u4ed8\u7c7b\u578b\uff1a" + payableDetailPo.getPayableType() + "-" + PayableType.desc(payableDetailPo.getPayableType().toString()));
                        itemPayInfoBo.setInspectionId(payPurchaseOrderInfo.getInspectionId());
                        itemPayInfoBo.setBusiAmount(payPurchaseOrderInfo.getOrderAmt());
                        itemPayInfoBo.setSupplierNo(payPurchaseOrderInfo.getSupplierNo());
                        itemPayInfoBo.setSupplierName(payPurchaseOrderInfo.getSupplierName());
                        this.saveUocEsSync(reqBO.getUocEsSyncVersionId(), itemPayInfoBo.getOrderId());
                        creditRecordList.add(itemPayInfoBo);
                    }
                    if (!CollectionUtils.isEmpty(creditRecordList) && FscRu.isFailed((orderCreditRecordPayBusiRspBo = this.fscCreditRecordBusiService.dealOrderCreditRecordPay(orderCreditRecordPayBusiReqBo)).getRespCode()).booleanValue()) {
                        log.error("\u56de\u6b3e\u6838\u9500\u5931\u8d25\uff0c\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u91c7\u8d2d\u5f00\u7968\u901a\u77e5\u5e94\u4ed8,\u5165\u53c2\uff1a{}.\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)orderCreditRecordPayBusiReqBo)), (Object)JSON.toJSONString((Object)((Object)orderCreditRecordPayBusiRspBo)));
                        this.saveLog(((FscOrderCreditRecordPayInfoBO)creditRecordList.get(0)).getOrderId(), ((FscOrderCreditRecordPayInfoBO)creditRecordList.get(0)).getOrderId(), payableDetailPo.getPayableNo(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)orderCreditRecordPayBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), JSON.toJSONString((Object)((Object)orderCreditRecordPayBusiRspBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "\u56de\u6b3e\u6838\u9500\u5931\u8d25\uff0c\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u91c7\u8d2d\u5f00\u7968\u901a\u77e5\u5e94\u4ed8" + payableDetailPo.getPayableNo());
                        throw new PfscExtBusinessException(orderCreditRecordPayBusiRspBo.getRespCode(), orderCreditRecordPayBusiRspBo.getRespDesc());
                    }
                }
            } else if (PayableType.APPLY.getCode().equals(payableDetailPo.getPayableType().toString())) {
                String applyNo = payableDetailPo.getApplyNo();
                List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getSaleOrderListByApplyNo(applyNo);
                if (!CollectionUtils.isEmpty(saleOrderInfos)) {
                    FscOrderCreditRecordPayBusiReqBO orderCreditRecordPayBusiReqBo = new FscOrderCreditRecordPayBusiReqBO();
                    BeanUtils.copyProperties((Object)reqBaseBo, (Object)((Object)orderCreditRecordPayBusiReqBo));
                    ArrayList<FscOrderCreditRecordPayInfoBO> creditRecordList = new ArrayList<FscOrderCreditRecordPayInfoBO>();
                    orderCreditRecordPayBusiReqBo.setCreditRecordList(creditRecordList);
                    Object orderCreditRecordPayBusiRspBo = saleOrderInfos.iterator();
                    while (orderCreditRecordPayBusiRspBo.hasNext()) {
                        SaleOrderInfo saleOrderInfo = orderCreditRecordPayBusiRspBo.next();
                        FscOrderCreditRecordPayInfoBO itemPayInfoBo = new FscOrderCreditRecordPayInfoBO();
                        itemPayInfoBo.setBusiCategory(FscCreditBusiCategory.ORD_PAY.getCode());
                        itemPayInfoBo.setPayApplyCode(String.valueOf(applyPay.getPayno()));
                        itemPayInfoBo.setOrderId(saleOrderInfo.getOrderId());
                        itemPayInfoBo.setOrderCode(saleOrderInfo.getSaleOrderCode());
                        if (org.springframework.util.StringUtils.hasText((String)saleOrderInfo.getBusiModel())) {
                            itemPayInfoBo.setBusiModel(Integer.valueOf(saleOrderInfo.getBusiModel()));
                        }
                        itemPayInfoBo.setRemark("\u5e94\u4ed8\u7c7b\u578b\uff1a" + payableDetailPo.getPayableType() + "-" + PayableType.desc(payableDetailPo.getPayableType().toString()));
                        itemPayInfoBo.setInspectionId(saleOrderInfo.getInspectionId());
                        itemPayInfoBo.setBusiAmount(saleOrderInfo.getOrderAmt());
                        itemPayInfoBo.setSupplierNo(saleOrderInfo.getSupplierNo());
                        itemPayInfoBo.setSupplierName(saleOrderInfo.getSupplierName());
                        this.saveUocEsSync(reqBO.getUocEsSyncVersionId(), itemPayInfoBo.getOrderId());
                        creditRecordList.add(itemPayInfoBo);
                    }
                    if (!CollectionUtils.isEmpty(creditRecordList) && FscRu.isFailed((orderCreditRecordPayBusiRspBo = this.fscCreditRecordBusiService.dealOrderCreditRecordPay(orderCreditRecordPayBusiReqBo)).getRespCode()).booleanValue()) {
                        log.error("\u56de\u6b3e\u6838\u9500\u5931\u8d25\uff0c\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u91c7\u8d2d\u5f00\u7968\u7533\u8bf7\u5e94\u4ed8,\u5165\u53c2\uff1a{}.\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)orderCreditRecordPayBusiReqBo)), (Object)JSON.toJSONString(orderCreditRecordPayBusiRspBo));
                        this.saveLog(((FscOrderCreditRecordPayInfoBO)creditRecordList.get(0)).getOrderId(), ((FscOrderCreditRecordPayInfoBO)creditRecordList.get(0)).getOrderId(), payableDetailPo.getPayableNo(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)orderCreditRecordPayBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), JSON.toJSONString(orderCreditRecordPayBusiRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "\u56de\u6b3e\u6838\u9500\u5931\u8d25\uff0c\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u91c7\u8d2d\u5f00\u7968\u7533\u8bf7\u5e94\u4ed8" + payableDetailPo.getPayableNo());
                        throw new PfscExtBusinessException(orderCreditRecordPayBusiRspBo.getRespCode(), orderCreditRecordPayBusiRspBo.getRespDesc());
                    }
                }
            } else if (Arrays.asList(PayableType.AOG.getCode(), PayableType.INSPECTION.getCode(), PayableType.EXPIRE.getCode(), PayableType.YFYF.getCode(), PayableType.QUALITY_GUARANTEE_DEPOSIT.getCode()).contains(payableDetailPo.getPayableType().toString())) {
                List<SaleOrderInfo> saleOrders;
                BigDecimal changeInfo = amtMap.get(payableDetailPo.getPayableNo()) == null ? BigDecimal.ZERO : amtMap.get(payableDetailPo.getPayableNo());
                log.debug("\u5e94\u4ed8\u7f16\u53f7\uff1a{}.\u8fdd\u7ea6\u91d1\uff1a{}", (Object)payableDetailPo.getPayableNo(), (Object)payableDetailPo.getOverduePenalty());
                if (!(payableDetailPo.getOverduePenalty() == null || payableDetailPo.getApproveResult() != null && YesOrNo.YES.getCode().equals(payableDetailPo.getApproveResult()))) {
                    changeInfo = changeInfo.subtract(Optional.ofNullable(payableDetailPo.getOverduePenalty()).orElse(BigDecimal.ZERO));
                }
                FscOrderCreditRecordBusiReqBO creditRecordBusiReqBo = new FscOrderCreditRecordBusiReqBO();
                BeanUtils.copyProperties((Object)reqBaseBo, (Object)((Object)creditRecordBusiReqBo));
                creditRecordBusiReqBo.setBusiCategory(FscCreditBusiCategory.ORD_PAY.getCode());
                creditRecordBusiReqBo.setBusiAmount(changeInfo);
                creditRecordBusiReqBo.setPayApplyCode(String.valueOf(applyPay.getPayno()));
                creditRecordBusiReqBo.setSupplierNo(payableDetailPo.getSupplierId());
                creditRecordBusiReqBo.setSupplierName(payableDetailPo.getSupplierName());
                creditRecordBusiReqBo.setBusiModel(payableDetailPo.getBusiModel());
                creditRecordBusiReqBo.setOrderId(payableDetailPo.getOrderId());
                creditRecordBusiReqBo.setOrderCode(payableDetailPo.getPurchaseOrderCode());
                if (payableDetailPo.getOrderId() != null && !CollectionUtils.isEmpty(saleOrders = this.saleOrderInfoMapper.getListSaleOrderInfoByOrderIds(Collections.singletonList(payableDetailPo.getOrderId())))) {
                    if (saleOrders.get(0).getActivityId() != null) {
                        creditRecordBusiReqBo.setBusiType(FscCreditBusiType.ORD_FL.getCode());
                    } else {
                        creditRecordBusiReqBo.setBusiType(FscCreditBusiType.ORD.getCode());
                    }
                }
                creditRecordBusiReqBo.setRemark("\u5e94\u4ed8\u7c7b\u578b\uff1a" + payableDetailPo.getPayableType() + "-" + PayableType.desc(payableDetailPo.getPayableType().toString()));
                creditRecordBusiReqBo.setInspectionId(payableDetailPo.getInspectionId());
                this.saveUocEsSync(reqBO.getUocEsSyncVersionId(), creditRecordBusiReqBo.getOrderId());
                FscCreditRecordPO fscCreditRecordOld = new FscCreditRecordPO();
                fscCreditRecordOld.setObjId(creditRecordBusiReqBo.getOrderId());
                fscCreditRecordOld.setObjCode(creditRecordBusiReqBo.getOrderCode());
                fscCreditRecordOld.setBusiCategory(FscCreditBusiCategory.ORD_ADD.getCode());
                int checkBy = this.fscCreditRecordMapper.getCheckBy(fscCreditRecordOld);
                if (checkBy < 1) {
                    this.saveLog(creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderCode(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)creditRecordBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "", "\u5e94\u4ed8\u5bf9\u5e94\u4e0b\u5355\u6263\u51cf\u6388\u4fe1\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u4e0d\u9000\u6388\u4fe1" + payableDetailPo.getPayableNo());
                } else {
                    FscOrderCreditRecordBusiRspBO creditRecordBusiRspBo = this.fscCreditRecordBusiService.dealOrderCreditRecord(creditRecordBusiReqBo);
                    if (FscRu.isFailed(creditRecordBusiRspBo.getRespCode()).booleanValue()) {
                        log.error("\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u5230\u8d27\u5e94\u4ed8-\u9a8c\u6536\u5e94\u4ed8-\u8d26\u671f\u5e94\u4ed8-,\u5165\u53c2\uff1a{}.\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)creditRecordBusiReqBo)), (Object)JSON.toJSONString((Object)((Object)creditRecordBusiRspBo)));
                        this.saveLog(creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderCode(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)creditRecordBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), JSON.toJSONString((Object)((Object)creditRecordBusiRspBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u5230\u8d27\u5e94\u4ed8-\u9a8c\u6536\u5e94\u4ed8-\u8d26\u671f\u5e94\u4ed8" + payableDetailPo.getPayableNo());
                        throw new PfscExtBusinessException(creditRecordBusiRspBo.getRespCode(), creditRecordBusiRspBo.getRespDesc());
                    }
                }
            }
        }
    }

    private void saveLog(Long orderId, Long objId, String objCode, String createLoginId, String reqJson, String rspJson, String errDetail) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            FscExtInterLogAtomReqBO logAtomReqBo = new FscExtInterLogAtomReqBO();
            logAtomReqBo.setObjId(objId);
            logAtomReqBo.setObjCode(objCode);
            logAtomReqBo.setObjType(FscConstants.FscExtInterLogObjType.PAY_CREDIT);
            logAtomReqBo.setOrderId(orderId);
            logAtomReqBo.setInterSn("1");
            logAtomReqBo.setInterCode("dealOrderCreditRecord");
            logAtomReqBo.setFlowFlag(1);
            logAtomReqBo.setInContent(reqJson);
            logAtomReqBo.setOutContent(rspJson);
            logAtomReqBo.setCallCount(0);
            logAtomReqBo.setCallTime(new Date());
            logAtomReqBo.setRetTime(new Date());
            logAtomReqBo.setCallState("18000");
            logAtomReqBo.setErrCode("18000");
            logAtomReqBo.setErrDetail(errDetail);
            logAtomReqBo.setCreateTime(new Date());
            logAtomReqBo.setCreateLoginId(createLoginId);
            this.fscExtInterLogAtomService.dealFscExtInterLogAdd(logAtomReqBo);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u65e5\u5fd7\u5f02\u5e38\uff1a{}", (Object)e.toString());
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    @Deprecated
    private void dealConfirmPaySuccessCredit(ApplyPayInfoPO applyPay, Map<String, BigDecimal> amtMap, PayableDetailPO payableDetailPO) {
        BigDecimal changeInfo;
        AddCreditLineFscReqBo creditLineFscReqBo = new AddCreditLineFscReqBo();
        creditLineFscReqBo.setChangeType("3");
        BigDecimal bigDecimal = changeInfo = amtMap.get(payableDetailPO.getPayableNo()) == null ? BigDecimal.ZERO : amtMap.get(payableDetailPO.getPayableNo());
        if (payableDetailPO.getOverduePenalty() != null && payableDetailPO.getApproveResult() != null && 1 != payableDetailPO.getApproveResult()) {
            changeInfo = changeInfo.subtract(payableDetailPO.getOverduePenalty());
        }
        creditLineFscReqBo.setChangeInfo(changeInfo);
        creditLineFscReqBo.setPayApplyCode(String.valueOf(applyPay.getPayno()));
        if (payableDetailPO.getPayableType() == 1 && 1 == payableDetailPO.getBusiModel()) {
            String notificationNo = payableDetailPO.getNotificationNo();
            List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
            for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
                creditLineFscReqBo.setOrderCode(String.valueOf(payPurchaseOrderInfo.getPurchaseOrderCode()));
                creditLineFscReqBo.setChangeInfo(payPurchaseOrderInfo.getOrderAmt());
                creditLineFscReqBo.setSupplierNo(payPurchaseOrderInfo.getSupplierNo());
                if (!org.springframework.util.StringUtils.isEmpty((Object)payPurchaseOrderInfo.getBusiModel())) {
                    creditLineFscReqBo.setBusiModel(Integer.valueOf(payPurchaseOrderInfo.getBusiModel()));
                }
                this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
            }
        } else if (payableDetailPO.getPayableType() == 6) {
            String applyNo = payableDetailPO.getApplyNo();
            List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getMarketSaleOrderListByApplyNo(applyNo);
            for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                creditLineFscReqBo.setOrderCode(String.valueOf(saleOrderInfo.getSaleOrderCode()));
                creditLineFscReqBo.setChangeInfo(saleOrderInfo.getOrderAmt());
                creditLineFscReqBo.setSupplierNo(saleOrderInfo.getSupplierNo());
                if (!org.springframework.util.StringUtils.isEmpty((Object)saleOrderInfo.getBusiModel())) {
                    creditLineFscReqBo.setBusiModel(Integer.valueOf(saleOrderInfo.getBusiModel()));
                }
                this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
            }
        } else if (payableDetailPO.getPayableType() == 2 || payableDetailPO.getPayableType() == 3 || payableDetailPO.getPayableType() == 5) {
            creditLineFscReqBo.setOrderCode(payableDetailPO.getPurchaseOrderCode());
            creditLineFscReqBo.setSupplierNo(payableDetailPO.getSupplierId());
            if (!org.springframework.util.StringUtils.isEmpty((Object)payableDetailPO.getBusiModel())) {
                creditLineFscReqBo.setBusiModel(Integer.valueOf(payableDetailPO.getBusiModel()));
            }
            this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
        }
    }

    private void dealConfirmPayFailCreditNew(BusiPayResultModifyReqBO reqBO, ApplyPayInfoPO applyPay, Map<String, BigDecimal> amtMap, PayableDetailPO payableDetailPo) {
        PfscExtReqBaseBO reqBaseBo = FscRu.js(reqBO, PfscExtReqBaseBO.class);
        if (payableDetailPo.getPayableType() != null) {
            if (PayableType.NOTIFICATION.getCode().equals(payableDetailPo.getPayableType().toString())) {
                if (payableDetailPo.getBusiModel() != null && BusiModel.MATCH_UP_MODEL.getCode().equals(payableDetailPo.getBusiModel().toString())) {
                    String notificationNo = payableDetailPo.getNotificationNo();
                    List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
                    for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
                        FscOrderCreditRecordBusiReqBO creditRecordBusiReqBo = new FscOrderCreditRecordBusiReqBO();
                        BeanUtils.copyProperties((Object)reqBaseBo, (Object)((Object)creditRecordBusiReqBo));
                        creditRecordBusiReqBo.setBusiCategory(FscCreditBusiCategory.WRITE_OFF_FAIL.getCode());
                        creditRecordBusiReqBo.setPayApplyCode(String.valueOf(applyPay.getPayno()));
                        creditRecordBusiReqBo.setOrderId(payPurchaseOrderInfo.getOrderId());
                        creditRecordBusiReqBo.setOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
                        if (StringUtils.isNotBlank((CharSequence)payPurchaseOrderInfo.getBusiModel())) {
                            creditRecordBusiReqBo.setBusiModel(Integer.valueOf(payPurchaseOrderInfo.getBusiModel()));
                        }
                        creditRecordBusiReqBo.setBusiAmount(payPurchaseOrderInfo.getOrderAmt().negate());
                        creditRecordBusiReqBo.setSupplierNo(payPurchaseOrderInfo.getSupplierNo());
                        creditRecordBusiReqBo.setSupplierName(payPurchaseOrderInfo.getSupplierName());
                        if (payPurchaseOrderInfo.getActivityId() != null) {
                            creditRecordBusiReqBo.setBusiType(FscCreditBusiType.ORD_FL.getCode());
                        } else {
                            creditRecordBusiReqBo.setBusiType(FscCreditBusiType.ORD.getCode());
                        }
                        creditRecordBusiReqBo.setRemark("\u6838\u9500\u5931\u8d25-\u5e94\u4ed8\u7c7b\u578b\uff1a" + payableDetailPo.getPayableType() + "-" + PayableType.desc(payableDetailPo.getPayableType().toString()));
                        creditRecordBusiReqBo.setInspectionId(payPurchaseOrderInfo.getInspectionId());
                        this.saveUocEsSync(reqBO.getUocEsSyncVersionId(), creditRecordBusiReqBo.getOrderId());
                        FscCreditRecordPO fscCreditRecordOld = new FscCreditRecordPO();
                        fscCreditRecordOld.setObjId(creditRecordBusiReqBo.getOrderId());
                        fscCreditRecordOld.setObjCode(creditRecordBusiReqBo.getOrderCode());
                        fscCreditRecordOld.setBusiCategory(FscCreditBusiCategory.ORD_ADD.getCode());
                        int checkBy = this.fscCreditRecordMapper.getCheckBy(fscCreditRecordOld);
                        if (checkBy < 1) {
                            this.saveLog(creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderCode(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)creditRecordBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "", "\u5e94\u4ed8\u5bf9\u5e94\u4e0b\u5355\u6263\u51cf\u6388\u4fe1\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u6838\u9500\u5931\u8d25\u4e0d\u6263\u6388\u4fe1" + notificationNo);
                            continue;
                        }
                        FscOrderCreditRecordBusiRspBO creditRecordBusiRspBo = this.fscCreditRecordBusiService.dealOrderCreditRecord(creditRecordBusiReqBo);
                        if (!FscRu.isFailed(creditRecordBusiRspBo.getRespCode()).booleanValue()) continue;
                        log.error("\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u91c7\u8d2d\u5f00\u7968\u901a\u77e5\u5e94\u4ed8-\u6838\u9178\u5931\u8d25,\u5165\u53c2\uff1a{}.\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)creditRecordBusiReqBo)), (Object)JSON.toJSONString((Object)((Object)creditRecordBusiRspBo)));
                        this.saveLog(creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderCode(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)creditRecordBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), JSON.toJSONString((Object)((Object)creditRecordBusiRspBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u91c7\u8d2d\u5f00\u7968\u901a\u77e5\u5e94\u4ed8-\u6838\u9500\u5931\u8d25" + notificationNo);
                        throw new PfscExtBusinessException(creditRecordBusiRspBo.getRespCode(), creditRecordBusiRspBo.getRespDesc());
                    }
                }
            } else if (PayableType.APPLY.getCode().equals(payableDetailPo.getPayableType().toString())) {
                String applyNo = payableDetailPo.getApplyNo();
                List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getMarketSaleOrderListByApplyNo(applyNo);
                for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                    FscOrderCreditRecordBusiReqBO creditRecordBusiReqBo = new FscOrderCreditRecordBusiReqBO();
                    BeanUtils.copyProperties((Object)reqBaseBo, (Object)((Object)creditRecordBusiReqBo));
                    creditRecordBusiReqBo.setBusiCategory(FscCreditBusiCategory.WRITE_OFF_FAIL.getCode());
                    creditRecordBusiReqBo.setPayApplyCode(String.valueOf(applyPay.getPayno()));
                    creditRecordBusiReqBo.setOrderId(saleOrderInfo.getOrderId());
                    creditRecordBusiReqBo.setOrderCode(saleOrderInfo.getSaleOrderCode());
                    if (StringUtils.isNotBlank((CharSequence)saleOrderInfo.getBusiModel())) {
                        creditRecordBusiReqBo.setBusiModel(Integer.valueOf(saleOrderInfo.getBusiModel()));
                    }
                    creditRecordBusiReqBo.setBusiAmount(saleOrderInfo.getOrderAmt().negate());
                    creditRecordBusiReqBo.setSupplierNo(saleOrderInfo.getSupplierNo());
                    creditRecordBusiReqBo.setSupplierName(saleOrderInfo.getSupplierName());
                    if (saleOrderInfo.getActivityId() != null) {
                        creditRecordBusiReqBo.setBusiType(FscCreditBusiType.ORD_FL.getCode());
                    } else {
                        creditRecordBusiReqBo.setBusiType(FscCreditBusiType.ORD.getCode());
                    }
                    creditRecordBusiReqBo.setRemark("\u6838\u9500\u5931\u8d25-\u5e94\u4ed8\u7c7b\u578b\uff1a" + payableDetailPo.getPayableType() + "-" + PayableType.desc(payableDetailPo.getPayableType().toString()));
                    creditRecordBusiReqBo.setInspectionId(saleOrderInfo.getInspectionId());
                    this.saveUocEsSync(reqBO.getUocEsSyncVersionId(), creditRecordBusiReqBo.getOrderId());
                    FscCreditRecordPO fscCreditRecordOld = new FscCreditRecordPO();
                    fscCreditRecordOld.setObjId(creditRecordBusiReqBo.getOrderId());
                    fscCreditRecordOld.setObjCode(creditRecordBusiReqBo.getOrderCode());
                    fscCreditRecordOld.setBusiCategory(FscCreditBusiCategory.ORD_ADD.getCode());
                    int checkBy = this.fscCreditRecordMapper.getCheckBy(fscCreditRecordOld);
                    if (checkBy < 1) {
                        this.saveLog(creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderCode(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)creditRecordBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "", "\u5e94\u4ed8\u5bf9\u5e94\u4e0b\u5355\u6263\u51cf\u6388\u4fe1\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u6838\u9500\u5931\u8d25\u4e0d\u6263\u6388\u4fe1" + applyNo);
                        continue;
                    }
                    FscOrderCreditRecordBusiRspBO creditRecordBusiRspBo = this.fscCreditRecordBusiService.dealOrderCreditRecord(creditRecordBusiReqBo);
                    if (!FscRu.isFailed(creditRecordBusiRspBo.getRespCode()).booleanValue()) continue;
                    log.error("\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u91c7\u8d2d\u5f00\u7968\u7533\u8bf7\u5e94\u4ed8-\u6838\u9178\u5931\u8d25,\u5165\u53c2\uff1a{}.\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)creditRecordBusiReqBo)), (Object)JSON.toJSONString((Object)((Object)creditRecordBusiRspBo)));
                    this.saveLog(creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderCode(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)creditRecordBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), JSON.toJSONString((Object)((Object)creditRecordBusiRspBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u91c7\u8d2d\u5f00\u7968\u7533\u8bf7\u5e94\u4ed8-\u6838\u9500\u5931\u8d25" + applyNo);
                    throw new PfscExtBusinessException(creditRecordBusiRspBo.getRespCode(), creditRecordBusiRspBo.getRespDesc());
                }
            } else if (Arrays.asList(PayableType.AOG.getCode(), PayableType.INSPECTION.getCode(), PayableType.EXPIRE.getCode(), PayableType.YFYF.getCode(), PayableType.QUALITY_GUARANTEE_DEPOSIT.getCode()).contains(payableDetailPo.getPayableType().toString())) {
                List<SaleOrderInfo> saleOrders;
                BigDecimal changeInfo;
                BigDecimal bigDecimal = changeInfo = amtMap.get(payableDetailPo.getPayableNo()) == null ? BigDecimal.ZERO : amtMap.get(payableDetailPo.getPayableNo());
                if (payableDetailPo.getOverduePenalty() != null && (payableDetailPo.getApproveResult() == null || 1 != payableDetailPo.getApproveResult())) {
                    changeInfo = changeInfo.subtract(payableDetailPo.getOverduePenalty());
                }
                FscOrderCreditRecordBusiReqBO creditRecordBusiReqBo = new FscOrderCreditRecordBusiReqBO();
                BeanUtils.copyProperties((Object)reqBaseBo, (Object)((Object)creditRecordBusiReqBo));
                creditRecordBusiReqBo.setBusiCategory(FscCreditBusiCategory.WRITE_OFF_FAIL.getCode());
                creditRecordBusiReqBo.setBusiAmount(changeInfo.negate());
                creditRecordBusiReqBo.setPayApplyCode(String.valueOf(applyPay.getPayno()));
                creditRecordBusiReqBo.setSupplierNo(payableDetailPo.getSupplierId());
                creditRecordBusiReqBo.setSupplierName(payableDetailPo.getSupplierName());
                creditRecordBusiReqBo.setBusiModel(payableDetailPo.getBusiModel());
                creditRecordBusiReqBo.setOrderId(payableDetailPo.getOrderId());
                creditRecordBusiReqBo.setOrderCode(payableDetailPo.getPurchaseOrderCode());
                if (payableDetailPo.getOrderId() != null && !CollectionUtils.isEmpty(saleOrders = this.saleOrderInfoMapper.getListSaleOrderInfoByOrderIds(Collections.singletonList(payableDetailPo.getOrderId())))) {
                    if (saleOrders.get(0).getActivityId() != null) {
                        creditRecordBusiReqBo.setBusiType(FscCreditBusiType.ORD_FL.getCode());
                    } else {
                        creditRecordBusiReqBo.setBusiType(FscCreditBusiType.ORD.getCode());
                    }
                }
                creditRecordBusiReqBo.setRemark("\u6838\u9500\u5931\u8d25-\u5e94\u4ed8\u7c7b\u578b\uff1a" + payableDetailPo.getPayableType() + "-" + PayableType.desc(payableDetailPo.getPayableType().toString()));
                creditRecordBusiReqBo.setInspectionId(payableDetailPo.getInspectionId());
                this.saveUocEsSync(reqBO.getUocEsSyncVersionId(), creditRecordBusiReqBo.getOrderId());
                FscCreditRecordPO fscCreditRecordOld = new FscCreditRecordPO();
                fscCreditRecordOld.setObjId(creditRecordBusiReqBo.getOrderId());
                fscCreditRecordOld.setObjCode(creditRecordBusiReqBo.getOrderCode());
                fscCreditRecordOld.setBusiCategory(FscCreditBusiCategory.ORD_ADD.getCode());
                int checkBy = this.fscCreditRecordMapper.getCheckBy(fscCreditRecordOld);
                if (checkBy < 1) {
                    this.saveLog(creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderCode(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)creditRecordBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "", "\u5e94\u4ed8\u5bf9\u5e94\u4e0b\u5355\u6263\u51cf\u6388\u4fe1\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u6838\u9500\u5931\u8d25\u4e0d\u6263\u6388\u4fe1" + payableDetailPo.getPayableNo());
                } else {
                    FscOrderCreditRecordBusiRspBO creditRecordBusiRspBo = this.fscCreditRecordBusiService.dealOrderCreditRecord(creditRecordBusiReqBo);
                    if (FscRu.isFailed(creditRecordBusiRspBo.getRespCode()).booleanValue()) {
                        log.error("\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u5230\u8d27\u5e94\u4ed8-\u9a8c\u6536\u5e94\u4ed8-\u8d26\u671f\u5e94\u4ed8-\u6838\u9178\u5931\u8d25,\u5165\u53c2\uff1a{}.\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)creditRecordBusiReqBo)), (Object)JSON.toJSONString((Object)((Object)creditRecordBusiRspBo)));
                        this.saveLog(creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderId(), creditRecordBusiReqBo.getOrderCode(), reqBO.getUserId() + "", JSON.toJSONString((Object)((Object)creditRecordBusiReqBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), JSON.toJSONString((Object)((Object)creditRecordBusiRspBo), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), "\u65b0\u589e\u6388\u4fe1\u8bb0\u5f55\u5931\u8d25-\u5230\u8d27\u5e94\u4ed8-\u9a8c\u6536\u5e94\u4ed8-\u8d26\u671f\u5e94\u4ed8-\u6838\u9500\u5931\u8d25" + payableDetailPo.getPayableNo());
                        throw new PfscExtBusinessException(creditRecordBusiRspBo.getRespCode(), creditRecordBusiRspBo.getRespDesc());
                    }
                }
            }
        }
    }

    private void saveUocEsSync(Long uocEsSyncVersionId, Long orderId) {
        if (uocEsSyncVersionId != null && orderId != null) {
            FscEsSyncTodoTemporaryPO fscEsSyncTodoTemporaryPo = new FscEsSyncTodoTemporaryPO();
            fscEsSyncTodoTemporaryPo.setVersionId(uocEsSyncVersionId);
            fscEsSyncTodoTemporaryPo.setBusinessId(orderId);
            fscEsSyncTodoTemporaryPo.setBusinessType("1");
            this.fscEsSyncTodoTemporaryMapper.insertIgnore(fscEsSyncTodoTemporaryPo);
        }
    }

    @Deprecated
    private void dealConfirmPayFailCredit(ApplyPayInfoPO applyPay, Map<String, BigDecimal> amtMap, PayableDetailPO payableDetailPO) {
        BigDecimal changeInfo;
        AddCreditLineFscReqBo creditLineFscReqBo = new AddCreditLineFscReqBo();
        creditLineFscReqBo.setChangeType("4");
        BigDecimal bigDecimal = changeInfo = amtMap.get(payableDetailPO.getPayableNo()) == null ? BigDecimal.ZERO : amtMap.get(payableDetailPO.getPayableNo());
        if (payableDetailPO.getOverduePenalty() != null && payableDetailPO.getApproveResult() != null && 1 != payableDetailPO.getApproveResult()) {
            changeInfo = changeInfo.subtract(payableDetailPO.getOverduePenalty());
        }
        creditLineFscReqBo.setChangeInfo(changeInfo.negate());
        creditLineFscReqBo.setPayApplyCode(String.valueOf(applyPay.getPayno()));
        if (payableDetailPO.getPayableType() == 1 && 1 == payableDetailPO.getBusiModel()) {
            String notificationNo = payableDetailPO.getNotificationNo();
            List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
            for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
                creditLineFscReqBo.setOrderCode(String.valueOf(payPurchaseOrderInfo.getPurchaseOrderCode()));
                creditLineFscReqBo.setChangeInfo(payPurchaseOrderInfo.getOrderAmt().negate());
                creditLineFscReqBo.setSupplierNo(payPurchaseOrderInfo.getSupplierNo());
                if (!org.springframework.util.StringUtils.isEmpty((Object)payPurchaseOrderInfo.getBusiModel())) {
                    creditLineFscReqBo.setBusiModel(Integer.valueOf(payPurchaseOrderInfo.getBusiModel()));
                }
                this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
            }
        } else if (payableDetailPO.getPayableType() == 6) {
            String applyNo = payableDetailPO.getApplyNo();
            List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getMarketSaleOrderListByApplyNo(applyNo);
            for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                creditLineFscReqBo.setOrderCode(String.valueOf(saleOrderInfo.getSaleOrderCode()));
                creditLineFscReqBo.setChangeInfo(saleOrderInfo.getOrderAmt().negate());
                creditLineFscReqBo.setSupplierNo(saleOrderInfo.getSupplierNo());
                if (!org.springframework.util.StringUtils.isEmpty((Object)saleOrderInfo.getBusiModel())) {
                    creditLineFscReqBo.setBusiModel(Integer.valueOf(saleOrderInfo.getBusiModel()));
                }
                this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
            }
        } else if (payableDetailPO.getPayableType() == 2 || payableDetailPO.getPayableType() == 3 || payableDetailPO.getPayableType() == 5) {
            creditLineFscReqBo.setOrderCode(payableDetailPO.getPurchaseOrderCode());
            creditLineFscReqBo.setSupplierNo(payableDetailPO.getSupplierId());
            if (!org.springframework.util.StringUtils.isEmpty((Object)payableDetailPO.getBusiModel())) {
                creditLineFscReqBo.setBusiModel(Integer.valueOf(payableDetailPO.getBusiModel()));
            }
            this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
        }
    }
}

